require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_ASM_POWERPC_SEMAPHORE_H)) {
    eval 'sub _ASM_POWERPC_SEMAPHORE_H () {1;}' unless defined(&_ASM_POWERPC_SEMAPHORE_H);
    if(defined(&__KERNEL__)) {
	require 'asm/atomic.ph';
	require 'asm/system.ph';
	require 'linux/wait.ph';
	require 'linux/rwsem.ph';
	eval 'sub __SEMAPHORE_INITIALIZER {
	    my($name, $n) = @_;
    	    eval q({ . &count =  &ATOMIC_INIT($n), . &wait =  &__WAIT_QUEUE_HEAD_INITIALIZER(($name). &wait) });
	}' unless defined(&__SEMAPHORE_INITIALIZER);
	eval 'sub __DECLARE_SEMAPHORE_GENERIC {
	    my($name, $count) = @_;
    	    eval q(\'struct semaphore\' $name =  &__SEMAPHORE_INITIALIZER($name,$count));
	}' unless defined(&__DECLARE_SEMAPHORE_GENERIC);
	eval 'sub DECLARE_MUTEX {
	    my($name) = @_;
    	    eval q( &__DECLARE_SEMAPHORE_GENERIC($name, 1));
	}' unless defined(&DECLARE_MUTEX);
	eval 'sub DECLARE_MUTEX_LOCKED {
	    my($name) = @_;
    	    eval q( &__DECLARE_SEMAPHORE_GENERIC($name, 0));
	}' unless defined(&DECLARE_MUTEX_LOCKED);
	eval 'sub sema_init {
	    my($sem,$val) = @_;
    	    eval q({  &atomic_set( ($sem->{count}), $val);  &init_waitqueue_head( ($sem->{wait})); });
	}' unless defined(&sema_init);
	eval 'sub init_MUTEX {
	    my($sem) = @_;
    	    eval q({  &sema_init($sem, 1); });
	}' unless defined(&init_MUTEX);
	eval 'sub init_MUTEX_LOCKED {
	    my($sem) = @_;
    	    eval q({  &sema_init($sem, 0); });
	}' unless defined(&init_MUTEX_LOCKED);
	eval 'sub down {
	    my($sem) = @_;
    	    eval q({  &might_sleep();  &if ( &unlikely( &atomic_dec_return( ($sem->{count})) < 0))  &__down($sem); });
	}' unless defined(&down);
	eval 'sub down_interruptible {
	    my($sem) = @_;
    	    eval q({ \'int\'  &ret = 0;  &might_sleep();  &if ( &unlikely( &atomic_dec_return( ($sem->{count})) < 0))  &ret =  &__down_interruptible($sem);  &ret; });
	}' unless defined(&down_interruptible);
	eval 'sub down_trylock {
	    my($sem) = @_;
    	    eval q({  &atomic_dec_if_positive( ($sem->{count})) < 0; });
	}' unless defined(&down_trylock);
	eval 'sub up {
	    my($sem) = @_;
    	    eval q({  &if ( &unlikely( &atomic_inc_return( ($sem->{count})) <= 0))  &__up($sem); });
	}' unless defined(&up);
    }
}
1;
