require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_SPU_H)) {
    eval 'sub _SPU_H () {1;}' unless defined(&_SPU_H);
    if(defined(&__KERNEL__)) {
	require 'linux/config.ph';
	require 'linux/kref.ph';
	require 'linux/workqueue.ph';
	eval 'sub LS_SIZE () {(256* 1024);}' unless defined(&LS_SIZE);
	eval 'sub LS_ADDR_MASK () {( &LS_SIZE - 1);}' unless defined(&LS_ADDR_MASK);
	eval 'sub MFC_PUT_CMD () {0x20;}' unless defined(&MFC_PUT_CMD);
	eval 'sub MFC_PUTS_CMD () {0x28;}' unless defined(&MFC_PUTS_CMD);
	eval 'sub MFC_PUTR_CMD () {0x30;}' unless defined(&MFC_PUTR_CMD);
	eval 'sub MFC_PUTF_CMD () {0x22;}' unless defined(&MFC_PUTF_CMD);
	eval 'sub MFC_PUTB_CMD () {0x21;}' unless defined(&MFC_PUTB_CMD);
	eval 'sub MFC_PUTFS_CMD () {0x2a;}' unless defined(&MFC_PUTFS_CMD);
	eval 'sub MFC_PUTBS_CMD () {0x29;}' unless defined(&MFC_PUTBS_CMD);
	eval 'sub MFC_PUTRF_CMD () {0x32;}' unless defined(&MFC_PUTRF_CMD);
	eval 'sub MFC_PUTRB_CMD () {0x31;}' unless defined(&MFC_PUTRB_CMD);
	eval 'sub MFC_PUTL_CMD () {0x24;}' unless defined(&MFC_PUTL_CMD);
	eval 'sub MFC_PUTRL_CMD () {0x34;}' unless defined(&MFC_PUTRL_CMD);
	eval 'sub MFC_PUTLF_CMD () {0x26;}' unless defined(&MFC_PUTLF_CMD);
	eval 'sub MFC_PUTLB_CMD () {0x25;}' unless defined(&MFC_PUTLB_CMD);
	eval 'sub MFC_PUTRLF_CMD () {0x36;}' unless defined(&MFC_PUTRLF_CMD);
	eval 'sub MFC_PUTRLB_CMD () {0x35;}' unless defined(&MFC_PUTRLB_CMD);
	eval 'sub MFC_GET_CMD () {0x40;}' unless defined(&MFC_GET_CMD);
	eval 'sub MFC_GETS_CMD () {0x48;}' unless defined(&MFC_GETS_CMD);
	eval 'sub MFC_GETF_CMD () {0x42;}' unless defined(&MFC_GETF_CMD);
	eval 'sub MFC_GETB_CMD () {0x41;}' unless defined(&MFC_GETB_CMD);
	eval 'sub MFC_GETFS_CMD () {0x4a;}' unless defined(&MFC_GETFS_CMD);
	eval 'sub MFC_GETBS_CMD () {0x49;}' unless defined(&MFC_GETBS_CMD);
	eval 'sub MFC_GETL_CMD () {0x44;}' unless defined(&MFC_GETL_CMD);
	eval 'sub MFC_GETLF_CMD () {0x46;}' unless defined(&MFC_GETLF_CMD);
	eval 'sub MFC_GETLB_CMD () {0x45;}' unless defined(&MFC_GETLB_CMD);
	eval 'sub MFC_SDCRT_CMD () {0x80;}' unless defined(&MFC_SDCRT_CMD);
	eval 'sub MFC_SDCRTST_CMD () {0x81;}' unless defined(&MFC_SDCRTST_CMD);
	eval 'sub MFC_SDCRZ_CMD () {0x89;}' unless defined(&MFC_SDCRZ_CMD);
	eval 'sub MFC_SDCRS_CMD () {0x8d;}' unless defined(&MFC_SDCRS_CMD);
	eval 'sub MFC_SDCRF_CMD () {0x8f;}' unless defined(&MFC_SDCRF_CMD);
	eval 'sub MFC_GETLLAR_CMD () {0xd0;}' unless defined(&MFC_GETLLAR_CMD);
	eval 'sub MFC_PUTLLC_CMD () {0xb4;}' unless defined(&MFC_PUTLLC_CMD);
	eval 'sub MFC_PUTLLUC_CMD () {0xb0;}' unless defined(&MFC_PUTLLUC_CMD);
	eval 'sub MFC_PUTQLLUC_CMD () {0xb8;}' unless defined(&MFC_PUTQLLUC_CMD);
	eval 'sub MFC_SNDSIG_CMD () {0xa0;}' unless defined(&MFC_SNDSIG_CMD);
	eval 'sub MFC_SNDSIGB_CMD () {0xa1;}' unless defined(&MFC_SNDSIGB_CMD);
	eval 'sub MFC_SNDSIGF_CMD () {0xa2;}' unless defined(&MFC_SNDSIGF_CMD);
	eval 'sub MFC_BARRIER_CMD () {0xc0;}' unless defined(&MFC_BARRIER_CMD);
	eval 'sub MFC_EIEIO_CMD () {0xc8;}' unless defined(&MFC_EIEIO_CMD);
	eval 'sub MFC_SYNC_CMD () {0xcc;}' unless defined(&MFC_SYNC_CMD);
	eval 'sub MFC_MIN_DMA_SIZE_SHIFT () {4;}' unless defined(&MFC_MIN_DMA_SIZE_SHIFT);
	eval 'sub MFC_MAX_DMA_SIZE_SHIFT () {14;}' unless defined(&MFC_MAX_DMA_SIZE_SHIFT);
	eval 'sub MFC_MIN_DMA_SIZE () {(1<<  &MFC_MIN_DMA_SIZE_SHIFT);}' unless defined(&MFC_MIN_DMA_SIZE);
	eval 'sub MFC_MAX_DMA_SIZE () {(1<<  &MFC_MAX_DMA_SIZE_SHIFT);}' unless defined(&MFC_MAX_DMA_SIZE);
	eval 'sub MFC_MIN_DMA_SIZE_MASK () {( &MFC_MIN_DMA_SIZE - 1);}' unless defined(&MFC_MIN_DMA_SIZE_MASK);
	eval 'sub MFC_MAX_DMA_SIZE_MASK () {( &MFC_MAX_DMA_SIZE - 1);}' unless defined(&MFC_MAX_DMA_SIZE_MASK);
	eval 'sub MFC_MIN_DMA_LIST_SIZE () {0x8;}' unless defined(&MFC_MIN_DMA_LIST_SIZE);
	eval 'sub MFC_MAX_DMA_LIST_SIZE () {0x4000;}' unless defined(&MFC_MAX_DMA_LIST_SIZE);
	eval 'sub MFC_TAGID_TO_TAGMASK {
	    my($tag_id) = @_;
    	    eval q((1<< ($tag_id & 0x1f)));
	}' unless defined(&MFC_TAGID_TO_TAGMASK);
	eval 'sub MFC_DMA_TAG_STATUS_UPDATE_EVENT () {0x1;}' unless defined(&MFC_DMA_TAG_STATUS_UPDATE_EVENT);
	eval 'sub MFC_DMA_TAG_CMD_STALL_NOTIFY_EVENT () {0x2;}' unless defined(&MFC_DMA_TAG_CMD_STALL_NOTIFY_EVENT);
	eval 'sub MFC_DMA_QUEUE_AVAILABLE_EVENT () {0x8;}' unless defined(&MFC_DMA_QUEUE_AVAILABLE_EVENT);
	eval 'sub MFC_SPU_MAILBOX_WRITTEN_EVENT () {0x10;}' unless defined(&MFC_SPU_MAILBOX_WRITTEN_EVENT);
	eval 'sub MFC_DECREMENTER_EVENT () {0x20;}' unless defined(&MFC_DECREMENTER_EVENT);
	eval 'sub MFC_PU_INT_MAILBOX_AVAILABLE_EVENT () {0x40;}' unless defined(&MFC_PU_INT_MAILBOX_AVAILABLE_EVENT);
	eval 'sub MFC_PU_MAILBOX_AVAILABLE_EVENT () {0x80;}' unless defined(&MFC_PU_MAILBOX_AVAILABLE_EVENT);
	eval 'sub MFC_SIGNAL_2_EVENT () {0x100;}' unless defined(&MFC_SIGNAL_2_EVENT);
	eval 'sub MFC_SIGNAL_1_EVENT () {0x200;}' unless defined(&MFC_SIGNAL_1_EVENT);
	eval 'sub MFC_LLR_LOST_EVENT () {0x400;}' unless defined(&MFC_LLR_LOST_EVENT);
	eval 'sub MFC_PRIV_ATTN_EVENT () {0x800;}' unless defined(&MFC_PRIV_ATTN_EVENT);
	eval 'sub MFC_MULTI_SRC_EVENT () {0x1000;}' unless defined(&MFC_MULTI_SRC_EVENT);
	eval 'sub SPU_CONTEXT_SWITCH_PENDING () {0;}' unless defined(&SPU_CONTEXT_SWITCH_PENDING);
	eval 'sub SPU_CONTEXT_SWITCH_ACTIVE () {1;}' unless defined(&SPU_CONTEXT_SWITCH_ACTIVE);
	if(defined(&CONFIG_SPU_FS_MODULE)) {
	} else {
	    eval 'sub register_spu_syscalls {
	        my($calls) = @_;
    		eval q({ 0; });
	    }' unless defined(&register_spu_syscalls);
	    eval 'sub unregister_spu_syscalls {
	        my($calls) = @_;
    		eval q({ });
	    }' unless defined(&unregister_spu_syscalls);
	}
	eval 'sub MS_SYNC_PENDING () {1;}' unless defined(&MS_SYNC_PENDING);
	eval 'sub DMA_TAGSTATUS_INTR_ANY () {1;}' unless defined(&DMA_TAGSTATUS_INTR_ANY);
	eval 'sub DMA_TAGSTATUS_INTR_ALL () {2;}' unless defined(&DMA_TAGSTATUS_INTR_ALL);
	eval 'sub SPU_RUNCNTL_STOP () {0;}' unless defined(&SPU_RUNCNTL_STOP);
	eval 'sub SPU_RUNCNTL_RUNNABLE () {1;}' unless defined(&SPU_RUNCNTL_RUNNABLE);
	eval 'sub SPU_STOP_STATUS_SHIFT () {16;}' unless defined(&SPU_STOP_STATUS_SHIFT);
	eval 'sub SPU_STATUS_STOPPED () {0x;}' unless defined(&SPU_STATUS_STOPPED);
	eval 'sub SPU_STATUS_RUNNING () {0x1;}' unless defined(&SPU_STATUS_RUNNING);
	eval 'sub SPU_STATUS_STOPPED_BY_STOP () {0x2;}' unless defined(&SPU_STATUS_STOPPED_BY_STOP);
	eval 'sub SPU_STATUS_STOPPED_BY_HALT () {0x4;}' unless defined(&SPU_STATUS_STOPPED_BY_HALT);
	eval 'sub SPU_STATUS_WAITING_FOR_CHANNEL () {0x8;}' unless defined(&SPU_STATUS_WAITING_FOR_CHANNEL);
	eval 'sub SPU_STATUS_SINGLE_STEP () {0x10;}' unless defined(&SPU_STATUS_SINGLE_STEP);
	eval 'sub SPU_STATUS_INVALID_INSTR () {0x20;}' unless defined(&SPU_STATUS_INVALID_INSTR);
	eval 'sub SPU_STATUS_INVALID_CH () {0x40;}' unless defined(&SPU_STATUS_INVALID_CH);
	eval 'sub SPU_STATUS_ISOLATED_STATE () {0x80;}' unless defined(&SPU_STATUS_ISOLATED_STATE);
	eval 'sub SPU_STATUS_ISOLATED_LOAD_STAUTUS () {0x200;}' unless defined(&SPU_STATUS_ISOLATED_LOAD_STAUTUS);
	eval 'sub SPU_STATUS_ISOLATED_EXIT_STAUTUS () {0x400;}' unless defined(&SPU_STATUS_ISOLATED_EXIT_STAUTUS);
	eval 'sub SLB_INDEX_MASK () {0x7;}' unless defined(&SLB_INDEX_MASK);
	eval 'sub SLB_VSID_SUPERVISOR_STATE () {(0x1 << 11);}' unless defined(&SLB_VSID_SUPERVISOR_STATE);
	eval 'sub SLB_VSID_SUPERVISOR_STATE_MASK () {(0x1 << 11);}' unless defined(&SLB_VSID_SUPERVISOR_STATE_MASK);
	eval 'sub SLB_VSID_PROBLEM_STATE () {(0x1 << 10);}' unless defined(&SLB_VSID_PROBLEM_STATE);
	eval 'sub SLB_VSID_PROBLEM_STATE_MASK () {(0x1 << 10);}' unless defined(&SLB_VSID_PROBLEM_STATE_MASK);
	eval 'sub SLB_VSID_EXECUTE_SEGMENT () {(0x1 << 9);}' unless defined(&SLB_VSID_EXECUTE_SEGMENT);
	eval 'sub SLB_VSID_NO_EXECUTE_SEGMENT () {(0x1 << 9);}' unless defined(&SLB_VSID_NO_EXECUTE_SEGMENT);
	eval 'sub SLB_VSID_EXECUTE_SEGMENT_MASK () {(0x1 << 9);}' unless defined(&SLB_VSID_EXECUTE_SEGMENT_MASK);
	eval 'sub SLB_VSID_4K_PAGE () {(0x << 8);}' unless defined(&SLB_VSID_4K_PAGE);
	eval 'sub SLB_VSID_LARGE_PAGE () {(0x1 << 8);}' unless defined(&SLB_VSID_LARGE_PAGE);
	eval 'sub SLB_VSID_PAGE_SIZE_MASK () {(0x1 << 8);}' unless defined(&SLB_VSID_PAGE_SIZE_MASK);
	eval 'sub SLB_VSID_CLASS_MASK () {(0x1 << 7);}' unless defined(&SLB_VSID_CLASS_MASK);
	eval 'sub SLB_VSID_VIRTUAL_PAGE_SIZE_MASK () {(0x1 << 6);}' unless defined(&SLB_VSID_VIRTUAL_PAGE_SIZE_MASK);
	eval 'sub MFC_CNTL_RESUME_DMA_QUEUE () {(0 << 0);}' unless defined(&MFC_CNTL_RESUME_DMA_QUEUE);
	eval 'sub MFC_CNTL_SUSPEND_DMA_QUEUE () {(1 << 0);}' unless defined(&MFC_CNTL_SUSPEND_DMA_QUEUE);
	eval 'sub MFC_CNTL_SUSPEND_DMA_QUEUE_MASK () {(1 << 0);}' unless defined(&MFC_CNTL_SUSPEND_DMA_QUEUE_MASK);
	eval 'sub MFC_CNTL_NORMAL_DMA_QUEUE_OPERATION () {(0 << 8);}' unless defined(&MFC_CNTL_NORMAL_DMA_QUEUE_OPERATION);
	eval 'sub MFC_CNTL_SUSPEND_IN_PROGRESS () {(1 << 8);}' unless defined(&MFC_CNTL_SUSPEND_IN_PROGRESS);
	eval 'sub MFC_CNTL_SUSPEND_COMPLETE () {(3 << 8);}' unless defined(&MFC_CNTL_SUSPEND_COMPLETE);
	eval 'sub MFC_CNTL_SUSPEND_DMA_STATUS_MASK () {(3 << 8);}' unless defined(&MFC_CNTL_SUSPEND_DMA_STATUS_MASK);
	eval 'sub MFC_CNTL_DMA_QUEUES_EMPTY () {(1 << 14);}' unless defined(&MFC_CNTL_DMA_QUEUES_EMPTY);
	eval 'sub MFC_CNTL_DMA_QUEUES_EMPTY_MASK () {(1 << 14);}' unless defined(&MFC_CNTL_DMA_QUEUES_EMPTY_MASK);
	eval 'sub MFC_CNTL_PURGE_DMA_REQUEST () {(1 << 15);}' unless defined(&MFC_CNTL_PURGE_DMA_REQUEST);
	eval 'sub MFC_CNTL_PURGE_DMA_IN_PROGRESS () {(1 << 24);}' unless defined(&MFC_CNTL_PURGE_DMA_IN_PROGRESS);
	eval 'sub MFC_CNTL_PURGE_DMA_COMPLETE () {(3 << 24);}' unless defined(&MFC_CNTL_PURGE_DMA_COMPLETE);
	eval 'sub MFC_CNTL_PURGE_DMA_STATUS_MASK () {(3 << 24);}' unless defined(&MFC_CNTL_PURGE_DMA_STATUS_MASK);
	eval 'sub MFC_CNTL_RESTART_DMA_COMMAND () {(1 << 32);}' unless defined(&MFC_CNTL_RESTART_DMA_COMMAND);
	eval 'sub MFC_CNTL_DMA_COMMAND_REISSUE_PENDING () {(1 << 32);}' unless defined(&MFC_CNTL_DMA_COMMAND_REISSUE_PENDING);
	eval 'sub MFC_CNTL_DMA_COMMAND_REISSUE_STATUS_MASK () {(1 << 32);}' unless defined(&MFC_CNTL_DMA_COMMAND_REISSUE_STATUS_MASK);
	eval 'sub MFC_CNTL_MFC_PRIVILEGE_STATE () {(2 << 33);}' unless defined(&MFC_CNTL_MFC_PRIVILEGE_STATE);
	eval 'sub MFC_CNTL_MFC_PROBLEM_STATE () {(3 << 33);}' unless defined(&MFC_CNTL_MFC_PROBLEM_STATE);
	eval 'sub MFC_CNTL_MFC_KEY_PROTECTION_STATE_MASK () {(3 << 33);}' unless defined(&MFC_CNTL_MFC_KEY_PROTECTION_STATE_MASK);
	eval 'sub MFC_CNTL_DECREMENTER_HALTED () {(1 << 35);}' unless defined(&MFC_CNTL_DECREMENTER_HALTED);
	eval 'sub MFC_CNTL_DECREMENTER_RUNNING () {(1 << 40);}' unless defined(&MFC_CNTL_DECREMENTER_RUNNING);
	eval 'sub MFC_CNTL_DECREMENTER_STATUS_MASK () {(1 << 40);}' unless defined(&MFC_CNTL_DECREMENTER_STATUS_MASK);
	eval 'sub SPU_PRIVCNTL_MODE_NORMAL () {(0x << 0);}' unless defined(&SPU_PRIVCNTL_MODE_NORMAL);
	eval 'sub SPU_PRIVCNTL_MODE_SINGLE_STEP () {(0x1 << 0);}' unless defined(&SPU_PRIVCNTL_MODE_SINGLE_STEP);
	eval 'sub SPU_PRIVCNTL_MODE_MASK () {(0x1 << 0);}' unless defined(&SPU_PRIVCNTL_MODE_MASK);
	eval 'sub SPU_PRIVCNTL_NO_ATTENTION_EVENT () {(0x << 1);}' unless defined(&SPU_PRIVCNTL_NO_ATTENTION_EVENT);
	eval 'sub SPU_PRIVCNTL_ATTENTION_EVENT () {(0x1 << 1);}' unless defined(&SPU_PRIVCNTL_ATTENTION_EVENT);
	eval 'sub SPU_PRIVCNTL_ATTENTION_EVENT_MASK () {(0x1 << 1);}' unless defined(&SPU_PRIVCNTL_ATTENTION_EVENT_MASK);
	eval 'sub SPU_PRIVCNT_LOAD_REQUEST_NORMAL () {(0x << 2);}' unless defined(&SPU_PRIVCNT_LOAD_REQUEST_NORMAL);
	eval 'sub SPU_PRIVCNT_LOAD_REQUEST_ENABLE_MASK () {(0x1 << 2);}' unless defined(&SPU_PRIVCNT_LOAD_REQUEST_ENABLE_MASK);
	eval 'sub TAG_STATUS_QUERY_CONDITION_BITS () {(0x3 << 32);}' unless defined(&TAG_STATUS_QUERY_CONDITION_BITS);
	eval 'sub TAG_STATUS_QUERY_MASK_BITS () {(0xffffffff);}' unless defined(&TAG_STATUS_QUERY_MASK_BITS);
	eval 'sub SPU_COMMAND_BUFFER_1_LSA_BITS () {(0x7ffff << 32);}' unless defined(&SPU_COMMAND_BUFFER_1_LSA_BITS);
	eval 'sub SPU_COMMAND_BUFFER_1_EAH_BITS () {(0xffffffff);}' unless defined(&SPU_COMMAND_BUFFER_1_EAH_BITS);
	eval 'sub SPU_COMMAND_BUFFER_2_EAL_BITS () {((0xffffffff) << 32);}' unless defined(&SPU_COMMAND_BUFFER_2_EAL_BITS);
	eval 'sub SPU_COMMAND_BUFFER_2_TS_BITS () {(0xffff << 16);}' unless defined(&SPU_COMMAND_BUFFER_2_TS_BITS);
	eval 'sub SPU_COMMAND_BUFFER_2_TAG_BITS () {(0x3f);}' unless defined(&SPU_COMMAND_BUFFER_2_TAG_BITS);
	eval 'sub MFC_STATE1_LOCAL_STORAGE_DECODE_MASK () {0x1;}' unless defined(&MFC_STATE1_LOCAL_STORAGE_DECODE_MASK);
	eval 'sub MFC_STATE1_BUS_TLBIE_MASK () {0x2;}' unless defined(&MFC_STATE1_BUS_TLBIE_MASK);
	eval 'sub MFC_STATE1_REAL_MODE_OFFSET_ENABLE_MASK () {0x4;}' unless defined(&MFC_STATE1_REAL_MODE_OFFSET_ENABLE_MASK);
	eval 'sub MFC_STATE1_PROBLEM_STATE_MASK () {0x8;}' unless defined(&MFC_STATE1_PROBLEM_STATE_MASK);
	eval 'sub MFC_STATE1_RELOCATE_MASK () {0x10;}' unless defined(&MFC_STATE1_RELOCATE_MASK);
	eval 'sub MFC_STATE1_MASTER_RUN_CONTROL_MASK () {0x20;}' unless defined(&MFC_STATE1_MASTER_RUN_CONTROL_MASK);
	eval 'sub MFC_VERSION_BITS () {(0xffff << 16);}' unless defined(&MFC_VERSION_BITS);
	eval 'sub MFC_REVISION_BITS () {(0xffff);}' unless defined(&MFC_REVISION_BITS);
	eval 'sub MFC_GET_VERSION_BITS {
	    my($vr) = @_;
    	    eval q(((($vr) &  &MFC_VERSION_BITS) >> 16));
	}' unless defined(&MFC_GET_VERSION_BITS);
	eval 'sub MFC_GET_REVISION_BITS {
	    my($vr) = @_;
    	    eval q((($vr) &  &MFC_REVISION_BITS));
	}' unless defined(&MFC_GET_REVISION_BITS);
	eval 'sub SPU_VERSION_BITS () {(0xffff << 16);}' unless defined(&SPU_VERSION_BITS);
	eval 'sub SPU_REVISION_BITS () {(0xffff);}' unless defined(&SPU_REVISION_BITS);
	eval 'sub SPU_GET_VERSION_BITS {
	    my($vr) = @_;
    	    eval q(($vr &  &SPU_VERSION_BITS) >> 16);
	}' unless defined(&SPU_GET_VERSION_BITS);
	eval 'sub SPU_GET_REVISION_BITS {
	    my($vr) = @_;
    	    eval q(($vr &  &SPU_REVISION_BITS));
	}' unless defined(&SPU_GET_REVISION_BITS);
	eval 'sub CLASS0_ENABLE_DMA_ALIGNMENT_INTR () {0x1;}' unless defined(&CLASS0_ENABLE_DMA_ALIGNMENT_INTR);
	eval 'sub CLASS0_ENABLE_INVALID_DMA_COMMAND_INTR () {0x2;}' unless defined(&CLASS0_ENABLE_INVALID_DMA_COMMAND_INTR);
	eval 'sub CLASS0_ENABLE_SPU_ERROR_INTR () {0x4;}' unless defined(&CLASS0_ENABLE_SPU_ERROR_INTR);
	eval 'sub CLASS0_ENABLE_MFC_FIR_INTR () {0x8;}' unless defined(&CLASS0_ENABLE_MFC_FIR_INTR);
	eval 'sub CLASS1_ENABLE_SEGMENT_FAULT_INTR () {0x1;}' unless defined(&CLASS1_ENABLE_SEGMENT_FAULT_INTR);
	eval 'sub CLASS1_ENABLE_STORAGE_FAULT_INTR () {0x2;}' unless defined(&CLASS1_ENABLE_STORAGE_FAULT_INTR);
	eval 'sub CLASS1_ENABLE_LS_COMPARE_SUSPEND_ON_GET_INTR () {0x4;}' unless defined(&CLASS1_ENABLE_LS_COMPARE_SUSPEND_ON_GET_INTR);
	eval 'sub CLASS1_ENABLE_LS_COMPARE_SUSPEND_ON_PUT_INTR () {0x8;}' unless defined(&CLASS1_ENABLE_LS_COMPARE_SUSPEND_ON_PUT_INTR);
	eval 'sub CLASS2_ENABLE_MAILBOX_INTR () {0x1;}' unless defined(&CLASS2_ENABLE_MAILBOX_INTR);
	eval 'sub CLASS2_ENABLE_SPU_STOP_INTR () {0x2;}' unless defined(&CLASS2_ENABLE_SPU_STOP_INTR);
	eval 'sub CLASS2_ENABLE_SPU_HALT_INTR () {0x4;}' unless defined(&CLASS2_ENABLE_SPU_HALT_INTR);
	eval 'sub CLASS2_ENABLE_SPU_DMA_TAG_GROUP_COMPLETE_INTR () {0x8;}' unless defined(&CLASS2_ENABLE_SPU_DMA_TAG_GROUP_COMPLETE_INTR);
	eval 'sub mfc_atomic_flush_enable () {0x1;}' unless defined(&mfc_atomic_flush_enable);
	eval 'sub smf_sbi_mask_lsb () {56;}' unless defined(&smf_sbi_mask_lsb);
	eval 'sub smf_sbi_shift () {(63-  &smf_sbi_mask_lsb);}' unless defined(&smf_sbi_shift);
	eval 'sub smf_sbi_mask () {(0x301 <<  &smf_sbi_shift);}' unless defined(&smf_sbi_mask);
	eval 'sub smf_sbi_bus0_bits () {(0x1 <<  &smf_sbi_shift);}' unless defined(&smf_sbi_bus0_bits);
	eval 'sub smf_sbi_bus2_bits () {(0x100 <<  &smf_sbi_shift);}' unless defined(&smf_sbi_bus2_bits);
	eval 'sub smf_sbi2_bus0_bits () {(0x201 <<  &smf_sbi_shift);}' unless defined(&smf_sbi2_bus0_bits);
	eval 'sub smf_sbi2_bus2_bits () {(0x300 <<  &smf_sbi_shift);}' unless defined(&smf_sbi2_bus2_bits);
	eval 'sub smf_ato_mask_lsb () {35;}' unless defined(&smf_ato_mask_lsb);
	eval 'sub smf_ato_shift () {(63-  &smf_ato_mask_lsb);}' unless defined(&smf_ato_shift);
	eval 'sub smf_ato_mask () {(0x3 <<  &smf_ato_shift);}' unless defined(&smf_ato_mask);
	eval 'sub smf_ato_bus0_bits () {(0x2 <<  &smf_ato_shift);}' unless defined(&smf_ato_bus0_bits);
	eval 'sub smf_ato_bus2_bits () {(0x1 <<  &smf_ato_shift);}' unless defined(&smf_ato_bus2_bits);
	eval 'sub PAGE_SIZE_MASK () {1.72938225691027e+19;}' unless defined(&PAGE_SIZE_MASK);
	eval 'sub PAGE_SIZE_16MB_64KB () {2.30584300921369e+18;}' unless defined(&PAGE_SIZE_16MB_64KB);
	eval 'sub MFC_ACCR_EA_ACCESS_GET () {(1<< 0);}' unless defined(&MFC_ACCR_EA_ACCESS_GET);
	eval 'sub MFC_ACCR_EA_ACCESS_PUT () {(1<< 1);}' unless defined(&MFC_ACCR_EA_ACCESS_PUT);
	eval 'sub MFC_ACCR_LS_ACCESS_GET () {(1<< 3);}' unless defined(&MFC_ACCR_LS_ACCESS_GET);
	eval 'sub MFC_ACCR_LS_ACCESS_PUT () {(1<< 4);}' unless defined(&MFC_ACCR_LS_ACCESS_PUT);
	eval 'sub MFC_DSISR_PTE_NOT_FOUND () {(1<< 30);}' unless defined(&MFC_DSISR_PTE_NOT_FOUND);
	eval 'sub MFC_DSISR_ACCESS_DENIED () {(1<< 27);}' unless defined(&MFC_DSISR_ACCESS_DENIED);
	eval 'sub MFC_DSISR_ATOMIC () {(1<< 26);}' unless defined(&MFC_DSISR_ATOMIC);
	eval 'sub MFC_DSISR_ACCESS_PUT () {(1<< 25);}' unless defined(&MFC_DSISR_ACCESS_PUT);
	eval 'sub MFC_DSISR_ADDR_MATCH () {(1<< 22);}' unless defined(&MFC_DSISR_ADDR_MATCH);
	eval 'sub MFC_DSISR_LS () {(1<< 17);}' unless defined(&MFC_DSISR_LS);
	eval 'sub MFC_DSISR_L () {(1<< 16);}' unless defined(&MFC_DSISR_L);
	eval 'sub MFC_DSISR_ADDRESS_OVERFLOW () {(1<< 0);}' unless defined(&MFC_DSISR_ADDRESS_OVERFLOW);
	eval 'sub MFC_DSIR_Q () {(1<< 31);}' unless defined(&MFC_DSIR_Q);
	eval 'sub MFC_DSIR_SPU_QUEUE () { &MFC_DSIR_Q;}' unless defined(&MFC_DSIR_SPU_QUEUE);
	eval 'sub MFC_LSACR_COMPARE_MASK () {((~0) << 32);}' unless defined(&MFC_LSACR_COMPARE_MASK);
	eval 'sub MFC_LSACR_COMPARE_ADDR () {((~0) >> 32);}' unless defined(&MFC_LSACR_COMPARE_ADDR);
	eval 'sub MFC_LSCRR_Q () {(1<< 31);}' unless defined(&MFC_LSCRR_Q);
	eval 'sub MFC_LSCRR_SPU_QUEUE () { &MFC_LSCRR_Q;}' unless defined(&MFC_LSCRR_SPU_QUEUE);
	eval 'sub MFC_LSCRR_QI_SHIFT () {32;}' unless defined(&MFC_LSCRR_QI_SHIFT);
	eval 'sub MFC_LSCRR_QI_MASK () {((~0) <<  &MFC_LSCRR_QI_SHIFT);}' unless defined(&MFC_LSCRR_QI_MASK);
	eval 'sub MFC_TCLASS_ID_ENABLE () {(1 << 0);}' unless defined(&MFC_TCLASS_ID_ENABLE);
	eval 'sub MFC_TCLASS_SLOT2_ENABLE () {(1 << 5);}' unless defined(&MFC_TCLASS_SLOT2_ENABLE);
	eval 'sub MFC_TCLASS_SLOT1_ENABLE () {(1 << 6);}' unless defined(&MFC_TCLASS_SLOT1_ENABLE);
	eval 'sub MFC_TCLASS_SLOT0_ENABLE () {(1 << 7);}' unless defined(&MFC_TCLASS_SLOT0_ENABLE);
	eval 'sub MFC_TCLASS_QUOTA_2_SHIFT () {8;}' unless defined(&MFC_TCLASS_QUOTA_2_SHIFT);
	eval 'sub MFC_TCLASS_QUOTA_1_SHIFT () {16;}' unless defined(&MFC_TCLASS_QUOTA_1_SHIFT);
	eval 'sub MFC_TCLASS_QUOTA_0_SHIFT () {24;}' unless defined(&MFC_TCLASS_QUOTA_0_SHIFT);
	eval 'sub MFC_TCLASS_QUOTA_2_MASK () {(0x1f <<  &MFC_TCLASS_QUOTA_2_SHIFT);}' unless defined(&MFC_TCLASS_QUOTA_2_MASK);
	eval 'sub MFC_TCLASS_QUOTA_1_MASK () {(0x1f <<  &MFC_TCLASS_QUOTA_1_SHIFT);}' unless defined(&MFC_TCLASS_QUOTA_1_MASK);
	eval 'sub MFC_TCLASS_QUOTA_0_MASK () {(0x1f <<  &MFC_TCLASS_QUOTA_0_SHIFT);}' unless defined(&MFC_TCLASS_QUOTA_0_MASK);
	eval 'sub mfc_dma1_mask_lsb () {41;}' unless defined(&mfc_dma1_mask_lsb);
	eval 'sub mfc_dma1_shift () {(63-  &mfc_dma1_mask_lsb);}' unless defined(&mfc_dma1_shift);
	eval 'sub mfc_dma1_mask () {(0x3 <<  &mfc_dma1_shift);}' unless defined(&mfc_dma1_mask);
	eval 'sub mfc_dma1_bits () {(0x1 <<  &mfc_dma1_shift);}' unless defined(&mfc_dma1_bits);
	eval 'sub mfc_dma2_mask_lsb () {43;}' unless defined(&mfc_dma2_mask_lsb);
	eval 'sub mfc_dma2_shift () {(63-  &mfc_dma2_mask_lsb);}' unless defined(&mfc_dma2_shift);
	eval 'sub mfc_dma2_mask () {(0x3 <<  &mfc_dma2_shift);}' unless defined(&mfc_dma2_mask);
	eval 'sub mfc_dma2_bits () {(0x1 <<  &mfc_dma2_shift);}' unless defined(&mfc_dma2_bits);
	eval 'sub smm_sig_mask_lsb () {12;}' unless defined(&smm_sig_mask_lsb);
	eval 'sub smm_sig_shift () {(63-  &smm_sig_mask_lsb);}' unless defined(&smm_sig_shift);
	eval 'sub smm_sig_mask () {(0x3 <<  &smm_sig_shift);}' unless defined(&smm_sig_mask);
	eval 'sub smm_sig_bus0_bits () {(0x2 <<  &smm_sig_shift);}' unless defined(&smm_sig_bus0_bits);
	eval 'sub smm_sig_bus2_bits () {(0x1 <<  &smm_sig_shift);}' unless defined(&smm_sig_bus2_bits);
	eval 'sub MFC_CER_Q () {(1<< 31);}' unless defined(&MFC_CER_Q);
	eval 'sub MFC_CER_SPU_QUEUE () { &MFC_CER_Q;}' unless defined(&MFC_CER_SPU_QUEUE);
	eval 'sub SPU_ECC_CNTL_E () {(1 << 0);}' unless defined(&SPU_ECC_CNTL_E);
	eval 'sub SPU_ECC_CNTL_ENABLE () { &SPU_ECC_CNTL_E;}' unless defined(&SPU_ECC_CNTL_ENABLE);
	eval 'sub SPU_ECC_CNTL_DISABLE () {(~ &SPU_ECC_CNTL_E & 1);}' unless defined(&SPU_ECC_CNTL_DISABLE);
	eval 'sub SPU_ECC_CNTL_S () {(1 << 1);}' unless defined(&SPU_ECC_CNTL_S);
	eval 'sub SPU_ECC_STOP_AFTER_ERROR () { &SPU_ECC_CNTL_S;}' unless defined(&SPU_ECC_STOP_AFTER_ERROR);
	eval 'sub SPU_ECC_CONTINUE_AFTER_ERROR () {(~ &SPU_ECC_CNTL_S & 2);}' unless defined(&SPU_ECC_CONTINUE_AFTER_ERROR);
	eval 'sub SPU_ECC_CNTL_B () {(1 << 2);}' unless defined(&SPU_ECC_CNTL_B);
	eval 'sub SPU_ECC_BACKGROUND_ENABLE () { &SPU_ECC_CNTL_B;}' unless defined(&SPU_ECC_BACKGROUND_ENABLE);
	eval 'sub SPU_ECC_BACKGROUND_DISABLE () {(~ &SPU_ECC_CNTL_B & 4);}' unless defined(&SPU_ECC_BACKGROUND_DISABLE);
	eval 'sub SPU_ECC_CNTL_I_SHIFT () {3;}' unless defined(&SPU_ECC_CNTL_I_SHIFT);
	eval 'sub SPU_ECC_CNTL_I_MASK () {(3 <<  &SPU_ECC_CNTL_I_SHIFT);}' unless defined(&SPU_ECC_CNTL_I_MASK);
	eval 'sub SPU_ECC_WRITE_ALWAYS () {(~ &SPU_ECC_CNTL_I & 12);}' unless defined(&SPU_ECC_WRITE_ALWAYS);
	eval 'sub SPU_ECC_WRITE_CORRECTABLE () {(1 <<  &SPU_ECC_CNTL_I_SHIFT);}' unless defined(&SPU_ECC_WRITE_CORRECTABLE);
	eval 'sub SPU_ECC_WRITE_UNCORRECTABLE () {(3 <<  &SPU_ECC_CNTL_I_SHIFT);}' unless defined(&SPU_ECC_WRITE_UNCORRECTABLE);
	eval 'sub SPU_ECC_CNTL_D () {(1 << 5);}' unless defined(&SPU_ECC_CNTL_D);
	eval 'sub SPU_ECC_DETECTION_ENABLE () { &SPU_ECC_CNTL_D;}' unless defined(&SPU_ECC_DETECTION_ENABLE);
	eval 'sub SPU_ECC_DETECTION_DISABLE () {(~ &SPU_ECC_CNTL_D & 32);}' unless defined(&SPU_ECC_DETECTION_DISABLE);
	eval 'sub SPU_ECC_CORRECTED_ERROR () {(1 << 0);}' unless defined(&SPU_ECC_CORRECTED_ERROR);
	eval 'sub SPU_ECC_UNCORRECTED_ERROR () {(1 << 1);}' unless defined(&SPU_ECC_UNCORRECTED_ERROR);
	eval 'sub SPU_ECC_SCRUB_COMPLETE () {(1 << 2);}' unless defined(&SPU_ECC_SCRUB_COMPLETE);
	eval 'sub SPU_ECC_SCRUB_IN_PROGRESS () {(1 << 3);}' unless defined(&SPU_ECC_SCRUB_IN_PROGRESS);
	eval 'sub SPU_ECC_INSTRUCTION_ERROR () {(1 << 4);}' unless defined(&SPU_ECC_INSTRUCTION_ERROR);
	eval 'sub SPU_ECC_DATA_ERROR () {(1 << 5);}' unless defined(&SPU_ECC_DATA_ERROR);
	eval 'sub SPU_ECC_DMA_ERROR () {(1 << 6);}' unless defined(&SPU_ECC_DMA_ERROR);
	eval 'sub SPU_ECC_STATUS_CNT_MASK () {(256 << 8);}' unless defined(&SPU_ECC_STATUS_CNT_MASK);
	eval 'sub SPU_ERR_ILLEGAL_INSTR () {(1 << 0);}' unless defined(&SPU_ERR_ILLEGAL_INSTR);
	eval 'sub SPU_ERR_ILLEGAL_CHANNEL () {(1 << 1);}' unless defined(&SPU_ERR_ILLEGAL_CHANNEL);
	eval 'sub spu_trace_sel_mask () {0x1f1f;}' unless defined(&spu_trace_sel_mask);
	eval 'sub spu_trace_sel_bus0_bits () {0x1000;}' unless defined(&spu_trace_sel_bus0_bits);
	eval 'sub spu_trace_sel_bus2_bits () {0x10;}' unless defined(&spu_trace_sel_bus2_bits);
    }
}
1;
