require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_LINUX_FS_H)) {
    eval 'sub _LINUX_FS_H () {1;}' unless defined(&_LINUX_FS_H);
    require 'linux/config.ph';
    require 'linux/limits.ph';
    require 'linux/ioctl.ph';
    undef(&NR_OPEN) if defined(&NR_OPEN);
    eval 'sub NR_OPEN () {(1024*1024);}' unless defined(&NR_OPEN);
    eval 'sub INR_OPEN () {1024;}' unless defined(&INR_OPEN);
    eval 'sub BLOCK_SIZE_BITS () {10;}' unless defined(&BLOCK_SIZE_BITS);
    eval 'sub BLOCK_SIZE () {(1<< &BLOCK_SIZE_BITS);}' unless defined(&BLOCK_SIZE);
    if(defined(&CONFIG_DNOTIFY)) {
    }
    eval 'sub NR_FILE () {8192;}' unless defined(&NR_FILE);
    eval 'sub MAY_EXEC () {1;}' unless defined(&MAY_EXEC);
    eval 'sub MAY_WRITE () {2;}' unless defined(&MAY_WRITE);
    eval 'sub MAY_READ () {4;}' unless defined(&MAY_READ);
    eval 'sub MAY_APPEND () {8;}' unless defined(&MAY_APPEND);
    eval 'sub FMODE_READ () {1;}' unless defined(&FMODE_READ);
    eval 'sub FMODE_WRITE () {2;}' unless defined(&FMODE_WRITE);
    eval 'sub FMODE_LSEEK () {4;}' unless defined(&FMODE_LSEEK);
    eval 'sub FMODE_PREAD () {8;}' unless defined(&FMODE_PREAD);
    eval 'sub FMODE_PWRITE () { &FMODE_PREAD;}' unless defined(&FMODE_PWRITE);
    eval 'sub FMODE_EXEC () {16;}' unless defined(&FMODE_EXEC);
    eval 'sub RW_MASK () {1;}' unless defined(&RW_MASK);
    eval 'sub RWA_MASK () {2;}' unless defined(&RWA_MASK);
    eval 'sub READ () {0;}' unless defined(&READ);
    eval 'sub WRITE () {1;}' unless defined(&WRITE);
    eval 'sub READA () {2;}' unless defined(&READA);
    eval 'sub SWRITE () {3;}' unless defined(&SWRITE);
    eval 'sub SPECIAL () {4;}' unless defined(&SPECIAL);
    eval 'sub READ_SYNC () {( &READ | (1<<  &BIO_RW_SYNC));}' unless defined(&READ_SYNC);
    eval 'sub WRITE_SYNC () {( &WRITE | (1<<  &BIO_RW_SYNC));}' unless defined(&WRITE_SYNC);
    eval 'sub WRITE_BARRIER () {((1<<  &BIO_RW) | (1<<  &BIO_RW_BARRIER));}' unless defined(&WRITE_BARRIER);
    eval 'sub SEL_IN () {1;}' unless defined(&SEL_IN);
    eval 'sub SEL_OUT () {2;}' unless defined(&SEL_OUT);
    eval 'sub SEL_EX () {4;}' unless defined(&SEL_EX);
    eval 'sub FS_REQUIRES_DEV () {1;}' unless defined(&FS_REQUIRES_DEV);
    eval 'sub FS_BINARY_MOUNTDATA () {2;}' unless defined(&FS_BINARY_MOUNTDATA);
    eval 'sub FS_REVAL_DOT () {16384;}' unless defined(&FS_REVAL_DOT);
    eval 'sub FS_ODD_RENAME () {32768;}' unless defined(&FS_ODD_RENAME);
    eval 'sub MS_RDONLY () {1;}' unless defined(&MS_RDONLY);
    eval 'sub MS_NOSUID () {2;}' unless defined(&MS_NOSUID);
    eval 'sub MS_NODEV () {4;}' unless defined(&MS_NODEV);
    eval 'sub MS_NOEXEC () {8;}' unless defined(&MS_NOEXEC);
    eval 'sub MS_SYNCHRONOUS () {16;}' unless defined(&MS_SYNCHRONOUS);
    eval 'sub MS_REMOUNT () {32;}' unless defined(&MS_REMOUNT);
    eval 'sub MS_MANDLOCK () {64;}' unless defined(&MS_MANDLOCK);
    eval 'sub MS_DIRSYNC () {128;}' unless defined(&MS_DIRSYNC);
    eval 'sub MS_NOATIME () {1024;}' unless defined(&MS_NOATIME);
    eval 'sub MS_NODIRATIME () {2048;}' unless defined(&MS_NODIRATIME);
    eval 'sub MS_BIND () {4096;}' unless defined(&MS_BIND);
    eval 'sub MS_MOVE () {8192;}' unless defined(&MS_MOVE);
    eval 'sub MS_REC () {16384;}' unless defined(&MS_REC);
    eval 'sub MS_VERBOSE () {32768;}' unless defined(&MS_VERBOSE);
    eval 'sub MS_SILENT () {32768;}' unless defined(&MS_SILENT);
    eval 'sub MS_POSIXACL () {(1<<16);}' unless defined(&MS_POSIXACL);
    eval 'sub MS_UNBINDABLE () {(1<<17);}' unless defined(&MS_UNBINDABLE);
    eval 'sub MS_PRIVATE () {(1<<18);}' unless defined(&MS_PRIVATE);
    eval 'sub MS_SLAVE () {(1<<19);}' unless defined(&MS_SLAVE);
    eval 'sub MS_SHARED () {(1<<20);}' unless defined(&MS_SHARED);
    eval 'sub MS_ACTIVE () {(1<<30);}' unless defined(&MS_ACTIVE);
    eval 'sub MS_NOUSER () {(1<<31);}' unless defined(&MS_NOUSER);
    eval 'sub MS_RMT_MASK () {( &MS_RDONLY| &MS_SYNCHRONOUS| &MS_MANDLOCK);}' unless defined(&MS_RMT_MASK);
    eval 'sub MS_MGC_VAL () {0xc0ed0000;}' unless defined(&MS_MGC_VAL);
    eval 'sub MS_MGC_MSK () {0xffff0000;}' unless defined(&MS_MGC_MSK);
    eval 'sub S_SYNC () {1;}' unless defined(&S_SYNC);
    eval 'sub S_NOATIME () {2;}' unless defined(&S_NOATIME);
    eval 'sub S_APPEND () {4;}' unless defined(&S_APPEND);
    eval 'sub S_IMMUTABLE () {8;}' unless defined(&S_IMMUTABLE);
    eval 'sub S_DEAD () {16;}' unless defined(&S_DEAD);
    eval 'sub S_NOQUOTA () {32;}' unless defined(&S_NOQUOTA);
    eval 'sub S_DIRSYNC () {64;}' unless defined(&S_DIRSYNC);
    eval 'sub S_NOCMTIME () {128;}' unless defined(&S_NOCMTIME);
    eval 'sub S_SWAPFILE () {256;}' unless defined(&S_SWAPFILE);
    eval 'sub S_PRIVATE () {512;}' unless defined(&S_PRIVATE);
    eval 'sub __IS_FLG {
        my($inode,$flg) = @_;
	    eval q((($inode)-> ($i_sb->{s_flags}) & ($flg)));
    }' unless defined(&__IS_FLG);
    eval 'sub IS_RDONLY {
        my($inode) = @_;
	    eval q((($inode)-> ($i_sb->{s_flags}) &  &MS_RDONLY));
    }' unless defined(&IS_RDONLY);
    eval 'sub IS_SYNC {
        my($inode) = @_;
	    eval q(( &__IS_FLG($inode,  &MS_SYNCHRONOUS) || (($inode)-> &i_flags &  &S_SYNC)));
    }' unless defined(&IS_SYNC);
    eval 'sub IS_DIRSYNC {
        my($inode) = @_;
	    eval q(( &__IS_FLG($inode,  &MS_SYNCHRONOUS| &MS_DIRSYNC) || (($inode)-> &i_flags & ( &S_SYNC| &S_DIRSYNC))));
    }' unless defined(&IS_DIRSYNC);
    eval 'sub IS_MANDLOCK {
        my($inode) = @_;
	    eval q( &__IS_FLG($inode,  &MS_MANDLOCK));
    }' unless defined(&IS_MANDLOCK);
    eval 'sub IS_NOQUOTA {
        my($inode) = @_;
	    eval q((($inode)-> &i_flags &  &S_NOQUOTA));
    }' unless defined(&IS_NOQUOTA);
    eval 'sub IS_APPEND {
        my($inode) = @_;
	    eval q((($inode)-> &i_flags &  &S_APPEND));
    }' unless defined(&IS_APPEND);
    eval 'sub IS_IMMUTABLE {
        my($inode) = @_;
	    eval q((($inode)-> &i_flags &  &S_IMMUTABLE));
    }' unless defined(&IS_IMMUTABLE);
    eval 'sub IS_POSIXACL {
        my($inode) = @_;
	    eval q( &__IS_FLG($inode,  &MS_POSIXACL));
    }' unless defined(&IS_POSIXACL);
    eval 'sub IS_DEADDIR {
        my($inode) = @_;
	    eval q((($inode)-> &i_flags &  &S_DEAD));
    }' unless defined(&IS_DEADDIR);
    eval 'sub IS_NOCMTIME {
        my($inode) = @_;
	    eval q((($inode)-> &i_flags &  &S_NOCMTIME));
    }' unless defined(&IS_NOCMTIME);
    eval 'sub IS_SWAPFILE {
        my($inode) = @_;
	    eval q((($inode)-> &i_flags &  &S_SWAPFILE));
    }' unless defined(&IS_SWAPFILE);
    eval 'sub IS_PRIVATE {
        my($inode) = @_;
	    eval q((($inode)-> &i_flags &  &S_PRIVATE));
    }' unless defined(&IS_PRIVATE);
    eval 'sub BLKROSET () { &_IO(0x12,93);}' unless defined(&BLKROSET);
    eval 'sub BLKROGET () { &_IO(0x12,94);}' unless defined(&BLKROGET);
    eval 'sub BLKRRPART () { &_IO(0x12,95);}' unless defined(&BLKRRPART);
    eval 'sub BLKGETSIZE () { &_IO(0x12,96);}' unless defined(&BLKGETSIZE);
    eval 'sub BLKFLSBUF () { &_IO(0x12,97);}' unless defined(&BLKFLSBUF);
    eval 'sub BLKRASET () { &_IO(0x12,98);}' unless defined(&BLKRASET);
    eval 'sub BLKRAGET () { &_IO(0x12,99);}' unless defined(&BLKRAGET);
    eval 'sub BLKFRASET () { &_IO(0x12,100);}' unless defined(&BLKFRASET);
    eval 'sub BLKFRAGET () { &_IO(0x12,101);}' unless defined(&BLKFRAGET);
    eval 'sub BLKSECTSET () { &_IO(0x12,102);}' unless defined(&BLKSECTSET);
    eval 'sub BLKSECTGET () { &_IO(0x12,103);}' unless defined(&BLKSECTGET);
    eval 'sub BLKSSZGET () { &_IO(0x12,104);}' unless defined(&BLKSSZGET);
    if(0) {
	eval 'sub BLKPG () { &_IO(0x12,105);}' unless defined(&BLKPG);
	eval 'sub BLKELVGET () { &_IOR(0x12,106,\'size_t\');}' unless defined(&BLKELVGET);
	eval 'sub BLKELVSET () { &_IOW(0x12,107,\'size_t\');}' unless defined(&BLKELVSET);
    }
    eval 'sub BLKBSZGET () { &_IOR(0x12,112,\'size_t\');}' unless defined(&BLKBSZGET);
    eval 'sub BLKBSZSET () { &_IOW(0x12,113,\'size_t\');}' unless defined(&BLKBSZSET);
    eval 'sub BLKGETSIZE64 () { &_IOR(0x12,114,\'size_t\');}' unless defined(&BLKGETSIZE64);
    eval 'sub BLKTRACESETUP () { &_IOWR(0x12,115,\'struct blk_user_trace_setup\');}' unless defined(&BLKTRACESETUP);
    eval 'sub BLKTRACESTART () { &_IO(0x12,116);}' unless defined(&BLKTRACESTART);
    eval 'sub BLKTRACESTOP () { &_IO(0x12,117);}' unless defined(&BLKTRACESTOP);
    eval 'sub BLKTRACETEARDOWN () { &_IO(0x12,118);}' unless defined(&BLKTRACETEARDOWN);
    eval 'sub BMAP_IOCTL () {1;}' unless defined(&BMAP_IOCTL);
    eval 'sub FIBMAP () { &_IO(0x,1);}' unless defined(&FIBMAP);
    eval 'sub FIGETBSZ () { &_IO(0x,2);}' unless defined(&FIGETBSZ);
    eval 'sub SYNC_FILE_RANGE_WAIT_BEFORE () {1;}' unless defined(&SYNC_FILE_RANGE_WAIT_BEFORE);
    eval 'sub SYNC_FILE_RANGE_WRITE () {2;}' unless defined(&SYNC_FILE_RANGE_WRITE);
    eval 'sub SYNC_FILE_RANGE_WAIT_AFTER () {4;}' unless defined(&SYNC_FILE_RANGE_WAIT_AFTER);
    if(defined(&__KERNEL__)) {
	require 'linux/linkage.ph';
	require 'linux/wait.ph';
	require 'linux/types.ph';
	require 'linux/kdev_t.ph';
	require 'linux/dcache.ph';
	require 'linux/stat.ph';
	require 'linux/cache.ph';
	require 'linux/kobject.ph';
	require 'linux/list.ph';
	require 'linux/radix-tree.ph';
	require 'linux/prio_tree.ph';
	require 'linux/init.ph';
	require 'linux/sched.ph';
	require 'linux/mutex.ph';
	require 'asm/atomic.ph';
	require 'asm/semaphore.ph';
	require 'asm/byteorder.ph';
	eval 'sub ATTR_MODE () {1;}' unless defined(&ATTR_MODE);
	eval 'sub ATTR_UID () {2;}' unless defined(&ATTR_UID);
	eval 'sub ATTR_GID () {4;}' unless defined(&ATTR_GID);
	eval 'sub ATTR_SIZE () {8;}' unless defined(&ATTR_SIZE);
	eval 'sub ATTR_ATIME () {16;}' unless defined(&ATTR_ATIME);
	eval 'sub ATTR_MTIME () {32;}' unless defined(&ATTR_MTIME);
	eval 'sub ATTR_CTIME () {64;}' unless defined(&ATTR_CTIME);
	eval 'sub ATTR_ATIME_SET () {128;}' unless defined(&ATTR_ATIME_SET);
	eval 'sub ATTR_MTIME_SET () {256;}' unless defined(&ATTR_MTIME_SET);
	eval 'sub ATTR_FORCE () {512;}' unless defined(&ATTR_FORCE);
	eval 'sub ATTR_ATTR_FLAG () {1024;}' unless defined(&ATTR_ATTR_FLAG);
	eval 'sub ATTR_KILL_SUID () {2048;}' unless defined(&ATTR_KILL_SUID);
	eval 'sub ATTR_KILL_SGID () {4096;}' unless defined(&ATTR_KILL_SGID);
	eval 'sub ATTR_FILE () {8192;}' unless defined(&ATTR_FILE);
	require 'linux/quota.ph';
	eval("sub AOP_WRITEPAGE_ACTIVATE () { 0x80000; }") unless defined(&AOP_WRITEPAGE_ACTIVATE);
	eval("sub AOP_TRUNCATED_PAGE () { 0x80001; }") unless defined(&AOP_TRUNCATED_PAGE);
	if(defined(&CONFIG_SYSFS)) {
	}
	eval 'sub PAGECACHE_TAG_DIRTY () {0;}' unless defined(&PAGECACHE_TAG_DIRTY);
	eval 'sub PAGECACHE_TAG_WRITEBACK () {1;}' unless defined(&PAGECACHE_TAG_WRITEBACK);
	if((defined(&BITS_PER_LONG) ? &BITS_PER_LONG : 0)==32 && defined( &CONFIG_SMP)) {
	    require 'linux/seqlock.ph';
	    eval 'sub __NEED_I_SIZE_ORDERED () {1;}' unless defined(&__NEED_I_SIZE_ORDERED);
	    eval 'sub i_size_ordered_init {
	        my($inode) = @_;
    		eval q( &seqcount_init( ($inode->{i_size_seqcount})));
	    }' unless defined(&i_size_ordered_init);
	} else {
	    eval 'sub i_size_ordered_init {
	        my($inode) = @_;
    		eval q( &do { }  &while (0));
	    }' unless defined(&i_size_ordered_init);
	}
	if(defined(&CONFIG_QUOTA)) {
	}
	if(defined(&CONFIG_DNOTIFY)) {
	}
	if(defined(&CONFIG_INOTIFY)) {
	}
	if(defined(&__NEED_I_SIZE_ORDERED)) {
	}
	if((defined(&BITS_PER_LONG) ? &BITS_PER_LONG : 0)==32 && defined( &CONFIG_SMP)) {
	}
 elsif((defined(&BITS_PER_LONG) ? &BITS_PER_LONG : 0)==32 && defined( &CONFIG_PREEMPT)) {
	} else {
	}
# some #ifdef were dropped here -- fill in the blanks
	eval 'sub i_size_write {
	    my($inode,$i_size) = @_;
    	    eval q({ });
	}' unless defined(&i_size_write);
	eval 'sub iminor {
	    my($inode) = @_;
    	    eval q({  &MINOR( ($inode->{i_rdev})); });
	}' unless defined(&iminor);
	eval 'sub imajor {
	    my($inode) = @_;
    	    eval q({  &MAJOR( ($inode->{i_rdev})); });
	}' unless defined(&imajor);
	eval 'sub RA_FLAG_MISS () {0x1;}' unless defined(&RA_FLAG_MISS);
	eval 'sub RA_FLAG_INCACHE () {0x2;}' unless defined(&RA_FLAG_INCACHE);
	if(defined(&CONFIG_EPOLL)) {
	}
	eval 'sub file_list_lock () {
	    eval q( &spin_lock( &files_lock););
	}' unless defined(&file_list_lock);
	eval 'sub file_list_unlock () {
	    eval q( &spin_unlock( &files_lock););
	}' unless defined(&file_list_unlock);
	eval 'sub get_file {
	    my($x) = @_;
    	    eval q( &atomic_inc(($x)-> &f_count));
	}' unless defined(&get_file);
	eval 'sub file_count {
	    my($x) = @_;
    	    eval q( &atomic_read(($x)-> &f_count));
	}' unless defined(&file_count);
	eval 'sub MAX_NON_LFS () {((1<<31) - 1);}' unless defined(&MAX_NON_LFS);
	if((defined(&BITS_PER_LONG) ? &BITS_PER_LONG : 0)==32) {
	    eval 'sub MAX_LFS_FILESIZE () {((( &__u64) &PAGE_CACHE_SIZE << ( &BITS_PER_LONG-1))-1);}' unless defined(&MAX_LFS_FILESIZE);
	}
 elsif((defined(&BITS_PER_LONG) ? &BITS_PER_LONG : 0)==64) {
	    eval 'sub MAX_LFS_FILESIZE () {9.22337203685478e+18;}' unless defined(&MAX_LFS_FILESIZE);
	}
	eval 'sub FL_POSIX () {1;}' unless defined(&FL_POSIX);
	eval 'sub FL_FLOCK () {2;}' unless defined(&FL_FLOCK);
	eval 'sub FL_ACCESS () {8;}' unless defined(&FL_ACCESS);
	eval 'sub FL_LEASE () {32;}' unless defined(&FL_LEASE);
	eval 'sub FL_SLEEP () {128;}' unless defined(&FL_SLEEP);
	require 'linux/nfs_fs_i.ph';
	unless(defined(&OFFSET_MAX)) {
	    eval 'sub INT_LIMIT {
	        my($x) = @_;
    		eval q((~(($x)1<< ($sizeof{$x}*8- 1))));
	    }' unless defined(&INT_LIMIT);
	    eval 'sub OFFSET_MAX () { &INT_LIMIT( &loff_t);}' unless defined(&OFFSET_MAX);
	    eval 'sub OFFT_OFFSET_MAX () { &INT_LIMIT( &off_t);}' unless defined(&OFFT_OFFSET_MAX);
	}
	require 'linux/fcntl.ph';
	if((defined(&BITS_PER_LONG) ? &BITS_PER_LONG : 0) == 32) {
	}
	eval 'sub FASYNC_MAGIC () {0x4601;}' unless defined(&FASYNC_MAGIC);
	eval 'sub MNT_FORCE () {0x1;}' unless defined(&MNT_FORCE);
	eval 'sub MNT_DETACH () {0x2;}' unless defined(&MNT_DETACH);
	eval 'sub MNT_EXPIRE () {0x4;}' unless defined(&MNT_EXPIRE);
	eval 'sub sb_entry {
	    my($list) = @_;
    	    eval q( &list_entry(($list), \'struct super_block\',  &s_list));
	}' unless defined(&sb_entry);
	eval 'sub S_BIAS () {(1<<30);}' unless defined(&S_BIAS);
	eval("sub SB_UNFROZEN () { 0; }") unless defined(&SB_UNFROZEN);
	eval("sub SB_FREEZE_WRITE () { 1; }") unless defined(&SB_FREEZE_WRITE);
	eval("sub SB_FREEZE_TRANS () { 2; }") unless defined(&SB_FREEZE_TRANS);
	eval 'sub vfs_check_frozen {
	    my($sb, $level) = @_;
    	    eval q( &wait_event(($sb)-> &s_wait_unfrozen, (($sb)-> &s_frozen < ($level))));
	}' unless defined(&vfs_check_frozen);
	eval 'sub get_fs_excl {
	    my($void) = @_;
    	    eval q({  &atomic_inc( ($current->{fs_excl})); });
	}' unless defined(&get_fs_excl);
	eval 'sub put_fs_excl {
	    my($void) = @_;
    	    eval q({  &atomic_dec( ($current->{fs_excl})); });
	}' unless defined(&put_fs_excl);
	eval 'sub has_fs_excl {
	    my($void) = @_;
    	    eval q({  &atomic_read( ($current->{fs_excl})); });
	}' unless defined(&has_fs_excl);
	eval 'sub unlock_super {
	    my($sb) = @_;
    	    eval q({  &put_fs_excl();  &mutex_unlock( ($sb->{s_lock})); });
	}' unless defined(&unlock_super);
	eval 'sub DT_UNKNOWN () {0;}' unless defined(&DT_UNKNOWN);
	eval 'sub DT_FIFO () {1;}' unless defined(&DT_FIFO);
	eval 'sub DT_CHR () {2;}' unless defined(&DT_CHR);
	eval 'sub DT_DIR () {4;}' unless defined(&DT_DIR);
	eval 'sub DT_BLK () {6;}' unless defined(&DT_BLK);
	eval 'sub DT_REG () {8;}' unless defined(&DT_REG);
	eval 'sub DT_LNK () {10;}' unless defined(&DT_LNK);
	eval 'sub DT_SOCK () {12;}' unless defined(&DT_SOCK);
	eval 'sub DT_WHT () {14;}' unless defined(&DT_WHT);
	eval 'sub OSYNC_METADATA () {(1<<0);}' unless defined(&OSYNC_METADATA);
	eval 'sub OSYNC_DATA () {(1<<1);}' unless defined(&OSYNC_DATA);
	eval 'sub OSYNC_INODE () {(1<<2);}' unless defined(&OSYNC_INODE);
	eval 'sub HAVE_COMPAT_IOCTL () {1;}' unless defined(&HAVE_COMPAT_IOCTL);
	eval 'sub HAVE_UNLOCKED_IOCTL () {1;}' unless defined(&HAVE_UNLOCKED_IOCTL);
	eval 'sub I_DIRTY_SYNC () {1;}' unless defined(&I_DIRTY_SYNC);
	eval 'sub I_DIRTY_DATASYNC () {2;}' unless defined(&I_DIRTY_DATASYNC);
	eval 'sub I_DIRTY_PAGES () {4;}' unless defined(&I_DIRTY_PAGES);
	eval 'sub __I_LOCK () {3;}' unless defined(&__I_LOCK);
	eval 'sub I_LOCK () {(1<<  &__I_LOCK);}' unless defined(&I_LOCK);
	eval 'sub I_FREEING () {16;}' unless defined(&I_FREEING);
	eval 'sub I_CLEAR () {32;}' unless defined(&I_CLEAR);
	eval 'sub I_NEW () {64;}' unless defined(&I_NEW);
	eval 'sub I_WILL_FREE () {128;}' unless defined(&I_WILL_FREE);
	eval 'sub I_DIRTY () {( &I_DIRTY_SYNC |  &I_DIRTY_DATASYNC |  &I_DIRTY_PAGES);}' unless defined(&I_DIRTY);
	eval 'sub mark_inode_dirty {
	    my($inode) = @_;
    	    eval q({  &__mark_inode_dirty($inode,  &I_DIRTY); });
	}' unless defined(&mark_inode_dirty);
	eval 'sub mark_inode_dirty_sync {
	    my($inode) = @_;
    	    eval q({  &__mark_inode_dirty($inode,  &I_DIRTY_SYNC); });
	}' unless defined(&mark_inode_dirty_sync);
	eval 'sub inode_inc_link_count {
	    my($inode) = @_;
    	    eval q({  ($inode->{i_nlink})++;  &mark_inode_dirty($inode); });
	}' unless defined(&inode_inc_link_count);
	eval 'sub inode_dec_link_count {
	    my($inode) = @_;
    	    eval q({  ($inode->{i_nlink})--;  &mark_inode_dirty($inode); });
	}' unless defined(&inode_dec_link_count);
	eval 'sub file_accessed {
	    my($file) = @_;
    	    eval q({  &if (!( ($file->{f_flags}) &  &O_NOATIME))  &touch_atime( ($file->{f_vfsmnt}),  ($file->{f_dentry})); });
	}' unless defined(&file_accessed);
	eval 'sub fops_get {
	    my($fops) = @_;
    	    eval q(((($fops)  &&  &try_module_get(($fops)-> &owner) ? ($fops) :  &NULL)));
	}' unless defined(&fops_get);
	eval 'sub fops_put {
	    my($fops) = @_;
    	    eval q( &do {  &if ($fops)  &module_put(($fops)-> &owner); }  &while(0));
	}' unless defined(&fops_put);
	eval 'sub FLOCK_VERIFY_READ () {1;}' unless defined(&FLOCK_VERIFY_READ);
	eval 'sub FLOCK_VERIFY_WRITE () {2;}' unless defined(&FLOCK_VERIFY_WRITE);
	eval 'sub MANDATORY_LOCK {
	    my($inode) = @_;
    	    eval q(( &IS_MANDLOCK($inode)  && (($inode)-> &i_mode & ( &S_ISGID |  &S_IXGRP)) ==  &S_ISGID));
	}' unless defined(&MANDATORY_LOCK);
	eval 'sub locks_verify_locked {
	    my($inode) = @_;
    	    eval q({  &if ( &MANDATORY_LOCK($inode))  &locks_mandatory_locked($inode); 0; });
	}' unless defined(&locks_verify_locked);
	eval 'sub locks_verify_truncate {
	    my($inode,$filp,$size) = @_;
    	    eval q({  &if ( ($inode->{i_flock})  &&  &MANDATORY_LOCK($inode))  &locks_mandatory_area(  &FLOCK_VERIFY_WRITE, $inode, $filp, $size <  ($inode->{i_size}) ? $size :  ($inode->{i_size}), ($size <  ($inode->{i_size}) ?  ($inode->{i_size}) - $size : $size -  ($inode->{i_size})) ); 0; });
	}' unless defined(&locks_verify_truncate);
	eval 'sub break_lease {
	    my($inode,$mode) = @_;
    	    eval q({  &if ( ($inode->{i_flock}))  &__break_lease($inode, $mode); 0; });
	}' unless defined(&break_lease);
	eval 'sub __getname () {
	    eval q( &kmem_cache_alloc( &names_cachep,  &SLAB_KERNEL));
	}' unless defined(&__getname);
	eval 'sub __putname {
	    my($name) = @_;
    	    eval q( &kmem_cache_free( &names_cachep, ( &void *)($name)));
	}' unless defined(&__putname);
	unless(defined(&CONFIG_AUDITSYSCALL)) {
	    eval 'sub putname {
	        my($name) = @_;
    		eval q( &__putname($name));
	    }' unless defined(&putname);
	} else {
	}
	if(defined(&CONFIG_SYSFS)) {
	} else {
	    eval 'sub bd_claim_by_disk {
	        my($bdev, $holder, $disk) = @_;
    		eval q( &bd_claim($bdev, $holder));
	    }' unless defined(&bd_claim_by_disk);
	    eval 'sub bd_release_from_disk {
	        my($bdev, $disk) = @_;
    		eval q( &bd_release($bdev));
	    }' unless defined(&bd_release_from_disk);
	}
	eval 'sub CHRDEV_MAJOR_HASH_SIZE () {255;}' unless defined(&CHRDEV_MAJOR_HASH_SIZE);
	eval 'sub BLKDEV_MAJOR_HASH_SIZE () {255;}' unless defined(&BLKDEV_MAJOR_HASH_SIZE);
	eval 'sub BDEVNAME_SIZE () {32;}' unless defined(&BDEVNAME_SIZE);
	eval 'sub bio_rw {
	    my($bio) = @_;
    	    eval q((($bio)-> &bi_rw & ( &RW_MASK |  &RWA_MASK)));
	}' unless defined(&bio_rw);
	eval 'sub bio_data_dir {
	    my($bio) = @_;
    	    eval q((($bio)-> &bi_rw & 1));
	}' unless defined(&bio_data_dir);
	eval 'sub invalidate_remote_inode {
	    my($inode) = @_;
    	    eval q({  &if ( &S_ISREG( ($inode->{i_mode})) ||  &S_ISDIR( ($inode->{i_mode})) ||  &S_ISLNK( ($inode->{i_mode})))  &invalidate_inode_pages( ($inode->{i_mapping})); });
	}' unless defined(&invalidate_remote_inode);
	eval 'sub put_write_access {
	    my($inode) = @_;
    	    eval q({  &atomic_dec( ($inode->{i_writecount})); });
	}' unless defined(&put_write_access);
	eval 'sub allow_write_access {
	    my($file) = @_;
    	    eval q({  &if ($file)  &atomic_inc( ($file->{f_dentry}->{d_inode}->{i_writecount})); });
	}' unless defined(&allow_write_access);
	require 'linux/err.ph';
	eval 'sub inode {
	    eval q(* &iget(\'struct super_block\' * &sb, my $ino) { \'struct inode\' * &inode =  &iget_locked( &sb,  $ino);  &if ( &inode  && ( ($inode->{i_state}) &  &I_NEW)) {  ($sb->{s_op}->{read_inode})( &inode);  &unlock_new_inode( &inode); }  &inode; });
	}' unless defined(&inode);
	eval 'sub insert_inode_hash {
	    my($inode) = @_;
    	    eval q({  &__insert_inode_hash($inode,  ($inode->{i_ino})); });
	}' unless defined(&insert_inode_hash);
	if(defined(&CONFIG_FS_XIP)) {
	} else {
	    eval 'sub xip_truncate_page {
	        my($mapping,$from) = @_;
    		eval q({ 0; });
	    }' unless defined(&xip_truncate_page);
	}
	eval 'sub do_generic_file_read {
	    my($filp,$ppos,$desc,$actor) = @_;
    	    eval q({  &do_generic_mapping_read( ($filp->{f_mapping}),  ($filp->{f_ra}), $filp, $ppos, $desc, $actor); });
	}' unless defined(&do_generic_file_read);
	eval("sub DIO_LOCKING () { 1; }") unless defined(&DIO_LOCKING);
	eval("sub DIO_NO_LOCKING () { 2; }") unless defined(&DIO_NO_LOCKING);
	eval("sub DIO_OWN_LOCKING () { 3; }") unless defined(&DIO_OWN_LOCKING);
	eval 'sub blockdev_direct_IO {
	    my($rw,$iocb,$inode,$bdev,$iov,$offset,$nr_segs,$get_block,$end_io) = @_;
    	    eval q({  &__blockdev_direct_IO($rw, $iocb, $inode, $bdev, $iov, $offset, $nr_segs, $get_block, $end_io,  &DIO_LOCKING); });
	}' unless defined(&blockdev_direct_IO);
	eval 'sub blockdev_direct_IO_no_locking {
	    my($rw,$iocb,$inode,$bdev,$iov,$offset,$nr_segs,$get_block,$end_io) = @_;
    	    eval q({  &__blockdev_direct_IO($rw, $iocb, $inode, $bdev, $iov, $offset, $nr_segs, $get_block, $end_io,  &DIO_NO_LOCKING); });
	}' unless defined(&blockdev_direct_IO_no_locking);
	eval 'sub blockdev_direct_IO_own_locking {
	    my($rw,$iocb,$inode,$bdev,$iov,$offset,$nr_segs,$get_block,$end_io) = @_;
    	    eval q({  &__blockdev_direct_IO($rw, $iocb, $inode, $bdev, $iov, $offset, $nr_segs, $get_block, $end_io,  &DIO_OWN_LOCKING); });
	}' unless defined(&blockdev_direct_IO_own_locking);
	eval 'sub special_file {
	    my($m) = @_;
    	    eval q(( &S_ISCHR($m)|| &S_ISBLK($m)|| &S_ISFIFO($m)|| &S_ISSOCK($m)));
	}' unless defined(&special_file);
	if(defined(&CONFIG_MIGRATION)) {
	} else {
	    eval 'sub buffer_migrate_page () { &NULL;}' unless defined(&buffer_migrate_page);
	}
	eval 'sub parent_ino {
	    my($dentry) = @_;
    	    eval q({  &ino_t  &res;  &spin_lock( ($dentry->{d_lock}));  &res =  ($dentry->{d_parent}->{d_inode}->{i_ino});  &spin_unlock( ($dentry->{d_lock}));  &res; });
	}' unless defined(&parent_ino);
	eval 'sub SIMPLE_TRANSACTION_LIMIT () {( &PAGE_SIZE - $sizeof{\'struct simple_transaction_argresp\'});}' unless defined(&SIMPLE_TRANSACTION_LIMIT);
	eval 'sub simple_transaction_set {
	    my($file,$n) = @_;
    	    eval q({ \'struct simple_transaction_argresp\' * &ar =  ($file->{private_data});  &BUG_ON($n >  &SIMPLE_TRANSACTION_LIMIT);  &smp_mb();  ($ar->{size}) = $n; });
	}' unless defined(&simple_transaction_set);
	eval 'sub DEFINE_SIMPLE_ATTRIBUTE {
	    my($__fops, $__get, $__set, $__fmt) = @_;
    	    eval q( &static \'int\' $__fops   &_open(\'struct inode\' * &inode, \'struct file\' * &file) {  &__simple_attr_check_format($__fmt, 0);  &return  &simple_attr_open( &inode,  &file, $__get, $__set, $__fmt); }  &static \'struct file_operations\' $__fops = { . &owner =  &THIS_MODULE, . &open = $__fops   &_open, . &release =  &simple_attr_close, . &read =  &simple_attr_read, . &write =  &simple_attr_write, };);
	}' unless defined(&DEFINE_SIMPLE_ATTRIBUTE);
	eval 'sub free_secdata {
	    my($secdata) = @_;
    	    eval q({  &free_page($secdata); });
	}' unless defined(&free_secdata);
    } else {
	eval 'sub char {
	    eval q(* &alloc_secdata { 1; });
	}' unless defined(&char);
	eval 'sub free_secdata {
	    my($secdata) = @_;
    	    eval q({ });
	}' unless defined(&free_secdata);
    }
}
    }
1;
