require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_ASM_POWERPC_HW_IRQ_H)) {
    eval 'sub _ASM_POWERPC_HW_IRQ_H () {1;}' unless defined(&_ASM_POWERPC_HW_IRQ_H);
    if(defined(&__KERNEL__)) {
	require 'linux/config.ph';
	require 'linux/errno.ph';
	require 'asm/ptrace.ph';
	require 'asm/processor.ph';
	if(defined(&CONFIG_PPC_ISERIES)) {
	    eval 'sub local_irq_enable () {
	        eval q( &local_irq_restore(1));
	    }' unless defined(&local_irq_enable);
	    eval 'sub local_save_flags {
	        my($flags) = @_;
    		eval q((($flags) =  &local_get_flags()));
	    }' unless defined(&local_save_flags);
	    eval 'sub local_irq_save {
	        my($flags) = @_;
    		eval q((($flags) =  &local_irq_disable()));
	    }' unless defined(&local_irq_save);
	    eval 'sub irqs_disabled () {
	        eval q(( &local_get_flags() == 0));
	    }' unless defined(&irqs_disabled);
	} else {
	    if(defined( &CONFIG_BOOKE)) {
		eval 'sub SET_MSR_EE {
		    my($x) = @_;
    		    eval q( &mtmsr($x));
		}' unless defined(&SET_MSR_EE);
		eval 'sub local_irq_restore {
		    my($flags) = @_;
    		    eval q(\\"(assembly code)\\");
		}' unless defined(&local_irq_restore);
	    }
 elsif(defined( &__powerpc64__)) {
		eval 'sub SET_MSR_EE {
		    my($x) = @_;
    		    eval q( &__mtmsrd($x, 1));
		}' unless defined(&SET_MSR_EE);
		eval 'sub local_irq_restore {
		    my($flags) = @_;
    		    eval q(\\"(assembly code)\\");
		}' unless defined(&local_irq_restore);
	    } else {
		eval 'sub SET_MSR_EE {
		    my($x) = @_;
    		    eval q( &mtmsr($x));
		}' unless defined(&SET_MSR_EE);
		eval 'sub local_irq_restore {
		    my($flags) = @_;
    		    eval q( &mtmsr($flags));
		}' unless defined(&local_irq_restore);
	    }
# some #ifdef were dropped here -- fill in the blanks
	    eval 'sub local_irq_disable {
	        my($void) = @_;
    		eval q({ });
	    }' unless defined(&local_irq_disable);
# some #ifdef were dropped here -- fill in the blanks
	    eval 'sub local_irq_enable {
	        my($void) = @_;
    		eval q({ });
	    }' unless defined(&local_irq_enable);
# some #ifdef were dropped here -- fill in the blanks
	    eval 'sub local_irq_save_ptr {
	        my($flags) = @_;
    		eval q(\\"(assembly code)\\");
	    }' unless defined(&local_irq_save_ptr);
	    eval 'sub local_save_flags {
	        my($flags) = @_;
    		eval q((($flags) =  &mfmsr()));
	    }' unless defined(&local_save_flags);
	    eval 'sub local_irq_save {
	        my($flags) = @_;
    		eval q( &local_irq_save_ptr($flags));
	    }' unless defined(&local_irq_save);
	    eval 'sub irqs_disabled () {
	        eval q((( &mfmsr() &  &MSR_EE) == 0));
	    }' unless defined(&irqs_disabled);
	}
	eval 'sub mask_irq {
	    my($irq) = @_;
    	    eval q(({  &irq_desc_t * &desc =  &get_irq_desc($irq);  &if ( ($desc->{handler})  &&  ($desc->{handler}->{disable}))  ($desc->{handler}->{disable})($irq); }));
	}' unless defined(&mask_irq);
	eval 'sub unmask_irq {
	    my($irq) = @_;
    	    eval q(({  &irq_desc_t * &desc =  &get_irq_desc($irq);  &if ( ($desc->{handler})  &&  ($desc->{handler}->{enable}))  ($desc->{handler}->{enable})($irq); }));
	}' unless defined(&unmask_irq);
	eval 'sub ack_irq {
	    my($irq) = @_;
    	    eval q(({  &irq_desc_t * &desc =  &get_irq_desc($irq);  &if ( ($desc->{handler})  &&  ($desc->{handler}->{ack}))  ($desc->{handler}->{ack})($irq); }));
	}' unless defined(&ack_irq);
    }
}
1;
