require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_PPC64_LMB_H)) {
    eval 'sub _PPC64_LMB_H () {1;}' unless defined(&_PPC64_LMB_H);
    if(defined(&__KERNEL__)) {
	require 'linux/init.ph';
	require 'asm/prom.ph';
	eval 'sub MAX_LMB_REGIONS () {128;}' unless defined(&MAX_LMB_REGIONS);
	eval 'sub lmb_size_bytes {
	    my($type,$region_nr) = @_;
    	    eval q({  ($type->{region[$region_nr]}->{size}); });
	}' unless defined(&lmb_size_bytes);
	eval 'sub lmb_size_pages {
	    my($type,$region_nr) = @_;
    	    eval q({  &lmb_size_bytes($type, $region_nr) >>  &PAGE_SHIFT; });
	}' unless defined(&lmb_size_pages);
	eval 'sub lmb_start_pfn {
	    my($type,$region_nr) = @_;
    	    eval q({  ($type->{region[$region_nr]}->{base}) >>  &PAGE_SHIFT; });
	}' unless defined(&lmb_start_pfn);
	eval 'sub lmb_end_pfn {
	    my($type,$region_nr) = @_;
    	    eval q({  &lmb_start_pfn($type, $region_nr) +  &lmb_size_pages($type, $region_nr); });
	}' unless defined(&lmb_end_pfn);
    }
}
1;
