require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_ASM_POWERPC_PAGE_64_H)) {
    eval 'sub _ASM_POWERPC_PAGE_64_H () {1;}' unless defined(&_ASM_POWERPC_PAGE_64_H);
    if(defined(&__KERNEL__)) {
	eval 'sub HW_PAGE_SHIFT () {12;}' unless defined(&HW_PAGE_SHIFT);
	eval 'sub HW_PAGE_SIZE () {( &ASM_CONST(1) <<  &HW_PAGE_SHIFT);}' unless defined(&HW_PAGE_SIZE);
	eval 'sub HW_PAGE_MASK () {(~( &HW_PAGE_SIZE-1));}' unless defined(&HW_PAGE_MASK);
	eval 'sub PAGE_FACTOR () {( &PAGE_SHIFT -  &HW_PAGE_SHIFT);}' unless defined(&PAGE_FACTOR);
	eval 'sub SID_SHIFT () {28;}' unless defined(&SID_SHIFT);
	eval 'sub SID_MASK () {0xfffffffff;}' unless defined(&SID_MASK);
	eval 'sub ESID_MASK () {0xfffffffff0000000;}' unless defined(&ESID_MASK);
	eval 'sub GET_ESID {
	    my($x) = @_;
    	    eval q(((($x) >>  &SID_SHIFT) &  &SID_MASK));
	}' unless defined(&GET_ESID);
	unless(defined(&__ASSEMBLY__)) {
	    require 'asm/cache.ph';
	    eval 'sub clear_page {
	        my($addr) = @_;
    		eval q(\\"(assembly code)\\");
	    }' unless defined(&clear_page);
	    if(defined(&CONFIG_PPC_64K_PAGES)) {
		eval 'sub copy_page {
		    my($to,$from) = @_;
    		    eval q({ my $i;  &for ( $i=0;  $i < (1<< ( &PAGE_SHIFT - 12));  $i++) {  &copy_4K_page($to, $from); $to += 4096; $from += 4096; } });
		}' unless defined(&copy_page);
	    } else {
		eval 'sub copy_page {
		    my($to,$from) = @_;
    		    eval q({  &copy_4K_page($to, $from); });
		}' unless defined(&copy_page);
	    }
	    if(defined(&CONFIG_HUGETLB_PAGE)) {
	    } else {
		eval 'sub HPAGE_SHIFT () { &PAGE_SHIFT;}' unless defined(&HPAGE_SHIFT);
	    }
	    eval 'sub HPAGE_SIZE () {((1) <<  &HPAGE_SHIFT);}' unless defined(&HPAGE_SIZE);
	    eval 'sub HPAGE_MASK () {(~( &HPAGE_SIZE - 1));}' unless defined(&HPAGE_MASK);
	    eval 'sub HUGETLB_PAGE_ORDER () {( &HPAGE_SHIFT -  &PAGE_SHIFT);}' unless defined(&HUGETLB_PAGE_ORDER);
	}
	if(defined(&CONFIG_HUGETLB_PAGE)) {
	    eval 'sub HTLB_AREA_SHIFT () {40;}' unless defined(&HTLB_AREA_SHIFT);
	    eval 'sub HTLB_AREA_SIZE () {(1 <<  &HTLB_AREA_SHIFT);}' unless defined(&HTLB_AREA_SIZE);
	    eval 'sub GET_HTLB_AREA {
	        my($x) = @_;
    		eval q((($x) >>  &HTLB_AREA_SHIFT));
	    }' unless defined(&GET_HTLB_AREA);
	    eval 'sub LOW_ESID_MASK {
	        my($addr, $len) = @_;
    		eval q((((1 << ( &GET_ESID( &min(($addr)+($len)-1, 0x100000000))+1)) - (1 <<  &GET_ESID( &min(($addr), 0x100000000)))) & 0xffff));
	    }' unless defined(&LOW_ESID_MASK);
	    eval 'sub HTLB_AREA_MASK {
	        my($addr, $len) = @_;
    		eval q((((1 << ( &GET_HTLB_AREA($addr+$len-1)+1)) - (1 <<  &GET_HTLB_AREA($addr))) & 0xffff));
	    }' unless defined(&HTLB_AREA_MASK);
	    eval 'sub ARCH_HAS_HUGEPAGE_ONLY_RANGE () {1;}' unless defined(&ARCH_HAS_HUGEPAGE_ONLY_RANGE);
	    eval 'sub ARCH_HAS_HUGETLB_FREE_PGD_RANGE () {1;}' unless defined(&ARCH_HAS_HUGETLB_FREE_PGD_RANGE);
	    eval 'sub ARCH_HAS_PREPARE_HUGEPAGE_RANGE () {1;}' unless defined(&ARCH_HAS_PREPARE_HUGEPAGE_RANGE);
	    eval 'sub ARCH_HAS_SETCLEAR_HUGE_PTE () {1;}' unless defined(&ARCH_HAS_SETCLEAR_HUGE_PTE);
	    eval 'sub touches_hugepage_low_range {
	        my($mm, $addr, $len) = @_;
    		eval q(((($addr) < 0x100000000)  && ( &LOW_ESID_MASK(($addr), ($len)) & ($mm)-> ($context->{low_htlb_areas}))));
	    }' unless defined(&touches_hugepage_low_range);
	    eval 'sub touches_hugepage_high_range {
	        my($mm, $addr, $len) = @_;
    		eval q((((($addr) + ($len)) > 0x100000000)  && ( &HTLB_AREA_MASK(($addr), ($len)) & ($mm)-> ($context->{high_htlb_areas}))));
	    }' unless defined(&touches_hugepage_high_range);
	    eval 'sub __within_hugepage_low_range {
	        my($addr, $len, $segmask) = @_;
    		eval q(( ((($addr)+($len)) <= 0x100000000)  && (( &LOW_ESID_MASK(($addr), ($len)) | ($segmask)) == ($segmask))));
	    }' unless defined(&__within_hugepage_low_range);
	    eval 'sub within_hugepage_low_range {
	        my($addr, $len) = @_;
    		eval q( &__within_hugepage_low_range(($addr), ($len),  ($current->{mm}->{context}->{low_htlb_areas})));
	    }' unless defined(&within_hugepage_low_range);
	    eval 'sub __within_hugepage_high_range {
	        my($addr, $len, $zonemask) = @_;
    		eval q(( (($addr) >= 0x100000000)  && (( &HTLB_AREA_MASK(($addr), ($len)) | ($zonemask)) == ($zonemask))));
	    }' unless defined(&__within_hugepage_high_range);
	    eval 'sub within_hugepage_high_range {
	        my($addr, $len) = @_;
    		eval q( &__within_hugepage_high_range(($addr), ($len),  ($current->{mm}->{context}->{high_htlb_areas})));
	    }' unless defined(&within_hugepage_high_range);
	    eval 'sub is_hugepage_only_range {
	        my($mm, $addr, $len) = @_;
    		eval q(( &touches_hugepage_high_range(($mm), ($addr), ($len)) ||  &touches_hugepage_low_range(($mm), ($addr), ($len))));
	    }' unless defined(&is_hugepage_only_range);
	    eval 'sub HAVE_ARCH_HUGETLB_UNMAPPED_AREA () {1;}' unless defined(&HAVE_ARCH_HUGETLB_UNMAPPED_AREA);
	    eval 'sub in_hugepage_area {
	        my($context, $addr) = @_;
    		eval q(( &cpu_has_feature( &CPU_FTR_16M_PAGE)  && ( ( ($addr) >= 0x100000000) ? ((1<<  &GET_HTLB_AREA($addr)) & ($context). &high_htlb_areas) : ((1<<  &GET_ESID($addr)) & ($context). &low_htlb_areas) ) ));
	    }' unless defined(&in_hugepage_area);
	} else {
	    eval 'sub in_hugepage_area {
	        my($mm, $addr) = @_;
    		eval q(0);
	    }' unless defined(&in_hugepage_area);
	}
	if(defined(&MODULE)) {
	    eval 'sub __page_aligned () { &__attribute__(( &__aligned__( &PAGE_SIZE)));}' unless defined(&__page_aligned);
	} else {
	    eval 'sub __page_aligned () { &__attribute__(( &__aligned__( &PAGE_SIZE),  &__section__(".data.page_aligned")));}' unless defined(&__page_aligned);
	}
	eval 'sub VM_DATA_DEFAULT_FLAGS () {( &test_thread_flag( &TIF_32BIT) ?  &VM_DATA_DEFAULT_FLAGS32 :  &VM_DATA_DEFAULT_FLAGS64);}' unless defined(&VM_DATA_DEFAULT_FLAGS);
	eval 'sub VM_STACK_DEFAULT_FLAGS32 () {( &VM_READ |  &VM_WRITE |  &VM_EXEC |  &VM_MAYREAD |  &VM_MAYWRITE |  &VM_MAYEXEC);}' unless defined(&VM_STACK_DEFAULT_FLAGS32);
	eval 'sub VM_STACK_DEFAULT_FLAGS64 () {( &VM_READ |  &VM_WRITE |  &VM_MAYREAD |  &VM_MAYWRITE |  &VM_MAYEXEC);}' unless defined(&VM_STACK_DEFAULT_FLAGS64);
	eval 'sub VM_STACK_DEFAULT_FLAGS () {( &test_thread_flag( &TIF_32BIT) ?  &VM_STACK_DEFAULT_FLAGS32 :  &VM_STACK_DEFAULT_FLAGS64);}' unless defined(&VM_STACK_DEFAULT_FLAGS);
	require 'asm-generic/page.ph';
    }
}
1;
