require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&__ASM_POWERPC_PCI_H)) {
    eval 'sub __ASM_POWERPC_PCI_H () {1;}' unless defined(&__ASM_POWERPC_PCI_H);
    if(defined(&__KERNEL__)) {
	require 'linux/types.ph';
	require 'linux/slab.ph';
	require 'linux/string.ph';
	require 'linux/dma-mapping.ph';
	require 'asm/machdep.ph';
	require 'asm/scatterlist.ph';
	require 'asm/io.ph';
	require 'asm/prom.ph';
	require 'asm/pci-bridge.ph';
	require 'asm-generic/pci-dma-compat.ph';
	eval 'sub PCIBIOS_MIN_IO () {0x1000;}' unless defined(&PCIBIOS_MIN_IO);
	eval 'sub PCIBIOS_MIN_MEM () {0x10000000;}' unless defined(&PCIBIOS_MIN_MEM);
	eval 'sub IOBASE_BRIDGE_NUMBER () {0;}' unless defined(&IOBASE_BRIDGE_NUMBER);
	eval 'sub IOBASE_MEMORY () {1;}' unless defined(&IOBASE_MEMORY);
	eval 'sub IOBASE_IO () {2;}' unless defined(&IOBASE_IO);
	eval 'sub IOBASE_ISA_IO () {3;}' unless defined(&IOBASE_ISA_IO);
	eval 'sub IOBASE_ISA_MEM () {4;}' unless defined(&IOBASE_ISA_MEM);
	eval 'sub pcibios_assign_all_busses () {
	    eval q(( &pci_assign_all_buses));
	}' unless defined(&pcibios_assign_all_busses);
	eval 'sub pcibios_scan_all_fns {
	    my($a, $b) = @_;
    	    eval q(0);
	}' unless defined(&pcibios_scan_all_fns);
	eval 'sub HAVE_ARCH_PCI_GET_LEGACY_IDE_IRQ () {1;}' unless defined(&HAVE_ARCH_PCI_GET_LEGACY_IDE_IRQ);
	eval 'sub pci_get_legacy_ide_irq {
	    my($dev,$channel) = @_;
    	    eval q({  &if ( ($ppc_md->{pci_get_legacy_ide_irq}))  ($ppc_md->{pci_get_legacy_ide_irq})($dev, $channel); $channel ? 15: 14; });
	}' unless defined(&pci_get_legacy_ide_irq);
	if(defined(&CONFIG_PPC64)) {
	    eval 'sub HAVE_ARCH_PCI_MWI () {1;}' unless defined(&HAVE_ARCH_PCI_MWI);
	    eval 'sub pcibios_prep_mwi {
	        my($dev) = @_;
    		eval q({ 0; });
	    }' unless defined(&pcibios_prep_mwi);
	    if(defined(&CONFIG_PCI)) {
		eval 'sub pci_dma_burst_advice {
		    my($pdev,$strat,$strategy_parameter) = @_;
    		    eval q({ my $cacheline_size;  &__u8  &byte;  &pci_read_config_byte($pdev,  &PCI_CACHE_LINE_SIZE,  &byte);  &if ( &byte == 0)  $cacheline_size = 1024;  &else  $cacheline_size =  &byte * 4; *$strat =  &PCI_DMA_BURST_MULTIPLE; *$strategy_parameter =  $cacheline_size; });
		}' unless defined(&pci_dma_burst_advice);
	    }
	} else {
	    if(defined(&CONFIG_PCI)) {
		eval 'sub pci_dma_burst_advice {
		    my($pdev,$strat,$strategy_parameter) = @_;
    		    eval q({ *$strat =  &PCI_DMA_BURST_INFINITY; *$strategy_parameter = ~0; });
		}' unless defined(&pci_dma_burst_advice);
	    }
	    eval 'sub pci_dac_dma_supported {
	        my($pci_dev, $mask) = @_;
    		eval q((0));
	    }' unless defined(&pci_dac_dma_supported);
	    eval 'sub pci_domain_nr {
	        my($bus) = @_;
    		eval q((($bus)-> &sysdata)-> &index);
	    }' unless defined(&pci_domain_nr);
	}
	eval 'sub HAVE_PCI_MMAP () {1;}' unless defined(&HAVE_PCI_MMAP);
	if(defined(&CONFIG_PPC64)) {
	    eval 'sub DECLARE_PCI_UNMAP_ADDR {
	        my($ADDR_NAME) = @_;
    		eval q( &dma_addr_t $ADDR_NAME;);
	    }' unless defined(&DECLARE_PCI_UNMAP_ADDR);
	    eval 'sub DECLARE_PCI_UNMAP_LEN {
	        my($LEN_NAME) = @_;
    		eval q( &__u32 $LEN_NAME;);
	    }' unless defined(&DECLARE_PCI_UNMAP_LEN);
	    eval 'sub pci_unmap_addr {
	        my($PTR, $ADDR_NAME) = @_;
    		eval q((($PTR)->$ADDR_NAME));
	    }' unless defined(&pci_unmap_addr);
	    eval 'sub pci_unmap_addr_set {
	        my($PTR, $ADDR_NAME, $VAL) = @_;
    		eval q(((($PTR)->$ADDR_NAME) = ($VAL)));
	    }' unless defined(&pci_unmap_addr_set);
	    eval 'sub pci_unmap_len {
	        my($PTR, $LEN_NAME) = @_;
    		eval q((($PTR)->$LEN_NAME));
	    }' unless defined(&pci_unmap_len);
	    eval 'sub pci_unmap_len_set {
	        my($PTR, $LEN_NAME, $VAL) = @_;
    		eval q(((($PTR)->$LEN_NAME) = ($VAL)));
	    }' unless defined(&pci_unmap_len_set);
	    eval 'sub PCI_DMA_BUS_IS_PHYS () {(0);}' unless defined(&PCI_DMA_BUS_IS_PHYS);
	} else {
	    eval 'sub PCI_DMA_BUS_IS_PHYS () {(1);}' unless defined(&PCI_DMA_BUS_IS_PHYS);
	    eval 'sub DECLARE_PCI_UNMAP_ADDR {
	        my($ADDR_NAME) = @_;
    		eval q();
	    }' unless defined(&DECLARE_PCI_UNMAP_ADDR);
	    eval 'sub DECLARE_PCI_UNMAP_LEN {
	        my($LEN_NAME) = @_;
    		eval q();
	    }' unless defined(&DECLARE_PCI_UNMAP_LEN);
	    eval 'sub pci_unmap_addr {
	        my($PTR, $ADDR_NAME) = @_;
    		eval q((0));
	    }' unless defined(&pci_unmap_addr);
	    eval 'sub pci_unmap_addr_set {
	        my($PTR, $ADDR_NAME, $VAL) = @_;
    		eval q( &do { }  &while (0));
	    }' unless defined(&pci_unmap_addr_set);
	    eval 'sub pci_unmap_len {
	        my($PTR, $LEN_NAME) = @_;
    		eval q((0));
	    }' unless defined(&pci_unmap_len);
	    eval 'sub pci_unmap_len_set {
	        my($PTR, $LEN_NAME, $VAL) = @_;
    		eval q( &do { }  &while (0));
	    }' unless defined(&pci_unmap_len_set);
	}
	eval 'sub resource {
	    eval q(* &pcibios_select_root(\'struct pci_dev\' * &pdev, \'struct resource\' * &res) { \'struct resource\' * &root =  &NULL;  &if ( ($res->{flags}) &  &IORESOURCE_IO)  &root =  &ioport_resource;  &if ( ($res->{flags}) &  &IORESOURCE_MEM)  &root =  &iomem_resource;  &root; });
	}' unless defined(&resource);
	if(defined( &CONFIG_PPC_MULTIPLATFORM) || defined( &CONFIG_PPC32)) {
	    eval 'sub HAVE_ARCH_PCI_RESOURCE_TO_USER () {1;}' unless defined(&HAVE_ARCH_PCI_RESOURCE_TO_USER);
	}
    }
}
1;
