require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_LINUX_PM_H)) {
    eval 'sub _LINUX_PM_H () {1;}' unless defined(&_LINUX_PM_H);
    if(defined(&__KERNEL__)) {
	require 'linux/config.ph';
	require 'linux/list.ph';
	require 'asm/atomic.ph';
	eval 'sub PM_SUSPEND () {(( &__force  &pm_request_t) 1);}' unless defined(&PM_SUSPEND);
	eval 'sub PM_RESUME () {(( &__force  &pm_request_t) 2);}' unless defined(&PM_RESUME);
	eval 'sub PM_UNKNOWN_DEV () {(( &__force  &pm_dev_t) 0);}' unless defined(&PM_UNKNOWN_DEV);
	eval 'sub PM_SYS_DEV () {(( &__force  &pm_dev_t) 1);}' unless defined(&PM_SYS_DEV);
	eval 'sub PM_PCI_DEV () {(( &__force  &pm_dev_t) 2);}' unless defined(&PM_PCI_DEV);
	eval 'sub PM_USB_DEV () {(( &__force  &pm_dev_t) 3);}' unless defined(&PM_USB_DEV);
	eval 'sub PM_SCSI_DEV () {(( &__force  &pm_dev_t) 4);}' unless defined(&PM_SCSI_DEV);
	eval 'sub PM_ISA_DEV () {(( &__force  &pm_dev_t) 5);}' unless defined(&PM_ISA_DEV);
	eval 'sub PM_MTD_DEV () {(( &__force  &pm_dev_t) 6);}' unless defined(&PM_MTD_DEV);
	eval("sub PM_SYS_UNKNOWN () { 0x00000000; }") unless defined(&PM_SYS_UNKNOWN);
	eval("sub PM_SYS_KBC () { 0x41d00303; }") unless defined(&PM_SYS_KBC);
	eval("sub PM_SYS_COM () { 0x41d00500; }") unless defined(&PM_SYS_COM);
	eval("sub PM_SYS_IRDA () { 0x41d00510; }") unless defined(&PM_SYS_IRDA);
	eval("sub PM_SYS_FDC () { 0x41d00700; }") unless defined(&PM_SYS_FDC);
	eval("sub PM_SYS_VGA () { 0x41d00900; }") unless defined(&PM_SYS_VGA);
	eval("sub PM_SYS_PCMCIA () { 0x41d00e00; }") unless defined(&PM_SYS_PCMCIA);
	eval 'sub PM_PCI_ID {
	    my($dev) = @_;
    	    eval q((($dev)-> ($bus->{number}) << 16| ($dev)-> &devfn));
	}' unless defined(&PM_PCI_ID);
	eval 'sub PM_SUSPEND_ON () {(( &__force  &suspend_state_t) 0);}' unless defined(&PM_SUSPEND_ON);
	eval 'sub PM_SUSPEND_STANDBY () {(( &__force  &suspend_state_t) 1);}' unless defined(&PM_SUSPEND_STANDBY);
	eval 'sub PM_SUSPEND_MEM () {(( &__force  &suspend_state_t) 3);}' unless defined(&PM_SUSPEND_MEM);
	eval 'sub PM_SUSPEND_DISK () {(( &__force  &suspend_state_t) 4);}' unless defined(&PM_SUSPEND_DISK);
	eval 'sub PM_SUSPEND_MAX () {(( &__force  &suspend_state_t) 5);}' unless defined(&PM_SUSPEND_MAX);
	eval 'sub PM_DISK_FIRMWARE () {(( &__force  &suspend_disk_method_t) 1);}' unless defined(&PM_DISK_FIRMWARE);
	eval 'sub PM_DISK_PLATFORM () {(( &__force  &suspend_disk_method_t) 2);}' unless defined(&PM_DISK_PLATFORM);
	eval 'sub PM_DISK_SHUTDOWN () {(( &__force  &suspend_disk_method_t) 3);}' unless defined(&PM_DISK_SHUTDOWN);
	eval 'sub PM_DISK_REBOOT () {(( &__force  &suspend_disk_method_t) 4);}' unless defined(&PM_DISK_REBOOT);
	eval 'sub PM_DISK_MAX () {(( &__force  &suspend_disk_method_t) 5);}' unless defined(&PM_DISK_MAX);
	eval 'sub PM_EVENT_ON () {0;}' unless defined(&PM_EVENT_ON);
	eval 'sub PM_EVENT_FREEZE () {1;}' unless defined(&PM_EVENT_FREEZE);
	eval 'sub PM_EVENT_SUSPEND () {2;}' unless defined(&PM_EVENT_SUSPEND);
	eval 'sub PMSG_FREEZE () {({ . &event =  &PM_EVENT_FREEZE, });}' unless defined(&PMSG_FREEZE);
	eval 'sub PMSG_SUSPEND () {({ . &event =  &PM_EVENT_SUSPEND, });}' unless defined(&PMSG_SUSPEND);
	eval 'sub PMSG_ON () {({ . &event =  &PM_EVENT_ON, });}' unless defined(&PMSG_ON);
	if(defined(&CONFIG_PM)) {
	}
	if(defined(&CONFIG_PM)) {
	    eval 'sub device_set_wakeup_enable {
	        my($dev,$val) = @_;
    		eval q((($dev)-> ($power->{should_wakeup}) = !!($val)));
	    }' unless defined(&device_set_wakeup_enable);
	    eval 'sub device_may_wakeup {
	        my($dev) = @_;
    		eval q(( &device_can_wakeup($dev)  && ($dev)-> ($power->{should_wakeup})));
	    }' unless defined(&device_may_wakeup);
	    eval 'sub suspend_report_result {
	        my($fn, $ret) = @_;
    		eval q( &do {  &__suspend_report_result( &__FUNCTION__, $fn, $ret); }  &while (0));
	    }' unless defined(&suspend_report_result);
	} else {
	    eval 'sub device_suspend {
	        my($state) = @_;
    		eval q({ 0; });
	    }' unless defined(&device_suspend);
	    eval 'sub device_set_wakeup_enable {
	        my($dev,$val) = @_;
    		eval q( &do{} &while(0));
	    }' unless defined(&device_set_wakeup_enable);
	    eval 'sub device_may_wakeup {
	        my($dev) = @_;
    		eval q((0));
	    }' unless defined(&device_may_wakeup);
	    eval 'sub dpm_runtime_suspend {
	        my($dev,$state) = @_;
    		eval q({ 0; });
	    }' unless defined(&dpm_runtime_suspend);
	    eval 'sub dpm_runtime_resume {
	        my($dev) = @_;
    		eval q({ });
	    }' unless defined(&dpm_runtime_resume);
	    eval 'sub suspend_report_result {
	        my($fn, $ret) = @_;
    		eval q( &do { }  &while (0));
	    }' unless defined(&suspend_report_result);
	}
	eval 'sub device_can_wakeup {
	    my($dev) = @_;
    	    eval q((($dev)-> ($power->{can_wakeup})));
	}' unless defined(&device_can_wakeup);
	eval 'sub device_init_wakeup {
	    my($dev,$val) = @_;
    	    eval q( &do {  &device_can_wakeup($dev) = !!($val);  &device_set_wakeup_enable($dev,$val); }  &while(0));
	}' unless defined(&device_init_wakeup);
    }
}
1;
