require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_LINUX_QUOTAOPS_)) {
    eval 'sub _LINUX_QUOTAOPS_ () {1;}' unless defined(&_LINUX_QUOTAOPS_);
    require 'linux/config.ph';
    require 'linux/smp_lock.ph';
    require 'linux/fs.ph';
    if(defined( &CONFIG_QUOTA)) {
	eval 'sub vfs_quota_off_mount {
	    my($sb, $type) = @_;
    	    eval q( &vfs_quota_off($sb, $type));
	}' unless defined(&vfs_quota_off_mount);
	eval 'sub sb_dquot_ops () {( &dquot_operations);}' unless defined(&sb_dquot_ops);
	eval 'sub sb_quotactl_ops () {( &vfs_quotactl_ops);}' unless defined(&sb_quotactl_ops);
	eval 'sub DQUOT_PREALLOC_SPACE {
	    my($inode,$nr) = @_;
    	    eval q({ \'int\'  &ret;  &if (!( &ret =  &DQUOT_PREALLOC_SPACE_NODIRTY($inode, $nr)))  &mark_inode_dirty($inode);  &ret; });
	}' unless defined(&DQUOT_PREALLOC_SPACE);
	eval 'sub DQUOT_ALLOC_SPACE_NODIRTY {
	    my($inode,$nr) = @_;
    	    eval q({  &if ( &sb_any_quota_enabled( ($inode->{i_sb}))) {  &if ( ($inode->{i_sb}->{dq_op}->{alloc_space})($inode, $nr, 0) ==  &NO_QUOTA) 1; }  &else  &inode_add_bytes($inode, $nr); 0; });
	}' unless defined(&DQUOT_ALLOC_SPACE_NODIRTY);
	eval 'sub DQUOT_ALLOC_SPACE {
	    my($inode,$nr) = @_;
    	    eval q({ \'int\'  &ret;  &if (!( &ret =  &DQUOT_ALLOC_SPACE_NODIRTY($inode, $nr)))  &mark_inode_dirty($inode);  &ret; });
	}' unless defined(&DQUOT_ALLOC_SPACE);
	eval 'sub DQUOT_ALLOC_INODE {
	    my($inode) = @_;
    	    eval q({  &if ( &sb_any_quota_enabled( ($inode->{i_sb}))) {  &DQUOT_INIT($inode);  &if ( ($inode->{i_sb}->{dq_op}->{alloc_inode})($inode, 1) ==  &NO_QUOTA) 1; } 0; });
	}' unless defined(&DQUOT_ALLOC_INODE);
	eval 'sub DQUOT_FREE_SPACE_NODIRTY {
	    my($inode,$nr) = @_;
    	    eval q({  &if ( &sb_any_quota_enabled( ($inode->{i_sb})))  ($inode->{i_sb}->{dq_op}->{free_space})($inode, $nr);  &else  &inode_sub_bytes($inode, $nr); });
	}' unless defined(&DQUOT_FREE_SPACE_NODIRTY);
	eval 'sub DQUOT_FREE_SPACE {
	    my($inode,$nr) = @_;
    	    eval q({  &DQUOT_FREE_SPACE_NODIRTY($inode, $nr);  &mark_inode_dirty($inode); });
	}' unless defined(&DQUOT_FREE_SPACE);
	eval 'sub DQUOT_FREE_INODE {
	    my($inode) = @_;
    	    eval q({  &if ( &sb_any_quota_enabled( ($inode->{i_sb})))  ($inode->{i_sb}->{dq_op}->{free_inode})($inode, 1); });
	}' unless defined(&DQUOT_FREE_INODE);
	eval 'sub DQUOT_TRANSFER {
	    my($inode,$iattr) = @_;
    	    eval q({  &if ( &sb_any_quota_enabled( ($inode->{i_sb}))  && ! &IS_NOQUOTA($inode)) {  &DQUOT_INIT($inode);  &if ( ($inode->{i_sb}->{dq_op}->{transfer})($inode, $iattr) ==  &NO_QUOTA) 1; } 0; });
	}' unless defined(&DQUOT_TRANSFER);
	eval 'sub DQUOT_SYNC {
	    my($sb) = @_;
    	    eval q( &sync_dquots($sb, -1));
	}' unless defined(&DQUOT_SYNC);
	eval 'sub DQUOT_OFF {
	    my($sb) = @_;
    	    eval q({ \'int\'  &ret = - &ENOSYS;  &if ( &sb_any_quota_enabled($sb)  &&  ($sb->{s_qcop})  &&  ($sb->{s_qcop}->{quota_off}))  &ret =  ($sb->{s_qcop}->{quota_off})($sb, -1);  &ret; });
	}' unless defined(&DQUOT_OFF);
    } else {
	eval 'sub sb_dquot_ops () {( &NULL);}' unless defined(&sb_dquot_ops);
	eval 'sub sb_quotactl_ops () {( &NULL);}' unless defined(&sb_quotactl_ops);
	eval 'sub DQUOT_INIT {
	    my($inode) = @_;
    	    eval q( &do { }  &while(0));
	}' unless defined(&DQUOT_INIT);
	eval 'sub DQUOT_DROP {
	    my($inode) = @_;
    	    eval q( &do { }  &while(0));
	}' unless defined(&DQUOT_DROP);
	eval 'sub DQUOT_ALLOC_INODE {
	    my($inode) = @_;
    	    eval q((0));
	}' unless defined(&DQUOT_ALLOC_INODE);
	eval 'sub DQUOT_FREE_INODE {
	    my($inode) = @_;
    	    eval q( &do { }  &while(0));
	}' unless defined(&DQUOT_FREE_INODE);
	eval 'sub DQUOT_SYNC {
	    my($sb) = @_;
    	    eval q( &do { }  &while(0));
	}' unless defined(&DQUOT_SYNC);
	eval 'sub DQUOT_OFF {
	    my($sb) = @_;
    	    eval q( &do { }  &while(0));
	}' unless defined(&DQUOT_OFF);
	eval 'sub DQUOT_TRANSFER {
	    my($inode, $iattr) = @_;
    	    eval q((0));
	}' unless defined(&DQUOT_TRANSFER);
	eval 'sub DQUOT_PREALLOC_SPACE_NODIRTY {
	    my($inode,$nr) = @_;
    	    eval q({  &inode_add_bytes($inode, $nr); 0; });
	}' unless defined(&DQUOT_PREALLOC_SPACE_NODIRTY);
	eval 'sub DQUOT_PREALLOC_SPACE {
	    my($inode,$nr) = @_;
    	    eval q({  &DQUOT_PREALLOC_SPACE_NODIRTY($inode, $nr);  &mark_inode_dirty($inode); 0; });
	}' unless defined(&DQUOT_PREALLOC_SPACE);
	eval 'sub DQUOT_ALLOC_SPACE_NODIRTY {
	    my($inode,$nr) = @_;
    	    eval q({  &inode_add_bytes($inode, $nr); 0; });
	}' unless defined(&DQUOT_ALLOC_SPACE_NODIRTY);
	eval 'sub DQUOT_ALLOC_SPACE {
	    my($inode,$nr) = @_;
    	    eval q({  &DQUOT_ALLOC_SPACE_NODIRTY($inode, $nr);  &mark_inode_dirty($inode); 0; });
	}' unless defined(&DQUOT_ALLOC_SPACE);
	eval 'sub DQUOT_FREE_SPACE_NODIRTY {
	    my($inode,$nr) = @_;
    	    eval q({  &inode_sub_bytes($inode, $nr); });
	}' unless defined(&DQUOT_FREE_SPACE_NODIRTY);
	eval 'sub DQUOT_FREE_SPACE {
	    my($inode,$nr) = @_;
    	    eval q({  &DQUOT_FREE_SPACE_NODIRTY($inode, $nr);  &mark_inode_dirty($inode); } );
	}' unless defined(&DQUOT_FREE_SPACE);
    }
    eval 'sub DQUOT_PREALLOC_BLOCK_NODIRTY {
        my($inode, $nr) = @_;
	    eval q( &DQUOT_PREALLOC_SPACE_NODIRTY($inode, (( &qsize_t)($nr)) << ($inode)-> ($i_sb->{s_blocksize_bits})));
    }' unless defined(&DQUOT_PREALLOC_BLOCK_NODIRTY);
    eval 'sub DQUOT_PREALLOC_BLOCK {
        my($inode, $nr) = @_;
	    eval q( &DQUOT_PREALLOC_SPACE($inode, (( &qsize_t)($nr)) << ($inode)-> ($i_sb->{s_blocksize_bits})));
    }' unless defined(&DQUOT_PREALLOC_BLOCK);
    eval 'sub DQUOT_ALLOC_BLOCK_NODIRTY {
        my($inode, $nr) = @_;
	    eval q( &DQUOT_ALLOC_SPACE_NODIRTY($inode, (( &qsize_t)($nr)) << ($inode)-> ($i_sb->{s_blocksize_bits})));
    }' unless defined(&DQUOT_ALLOC_BLOCK_NODIRTY);
    eval 'sub DQUOT_ALLOC_BLOCK {
        my($inode, $nr) = @_;
	    eval q( &DQUOT_ALLOC_SPACE($inode, (( &qsize_t)($nr)) << ($inode)-> ($i_sb->{s_blocksize_bits})));
    }' unless defined(&DQUOT_ALLOC_BLOCK);
    eval 'sub DQUOT_FREE_BLOCK_NODIRTY {
        my($inode, $nr) = @_;
	    eval q( &DQUOT_FREE_SPACE_NODIRTY($inode, (( &qsize_t)($nr)) << ($inode)-> ($i_sb->{s_blocksize_bits})));
    }' unless defined(&DQUOT_FREE_BLOCK_NODIRTY);
    eval 'sub DQUOT_FREE_BLOCK {
        my($inode, $nr) = @_;
	    eval q( &DQUOT_FREE_SPACE($inode, (( &qsize_t)($nr)) << ($inode)-> ($i_sb->{s_blocksize_bits})));
    }' unless defined(&DQUOT_FREE_BLOCK);
}
1;
