require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&__LINUX_USB_H)) {
    eval 'sub __LINUX_USB_H () {1;}' unless defined(&__LINUX_USB_H);
    require 'linux/mod_devicetable.ph';
    require 'linux/usb_ch9.ph';
    eval 'sub USB_MAJOR () {180;}' unless defined(&USB_MAJOR);
    eval 'sub USB_DEVICE_MAJOR () {189;}' unless defined(&USB_DEVICE_MAJOR);
    if(defined(&__KERNEL__)) {
	require 'linux/config.ph';
	require 'linux/errno.ph';
	require 'linux/delay.ph';
	require 'linux/interrupt.ph';
	require 'linux/list.ph';
	require 'linux/kref.ph';
	require 'linux/device.ph';
	require 'linux/fs.ph';
	require 'linux/completion.ph';
	require 'linux/sched.ph';
	eval("sub USB_INTERFACE_UNBOUND () { 0; }") unless defined(&USB_INTERFACE_UNBOUND);
	eval("sub USB_INTERFACE_BINDING () { 1; }") unless defined(&USB_INTERFACE_BINDING);
	eval("sub USB_INTERFACE_BOUND () { 2; }") unless defined(&USB_INTERFACE_BOUND);
	eval("sub USB_INTERFACE_UNBINDING () { 3; }") unless defined(&USB_INTERFACE_UNBINDING);
	eval 'sub to_usb_interface {
	    my($d) = @_;
    	    eval q( &container_of($d, \'struct usb_interface\',  &dev));
	}' unless defined(&to_usb_interface);
	eval 'sub interface_to_usbdev {
	    my($intf) = @_;
    	    eval q( &container_of( ($intf->{dev}->{parent}), \'struct usb_device\',  &dev));
	}' unless defined(&interface_to_usbdev);
	eval 'sub void {
	    eval q(* &usb_get_intfdata (\'struct usb_interface\' * &intf) {  &dev_get_drvdata ( ($intf->{dev})); });
	}' unless defined(&void);
	eval 'sub usb_set_intfdata {
	    my($intf,$data) = @_;
    	    eval q({  &dev_set_drvdata( ($intf->{dev}), $data); });
	}' unless defined(&usb_set_intfdata);
	eval 'sub USB_MAXINTERFACES () {32;}' unless defined(&USB_MAXINTERFACES);
	eval 'sub ref_to_usb_interface_cache {
	    my($r) = @_;
    	    eval q( &container_of($r, \'struct usb_interface_cache\',  &ref));
	}' unless defined(&ref_to_usb_interface_cache);
	eval 'sub altsetting_to_usb_interface_cache {
	    my($a) = @_;
    	    eval q( &container_of($a, \'struct usb_interface_cache\',  $altsetting[0]));
	}' unless defined(&altsetting_to_usb_interface_cache);
	eval 'sub usb_get_extra_descriptor {
	    my($ifpoint,$type,$ptr) = @_;
    	    eval q( &__usb_get_extra_descriptor(($ifpoint)-> &extra,($ifpoint)-> &extralen, $type,( &void**)$ptr));
	}' unless defined(&usb_get_extra_descriptor);
	if(defined( &CONFIG_USB_MON)) {
	}
	eval 'sub USB_MAXCHILDREN () {(16);}' unless defined(&USB_MAXCHILDREN);
	eval 'sub to_usb_device {
	    my($d) = @_;
    	    eval q( &container_of($d, \'struct usb_device\',  &dev));
	}' unless defined(&to_usb_device);
	eval 'sub usb_lock_device {
	    my($udev) = @_;
    	    eval q( &down(($udev)-> ($dev->{sem})));
	}' unless defined(&usb_lock_device);
	eval 'sub usb_unlock_device {
	    my($udev) = @_;
    	    eval q( &up(($udev)-> ($dev->{sem})));
	}' unless defined(&usb_unlock_device);
	eval 'sub usb_trylock_device {
	    my($udev) = @_;
    	    eval q( &down_trylock(($udev)-> ($dev->{sem})));
	}' unless defined(&usb_trylock_device);
	eval 'sub USB_DEVICE_ID_MATCH_DEVICE () {( &USB_DEVICE_ID_MATCH_VENDOR |  &USB_DEVICE_ID_MATCH_PRODUCT);}' unless defined(&USB_DEVICE_ID_MATCH_DEVICE);
	eval 'sub USB_DEVICE_ID_MATCH_DEV_RANGE () {( &USB_DEVICE_ID_MATCH_DEV_LO |  &USB_DEVICE_ID_MATCH_DEV_HI);}' unless defined(&USB_DEVICE_ID_MATCH_DEV_RANGE);
	eval 'sub USB_DEVICE_ID_MATCH_DEVICE_AND_VERSION () {( &USB_DEVICE_ID_MATCH_DEVICE |  &USB_DEVICE_ID_MATCH_DEV_RANGE);}' unless defined(&USB_DEVICE_ID_MATCH_DEVICE_AND_VERSION);
	eval 'sub USB_DEVICE_ID_MATCH_DEV_INFO () {( &USB_DEVICE_ID_MATCH_DEV_CLASS |  &USB_DEVICE_ID_MATCH_DEV_SUBCLASS |  &USB_DEVICE_ID_MATCH_DEV_PROTOCOL);}' unless defined(&USB_DEVICE_ID_MATCH_DEV_INFO);
	eval 'sub USB_DEVICE_ID_MATCH_INT_INFO () {( &USB_DEVICE_ID_MATCH_INT_CLASS |  &USB_DEVICE_ID_MATCH_INT_SUBCLASS |  &USB_DEVICE_ID_MATCH_INT_PROTOCOL);}' unless defined(&USB_DEVICE_ID_MATCH_INT_INFO);
	eval 'sub USB_DEVICE {
	    my($vend,$prod) = @_;
    	    eval q(. &match_flags =  &USB_DEVICE_ID_MATCH_DEVICE, . &idVendor = ($vend), . &idProduct = ($prod));
	}' unless defined(&USB_DEVICE);
	eval 'sub USB_DEVICE_VER {
	    my($vend,$prod,$lo,$hi) = @_;
    	    eval q(. &match_flags =  &USB_DEVICE_ID_MATCH_DEVICE_AND_VERSION, . &idVendor = ($vend), . &idProduct = ($prod), . &bcdDevice_lo = ($lo), . &bcdDevice_hi = ($hi));
	}' unless defined(&USB_DEVICE_VER);
	eval 'sub USB_DEVICE_INFO {
	    my($cl,$sc,$pr) = @_;
    	    eval q(. &match_flags =  &USB_DEVICE_ID_MATCH_DEV_INFO, . &bDeviceClass = ($cl), . &bDeviceSubClass = ($sc), . &bDeviceProtocol = ($pr));
	}' unless defined(&USB_DEVICE_INFO);
	eval 'sub USB_INTERFACE_INFO {
	    my($cl,$sc,$pr) = @_;
    	    eval q(. &match_flags =  &USB_DEVICE_ID_MATCH_INT_INFO, . &bInterfaceClass = ($cl), . &bInterfaceSubClass = ($sc), . &bInterfaceProtocol = ($pr));
	}' unless defined(&USB_INTERFACE_INFO);
	eval 'sub to_usb_driver {
	    my($d) = @_;
    	    eval q( &container_of($d, \'struct usb_driver\',  &driver));
	}' unless defined(&to_usb_driver);
	eval 'sub usb_register {
	    my($driver) = @_;
    	    eval q({  &usb_register_driver($driver,  &THIS_MODULE); });
	}' unless defined(&usb_register);
	eval 'sub URB_SHORT_NOT_OK () {0x1;}' unless defined(&URB_SHORT_NOT_OK);
	eval 'sub URB_ISO_ASAP () {0x2;}' unless defined(&URB_ISO_ASAP);
	eval 'sub URB_NO_TRANSFER_DMA_MAP () {0x4;}' unless defined(&URB_NO_TRANSFER_DMA_MAP);
	eval 'sub URB_NO_SETUP_DMA_MAP () {0x8;}' unless defined(&URB_NO_SETUP_DMA_MAP);
	eval 'sub URB_NO_FSBR () {0x20;}' unless defined(&URB_NO_FSBR);
	eval 'sub URB_ZERO_PACKET () {0x40;}' unless defined(&URB_ZERO_PACKET);
	eval 'sub URB_NO_INTERRUPT () {0x80;}' unless defined(&URB_NO_INTERRUPT);
	eval 'sub usb_put_urb () { &usb_free_urb;}' unless defined(&usb_put_urb);
	eval 'sub HAVE_USB_BUFFERS () {1;}' unless defined(&HAVE_USB_BUFFERS);
	if(0) {
	}
	if(0) {
	}
	eval 'sub USB_CTRL_GET_TIMEOUT () {5000;}' unless defined(&USB_CTRL_GET_TIMEOUT);
	eval 'sub USB_CTRL_SET_TIMEOUT () {5000;}' unless defined(&USB_CTRL_SET_TIMEOUT);
	eval 'sub PIPE_ISOCHRONOUS () {0;}' unless defined(&PIPE_ISOCHRONOUS);
	eval 'sub PIPE_INTERRUPT () {1;}' unless defined(&PIPE_INTERRUPT);
	eval 'sub PIPE_CONTROL () {2;}' unless defined(&PIPE_CONTROL);
	eval 'sub PIPE_BULK () {3;}' unless defined(&PIPE_BULK);
	eval 'sub usb_pipein {
	    my($pipe) = @_;
    	    eval q((($pipe) &  &USB_DIR_IN));
	}' unless defined(&usb_pipein);
	eval 'sub usb_pipeout {
	    my($pipe) = @_;
    	    eval q((! &usb_pipein($pipe)));
	}' unless defined(&usb_pipeout);
	eval 'sub usb_pipedevice {
	    my($pipe) = @_;
    	    eval q(((($pipe) >> 8) & 0x7f));
	}' unless defined(&usb_pipedevice);
	eval 'sub usb_pipeendpoint {
	    my($pipe) = @_;
    	    eval q(((($pipe) >> 15) & 0xf));
	}' unless defined(&usb_pipeendpoint);
	eval 'sub usb_pipetype {
	    my($pipe) = @_;
    	    eval q(((($pipe) >> 30) & 3));
	}' unless defined(&usb_pipetype);
	eval 'sub usb_pipeisoc {
	    my($pipe) = @_;
    	    eval q(( &usb_pipetype(($pipe)) ==  &PIPE_ISOCHRONOUS));
	}' unless defined(&usb_pipeisoc);
	eval 'sub usb_pipeint {
	    my($pipe) = @_;
    	    eval q(( &usb_pipetype(($pipe)) ==  &PIPE_INTERRUPT));
	}' unless defined(&usb_pipeint);
	eval 'sub usb_pipecontrol {
	    my($pipe) = @_;
    	    eval q(( &usb_pipetype(($pipe)) ==  &PIPE_CONTROL));
	}' unless defined(&usb_pipecontrol);
	eval 'sub usb_pipebulk {
	    my($pipe) = @_;
    	    eval q(( &usb_pipetype(($pipe)) ==  &PIPE_BULK));
	}' unless defined(&usb_pipebulk);
	eval 'sub usb_gettoggle {
	    my($dev, $ep, $out) = @_;
    	    eval q(((($dev)-> $toggle[$out] >> ($ep)) & 1));
	}' unless defined(&usb_gettoggle);
	eval 'sub usb_dotoggle {
	    my($dev, $ep, $out) = @_;
    	    eval q((($dev)-> $toggle[$out] ^= (1<< ($ep))));
	}' unless defined(&usb_dotoggle);
	eval 'sub usb_settoggle {
	    my($dev, $ep, $out, $bit) = @_;
    	    eval q((($dev)-> $toggle[$out] = (($dev)-> $toggle[$out] & ~(1<< ($ep))) | (($bit) << ($ep))));
	}' unless defined(&usb_settoggle);
	eval 'sub __create_pipe {
	    my($dev,$endpoint) = @_;
    	    eval q({ ( ($dev->{devnum}) << 8) | ($endpoint << 15); });
	}' unless defined(&__create_pipe);
	eval 'sub usb_sndctrlpipe {
	    my($dev,$endpoint) = @_;
    	    eval q((( &PIPE_CONTROL << 30) |  &__create_pipe($dev,$endpoint)));
	}' unless defined(&usb_sndctrlpipe);
	eval 'sub usb_rcvctrlpipe {
	    my($dev,$endpoint) = @_;
    	    eval q((( &PIPE_CONTROL << 30) |  &__create_pipe($dev,$endpoint) |  &USB_DIR_IN));
	}' unless defined(&usb_rcvctrlpipe);
	eval 'sub usb_sndisocpipe {
	    my($dev,$endpoint) = @_;
    	    eval q((( &PIPE_ISOCHRONOUS << 30) |  &__create_pipe($dev,$endpoint)));
	}' unless defined(&usb_sndisocpipe);
	eval 'sub usb_rcvisocpipe {
	    my($dev,$endpoint) = @_;
    	    eval q((( &PIPE_ISOCHRONOUS << 30) |  &__create_pipe($dev,$endpoint) |  &USB_DIR_IN));
	}' unless defined(&usb_rcvisocpipe);
	eval 'sub usb_sndbulkpipe {
	    my($dev,$endpoint) = @_;
    	    eval q((( &PIPE_BULK << 30) |  &__create_pipe($dev,$endpoint)));
	}' unless defined(&usb_sndbulkpipe);
	eval 'sub usb_rcvbulkpipe {
	    my($dev,$endpoint) = @_;
    	    eval q((( &PIPE_BULK << 30) |  &__create_pipe($dev,$endpoint) |  &USB_DIR_IN));
	}' unless defined(&usb_rcvbulkpipe);
	eval 'sub usb_sndintpipe {
	    my($dev,$endpoint) = @_;
    	    eval q((( &PIPE_INTERRUPT << 30) |  &__create_pipe($dev,$endpoint)));
	}' unless defined(&usb_sndintpipe);
	eval 'sub usb_rcvintpipe {
	    my($dev,$endpoint) = @_;
    	    eval q((( &PIPE_INTERRUPT << 30) |  &__create_pipe($dev,$endpoint) |  &USB_DIR_IN));
	}' unless defined(&usb_rcvintpipe);
	eval 'sub USB_DEVICE_ADD () {0x1;}' unless defined(&USB_DEVICE_ADD);
	eval 'sub USB_DEVICE_REMOVE () {0x2;}' unless defined(&USB_DEVICE_REMOVE);
	eval 'sub USB_BUS_ADD () {0x3;}' unless defined(&USB_BUS_ADD);
	eval 'sub USB_BUS_REMOVE () {0x4;}' unless defined(&USB_BUS_REMOVE);
	if(defined(&DEBUG)) {
	    eval 'sub dbg () {( &format,  &arg...)  &printk( &KERN_DEBUG "%s: "  &format "\\n" ,  &__FILE__ ,   &arg);}' unless defined(&dbg);
	} else {
	    eval 'sub dbg () {( &format,  &arg...)  &do {}  &while (0);}' unless defined(&dbg);
	}
	eval 'sub err () {( &format,  &arg...)  &printk( &KERN_ERR "%s: "  &format "\\n" ,  &__FILE__ ,   &arg);}' unless defined(&err);
	eval 'sub info () {( &format,  &arg...)  &printk( &KERN_INFO "%s: "  &format "\\n" ,  &__FILE__ ,   &arg);}' unless defined(&info);
	eval 'sub warn () {( &format,  &arg...)  &printk( &KERN_WARNING "%s: "  &format "\\n" ,  &__FILE__ ,   &arg);}' unless defined(&warn);
    }
}
1;
