# Copyright 1999-2007 Gentoo Foundation
# Distributed under the terms of the GNU General Public License v2
# $Header $

inherit eutils qt3

MY_P=VirtualBox_${PV}_Linux_x86.run

DESCRIPTION="Softwarefamily of powerful x86 virtualization"
HOMEPAGE="http://www.virtualbox.org/"
SRC_URI="http://www.virtualbox.org/download/${PV}/${MY_P}
	vditool? ( http://www.virtualbox.org/download/testcase/vditool )"

LICENSE="PUEL"
SLOT="0"
KEYWORDS="-amd64 ~x86"
IUSE="additions sdk vditool wrapper"

DEPEND=">=sys-libs/glibc-2.3.5"
RDEPEND="!app-emulation/virtualbox
	=app-emulation/virtualbox-modules-${PV}
	sdk? ( dev-libs/libIDL )
	amd64? (
		>=app-emulation/emul-linux-x86-baselibs-2.5.5-r3
		>=app-emulation/emul-linux-x86-qtlibs-3.4.4
		app-emulation/emul-linux-x86-compat
		app-emulation/emul-linux-x86-xlibs
		app-emulation/emul-linux-x86-sdl )
	x86? (
		virtual/xft
		x11-libs/libX11
		x11-libs/libXtst
		x11-libs/libXext
		x11-libs/libXt
		x11-libs/libICE
		x11-libs/libSM
		x11-libs/libXrender
		=virtual/libstdc++-3.3
		x11-libs/libXcursor
		media-libs/libsdl
		$(qt_min_version 3.3.5) )"

S=${WORKDIR}

RESTRICT="primaryuri"

pkg_setup() {
	check_license
}

src_unpack() {
	unpack_makeself ${MY_P}
	unpack ./VirtualBox.tar.bz2
}

src_install() {
	cd "${S}"

	# desktop entry
	insinto /usr/share/pixmaps
	newins VBox.png virtualbox.png
	insinto /usr/share/applications
	newins VirtualBox.desktop virtualbox.desktop
	dosed -e "10d" /usr/share/applications/virtualbox.desktop
	dosed -e "5d" /usr/share/applications/virtualbox.desktop
	dosed -e "s/VirtualBox/virtualbox/" /usr/share/applications/virtualbox.desktop
	dosed -e "s/VBox.png/virtualbox.png/" /usr/share/applications/virtualbox.desktop

	insinto /opt/VirtualBox
	doins UserManual.pdf
	if use additions; then
		doins -r additions
	fi
	if use sdk; then
		doins -r sdk
		fperms 0755 /opt/VirtualBox/sdk/bin/xpidl
		make_wrapper xpidl "sdk/bin/xpidl" "/opt/VirtualBox" "/opt/VirtualBox" "/usr/bin"
	fi
	if use vditool; then
		doins "${DISTDIR}"/vditool
		fperms 0755 /opt/VirtualBox/vditool
		make_wrapper vditool "./vditool" "/opt/VirtualBox" "/opt/VirtualBox" "/usr/bin"
	fi

	rm -rf src sdk tst* UserManual.pdf rdesktop-vrdp.tar.gz deffiles install.sh \
	routines.sh runlevel.sh vboxdrv.sh VBox.sh VBox.png kchmviewer additions \
	VirtualBox.desktop VirtualBox.chm VirtualBox.tar.bz2 LICENSE

	doins -r *
	for each in VBox{Manage,SDL,SVC,XPCOMIPCD,VRDP} VirtualBox ; do
		fperms 0755 /opt/VirtualBox/${each}
	done

	if use wrapper ; then
		exeinto /opt/VirtualBox
		newexe "${FILESDIR}/${P}-wrapper" "wrapper.sh"
		dosym /opt/VirtualBox/wrapper.sh /usr/bin/VirtualBox
		dosym /opt/VirtualBox/wrapper.sh /usr/bin/VBoxManage
		dosym /opt/VirtualBox/wrapper.sh /usr/bin/VBoxSDL
		dosym /opt/VirtualBox/wrapper.sh /usr/bin/VBoxVRDP
	else
		make_wrapper vboxsvc "./VBoxSVC" "/opt/VirtualBox" "/opt/VirtualBox" "/usr/bin"
		make_wrapper virtualbox "./VirtualBox" "/opt/VirtualBox" "/opt/VirtualBox" "/usr/bin"
		make_wrapper vboxmanage "./VBoxManage" "/opt/VirtualBox" "/opt/VirtualBox" "/usr/bin"
		make_wrapper vboxsdl "./VBoxSDL" "/opt/VirtualBox" "/opt/VirtualBox" "/usr/bin"
		make_wrapper vboxvrdp "./VBoxVRDP" "/opt/VirtualBox" "/opt/VirtualBox" "/usr/bin"
	fi

}

pkg_postinst() {
	elog ""
	elog "In order to launch VirtualBox you need to start VBoxSVC first, with:"
	elog "vboxsvc --daemonize && virtualbox"
	elog ""
	elog "If you selected the useflag \"wrapper\" just type \"VirtualBox\" instead."
	elog ""
	elog "You must be in the vboxusers group to use VirtualBox."
	elog ""
}
