# Copyright 1999-2007 Gentoo Foundation
# Distributed under the terms of the GNU General Public License v2
# $Header: /var/cvsroot/gentoo-x86/app-emulation/wine/wine-20050830.ebuild,v 1.13 2007/03/07 01:28:23 vapier Exp $

inherit eutils flag-o-matic multilib

DESCRIPTION="free implementation of Windows(tm) on Unix"
HOMEPAGE="http://www.winehq.com/"
SRC_URI="mirror://sourceforge/${PN}/Wine-${PV}.tar.gz"

LICENSE="LGPL-2.1"
SLOT="0"
KEYWORDS="-*"
IUSE="X alsa arts cups debug nas opengl gif glut jack jpeg oss ncurses lcms" #doc
RESTRICT="test" #72375

RDEPEND=">=media-libs/freetype-2.0.0
	media-gfx/fontforge
	media-fonts/corefonts
	ncurses? ( >=sys-libs/ncurses-5.2 )
	jack? ( media-sound/jack-audio-connection-kit )
	X? (
		x11-libs/libXrandr
		x11-libs/libXi
		x11-libs/libXmu
		x11-libs/libXxf86vm
		x11-apps/xmessage
	)
	arts? ( kde-base/arts )
	alsa? ( media-libs/alsa-lib )
	nas? ( media-libs/nas )
	cups? ( net-print/cups )
	opengl? ( virtual/opengl )
	gif? ( media-libs/giflib )
	jpeg? ( media-libs/jpeg )
	glut? ( virtual/glut )
	lcms? ( media-libs/lcms )
	amd64? (
		>=app-emulation/emul-linux-x86-xlibs-2.1
		>=app-emulation/emul-linux-x86-soundlibs-2.1
		>=sys-kernel/linux-headers-2.6
	)"
DEPEND="${RDEPEND}
	X? (
		x11-proto/inputproto
		x11-proto/xextproto
		x11-proto/xf86dgaproto
		x11-proto/xf86vidmodeproto
	)
	sys-devel/bison
	sys-devel/flex"
#	doc? ( app-text/docbook-sgml-utils app-text/jadetex )

pkg_setup() {
	if use amd64 ; then
		if ! has_m32 ; then
			eerror "Your compiler seems to be unable to compile 32bit code."
			eerror "Make sure you compile gcc with:"
			echo
			eerror "    USE=multilib FEATURES=-sandbox"
			die "Cannot produce 32bit code"
		fi
		if has_multilib_profile ; then
			export ABI=x86
		else
			append-flags -m32
			append-ldflags -m32
		fi
	fi
}

src_unpack() {
	unpack Wine-${PV}.tar.gz
	cd "${S}"

	epatch "${FILESDIR}"/wine-wmf.patch
	epatch "${FILESDIR}"/wine-20050524-alsa-headers.patch
	sed -i '/^UPDATE_DESKTOP_DATABASE/s:=.*:=true:' tools/Makefile.in
	epatch "${FILESDIR}"/wine-no-ssp.patch #66002
	epatch "${FILESDIR}"/wine-20050830-gcc-32bit.patch
	epatch "${FILESDIR}"/wine-20050930-no-x.patch
	epatch "${FILESDIR}"/wine-20050930-dont-warn-lib-path.patch #107971
	epatch "${FILESDIR}"/wine-20050830-no-ldap.patch
	sed -i '/^MimeType/d' tools/wine.desktop || die #117785
}

config_cache() {
	local h ans="no"
	use ${1} && ans="yes"
	shift
	for h in "$@" ; do
		export ac_cv_${h}=${ans}
	done
}

src_compile() {
	export LDCONFIG=/bin/true
	config_cache jack header_jack_jack_h
	config_cache cups header_cups_cups_h
	config_cache alsa header_alsa_asoundlib_h header_sys_asoundlib_h lib_asound_snd_pcm_open
	use arts || export ARTSCCONFIG="/bin/false"
	config_cache nas header_audio_audiolib_h header_audio_soundlib_h
	config_cache gif header_gif_lib_h
	config_cache glut lib_glut_glutMainLoop
	config_cache jpeg header_jpeglib_h
	config_cache oss header_sys_soundcard_h header_machine_soundcard_h header_soundcard_h
	config_cache lcms header_lcms_h

	strip-flags

#	if ! built_with_use app-text/docbook-sgml-utils tetex ; then
#		export DB2PDF=true
#		export DB2PS=true
#	fi

	#	$(use_enable amd64 win64)
	# USE=debug is broken in this release
	econf \
		CC=$(tc-getCC) \
		--sysconfdir=/etc/wine \
		$(use_with ncurses curses) \
		$(use_with opengl) \
		$(use_with X x) \
		$(use_enable debug trace) \
		$(use_enable debug) \
		|| die "configure failed"

	emake -j1 depend || die "depend"
	emake all || die "all"
#	if use doc ; then
#		VARTEXFONTS=${T} \
#		emake -j1 -C documentation doc || die "docs"
#	fi
}

src_install() {
	make \
		prefix="${D}"/usr \
		bindir="${D}"/usr/bin \
		datadir="${D}"/usr/share \
		includedir="${D}"/usr/include/wine \
		sysconfdir="${D}"/etc/wine \
		mandir="${D}"/usr/share/man \
		libdir="${D}"/usr/$(get_libdir) \
		dlldir="${D}"/usr/$(get_libdir)/wine \
		install || die
#	use doc && dodoc documentation/*.pdf

	dodoc ANNOUNCE AUTHORS BUGS ChangeLog DEVELOPERS-HINTS README
}

pkg_postinst() {
	elog "~/.wine/config is now deprecated.  For configuration either use"
	elog "winecfg or regedit HKCU\\Software\\Wine"
}
