# Copyright 1999-2007 Gentoo Foundation
# Distributed under the terms of the GNU General Public License v2
# $Header: /var/cvsroot/gentoo-x86/gnome-base/gnome-session/gnome-session-2.16.2.ebuild,v 1.10 2007/02/09 23:29:10 uberlord Exp $

inherit eutils gnome2

DESCRIPTION="Gnome session manager"
HOMEPAGE="http://www.gnome.org/"
SRC_URI="${SRC_URI}
	 branding? (
		 http://dev.gentoo.org/~wolf31o2/sources/dump/gnome-splash-2007.0.png )"

LICENSE="GPL-2 LGPL-2 FDL-1.1"
SLOT="0"
KEYWORDS="alpha amd64 hppa ia64 ppc ppc64 sparc x86 ~x86-fbsd"
IUSE="branding esd ipv6 tcpd"

RDEPEND=">=dev-libs/glib-2.6
		 >=x11-libs/gtk+-2.3.1
		 x11-libs/libXau
		 x11-apps/xdpyinfo
		 >=gnome-base/libgnomeui-2.2
		  =gnome-base/gnome-desktop-2*
		 >=gnome-base/control-center-2.15.4
		 >=x11-libs/libnotify-0.2.1
		 >=gnome-base/gconf-2
		 >=gnome-base/gnome-keyring-0.5.1
		 || (
				>=dev-libs/dbus-glib-0.71
				( <sys-apps/dbus-0.90 >=sys-apps/dbus-0.35 )
			)
		 esd? ( >=media-sound/esound-0.2.26 )
		 tcpd? ( >=sys-apps/tcp-wrappers-7.6 )"
DEPEND="${RDEPEND}
		  x11-apps/xrdb
		>=sys-devel/gettext-0.10.40
		>=dev-util/pkgconfig-0.17
		>=dev-util/intltool-0.35
		!gnome-base/gnome-core"

# gnome-base/gnome-core overwrite /usr/bin/gnome-session
DOCS="AUTHORS ChangeLog HACKING NEWS README"

pkg_setup() {
	# TODO: convert libnotify to a configure option
	G2CONF="${G2CONF} $(use_enable ipv6) $(use_enable esd) $(use_enable tcpd tcp-wrappers)"
}

src_unpack() {
	gnome2_src_unpack

	# Patch for Gentoo Branding (bug #42687)
	use branding && epatch ${FILESDIR}/${PN}-2.10.0-schema_defaults.patch
}

src_install() {
	gnome2_src_install

	dodir /etc/X11/Sessions
	exeinto /etc/X11/Sessions
	doexe ${FILESDIR}/Gnome

	# Our own splash for world domination
	if use branding ; then
		insinto /usr/share/pixmaps/splash/
		newins ${DISTDIR}/gnome-splash-2007.0.png gentoo-splash.png
	fi
}
