#!/bin/sh
# Copyright (c) 2006-2007 Gentoo Foundation
# Distributed under the terms of the GNU General Public License v2
# Contributed by Roy Marples (uberlord@gentoo.org)

# Setup our resolv.conf
# Vitally important that we use the domain entry in resolv.conf so we
# can setup the nameservers are for the domain ONLY in resolvconf if
# we're using a decent dns cache/forwarder like dnsmasq and NOT nscd/libc.
# nscd/libc users will get the VPN nameservers before their other ones
# and will use the first one that responds - maybe the LAN ones?
# non resolvconf users just the the VPN resolv.conf

NS=
DOMAIN=
i=1
while true ; do
	eval opt=\$foreign_option_${i}
	[ -z "${opt}" ] && break
	if [ "${opt}" != "${opt#dhcp-option DOMAIN *}" ] ; then
		DOMAIN="${DNS}domain ${opt#dhcp-option DOMAIN *}\n"
	elif [ "${opt}" != "${opt#dhcp-option DNS *}" ] ; then
		NS="${DNS}nameserver ${opt#dhcp-option DNS *}\n"
	fi
	i=$((${i} + 1))
done

if [ -n "${NS}" ] ; then
	DNS="# Generated by openvpn for interface ${dev}\n${DOMAIN}${NS}"
	if [ -x /sbin/resolvconf ] ; then
		echo -e "${DNS}" | /sbin/resolvconf -a "${dev}"
	else
		# Preserve the existing resolv.conf
		if [ -e /etc/resolv.conf ] ; then
			cp /etc/resolv.conf /etc/resolv.conf-"${dev}".sv
		fi
		echo -e "${DNS}" > /etc/resolv.conf
		chmod 644 /etc/resolv.conf
	fi
fi

# If we have a service specific script, run this now
if [ -x /etc/openvpn/"${SVCNAME}"-up.sh ] ; then
	/etc/openvpn/"${SVCNAME}"-up.sh
fi

# Re-enter the init script to start any dependant services
if ! /etc/init.d/"${SVCNAME}" --quiet status ; then
	export IN_BACKGROUND=true
	/etc/init.d/${SVCNAME} --quiet start
fi

exit 0

# vim: ts=4 :
