# Copyright 1999-2007 Gentoo Foundation
# Distributed under the terms of the GNU General Public License v2
# $Header: /var/cvsroot/gentoo-x86/sys-apps/makedev/makedev-3.23.1.ebuild,v 1.3 2007/01/03 06:07:45 vapier Exp $

inherit toolchain-funcs

MY_PN="MAKEDEV"
MY_VER=${PV%.*}
MY_REL=${PV#${MY_VER}.}
MY_P="${MY_PN}-${MY_VER}"
DESCRIPTION="program used for creating device files in /dev"
HOMEPAGE="http://people.redhat.com/nalin/MAKEDEV/"
SRC_URI="http://people.redhat.com/nalin/MAKEDEV/${MY_P}-${MY_REL}.tar.gz"

LICENSE="GPL-2"
SLOT="0"
KEYWORDS="~alpha ~amd64 ~arm ~hppa ~ia64 ~m68k ~mips ~ppc ~ppc64 ~s390 ~sh ~sparc ~x86"
IUSE="build selinux"

DEPEND=""

S=${WORKDIR}/${MY_P}

src_compile() {
	use selinux && export SELINUX=1
	emake CC=$(tc-getCC) OPTFLAGS="${CFLAGS}" || die
}

src_install() {
	# set devdir to makedevdir so we dont have to worry about /dev
	emake install DESTDIR="${D}" makedevdir=/sbin devdir=/sbin || die
	dodoc *.txt
	keepdir /dev
}

pkg_postinst() {
	use build && MAKEDEV -d "${ROOT}"/dev generic
}
