# Copyright 1999-2006 Gentoo Foundation
# Distributed under the terms of the GNU General Public License v2
# $Header: /var/cvsroot/gentoo-x86/sys-apps/qingy/qingy-0.7.4.ebuild,v 1.7 2006/11/16 10:01:22 s4t4n Exp $

DESCRIPTION="a DirectFB getty replacement"
HOMEPAGE="http://qingy.sourceforge.net/"
SRC_URI="mirror://sourceforge/${PN}/${P}.tar.bz2"

LICENSE="GPL-2"
SLOT="0"
KEYWORDS="x86 ~ppc ~amd64"
IUSE="crypt emacs gpm opensslcrypt pam static"

RDEPEND=">=dev-libs/DirectFB-0.9.18
	opensslcrypt? ( >=dev-libs/openssl-0.9.7e )
	crypt?        ( >=dev-libs/libgcrypt-1.2.1 )
	emacs?        ( virtual/emacs )
	pam?          ( >=sys-libs/pam-0.75-r11 )
	>=sys-libs/ncurses-5.4-r6
	|| ( (
		x11-libs/libX11
		x11-libs/libXScrnSaver
		x11-proto/scrnsaverproto )
	virtual/x11 )"

DEPEND="${RDEPEND}
	>=dev-util/pkgconfig-0.12.0"

src_unpack()
{
	if use opensslcrypt && use crypt; then
		echo
		eerror "You can have openssl or libgcrypt as a crypto library, not both."
		eerror "Please check your USE flags..."
		echo
		die "USE flags check failed"
	fi

	unpack ${A}
}

src_compile()
{
	local crypto_support="--disable-crypto"

	use opensslcrypt && crypto_support="--enable-crypto=openssl"
	use crypt        && crypto_support="--enable-crypto=libgcrypt"

	econf                                \
		--sbindir=/sbin                  \
		--disable-optimizations          \
		`use_enable emacs`               \
		`use_enable pam`                 \
		`use_enable static static-build` \
		`use_enable gpm gpm-lock`        \
		${crypto_support}                \
	|| die "Configuration failed"

	emake || die "Compilation failed"
}

src_install()
{
	# copy documentation manually as make install only installs info files
	# INSTALL is left because it contains also configuration informations
	dodoc AUTHORS ChangeLog INSTALL NEWS README THANKS TODO

	# and finally install the program
	make DESTDIR=${D} install || die "Installation failed"

	# Set the settings file umask to 600, in case somebody
	# wants to make use of the autologin feature
	/bin/chmod 600 ${D}/etc/qingy/settings

	# Replace qingy pam file with a more up-to-date one: see bug #155205
	cp ${FILESDIR}/qingy-pam ${D}/etc/pam.d/qingy
}

pkg_postinst()
{
	einfo "In order to use qingy you must first edit your /etc/inittab"
	einfo "Check the documentation at ${HOMEPAGE}"
	einfo "for instructions on how to do that."
	echo
	ewarn "Also note that qingy doesn't seem to work realiably with"
	ewarn "2.6.7 kernels due to problems with the DirectFB library."
	ewarn "Your mileage may vary, but it could even lock up your machine!"
	ewarn "See http://bugs.gentoo.org/show_bug.cgi?id=59340"
	ewarn "and http://bugs.gentoo.org/show_bug.cgi?id=60402"
	ewarn "Use either a 2.6.5 or a >=2.6.8 kernel!"

	if use crypt; then
		echo
		einfo "You will have to create a key pair using 'qingy-keygen'"
	fi
}
