# Copyright 1999-2007 Gentoo Foundation
# Distributed under the terms of the GNU General Public License v2
# $Header: /var/cvsroot/gentoo-x86/www-apache/mod_caucho/mod_caucho-3.0.22.ebuild,v 1.5 2007/02/03 13:43:13 beandog Exp $

inherit eutils apache-module autotools

KEYWORDS="amd64 ~ppc x86"

DESCRIPTION="mod_caucho connects Resin and Apache2."
HOMEPAGE="http://www.caucho.com/"
SRC_URI="http://www.caucho.com/download/resin-${PV}-src.tar.gz"
LICENSE="GPL-2"
SLOT="0"
IUSE=""

S="${WORKDIR}/resin-${PV}"

# See apache-module.eclass for more information.
APACHE2_MOD_CONF="88_${PN}"
APACHE2_MOD_DEFINE="CAUCHO"

need_apache2

src_unpack() {
	unpack ${A}
	cd "${S}"

	epatch "${FILESDIR}/${P}-gentoo.patch"
	eautoreconf
	chmod 755 ./configure
}

src_compile() {
	econf --with-apxs=${APXS2} || die "econf failed"

	emake -j1 -C "${S}/modules/c/src/common/" || die "emake failed"
	emake -j1 -C "${S}/modules/c/src/apache2/" || die "emake failed"
}

src_install() {
	cd "${S}/modules/c/src/apache2"
	emake -j1 DESTDIR="${D}" install || die "emake install failed"

	insinto "${APACHE2_MODULES_CONFDIR}"
	doins "${FILESDIR}/${APACHE2_MOD_CONF}.conf" \
	|| die "internal ebuild error: '${FILESDIR}/${APACHE2_MOD_CONF}.conf' not found."
}
