# Copyright 1999-2007 Gentoo Foundation
# Distributed under the terms of the GNU General Public License v2
# $Header: /var/cvsroot/gentoo-x86/app-misc/color/color-1.1.ebuild,v 1.18 2007/12/17 21:10:27 armin76 Exp $

inherit toolchain-funcs

DESCRIPTION="Easily add ANSI colouring to shell scripts"
HOMEPAGE="http://www.runslinux.net/?page_id=10"
SRC_URI="http://runslinux.net/projects/color/${P}.tar.gz"

LICENSE="GPL-2"
SLOT="0"
KEYWORDS="alpha amd64 ~hppa mips ppc ppc64 sparc x86"
IUSE=""

src_unpack() {
	unpack ${A}
	cd "${S}"

	# Use correct compiler and respect CFLAGS
	sed -i -e "s/cc/$(tc-getCC)/g" \
		-e "s/-W -Wall -O2 -g/${CFLAGS}/g" Makefile
}

src_install() {
	dobin color
	dodoc CHANGELOG README

	# symlink for british users.
	dosym /usr/bin/color /usr/bin/colour
}

pkg_postinst() {
	elog "For information on using colour in your shell scripts,"
	elog "run \`color\` without any arguments."
	elog
	elog "To see all the colours available, use this command"
	elog "	$ color --list"
	elog
	elog "More examples are available in /usr/share/doc/${PF}."
}
