# Copyright 1999-2007 Gentoo Foundation
# Distributed under the terms of the GNU General Public License v2
# $Header: /var/cvsroot/gentoo-x86/dev-perl/Tk-TableMatrix/Tk-TableMatrix-1.2.2.ebuild,v 1.12 2007/03/30 21:38:49 ticho Exp $

inherit versionator perl-module eutils multilib

MY_P="${PN}-$(delete_version_separator 2)"
S="${WORKDIR}/${MY_P}"

DESCRIPTION="Perl module for Tk-TableMatrix"
HOMEPAGE="http://search.cpan.org/author/CERNEY/${MY_P}"
SRC_URI="mirror://cpan/authors/id/C/CE/CERNEY/${MY_P}.tar.gz"

#SRC_TEST="do"

LICENSE="Artistic"
SLOT="0"
KEYWORDS="alpha amd64 ia64 ppc sparc x86"
IUSE=""

DEPEND="dev-perl/perl-tk
	dev-lang/perl"

src_unpack() {
	unpack ${A}
	cd ${S}
	epatch ${FILESDIR}/pTk-1.22.patch
}

src_install() {
	perl-module_src_install
	# Clean out stray conflicting file - its generated by perl-tk already.
	# Bug 169294
	local version
	eval `perl '-V:version'`
	perl_version=${version}

	local myarch
	eval `perl '-V:archname'`
	myarch=${archname}

	if [ -f ${D}/usr/$(get_libdir)/perl5/vendor_perl/${perl_version}/${myarch}/auto/Tk/pTk/extralibs.ld ]; then
		rm	${D}/usr/$(get_libdir)/perl5/vendor_perl/${perl_version}/${myarch}/auto/Tk/pTk/extralibs.ld
	fi

}
