# Copyright 1999-2008 Gentoo Foundation
# Distributed under the terms of the GNU General Public License v2
# $Header: /var/cvsroot/gentoo-x86/kde-base/krunner/krunner-4.0.0.ebuild,v 1.2 2008/01/27 15:21:21 zlin Exp $

EAPI="1"

KMNAME=kdebase-workspace
inherit kde4-meta

DESCRIPTION="KDE Command Runner"
IUSE="debug opengl xcomposite xscreensaver"
KEYWORDS="~amd64 ~x86"

COMMONDEPEND="
	>=kde-base/ksmserver-${PV}:${SLOT}
	>=kde-base/ksysguard-${PV}:${SLOT}
	>=kde-base/libkworkspace-${PV}:${SLOT}
	>=kde-base/libplasma-${PV}:${SLOT}
	>=kde-base/plasma-${PV}:${SLOT}
	x11-libs/libXxf86misc
	opengl? ( virtual/opengl )
	xcomposite? ( x11-libs/libXcomposite )"
DEPEND="${COMMONDEPEND}
	x11-proto/xf86miscproto
	xcomposite? ( x11-proto/compositeproto )"
RDEPEND="${COMMONDEPEND}
	>=kde-base/kdebase-data-${PV}:${SLOT}"

KMEXTRACTONLY="
	libs/kdm/
	libs/ksysguard/
	libs/kworkspace/
	kcontrol/
	ksysguard/
	ksmserver/org.kde.KSMServerInterface.xml
	kcheckpass/"

PATCHES="${FILESDIR}/${P}-linkage.patch
	${FILESDIR}/${P}-opengl.patch"

src_compile() {
	mycmakeargs="${mycmakeargs}
		$(cmake-utils_use_with opengl OpenGL)
		$(cmake-utils_use_with xcomposite X11_Xcomposite)"
	kde4-meta_src_compile
}
