# Copyright 1999-2008 Gentoo Foundation
# Distributed under the terms of the GNU General Public License v2
# $Header: /var/cvsroot/gentoo-x86/sys-apps/hal/hal-0.5.9.1-r3.ebuild,v 1.10 2008/04/14 18:36:31 cardoe Exp $

inherit eutils linux-info autotools flag-o-matic

DESCRIPTION="Hardware Abstraction Layer"
HOMEPAGE="http://www.freedesktop.org/Software/hal"
SRC_URI="http://people.freedesktop.org/~david/dist/${P}.tar.gz
		http://dev.gentoo.org/~cardoe/files/hal/${P}-r2.tar.bz2"

LICENSE="|| ( GPL-2 AFL-2.0 )"
SLOT="0"
KEYWORDS="alpha amd64 arm hppa ia64 -mips ppc -ppc64 sh sparc x86 ~x86-fbsd"

KERNEL_IUSE="kernel_linux kernel_FreeBSD"
IUSE="acpi crypt debug dell disk-partition doc pcmcia selinux ${KERNEL_IUSE}"

RDEPEND=">=dev-libs/glib-2.6
		>=dev-libs/dbus-glib-0.61
		kernel_linux? ( >=sys-fs/udev-104 )
		kernel_linux? ( >=sys-apps/util-linux-2.12r-r1 )
		kernel_linux? ( >=sys-kernel/linux-headers-2.6.17 )
		kernel_FreeBSD? ( dev-libs/libvolume_id )
		>=dev-libs/expat-1.95.8
		>=sys-apps/pciutils-2.2.7-r1
		>=dev-libs/libusb-0.1.10a
		sys-apps/usbutils
		virtual/eject
		amd64? ( >=sys-apps/dmidecode-2.7 )
		x86? ( >=sys-apps/dmidecode-2.7 )
		ia64? ( >=sys-apps/dmidecode-2.7 )
		dell? ( >=sys-libs/libsmbios-0.13.4 )
		disk-partition? ( <=sys-apps/parted-1.8.7 )
		kernel_linux? ( crypt? ( >=sys-fs/cryptsetup-1.0.5 ) )
		selinux? ( sys-libs/libselinux
					sec-policy/selinux-hal )"
#		pam? ( sys-auth/consolekit )"

DEPEND="${RDEPEND}
		dev-util/pkgconfig
		>=dev-util/intltool-0.35
		doc? ( app-doc/doxygen
				app-text/docbook-sgml-utils
				app-text/xmlto )"

PDEPEND="app-misc/hal-info"

## HAL Daemon drops privledges so we need group access to read disks
HALDAEMON_GROUPS_LINUX="haldaemon,plugdev,disk,cdrom,cdrw,floppy,usb"
HALDAEMON_GROUPS_FREEBSD="haldaemon,plugdev,operator"

function check_hotplug_net() {
	local CONFIG_CHECK="~HOTPLUG ~NET"
	local WARNING_HOTPLUG="CONFIG_HOTPLUG:\tis not set (required for HAL)
"
	local WARNING_NET="CONFIG_NET:\tis not set (required for HAL)
"
	check_extra_config
}

function check_inotify() {
	local CONFIG_CHECK="~INOTIFY_USER"
	local WARNING_INOTIFY_USER="CONFIG_INOTIFY_USER:\tis not set (required for HAL)
"
	check_extra_config
}

function check_procfs() {
	local CONFIG_CHECK="~PROC_FS"
	local WARNING_PROC_FS="CONFIG_PROC_FS:\tis not set (required for HAL)
"
	check_extra_config
}

pkg_setup() {
	if ! built_with_use --missing true sys-apps/pciutils hal ; then
		if built_with_use --missing false sys-apps/pciutils zlib ; then
			die "You MUST build sys-apps/pciutils without the zlib USE flag"
		fi
	fi

	if use kernel_linux ; then
		if [ -e ${ROOT}/usr/src/linux/.config ] ; then
			kernel_is ge 2 6 17 || \
				ewarn "HAL requires a kernel version 2.6.17 or newer"
		fi

		check_hotplug_net
		check_inotify
		use acpi && check_procfs
	fi

	if [[ -d ${ROOT}/etc/hal/device.d ]]; then
		eerror "HAL 0.5.x will not run with the HAL 0.4.x series of"
		eerror "/etc/hal/device.d/ so please remove this directory"
		eerror "with rm -rf /etc/hal/device.d/ and then re-emerge."
		eerror "This is due to configuration protection of /etc/"
		die "remove /etc/hal/device.d/"
	fi
}

src_unpack() {
	unpack ${A}
	cd "${S}"

	EPATCH_SUFFIX="patch" \
	EPATCH_FORCE="yes" \
	epatch "${WORKDIR}"/hal-patches

	eautoreconf
}

src_compile() {
	local backend=""
	local acpi=""

	# TODO :: policykit should have a pam useflag
	append-flags -rdynamic

	if use kernel_linux ; then
		backend="linux"
		use acpi && acpi="--enable-acpi-toshiba --enable-acpi-ibm"
	elif use kernel_FreeBSD ; then
		backend="freebsd"
	else
		eerror "Invalid backend"
	fi

	if ! use acpi ; then
		acpi="--disable-acpi-proc --disable-acpi-acpid"
	fi

	econf --disable-policy-kit \
		  --docdir=/usr/share/doc/${PF} \
		  --with-os-type=gentoo \
		  --with-pid-file=/var/run/hald.pid \
		  --with-socket-dir=/var/run/hald \
		  --with-hwdata=/usr/share/misc \
		  --enable-hotplug-map \
		  --enable-man-pages \
		  --with-backend=${backend} \
		  $(use_enable debug verbose-mode) \
		  $(use_with dell dell-backlight) \
		  $(use_enable disk-partition parted) \
		  $(use_enable pcmcia pcmcia-support) \
		  $(use_enable doc docbook-docs) \
		  $(use_enable doc doxygen-docs) \
		  $(use_enable selinux) \
		  --disable-console-kit \
		  ${acpi} \
	|| die "configure failed"
#$(use_enable pam console-kit)

	emake || die "make failed"
}

src_install() {
	make DESTDIR="${D}" install || die
	dodoc AUTHORS ChangeLog NEWS README

	# remove dep on gnome-python
	mv "${D}"/usr/bin/hal-device-manager "${D}"/usr/share/hal/device-manager/

	# hal umount for unclean unmounts
	exeinto /lib/udev/
	newexe "${FILESDIR}"/hal-unmount.dev hal_unmount

	# initscript
	newinitd "${FILESDIR}"/0.5.9-hald.rc hald
	cp "${FILESDIR}"/0.5.9-hald.conf "${WORKDIR}"/
#	if use pam; then
#		sed -e 's:RC_NEED="":RC_NEED="consolekit":' -i "${WORKDIR}"/0.5.9-hald.conf
#	fi
	if use debug; then
		sed -e 's:HALD_VERBOSE="no":HALD_VERBOSE="yes":' \
		-i "${WORKDIR}"/0.5.9-hald.conf
	fi
	newconfd "${WORKDIR}"/0.5.9-hald.conf hald

	# We now create and keep /media here as both gnome-mount and pmount
	# use these directories, to avoid collision.
	keepdir /media

	# We also need to create and keep /etc/fdi/{information,policy,preprobe}
	# or else hal bombs.
	keepdir /etc/hal/fdi/{information,policy,preprobe}

	# HAL stores it's fdi cache in /var/lib/cache/hald
	keepdir /var/lib/cache/hald

	# HAL keeps its unix socket here
	keepdir /var/run/hald
}

pkg_postinst() {
	# Despite what people keep changing this location. Either one works.. it doesn't matter
	# http://dev.gentoo.org/~plasmaroo/devmanual/ebuild-writing/functions/

	# Create groups for hotplugging and HAL
	enewgroup haldaemon || die "Problem adding haldaemon group"
	enewgroup plugdev || die "Problem adding plugdev group"

	# HAL drops priviledges by default now ...
	# ... so we must make sure it can read disk/cdrom info (ie. be in ${HALDAEMON_GROUPS} groups)
	if use kernel_linux; then
		enewuser haldaemon -1 "-1" /dev/null ${HALDAEMON_GROUPS_LINUX} \
			|| die "Problem adding haldaemon user"
	elif use kernel_FreeBSD; then
		enewuser haldaemon -1 "-1" /dev/null ${HALDAEMON_GROUPS_FREEBSD} \
			|| die "Problem addding haldaemon user"
	fi

	# Make sure that the haldaemon user is in the ${HALDAEMON_GROUPS}
	# If users have a problem with this, let them file a bug
	if [[ ${ROOT} == / ]] ; then
		if use kernel_linux; then
			usermod -G ${HALDAEMON_GROUPS_LINUX} haldaemon
		elif use kernel_FreeBSD; then
			pw usermod haldaemon -G ${HALDAEMON_GROUPS_FREEBSD}
		fi
	fi

	elog "The HAL daemon needs to be running for certain applications to"
	elog "work. Suggested is to add the init script to your start-up"
	elog "scripts, this should be done like this :"
	elog "\`rc-update add hald default\`"
	echo
	elog "Looking for automounting support? Add yourself to the plugdev group"
}
