# Copyright 1999-2008 Gentoo Foundation
# Distributed under the terms of the GNU General Public License v2
# $Header: /var/cvsroot/gentoo-x86/x11-libs/goffice/goffice-0.6.1.ebuild,v 1.10 2008/01/16 22:48:54 eva Exp $

inherit eutils gnome2 flag-o-matic

DESCRIPTION="A library of document-centric objects and utilities"
HOMEPAGE="http://freshmeat.net/projects/goffice/"

LICENSE="GPL-2"
SLOT="0.6"
KEYWORDS="alpha amd64 hppa ia64 ppc ppc64 sparc x86"
IUSE="gnome"
#doc support is broken without gtk-doc 1.9
#cairo support broken and -gtk broken

RDEPEND=">=dev-libs/glib-2.8.0
	>=gnome-extra/libgsf-1.13.3
	>=dev-libs/libxml2-2.4.12
	>=x11-libs/pango-1.8.1
	>=x11-libs/gtk+-2.6
	>=gnome-base/libglade-2.3.6
	>=media-libs/libart_lgpl-2.3.11
	>=x11-libs/cairo-1.2
	gnome? (
		>=gnome-base/gconf-2
		>=gnome-base/libgnomeui-2 )
	  dev-libs/libpcre"

DEPEND="${RDEPEND}
	>=dev-util/pkgconfig-0.18
	>=dev-util/intltool-0.35"
#	doc? ( >=dev-util/gtk-doc-1.4 )"

DOCS="AUTHORS BUGS ChangeLog MAINTAINERS NEWS README"

pkg_setup() {
	G2CONF="${G2CONF} $(use_with gnome)"

	local diemessage=""

	if use gnome && ! built_with_use gnome-extra/libgsf gnome; then
		eerror "Please rebuild gnome-extra/libgsf with gnome support enabled"
		eerror "echo \"gnome-extra/libgsf gnome\" >> /etc/portage/package.use"
		eerror "or add  \"gnome\" to your USE string in /etc/make.conf"
		diemessage="No Gnome support found in libgsf."
	fi

	if ! built_with_use x11-libs/cairo svg ; then
		eerror "Please rebuild x11-libs/cairo with svg support enabled"
		eerror "echo \"x11-libs/cairo svg\" >> /etc/portage/package.use"
		eerror "emerge -1 x11-libs/cairo"
		diemessage="${diemessage} No SVG support found in cairo."
	fi

	if ! built_with_use dev-libs/libpcre unicode; then
		eerror "Please rebuild dev-libs/libpcre with unicode support enabled"
		eerror "echo \"dev-libs/libpcre unicode\" >> /etc/portage/package.use"
		eerror "emerge -1 dev-libs/libpcre"
		diemessage="${diemessage} No unicode support found in libpcre."
	fi

	[ -n "${diemessage}" ] && die ${diemessage}
}

src_unpack() {
	gnome2_src_unpack

	# strip doc installation
	# needs gtk-doc-1.9 otherwise
	epatch "${FILESDIR}/${P}-die-gtk-doc.patch"
}

src_compile() {
	filter-flags -ffast-math
	gnome2_src_compile
}
