# Copyright 1999-2017 Gentoo Foundation
# Distributed under the terms of the GNU General Public License v2

EAPI=6

inherit toolchain-funcs

DESCRIPTION="Measures the speed of stdin/stdout communication"
HOMEPAGE="http://www.habets.pp.se/synscan/programs.php?prog=pipebench"
SRC_URI="ftp://ftp.habets.pp.se/pub/synscan/${P}.tar.gz"

LICENSE="GPL-2"
SLOT="0"
KEYWORDS="~alpha ~amd64 ~ppc ~ppc64 ~x86 ~arm-linux ~x86-linux"
IUSE=""

src_prepare() {
	sed -i Makefile \
		-e 's:CFLAGS=-Wall:CFLAGS+= -Wall:' \
		-e 's:$(CFLAGS) -o:$(LDFLAGS) &:g' \
		-e "s:/usr/local/bin/:${ED}/usr/bin:" \
		-e "s:/usr/local/man/man1/:${ED}/usr/share/man/man1:" \
		|| die "sed Makefile"
	default
}

src_compile() {
	emake CC=$(tc-getCC)
}

src_install() {
	dodir /usr/{bin,share/man/man1}
	emake install
	dodoc README
}
