# Copyright 1999-2017 Gentoo Foundation
# Distributed under the terms of the GNU General Public License v2

EAPI=6

# ebuild generated by hackport 0.5.9999

CABAL_FEATURES="lib profile haddock hoogle hscolour test-suite"
inherit haskell-cabal

DESCRIPTION="An HTTP client using io-streams"
HOMEPAGE="http://research.operationaldynamics.com/projects/http-streams/"
SRC_URI="mirror://hackage/packages/archive/${PN}/${PV}/${P}.tar.gz"

LICENSE="BSD"
SLOT="0/${PV}"
KEYWORDS="~amd64 ~x86"
IUSE="+network-uri"

RESTRICT=test # cyclic dep: http-streams[test]->snap-server->http-streams

RDEPEND="dev-haskell/aeson:=[profile?]
	dev-haskell/attoparsec:=[profile?]
	dev-haskell/base64-bytestring:=[profile?]
	>=dev-haskell/blaze-builder-0.4:=[profile?]
	dev-haskell/case-insensitive:=[profile?]
	>=dev-haskell/hsopenssl-0.10.3.5:=[profile?]
	>=dev-haskell/http-common-0.8.2:=[profile?]
	>=dev-haskell/io-streams-1.3:=[profile?] <dev-haskell/io-streams-1.4:=[profile?]
	dev-haskell/mtl:=[profile?]
	>=dev-haskell/openssl-streams-1.1:=[profile?] <dev-haskell/openssl-streams-1.4:=[profile?]
	dev-haskell/text:=[profile?]
	dev-haskell/unordered-containers:=[profile?]
	>=dev-lang/ghc-7.8.2:=
	network-uri? ( >=dev-haskell/network-2.6:=[profile?]
			>=dev-haskell/network-uri-2.6:=[profile?] )
	!network-uri? ( <dev-haskell/network-2.6:=[profile?]
			<dev-haskell/network-uri-2.6:=[profile?] )
"
DEPEND="${RDEPEND}
	>=dev-haskell/cabal-1.18.1.3
	test? ( dev-haskell/aeson-pretty
		dev-haskell/hspec
		dev-haskell/hspec-expectations
		dev-haskell/hunit
		dev-haskell/lifted-base
		>=dev-haskell/snap-core-1.0 <dev-haskell/snap-core-1.1
		>=dev-haskell/snap-server-1.0 <dev-haskell/snap-server-1.1
		>=dev-haskell/system-fileio-0.3.10 <dev-haskell/system-fileio-0.4
		>=dev-haskell/system-filepath-0.4.1 <dev-haskell/system-filepath-0.5
		!network-uri? ( >=dev-haskell/network-2.6
				>=dev-haskell/network-uri-2.6 ) )
"

src_configure() {
	haskell-cabal_src_configure \
		$(cabal_flag network-uri network-uri)
}
