# Copyright 1999-2017 Gentoo Foundation
# Distributed under the terms of the GNU General Public License v2

EAPI="5"

PYTHON_COMPAT=( python2_7 )

inherit autotools eutils python-r1 virtualx

DESCRIPTION="A Python Interface to GStreamer"
HOMEPAGE="https://gstreamer.freedesktop.org/"
SRC_URI="https://gstreamer.freedesktop.org/src/${PN}/${P}.tar.bz2"

LICENSE="LGPL-2"
SLOT="0.10"
KEYWORDS="alpha amd64 arm hppa ia64 ppc ppc64 sparc x86 ~x86-fbsd ~amd64-linux ~x86-linux ~x86-solaris"
IUSE="examples test"
REQUIRED_USE="${PYTHON_REQUIRED_USE}"

RDEPEND="${PYTHON_DEPS}
	dev-libs/libxml2
	>=dev-python/pygobject-2.28:2[${PYTHON_USEDEP}]
	>=media-libs/gstreamer-0.10.32:0.10
	>=media-libs/gst-plugins-base-0.10.32:0.10
"
DEPEND="${RDEPEND}
	virtual/pkgconfig
	test? (
		media-plugins/gst-plugins-ogg:0.10
		!!media-plugins/gst-plugins-ivorbis:0.10
		media-plugins/gst-plugins-vorbis:0.10
	)" # tests a "audiotestsrc ! vorbisenc ! oggmux ! fakesink" pipeline
# XXX: it looks like tests cannot be bothered with two vorbisdec implementations

src_prepare() {
	# FIXME: this comments out the only failing test, report to upstream
	sed -e '171,176 s/^\(.*\)$/#\1/' \
		-i testsuite/test_bin.py || die

	# Leave examples alone
	sed -e 's/\(SUBDIRS = .*\)examples/\1/' \
		-i Makefile.am Makefile.in || die

	sed \
		-e 's/AM_CONFIG_HEADER/AC_CONFIG_HEADERS/g' \
		-i configure.ac || die

	epatch "${FILESDIR}"/${PN}-0.10.9-lazy.patch
	AT_M4DIR="common/m4" eautoreconf

	prepare_gst() {
		mkdir -p "${BUILD_DIR}" || die
	}
	python_foreach_impl prepare_gst
}

src_configure() {
	configure_gst() {
		ECONF_SOURCE="${S}" econf
	}
	python_foreach_impl run_in_build_dir configure_gst
}

src_compile() {
	python_foreach_impl run_in_build_dir default
}

src_test() {
	LC_ALL="C" GST_REGISTRY="${T}/registry.cache.xml" python_foreach_impl run_in_build_dir Xemake check
}

src_install() {
	python_foreach_impl run_in_build_dir default
	prune_libtool_files --modules

	dodoc AUTHORS ChangeLog NEWS README TODO

	if use examples; then
		docinto examples
		dodoc examples/*
	fi
}

run_in_build_dir() {
	pushd "${BUILD_DIR}" > /dev/null || die
	"$@"
	popd > /dev/null
}
