# Copyright 1999-2017 Gentoo Foundation
# Distributed under the terms of the GNU General Public License v2

EAPI=6
PYTHON_COMPAT=( python{2_7,3_4,3_5,3_6} pypy )

inherit distutils-r1

DESCRIPTION="Bindings for the scrypt key derivation function library"
HOMEPAGE="https://bitbucket.org/mhallin/py-scrypt/wiki/Home/"
SRC_URI="mirror://pypi/${PN:0:1}/${PN}/${P}.tar.gz"

LICENSE="BSD-2"
KEYWORDS="amd64 ~arm ~arm64 x86"
SLOT="0"
IUSE="test doc"

DEPEND="${RDEPEND}
	dev-python/setuptools[${PYTHON_USEDEP}]"

# dist tarball does not have tests
RESTRICT=test

python_test() {
	esetup.py test || die "tests failed"
}
