# Copyright 1999-2017 Gentoo Foundation
# Distributed under the terms of the GNU General Public License v2

EAPI=6

PHP_EXT_NAME="apcu"
PHP_EXT_INI="yes"
PHP_EXT_ZENDEXT="no"
DOCS=( NOTICE README.md TECHNOTES.txt TODO )

USE_PHP="php5-6 php7-0 php7-1"

inherit php-ext-pecl-r3

USE_PHP="php5-6"

KEYWORDS="amd64 x86"

DESCRIPTION="Stripped down version of APC supporting only user cache"
LICENSE="PHP-3.01"
SLOT="0"
IUSE="+mmap"

DEPEND=""
PDEPEND="
php_targets_php7-0? ( dev-php/pecl-apcu:7[php_targets_php7-0] )
php_targets_php7-1? ( dev-php/pecl-apcu:7[php_targets_php7-1] )
"

LOCKS="pthreadmutex pthreadrw spinlock semaphore"

LUSE=""
for l in ${LOCKS}; do
	LUSE+="lock_${l} "
done

IUSE+=" ${LUSE/lock_pthreadrw/+lock_pthreadrw}"

REQUIRED_USE="^^ ( $LUSE )"

src_prepare() {
	if use php_targets_php5-6 ; then
		php-ext-source-r3_src_prepare
	else
		eapply_user
	fi
}

src_configure() {
	if use php_targets_php5-6 ; then
		local PHP_EXT_ECONF_ARGS=(
			--enable-apcu
			$(use_enable mmap apcu-mmap)
			$(use_enable lock_pthreadrw apcu-rwlocks)
			$(use_enable lock_spinlock apcu-spinlocks)
		)

		php-ext-source-r3_src_configure
	fi
}

src_install() {
	if use php_targets_php5-6 ; then
		php-ext-pecl-r3_src_install

		insinto "${PHP_EXT_SHARED_DIR}"
		doins apc.php
	fi
}

pkg_postinst() {
	if use php_targets_php5-6 ; then
		elog "The apc.php file shipped with this release of pecl-apcu was"
		elog "installed into ${PHP_EXT_SHARED_DIR}."
	fi
}
