# Copyright 1999-2016 Gentoo Foundation
# Distributed under the terms of the GNU General Public License v2

EAPI=6

# ebuild generated by hackport 0.5.9999

CABAL_FEATURES="lib profile haddock hoogle hscolour"
inherit haskell-cabal

MY_PN="iCalendar"
MY_P="${MY_PN}-${PV}"

DESCRIPTION="iCalendar data types, parser, and printer"
HOMEPAGE="https://github.com/chrra/iCalendar"
SRC_URI="mirror://hackage/packages/archive/${MY_PN}/${PV}/${MY_P}.tar.gz"

LICENSE="BSD"
SLOT="0/${PV}"
KEYWORDS="~amd64 ~x86"
IUSE="+network-uri"

RDEPEND=">=dev-haskell/base64-bytestring-1.0:=[profile?] <dev-haskell/base64-bytestring-1.1:=[profile?]
	>=dev-haskell/case-insensitive-0.4:=[profile?]
	>=dev-haskell/data-default-0.3:=[profile?]
	>=dev-haskell/mime-0.4.0.2:=[profile?]
	>=dev-haskell/mtl-2.1.0:=[profile?]
	dev-haskell/old-locale:=[profile?]
	>=dev-haskell/parsec-3.1.0:=[profile?]
	dev-haskell/text:=[profile?]
	>=dev-lang/ghc-7.10.1:=
	network-uri? ( >=dev-haskell/network-2.6:=[profile?] <dev-haskell/network-2.7:=[profile?]
			>=dev-haskell/network-uri-2.6:=[profile?] )
	!network-uri? ( >=dev-haskell/network-2.4:=[profile?] <dev-haskell/network-2.6:=[profile?] )
"
DEPEND="${RDEPEND}
	>=dev-haskell/cabal-1.22.2.0
"

S="${WORKDIR}/${MY_P}"

src_configure() {
	haskell-cabal_src_configure \
		$(cabal_flag network-uri network-uri)
}
