# Copyright 1999-2017 Gentoo Foundation
# Distributed under the terms of the GNU General Public License v2

EAPI="5"
PYTHON_COMPAT=( python{2_7,3_4,3_5,3_6} )
PYTHON_MULTIPLE_ABI=1

inherit distutils-r1

DESCRIPTION="python library for reading and writing collada documents"
HOMEPAGE="https://pycollada.github.com/"
SRC_URI="https://github.com/${PN}/${PN}/archive/v${PV}.tar.gz -> ${P}.tar.gz"

LICENSE="BSD"
SLOT="0"
KEYWORDS="~amd64 ~x86"
IUSE="doc examples test"

DEPEND="doc? ( dev-python/sphinx )
	test? ( dev-python/python-dateutil )"
RDEPEND="dev-python/numpy
	dev-python/lxml
	>=dev-python/python-dateutil-2.0"

src_compile() {
	distutils-r1_src_compile

	if use doc ; then
		pushd docs
		emake html
		popd
	fi
}

src_install() {
	distutils-r1_src_install

	if use doc ; then
		pushd docs/_build/html
		dohtml -r *
		popd
	fi

	if use examples ; then
		insinto /usr/share/${P}/
		doins -r examples
	fi

	install_test_data() {
		insinto $(python_get_sitedir)/collada/tests/
		doins -r collada/tests/data
	}
	python_foreach_impl install_test_data
}

src_test() {
	test_collada() {
		for script in "${S}"/collada/tests/*.py ; do
			PYTHONPATH="${S}" $EPYTHON "${script}"
		done
	}
	python_foreach_impl test_collada
}
