# Copyright 1999-2017 Gentoo Foundation
# Distributed under the terms of the GNU General Public License v2

EAPI=5

inherit eutils

DESCRIPTION="The GNU Emacs Lisp Reference Manual"
HOMEPAGE="https://www.gnu.org/software/emacs/manual/"
# taken from doc/lispref/ of emacs-${PV}
SRC_URI="https://dev.gentoo.org/~ulm/emacs/${P}.tar.xz
	https://dev.gentoo.org/~ulm/emacs/${P}-patches-1.tar.xz"

LICENSE="FDL-1.3+"
SLOT="23"
KEYWORDS="amd64 ppc x86 ~x86-fbsd"

DEPEND="sys-apps/texinfo"

S="${WORKDIR}/lispref"

src_prepare() {
	EPATCH_SUFFIX=patch epatch
}

src_compile() {
	makeinfo elisp.texi || die
}

src_install() {
	doinfo elisp${SLOT}.info*
	dodoc ChangeLog README
}
