
/**
 ** Generated data (by mkcproc.pl)
 **/
#line 1 "bseproject.proc"

#include <bse/bseplugin.h>
#include <bse/bseprocedure.h>
#include <bse/bseproject.h>
#include <bse/bsestorage.h>
#include <bse/bsesong.h>
#include <bse/bseundostack.h>
#include <bse/bsewaverepo.h>
#include <bse/bsecsynth.h>
#include <bse/bsemidisynth.h>
#include <bse/bsedatapocket.h>


#line 32 "bseproject.proc"


/* --- is-playing --- */
static void
is_playing_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 34 "bseproject.proc"
 {
#line 36 "bseproject.proc"
  *(in_pspecs++)    = bse_param_spec_object ("project", "Project", "The project",
                                 BSE_TYPE_PROJECT, SFI_PARAM_DEFAULT);
  *(out_pspecs++)   = sfi_pspec_bool ("is_playing", "Is Playing", "Whether the project is currently playing songs or synths",
                          FALSE, SFI_PARAM_DEFAULT);
#line 35 "bseproject.proc"
  proc->help = "Check whether a project is currently playing";
#line 30 "bseproject.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 31 "bseproject.proc"
  proc->copyright = "Copyright (C) 2001-2002 Tim Janik";
#line 40 "bseproject.proc"
}  }
static BseErrorType
#line 40 "bseproject.proc"
is_playing_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 43 "bseproject.proc"
{
#line 44 "bseproject.proc"
  
  BseProject *project = bse_value_get_object (in_values++);
  
#line 47 "bseproject.proc"
  
  if (!BSE_IS_PROJECT (project))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 51 "bseproject.proc"
  
  
#line 53 "bseproject.proc"
  
  sfi_value_set_bool (out_values++, project->state == BSE_PROJECT_PLAYING);
  
  return BSE_ERROR_NONE;
}

/* --- is-active --- */
static void
is_active_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 59 "bseproject.proc"
 {
#line 61 "bseproject.proc"
  *(in_pspecs++)    = bse_param_spec_object ("project", "Project", "The project",
                                 BSE_TYPE_PROJECT, SFI_PARAM_DEFAULT);
  *(out_pspecs++)   = sfi_pspec_bool ("is_active", NULL, "Whether the project is currently producing sound",
                          FALSE, SFI_PARAM_DEFAULT);
#line 60 "bseproject.proc"
  proc->help = "Check whether a project is active";
#line 30 "bseproject.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 31 "bseproject.proc"
  proc->copyright = "Copyright (C) 2001-2002 Tim Janik";
#line 65 "bseproject.proc"
}  }
static BseErrorType
#line 65 "bseproject.proc"
is_active_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 68 "bseproject.proc"
{
#line 69 "bseproject.proc"
  
  BseProject *project = bse_value_get_object (in_values++);
  
#line 72 "bseproject.proc"
  
  if (!BSE_IS_PROJECT (project))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 76 "bseproject.proc"
  
  
#line 78 "bseproject.proc"
  
  sfi_value_set_bool (out_values++, project->state != BSE_PROJECT_INACTIVE);
  
  return BSE_ERROR_NONE;
}

/* --- restore-from-file --- */
static void
restore_from_file_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 84 "bseproject.proc"
 {
#line 86 "bseproject.proc"
  *(in_pspecs++)    = bse_param_spec_object ("project", "Project", "The project",
                                 BSE_TYPE_PROJECT, SFI_PARAM_DEFAULT);
  *(in_pspecs++)    = sfi_pspec_string ("file-name", "File", "Source file name",
                            NULL, SFI_PARAM_DEFAULT);
  *(out_pspecs++)   = bse_param_spec_enum ("error", "Error", "Error indicating possible failures",
                               BSE_ERROR_NONE, BSE_TYPE_ERROR_TYPE,
                               SFI_PARAM_DEFAULT);
#line 85 "bseproject.proc"
  proc->help = "Load a project from file";
#line 30 "bseproject.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 31 "bseproject.proc"
  proc->copyright = "Copyright (C) 2001-2002 Tim Janik";
#line 93 "bseproject.proc"
}  }
static BseErrorType
#line 93 "bseproject.proc"
restore_from_file_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 96 "bseproject.proc"
{
#line 97 "bseproject.proc"
  
  BseProject *project = bse_value_get_object (in_values++);
  gchar *file_name = sfi_value_get_string (in_values++);
  BseErrorType error;
  
#line 102 "bseproject.proc"
  
  if (!BSE_IS_PROJECT (project) || !file_name)
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 106 "bseproject.proc"
  
  if (!project->in_undo && !project->in_redo)
    {
      BseStorage *storage = g_object_new (BSE_TYPE_STORAGE, NULL);
      error = bse_storage_input_file (storage, file_name);
      if (!error)
        error = bse_project_restore (project, storage);
      bse_storage_reset (storage);
      g_object_unref (storage);
      bse_undo_stack_clear (project->undo_stack);
      bse_undo_stack_clear (project->redo_stack);
      g_object_notify (project, "dirty");
    }
  else
    error = BSE_ERROR_PROC_BUSY;

#line 122 "bseproject.proc"
  
  g_value_set_enum (out_values++, error);
  
  return BSE_ERROR_NONE;
}

/* --- store-bse --- */
static void
store_bse_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 128 "bseproject.proc"
 {
#line 130 "bseproject.proc"
  *(in_pspecs++)    = bse_param_spec_object ("project", "Project", "The project",
                                 BSE_TYPE_PROJECT, SFI_PARAM_DEFAULT);
  *(in_pspecs++)    = sfi_pspec_string ("file-name", "File", "Destination file name",
                            NULL, SFI_PARAM_DEFAULT);
  *(in_pspecs++)    = sfi_pspec_bool ("self-contained", "Self Contained",
                          "Whether references to other objects (e.g. samples) should "
                          "be stored or whether to include everything in a self-contained .bse file",
                          FALSE, SFI_PARAM_DEFAULT);
  *(out_pspecs++)   = bse_param_spec_genum ("error", "Error", "Error indicating possible failures",
                                BSE_TYPE_ERROR_TYPE, BSE_ERROR_NONE,
                                SFI_PARAM_DEFAULT);
#line 129 "bseproject.proc"
  proc->help = "Save a project into a BSE file";
#line 30 "bseproject.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 31 "bseproject.proc"
  proc->copyright = "Copyright (C) 2001-2002 Tim Janik";
#line 141 "bseproject.proc"
}  }
static BseErrorType
#line 141 "bseproject.proc"
store_bse_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 144 "bseproject.proc"
{
#line 145 "bseproject.proc"
  
  BseProject *project = bse_value_get_object (in_values++);
  gchar *file_name = sfi_value_get_string (in_values++);
  gboolean self_contained = sfi_value_get_bool (in_values++);
  BseErrorType error;
  
#line 151 "bseproject.proc"
  
  if (!BSE_IS_PROJECT (project) || !file_name)
    return BSE_ERROR_PROC_PARAM_INVAL;
  
  error = bse_project_store_bse (project, file_name, self_contained);
  
#line 157 "bseproject.proc"
  
  g_value_set_enum (out_values++, error);
  
  return BSE_ERROR_NONE;
}

/* --- create-song --- */
static void
create_song_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 163 "bseproject.proc"
 {
#line 165 "bseproject.proc"
  *(in_pspecs++)    = bse_param_spec_object ("project", "Project", "The project",
                                 BSE_TYPE_PROJECT, SFI_PARAM_DEFAULT);
  *(in_pspecs++)    = sfi_pspec_string ("name", "Name", "Song name",
                            NULL, SFI_PARAM_DEFAULT);
  *(out_pspecs++)   = bse_param_spec_object ("song", "Song", "The new song",
                                 BSE_TYPE_SONG, SFI_PARAM_DEFAULT);
#line 30 "bseproject.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 31 "bseproject.proc"
  proc->copyright = "Copyright (C) 2001-2002 Tim Janik";
#line 171 "bseproject.proc"
}  }
static BseErrorType
#line 171 "bseproject.proc"
create_song_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 174 "bseproject.proc"
{
#line 175 "bseproject.proc"
  
  BseContainer *container = bse_value_get_object (in_values++);
  const gchar *name       = sfi_value_get_string (in_values++);
  BseUndoStack *ustack;
  BseItem *child;

#line 181 "bseproject.proc"
  
  if (!BSE_IS_PROJECT (container))
    return BSE_ERROR_PROC_PARAM_INVAL;

#line 185 "bseproject.proc"
  
  ustack = bse_item_undo_open (container, "create-song");
  child = bse_container_new_child (container, BSE_TYPE_SONG, NULL);
  if (name)
    bse_item_set (child, "uname", name, NULL);
  bse_item_push_undo_proc (container, "remove-snet", child);
  bse_item_undo_close (ustack);

#line 193 "bseproject.proc"
  
  bse_value_set_object (out_values++, child);

  return BSE_ERROR_NONE;
}

/* --- get-wave-repo --- */
static void
get_wave_repo_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 199 "bseproject.proc"
 {
#line 201 "bseproject.proc"
  *(in_pspecs++)    = bse_param_spec_object ("project", "Project", "The project",
                                 BSE_TYPE_PROJECT, SFI_PARAM_DEFAULT);
  *(out_pspecs++)   = bse_param_spec_object ("wrepo", "Wave Repo", "The project's unique wave repo",
                                 BSE_TYPE_WAVE_REPO, SFI_PARAM_DEFAULT);
#line 200 "bseproject.proc"
  proc->help = "Ensure the project has a wave repository";
#line 30 "bseproject.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 31 "bseproject.proc"
  proc->copyright = "Copyright (C) 2001-2002 Tim Janik";
#line 205 "bseproject.proc"
}  }
static BseErrorType
#line 205 "bseproject.proc"
get_wave_repo_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 208 "bseproject.proc"
{
#line 209 "bseproject.proc"
  
  BseProject *project = bse_value_get_object (in_values++);
  BseWaveRepo *wrepo = NULL;
  
#line 213 "bseproject.proc"
  
  if (!BSE_IS_PROJECT (project))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 217 "bseproject.proc"
  
  wrepo = bse_project_get_wave_repo (project);
  
#line 220 "bseproject.proc"
  
  bse_value_set_object (out_values++, wrepo);
  
  return BSE_ERROR_NONE;
}

/* --- get-data-pocket --- */
static void
get_data_pocket_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 226 "bseproject.proc"
 {
#line 228 "bseproject.proc"
  *(in_pspecs++)    = bse_param_spec_object ("project", "Project", "The project",
                                 BSE_TYPE_PROJECT, SFI_PARAM_DEFAULT);
  *(in_pspecs++)    = sfi_pspec_string ("name", "Name", "Name of the data pocket",
                            NULL, SFI_PARAM_DEFAULT);
  *(out_pspecs++)   = bse_param_spec_object ("data_pocket", "Data Pocket", "The data pocket",
                                 BSE_TYPE_DATA_POCKET, SFI_PARAM_DEFAULT);
#line 227 "bseproject.proc"
  proc->help = "Retrieve a specifically named data pocket for this project";
#line 30 "bseproject.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 31 "bseproject.proc"
  proc->copyright = "Copyright (C) 2001-2002 Tim Janik";
#line 234 "bseproject.proc"
}  }
static BseErrorType
#line 234 "bseproject.proc"
get_data_pocket_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 237 "bseproject.proc"
{
#line 238 "bseproject.proc"
  
  BseProject *project = bse_value_get_object (in_values++);
  gchar *name = sfi_value_get_string (in_values++);
  BseItem *item;
  
#line 243 "bseproject.proc"
  
  if (!BSE_IS_PROJECT (project) || !name)
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 247 "bseproject.proc"
  
  item = bse_project_lookup_typed_item (project, BSE_TYPE_DATA_POCKET, name);
  if (!item)
    item = bse_container_new_child (BSE_CONTAINER (project), BSE_TYPE_DATA_POCKET,
                                    "uname", name,
                                    NULL);
  
#line 254 "bseproject.proc"
  
  bse_value_set_object (out_values++, item);
  
  return BSE_ERROR_NONE;
}

/* --- create-csynth --- */
static void
create_csynth_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 260 "bseproject.proc"
 {
#line 262 "bseproject.proc"
  *(in_pspecs++)    = bse_param_spec_object ("project", "Project", "The project",
                                 BSE_TYPE_PROJECT, SFI_PARAM_DEFAULT);
  *(in_pspecs++)    = sfi_pspec_string ("name", "Name", "Synth network name",
                            NULL, SFI_PARAM_DEFAULT);
  *(out_pspecs++)   = bse_param_spec_object ("csynth", "Synthesizer Network", "New synth network",
                                 BSE_TYPE_CSYNTH, SFI_PARAM_DEFAULT);
#line 30 "bseproject.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 31 "bseproject.proc"
  proc->copyright = "Copyright (C) 2001-2002 Tim Janik";
#line 268 "bseproject.proc"
}  }
static BseErrorType
#line 268 "bseproject.proc"
create_csynth_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 271 "bseproject.proc"
{
#line 272 "bseproject.proc"
  
  BseContainer *container = bse_value_get_object (in_values++);
  const gchar *name       = sfi_value_get_string (in_values++);
  BseUndoStack *ustack;
  BseItem *child;
  
#line 278 "bseproject.proc"
  
  if (!BSE_IS_PROJECT (container))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 282 "bseproject.proc"
  
  ustack = bse_item_undo_open (container, "create-csynth");
  child = bse_container_new_child (container, BSE_TYPE_CSYNTH, NULL);
  if (name)
    bse_item_set (child, "uname", name, NULL);
  bse_item_push_undo_proc (container, "remove-snet", child);
  bse_item_undo_close (ustack);
  
#line 290 "bseproject.proc"
  
  bse_value_set_object (out_values++, child);
  
  return BSE_ERROR_NONE;
}

/* --- create-midi-synth --- */
static void
create_midi_synth_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 296 "bseproject.proc"
 {
#line 298 "bseproject.proc"
  *(in_pspecs++)    = bse_param_spec_object ("project", "Project", "The project",
                                 BSE_TYPE_PROJECT, SFI_PARAM_DEFAULT);
  *(in_pspecs++)    = sfi_pspec_string ("name", "Name", "MIDI synth name",
                            NULL, SFI_PARAM_DEFAULT);
  *(out_pspecs++)   = bse_param_spec_object ("midi_synth", "MIDI Synthesizer", "New MIDI synth",
                                 BSE_TYPE_MIDI_SYNTH, SFI_PARAM_DEFAULT);
#line 30 "bseproject.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 31 "bseproject.proc"
  proc->copyright = "Copyright (C) 2001-2002 Tim Janik";
#line 304 "bseproject.proc"
}  }
static BseErrorType
#line 304 "bseproject.proc"
create_midi_synth_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 307 "bseproject.proc"
{
#line 308 "bseproject.proc"
  
  BseContainer *container = bse_value_get_object (in_values++);
  gchar *name             = sfi_value_get_string (in_values++);
  BseUndoStack *ustack;
  BseItem *child;

#line 314 "bseproject.proc"
  
  if (!BSE_IS_PROJECT (container))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 318 "bseproject.proc"
  
  ustack = bse_item_undo_open (container, "create-midi-synth");
  child = bse_container_new_child (container, BSE_TYPE_MIDI_SYNTH, NULL);
  if (name)
    bse_item_set (child, "uname", name, NULL);
  bse_item_push_undo_proc (container, "remove-snet", child);
  bse_item_undo_close (ustack);

#line 326 "bseproject.proc"
  
  bse_value_set_object (out_values++, child);
  
  return BSE_ERROR_NONE;
}

/* --- remove-snet --- */
static void
remove_snet_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 332 "bseproject.proc"
 {
#line 334 "bseproject.proc"
  *(in_pspecs++)    = bse_param_spec_object ("project", "Project", "The project",
                                 BSE_TYPE_PROJECT, SFI_PARAM_DEFAULT);
  *(in_pspecs++)    = bse_param_spec_object ("snet", "SNet", "Synthesizer Network",
                                 BSE_TYPE_SNET, SFI_PARAM_DEFAULT);
#line 30 "bseproject.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 31 "bseproject.proc"
  proc->copyright = "Copyright (C) 2001-2002 Tim Janik";
#line 338 "bseproject.proc"
}  }
static BseErrorType
#line 338 "bseproject.proc"
remove_snet_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 341 "bseproject.proc"
{
#line 342 "bseproject.proc"
  
  BseContainer *self  = bse_value_get_object (in_values++);
  BseItem      *child = bse_value_get_object (in_values++);
  BseUndoStack *ustack;
  
#line 347 "bseproject.proc"
  
  if (!BSE_IS_PROJECT (self) || !BSE_IS_SNET (child) || child->parent != (BseItem*) self)
    return BSE_ERROR_PROC_PARAM_INVAL;

#line 351 "bseproject.proc"
  
  if (!BSE_SOURCE_PREPARED (self))
    {
      ustack = bse_item_undo_open (self, "remove-child %s", bse_object_debug_name (child));
#line 355 "bseproject.proc"
      
      bse_container_uncross_undoable (BSE_CONTAINER (self), child);
#line 357 "bseproject.proc"
      
      bse_item_push_redo_proc (self, "remove-snet", child);
#line 359 "bseproject.proc"
      
      bse_container_remove_backedup (BSE_CONTAINER (self), child, ustack);
#line 361 "bseproject.proc"
      
      bse_item_undo_close (ustack);
    }
  
  return BSE_ERROR_NONE;
}

/* --- list-uname-paths --- */
static void
list_uname_paths_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 368 "bseproject.proc"
 {
#line 371 "bseproject.proc"
  *(in_pspecs++)    = bse_param_spec_object ("project", NULL, NULL,
                                 BSE_TYPE_PROJECT, SFI_PARAM_DEFAULT);
  *(in_pspecs++)    = sfi_pspec_string ("item_type", NULL, NULL,
                            NULL, SFI_PARAM_DEFAULT);
  *(out_pspecs++)   = bse_param_spec_boxed ("uname_paths", "Uname Paths", NULL, BSE_TYPE_STRING_SEQ, SFI_PARAM_DEFAULT);
#line 369 "bseproject.proc"
  proc->help = ("List uname paths for all items of a specified type within this project. "
           "By their uname paths, items are uniquely identifyable within a project.");
#line 30 "bseproject.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 31 "bseproject.proc"
  proc->copyright = "Copyright (C) 2001-2002 Tim Janik";
#line 376 "bseproject.proc"
}  }
static BseErrorType
#line 376 "bseproject.proc"
list_uname_paths_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 379 "bseproject.proc"
{
#line 380 "bseproject.proc"
  
  BseProject *project = bse_value_get_object (in_values++);
  const gchar *tname  = sfi_value_get_string (in_values++);
  GType type          = tname ? g_type_from_name (tname) : 0;
  
#line 385 "bseproject.proc"
  
  if (!BSE_IS_PROJECT (project) || !g_type_is_a (type, BSE_TYPE_ITEM))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 389 "bseproject.proc"
  
  bse_value_take_boxed (out_values++, bse_project_list_upaths (project, type));
  
  return BSE_ERROR_NONE;
}

/* --- find-item --- */
static void
find_item_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 395 "bseproject.proc"
 {
#line 397 "bseproject.proc"
  *(in_pspecs++)    = bse_param_spec_object ("project", NULL, NULL,
                                 BSE_TYPE_PROJECT, SFI_PARAM_DEFAULT);
  *(in_pspecs++)    = sfi_pspec_string ("uname_path", NULL, NULL,
                            NULL, SFI_PARAM_DEFAULT);
  *(out_pspecs++)   = bse_param_spec_object ("item", NULL, NULL,
                                 BSE_TYPE_ITEM, SFI_PARAM_DEFAULT);
#line 396 "bseproject.proc"
  proc->help = "Find an item within a project, given its uname path.";
#line 30 "bseproject.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 31 "bseproject.proc"
  proc->copyright = "Copyright (C) 2001-2002 Tim Janik";
#line 403 "bseproject.proc"
}  }
static BseErrorType
#line 403 "bseproject.proc"
find_item_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 406 "bseproject.proc"
{
#line 407 "bseproject.proc"
  
  BseProject *project = bse_value_get_object (in_values++);
  const gchar *string = sfi_value_get_string (in_values++);
  
#line 411 "bseproject.proc"
  
  if (!BSE_IS_PROJECT (project) || !string)
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 415 "bseproject.proc"
  
  bse_value_set_object (out_values++, bse_container_resolve_upath (BSE_CONTAINER (project), string));
  
  return BSE_ERROR_NONE;
}

/* --- match-items-by-uname --- */
static void
match_items_by_uname_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 421 "bseproject.proc"
 {
#line 423 "bseproject.proc"
  *(in_pspecs++)    = bse_param_spec_object ("project", NULL, NULL,
                                 BSE_TYPE_PROJECT, SFI_PARAM_DEFAULT);
  *(in_pspecs++)    = sfi_pspec_string ("item_type", NULL, NULL,
                            NULL, SFI_PARAM_DEFAULT);
  *(in_pspecs++)    = sfi_pspec_string ("uname", NULL, NULL,
                            NULL, SFI_PARAM_DEFAULT);
  *(out_pspecs++)   = bse_param_spec_boxed ("item_list", "Item List", NULL, BSE_TYPE_PROXY_SEQ, SFI_PARAM_DEFAULT);
#line 422 "bseproject.proc"
  proc->help = "Retrieve all items of a specific type within a project with matching uname";
#line 30 "bseproject.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 31 "bseproject.proc"
  proc->copyright = "Copyright (C) 2001-2002 Tim Janik";
#line 430 "bseproject.proc"
}  }
static BseErrorType
#line 430 "bseproject.proc"
match_items_by_uname_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 433 "bseproject.proc"
{
#line 434 "bseproject.proc"
  
  BseProject *project = bse_value_get_object (in_values++);
  const gchar *tname  = sfi_value_get_string (in_values++);
  const gchar *string = sfi_value_get_string (in_values++);
  GType type          = tname ? g_type_from_name (tname) : 0;
  GList *list, *free_list;
  BseProxySeq *pseq;
  
#line 442 "bseproject.proc"
  
  if (!BSE_IS_PROJECT (project) || !string || !g_type_is_a (type, BSE_TYPE_ITEM))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 446 "bseproject.proc"
  
  pseq = bse_proxy_seq_new ();
  free_list = bse_objects_list_by_uname (type, string);
  for (list = free_list; list; list = list->next)
    if (bse_item_get_project (list->data) == project)
      {
        bse_proxy_seq_append (pseq, BSE_OBJECT_ID (list->data));
        break;
      }
  g_list_free (free_list);
  
#line 457 "bseproject.proc"
  
  bse_value_take_boxed (out_values++, pseq);
  
  return BSE_ERROR_NONE;
}

/* --- get-supers --- */
static void
get_supers_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 463 "bseproject.proc"
 {
#line 465 "bseproject.proc"
  *(in_pspecs++)    = bse_param_spec_object ("project", NULL, NULL,
                                 BSE_TYPE_PROJECT, SFI_PARAM_DEFAULT);
  *(out_pspecs++)   = bse_param_spec_boxed ("super_list", NULL, NULL, BSE_TYPE_PROXY_SEQ, SFI_PARAM_DEFAULT);
#line 464 "bseproject.proc"
  proc->help = "Retrieve all supers of this project.";
#line 30 "bseproject.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 31 "bseproject.proc"
  proc->copyright = "Copyright (C) 2001-2002 Tim Janik";
#line 468 "bseproject.proc"
}  }
static BseErrorType
#line 468 "bseproject.proc"
get_supers_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 471 "bseproject.proc"
{
#line 472 "bseproject.proc"
  
  BseProject *project = bse_value_get_object (in_values++);
  BseProxySeq *pseq;
  GSList *slist;
  
#line 477 "bseproject.proc"
  
  if (!BSE_IS_PROJECT (project))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 481 "bseproject.proc"
  
  pseq = bse_proxy_seq_new ();
  for (slist = project->supers; slist; slist = slist->next)
    bse_proxy_seq_append (pseq, BSE_OBJECT_ID (slist->data));
  
#line 486 "bseproject.proc"
  
  bse_value_take_boxed (out_values++, pseq);
  
  return BSE_ERROR_NONE;
}

/* --- can-play --- */
static void
can_play_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 492 "bseproject.proc"
 {
#line 494 "bseproject.proc"
  *(in_pspecs++)    = bse_param_spec_object ("project", "Project", "The project",
                                 BSE_TYPE_PROJECT, SFI_PARAM_DEFAULT);
  *(out_pspecs++)   = sfi_pspec_bool ("can_play", "Can Play", "Whether project playback makes sense",
                          FALSE, SFI_PARAM_DEFAULT);
#line 493 "bseproject.proc"
  proc->help = "Check whether project playback would makes sense.";
#line 30 "bseproject.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 31 "bseproject.proc"
  proc->copyright = "Copyright (C) 2001-2002 Tim Janik";
#line 498 "bseproject.proc"
}  }
static BseErrorType
#line 498 "bseproject.proc"
can_play_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 501 "bseproject.proc"
{
#line 502 "bseproject.proc"
  
  BseProject *project = bse_value_get_object (in_values++);
  gpointer wrepo;
  
#line 506 "bseproject.proc"
  
  if (!BSE_IS_PROJECT (project))
    return BSE_ERROR_PROC_PARAM_INVAL;

#line 510 "bseproject.proc"
  
  wrepo = bse_project_get_wave_repo (project);
  sfi_value_set_bool (out_values++, project->supers->data != wrepo || project->supers->next);
  
  return BSE_ERROR_NONE;
}

/* --- get-state --- */
static void
get_state_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 517 "bseproject.proc"
 {
#line 519 "bseproject.proc"
  *(in_pspecs++)    = bse_param_spec_object ("project", "Project", "The project",
                                 BSE_TYPE_PROJECT, SFI_PARAM_DEFAULT);
  *(out_pspecs++)   = bse_param_spec_genum ("state", "State", "Project playback/activation state",
                                BSE_TYPE_PROJECT_STATE, BSE_PROJECT_INACTIVE, SFI_PARAM_DEFAULT);
#line 518 "bseproject.proc"
  proc->help = "Retrieve the current project state.";
#line 30 "bseproject.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 31 "bseproject.proc"
  proc->copyright = "Copyright (C) 2001-2002 Tim Janik";
#line 523 "bseproject.proc"
}  }
static BseErrorType
#line 523 "bseproject.proc"
get_state_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 526 "bseproject.proc"
{
#line 527 "bseproject.proc"
  
  BseProject *self = bse_value_get_object (in_values++);
  
#line 530 "bseproject.proc"
  
  if (!BSE_IS_PROJECT (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 534 "bseproject.proc"
  
  g_value_set_enum (out_values++, self->state);
  
  return BSE_ERROR_NONE;
}

static void
undo_do_deactivate (BseUndoStep  *ustep,
                    BseUndoStack *ustack)
{
  BseProject *self = bse_undo_pointer_unpack (ustep->data[0].v_pointer, ustack);
  bse_project_stop_playback (self);
}

static void
undo_do_deactivate_free (BseUndoStep *ustep)
{
  g_free (ustep->data[0].v_pointer);
}

static void
project_push_undo_silent_deactivate (BseProject *self)
{
  BseUndoStack *ustack = bse_item_undo_open (self, "deactivate-project");
  BseUndoStep *ustep = bse_undo_step_new (undo_do_deactivate, undo_do_deactivate_free, 1);
#line 559 "bseproject.proc"
  
  ustep->data[0].v_pointer = bse_undo_pointer_pack (self, ustack);
  bse_undo_stack_push_add_on (ustack, ustep);
  bse_item_undo_close (ustack);
}

/* --- activate --- */
static void
activate_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 571 "bseproject.proc"
 {
#line 573 "bseproject.proc"
  *(in_pspecs++)    = bse_param_spec_object ("project", "Project", "The project",
                                 BSE_TYPE_PROJECT, SFI_PARAM_DEFAULT);
  *(out_pspecs++)   = bse_param_spec_genum ("error", "Error", NULL,
                                BSE_TYPE_ERROR_TYPE, BSE_ERROR_NONE,
                                SFI_PARAM_DEFAULT);
#line 572 "bseproject.proc"
  proc->help = "Activate a project, precondition to start playback.";
#line 30 "bseproject.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 31 "bseproject.proc"
  proc->copyright = "Copyright (C) 2001-2002 Tim Janik";
#line 578 "bseproject.proc"
}  }
static BseErrorType
#line 578 "bseproject.proc"
activate_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 581 "bseproject.proc"
{
#line 582 "bseproject.proc"
  
  BseProject *self = bse_value_get_object (in_values++);
  BseProjectState state_before;
  BseErrorType error;

#line 587 "bseproject.proc"
  
  if (!BSE_IS_PROJECT (self))
    return BSE_ERROR_PROC_PARAM_INVAL;

  state_before = self->state;
  error = bse_project_activate (self);
  if (state_before == BSE_PROJECT_INACTIVE && self->state != BSE_PROJECT_INACTIVE)
    {
#line 595 "bseproject.proc"
      
      project_push_undo_silent_deactivate (self);
    }
  
  g_value_set_enum (out_values++, error);

  return BSE_ERROR_NONE;
}

/* --- start-playback --- */
static void
start_playback_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 604 "bseproject.proc"
 {
#line 606 "bseproject.proc"
  *(in_pspecs++)    = bse_param_spec_object ("project", "Project", "The project",
                                 BSE_TYPE_PROJECT, SFI_PARAM_DEFAULT);
#line 605 "bseproject.proc"
  proc->help = "Start playback in an activated project.";
#line 30 "bseproject.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 31 "bseproject.proc"
  proc->copyright = "Copyright (C) 2001-2002 Tim Janik";
#line 608 "bseproject.proc"
}  }
static BseErrorType
#line 608 "bseproject.proc"
start_playback_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 611 "bseproject.proc"
{
#line 612 "bseproject.proc"
  
  BseProject *self = bse_value_get_object (in_values++);
  BseProjectState state_before;

#line 616 "bseproject.proc"
  
  if (!BSE_IS_PROJECT (self))
    return BSE_ERROR_PROC_PARAM_INVAL;

  state_before = self->state;
  bse_project_start_playback (self);
  if (state_before == BSE_PROJECT_INACTIVE && self->state != BSE_PROJECT_INACTIVE)
    {
#line 624 "bseproject.proc"
      
      project_push_undo_silent_deactivate (self);
    }

  return BSE_ERROR_NONE;
}

/* --- play --- */
static void
play_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 631 "bseproject.proc"
 {
#line 633 "bseproject.proc"
  *(in_pspecs++)    = bse_param_spec_object ("project", "Project", "The project",
                                 BSE_TYPE_PROJECT, SFI_PARAM_DEFAULT);
  *(out_pspecs++)   = bse_param_spec_genum ("error", "Error", NULL,
                                BSE_TYPE_ERROR_TYPE, BSE_ERROR_NONE,
                                SFI_PARAM_DEFAULT);
#line 632 "bseproject.proc"
  proc->help = "Activate a project and start project playback (and already playing project is first halted).";
#line 30 "bseproject.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 31 "bseproject.proc"
  proc->copyright = "Copyright (C) 2001-2002 Tim Janik";
#line 638 "bseproject.proc"
}  }
static BseErrorType
#line 638 "bseproject.proc"
play_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 641 "bseproject.proc"
{
#line 642 "bseproject.proc"
  
  BseProject *self = bse_value_get_object (in_values++);
  BseErrorType error;
  BseProjectState state_before;
  
#line 647 "bseproject.proc"
  
  if (!BSE_IS_PROJECT (self))
    return BSE_ERROR_PROC_PARAM_INVAL;

  state_before = self->state;
  error = bse_project_activate (self);
  if (!error)
    {
      if (self->state == BSE_PROJECT_PLAYING)
        bse_project_stop_playback (self);
      bse_project_start_playback (self);
    }
  if (state_before == BSE_PROJECT_INACTIVE && self->state != BSE_PROJECT_INACTIVE)
    {
#line 661 "bseproject.proc"
      
      project_push_undo_silent_deactivate (self);
    }

  g_value_set_enum (out_values++, error);

  return BSE_ERROR_NONE;
}

/* --- deactivate --- */
static void
deactivate_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 670 "bseproject.proc"
 {
#line 672 "bseproject.proc"
  *(in_pspecs++)    = bse_param_spec_object ("project", "Project", "The project",
                                 BSE_TYPE_PROJECT, SFI_PARAM_DEFAULT);
#line 671 "bseproject.proc"
  proc->help = "Deactivate the project, automatically stop playback.";
#line 30 "bseproject.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 31 "bseproject.proc"
  proc->copyright = "Copyright (C) 2001-2002 Tim Janik";
#line 674 "bseproject.proc"
}  }
static BseErrorType
#line 674 "bseproject.proc"
deactivate_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 677 "bseproject.proc"
{
#line 678 "bseproject.proc"
  
  BseProject *self = bse_value_get_object (in_values++);

#line 681 "bseproject.proc"
  
  if (!BSE_IS_PROJECT (self))
    return BSE_ERROR_PROC_PARAM_INVAL;

  bse_project_deactivate (self);

  return BSE_ERROR_NONE;
}

/* --- stop-playback --- */
static void
stop_playback_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 690 "bseproject.proc"
 {
#line 692 "bseproject.proc"
  *(in_pspecs++)    = bse_param_spec_object ("project", "Project", "The project",
                                 BSE_TYPE_PROJECT, SFI_PARAM_DEFAULT);
#line 691 "bseproject.proc"
  proc->help = "Stop project playback.";
#line 30 "bseproject.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 31 "bseproject.proc"
  proc->copyright = "Copyright (C) 2001-2002 Tim Janik";
#line 694 "bseproject.proc"
}  }
static BseErrorType
#line 694 "bseproject.proc"
stop_playback_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 697 "bseproject.proc"
{
#line 698 "bseproject.proc"
  
  BseProject *self = bse_value_get_object (in_values++);

#line 701 "bseproject.proc"
  
  if (!BSE_IS_PROJECT (self))
    return BSE_ERROR_PROC_PARAM_INVAL;

  bse_project_stop_playback (self);

  return BSE_ERROR_NONE;
}

/* --- stop --- */
static void
stop_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 710 "bseproject.proc"
 {
#line 712 "bseproject.proc"
  *(in_pspecs++)    = bse_param_spec_object ("project", "Project", "The project",
                                 BSE_TYPE_PROJECT, SFI_PARAM_DEFAULT);
#line 711 "bseproject.proc"
  proc->help = "Stop project playback and deactivate project.";
#line 30 "bseproject.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 31 "bseproject.proc"
  proc->copyright = "Copyright (C) 2001-2002 Tim Janik";
#line 714 "bseproject.proc"
}  }
static BseErrorType
#line 714 "bseproject.proc"
stop_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 717 "bseproject.proc"
{
#line 718 "bseproject.proc"
  
  BseProject *self = bse_value_get_object (in_values++);

#line 721 "bseproject.proc"
  
  if (!BSE_IS_PROJECT (self))
    return BSE_ERROR_PROC_PARAM_INVAL;

  bse_project_deactivate (self);

  return BSE_ERROR_NONE;
}

/* --- auto-deactivate --- */
static void
auto_deactivate_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 730 "bseproject.proc"
 {
#line 732 "bseproject.proc"
  *(in_pspecs++)    = bse_param_spec_object ("project", NULL, "The project",
                                 BSE_TYPE_PROJECT, SFI_PARAM_DEFAULT);
  *(in_pspecs++)    = sfi_pspec_int ("msec_delay", NULL, "Delay for deactivation in milliseconds",
                         0, -1, G_MAXINT, 1000, SFI_PARAM_DEFAULT);
#line 731 "bseproject.proc"
  proc->help = "Automatically deactivate a project once playback stopped.";
#line 30 "bseproject.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 31 "bseproject.proc"
  proc->copyright = "Copyright (C) 2001-2002 Tim Janik";
#line 736 "bseproject.proc"
}  }
static BseErrorType
#line 736 "bseproject.proc"
auto_deactivate_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 739 "bseproject.proc"
{
#line 740 "bseproject.proc"
  
  BseProject *self  = bse_value_get_object (in_values++);
  gint64      msecs = sfi_value_get_int (in_values++);

#line 744 "bseproject.proc"
  
  if (!BSE_IS_PROJECT (self))
    return BSE_ERROR_PROC_PARAM_INVAL;

  self->deactivate_usecs = msecs < 0 ? -1 : msecs * 1000;

  return BSE_ERROR_NONE;
}

/* --- undo-depth --- */
static void
undo_depth_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 753 "bseproject.proc"
 {
#line 755 "bseproject.proc"
  *(in_pspecs++)    = bse_param_spec_object ("project", "Project", "The project",
                                 BSE_TYPE_PROJECT, SFI_PARAM_DEFAULT);
  *(out_pspecs++)   = sfi_pspec_int ("undo_depth", NULL, "Number of times undo can be called on the project",
                         0, 0, G_MAXINT, 1, SFI_PARAM_DEFAULT);
#line 754 "bseproject.proc"
  proc->help = "Check whether a project can perform undo steps";
#line 30 "bseproject.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 31 "bseproject.proc"
  proc->copyright = "Copyright (C) 2001-2002 Tim Janik";
#line 759 "bseproject.proc"
}  }
static BseErrorType
#line 759 "bseproject.proc"
undo_depth_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 762 "bseproject.proc"
{
#line 763 "bseproject.proc"
  
  BseProject *project = bse_value_get_object (in_values++);
  
#line 766 "bseproject.proc"
  
  if (!BSE_IS_PROJECT (project))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 770 "bseproject.proc"
  
  sfi_value_set_int (out_values++, bse_undo_stack_depth (project->undo_stack));

  return BSE_ERROR_NONE;
}

/* --- undo --- */
static void
undo_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 776 "bseproject.proc"
 {
#line 778 "bseproject.proc"
  *(in_pspecs++)    = bse_param_spec_object ("project", "Project", "The project",
                                 BSE_TYPE_PROJECT, SFI_PARAM_DEFAULT);
#line 777 "bseproject.proc"
  proc->help = "Undo a previous operation in a project";
#line 30 "bseproject.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 31 "bseproject.proc"
  proc->copyright = "Copyright (C) 2001-2002 Tim Janik";
#line 780 "bseproject.proc"
}  }
static BseErrorType
#line 780 "bseproject.proc"
undo_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 783 "bseproject.proc"
{
#line 784 "bseproject.proc"
  
  BseProject *project = bse_value_get_object (in_values++);

#line 787 "bseproject.proc"
  
  if (!BSE_IS_PROJECT (project))
    return BSE_ERROR_PROC_PARAM_INVAL;

#line 791 "bseproject.proc"
  
  if (!project->in_undo && !project->in_redo)
    {
      const gchar *name = bse_undo_stack_peek (project->undo_stack);
      if (name)
        {
          project->in_undo = TRUE;
          bse_undo_group_open (project->redo_stack, name);
          bse_undo_stack_undo (project->undo_stack);
          bse_undo_group_close (project->redo_stack);
          project->in_undo = FALSE;
        }
    }

  return BSE_ERROR_NONE;
}

/* --- redo-depth --- */
static void
redo_depth_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 808 "bseproject.proc"
 {
#line 810 "bseproject.proc"
  *(in_pspecs++)    = bse_param_spec_object ("project", "Project", "The project",
                                 BSE_TYPE_PROJECT, SFI_PARAM_DEFAULT);
  *(out_pspecs++)   = sfi_pspec_int ("redo_depth", NULL, "Number of times redo can be called on the project",
                         0, 0, G_MAXINT, 1, SFI_PARAM_DEFAULT);
#line 809 "bseproject.proc"
  proc->help = "Check whether a project can perform redo steps";
#line 30 "bseproject.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 31 "bseproject.proc"
  proc->copyright = "Copyright (C) 2001-2002 Tim Janik";
#line 814 "bseproject.proc"
}  }
static BseErrorType
#line 814 "bseproject.proc"
redo_depth_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 817 "bseproject.proc"
{
#line 818 "bseproject.proc"
  
  BseProject *project = bse_value_get_object (in_values++);
  
#line 821 "bseproject.proc"
  
  if (!BSE_IS_PROJECT (project))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 825 "bseproject.proc"
  
  sfi_value_set_int (out_values++, bse_undo_stack_depth (project->redo_stack));

  return BSE_ERROR_NONE;
}

/* --- redo --- */
static void
redo_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 831 "bseproject.proc"
 {
#line 833 "bseproject.proc"
  *(in_pspecs++)    = bse_param_spec_object ("project", "Project", "The project",
                                 BSE_TYPE_PROJECT, SFI_PARAM_DEFAULT);
#line 832 "bseproject.proc"
  proc->help = "Redo a previously undone operaiton in a project";
#line 30 "bseproject.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 31 "bseproject.proc"
  proc->copyright = "Copyright (C) 2001-2002 Tim Janik";
#line 835 "bseproject.proc"
}  }
static BseErrorType
#line 835 "bseproject.proc"
redo_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 838 "bseproject.proc"
{
#line 839 "bseproject.proc"
  
  BseProject *project = bse_value_get_object (in_values++);
  
#line 842 "bseproject.proc"
  
  if (!BSE_IS_PROJECT (project))
    return BSE_ERROR_PROC_PARAM_INVAL;

#line 846 "bseproject.proc"
  
  if (!project->in_undo && !project->in_redo)
    {
      const gchar *name = bse_undo_stack_peek (project->redo_stack);
      if (name)
        {
          project->in_redo = TRUE;
          bse_undo_group_open (project->undo_stack, name);
          bse_undo_stack_undo (project->redo_stack);
          bse_undo_group_close (project->undo_stack);
          project->in_redo = FALSE;
        }
    }

  return BSE_ERROR_NONE;
}

/* --- clear-undo --- */
static void
clear_undo_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 863 "bseproject.proc"
 {
#line 865 "bseproject.proc"
  *(in_pspecs++)    = bse_param_spec_object ("project", "Project", NULL,
                                 BSE_TYPE_PROJECT, SFI_PARAM_DEFAULT);
#line 864 "bseproject.proc"
  proc->help = "Delete all recorded undo or redo steps.";
#line 30 "bseproject.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 31 "bseproject.proc"
  proc->copyright = "Copyright (C) 2001-2002 Tim Janik";
#line 867 "bseproject.proc"
}  }
static BseErrorType
#line 867 "bseproject.proc"
clear_undo_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 870 "bseproject.proc"
{
#line 871 "bseproject.proc"
  
  BseProject *project = bse_value_get_object (in_values++);
  
#line 874 "bseproject.proc"
  
  if (!BSE_IS_PROJECT (project))
    return BSE_ERROR_PROC_PARAM_INVAL;

#line 878 "bseproject.proc"
  
  if (!project->in_undo && !project->in_redo)
    {
      bse_undo_stack_clear (project->undo_stack);
      bse_undo_stack_clear (project->redo_stack);
      g_object_notify (project, "dirty");
    }

  return BSE_ERROR_NONE;
}

/* --- Export to BSE --- */
static BseExportNodeProc __enode_is_playing = {
  { NULL, BSE_EXPORT_NODE_PROC,
    "BseProject+is-playing", "/Methods/BseProject/General/Is Playing", NULL },
  0, is_playing_setup, is_playing_exec, 
};
static BseExportNodeProc __enode_is_active = {
  { (BseExportNode*) &__enode_is_playing, BSE_EXPORT_NODE_PROC,
    "BseProject+is-active", "/Methods/BseProject/General/Is Active", NULL },
  0, is_active_setup, is_active_exec, 
};
static BseExportNodeProc __enode_restore_from_file = {
  { (BseExportNode*) &__enode_is_active, BSE_EXPORT_NODE_PROC,
    "BseProject+restore-from-file", "/Methods/BseProject/File/Restore", NULL },
  0, restore_from_file_setup, restore_from_file_exec, 
};
static BseExportNodeProc __enode_store_bse = {
  { (BseExportNode*) &__enode_restore_from_file, BSE_EXPORT_NODE_PROC,
    "BseProject+store-bse", "/Methods/BseProject/File/Store", NULL },
  0, store_bse_setup, store_bse_exec, 
};
static BseExportNodeProc __enode_create_song = {
  { (BseExportNode*) &__enode_store_bse, BSE_EXPORT_NODE_PROC,
    "BseProject+create-song", "/Methods/BseProject/General/Create Song", "Create a song for this project." },
  0, create_song_setup, create_song_exec, 
};
static BseExportNodeProc __enode_get_wave_repo = {
  { (BseExportNode*) &__enode_create_song, BSE_EXPORT_NODE_PROC,
    "BseProject+get-wave-repo", "/Methods/BseProject/General/Get Wave Repo", NULL },
  0, get_wave_repo_setup, get_wave_repo_exec, 
};
static BseExportNodeProc __enode_get_data_pocket = {
  { (BseExportNode*) &__enode_get_wave_repo, BSE_EXPORT_NODE_PROC,
    "BseProject+get-data-pocket", "/Methods/BseProject/General/Get Data Pocket", NULL },
  0, get_data_pocket_setup, get_data_pocket_exec, 
};
static BseExportNodeProc __enode_create_csynth = {
  { (BseExportNode*) &__enode_get_data_pocket, BSE_EXPORT_NODE_PROC,
    "BseProject+create-csynth", "/Methods/BseProject/General/Create Csynth", "Create a synthsizer network for this project." },
  0, create_csynth_setup, create_csynth_exec, 
};
static BseExportNodeProc __enode_create_midi_synth = {
  { (BseExportNode*) &__enode_create_csynth, BSE_EXPORT_NODE_PROC,
    "BseProject+create-midi-synth", "/Methods/BseProject/General/Create Midi Synth", "Create a MIDI synthesizer network for this project." },
  0, create_midi_synth_setup, create_midi_synth_exec, 
};
static BseExportNodeProc __enode_remove_snet = {
  { (BseExportNode*) &__enode_create_midi_synth, BSE_EXPORT_NODE_PROC,
    "BseProject+remove-snet", "/Methods/BseProject/General/Remove Snet", "Remove an existing synthesizer network from this project." },
  0, remove_snet_setup, remove_snet_exec, 
};
static BseExportNodeProc __enode_list_uname_paths = {
  { (BseExportNode*) &__enode_remove_snet, BSE_EXPORT_NODE_PROC,
    "BseProject+list-uname-paths", "/Methods/BseProject/General/List Uname Paths", NULL },
  0, list_uname_paths_setup, list_uname_paths_exec, 
};
static BseExportNodeProc __enode_find_item = {
  { (BseExportNode*) &__enode_list_uname_paths, BSE_EXPORT_NODE_PROC,
    "BseProject+find-item", "/Methods/BseProject/General/Find Item", NULL },
  0, find_item_setup, find_item_exec, 
};
static BseExportNodeProc __enode_match_items_by_uname = {
  { (BseExportNode*) &__enode_find_item, BSE_EXPORT_NODE_PROC,
    "BseProject+match-items-by-uname", "/Methods/BseProject/General/Match Items By Uname", NULL },
  0, match_items_by_uname_setup, match_items_by_uname_exec, 
};
static BseExportNodeProc __enode_get_supers = {
  { (BseExportNode*) &__enode_match_items_by_uname, BSE_EXPORT_NODE_PROC,
    "BseProject+get-supers", "/Methods/BseProject/General/Get Supers", NULL },
  0, get_supers_setup, get_supers_exec, 
};
static BseExportNodeProc __enode_can_play = {
  { (BseExportNode*) &__enode_get_supers, BSE_EXPORT_NODE_PROC,
    "BseProject+can-play", "/Methods/BseProject/General/Can Play", NULL },
  0, can_play_setup, can_play_exec, 
};
static BseExportNodeProc __enode_get_state = {
  { (BseExportNode*) &__enode_can_play, BSE_EXPORT_NODE_PROC,
    "BseProject+get-state", "/Methods/BseProject/General/Get State", NULL },
  0, get_state_setup, get_state_exec, 
};
static BseExportNodeProc __enode_activate = {
  { (BseExportNode*) &__enode_get_state, BSE_EXPORT_NODE_PROC,
    "BseProject+activate", "/Methods/BseProject/General/Activate", NULL },
  0, activate_setup, activate_exec, 
};
static BseExportNodeProc __enode_start_playback = {
  { (BseExportNode*) &__enode_activate, BSE_EXPORT_NODE_PROC,
    "BseProject+start-playback", "/Methods/BseProject/General/Start Playback", NULL },
  0, start_playback_setup, start_playback_exec, 
};
static BseExportNodeProc __enode_play = {
  { (BseExportNode*) &__enode_start_playback, BSE_EXPORT_NODE_PROC,
    "BseProject+play", "/Methods/BseProject/General/Play", NULL },
  0, play_setup, play_exec, 
};
static BseExportNodeProc __enode_deactivate = {
  { (BseExportNode*) &__enode_play, BSE_EXPORT_NODE_PROC,
    "BseProject+deactivate", "/Methods/BseProject/General/Deactivate", NULL },
  0, deactivate_setup, deactivate_exec, 
};
static BseExportNodeProc __enode_stop_playback = {
  { (BseExportNode*) &__enode_deactivate, BSE_EXPORT_NODE_PROC,
    "BseProject+stop-playback", "/Methods/BseProject/General/Stop Playback", NULL },
  0, stop_playback_setup, stop_playback_exec, 
};
static BseExportNodeProc __enode_stop = {
  { (BseExportNode*) &__enode_stop_playback, BSE_EXPORT_NODE_PROC,
    "BseProject+stop", "/Methods/BseProject/General/Stop", NULL },
  0, stop_setup, stop_exec, 
};
static BseExportNodeProc __enode_auto_deactivate = {
  { (BseExportNode*) &__enode_stop, BSE_EXPORT_NODE_PROC,
    "BseProject+auto-deactivate", "/Methods/BseProject/General/Auto Deactivate", NULL },
  0, auto_deactivate_setup, auto_deactivate_exec, 
};
static BseExportNodeProc __enode_undo_depth = {
  { (BseExportNode*) &__enode_auto_deactivate, BSE_EXPORT_NODE_PROC,
    "BseProject+undo-depth", "/Methods/BseProject/General/Undo Depth", NULL },
  0, undo_depth_setup, undo_depth_exec, 
};
static BseExportNodeProc __enode_undo = {
  { (BseExportNode*) &__enode_undo_depth, BSE_EXPORT_NODE_PROC,
    "BseProject+undo", "/Methods/BseProject/General/Undo", NULL },
  0, undo_setup, undo_exec, 
};
static BseExportNodeProc __enode_redo_depth = {
  { (BseExportNode*) &__enode_undo, BSE_EXPORT_NODE_PROC,
    "BseProject+redo-depth", "/Methods/BseProject/General/Redo Depth", NULL },
  0, redo_depth_setup, redo_depth_exec, 
};
static BseExportNodeProc __enode_redo = {
  { (BseExportNode*) &__enode_redo_depth, BSE_EXPORT_NODE_PROC,
    "BseProject+redo", "/Methods/BseProject/General/Redo", NULL },
  0, redo_setup, redo_exec, 
};
static BseExportNodeProc __enode_clear_undo = {
  { (BseExportNode*) &__enode_redo, BSE_EXPORT_NODE_PROC,
    "BseProject+clear-undo", "/Methods/BseProject/General/Clear Undo", NULL },
  0, clear_undo_setup, clear_undo_exec, 
};
BseExportNode* bse__builtin_init_bseproject_gen_proc_c (void);
BseExportNode* bse__builtin_init_bseproject_gen_proc_c (void)
{
  return (BseExportNode*) &__enode_clear_undo;
}

/**
 ** Generated data ends here
 **/
