/* CSL - Common Sound Layer
 * Copyright (C) 2000-2001 Stefan Westerfeld and Tim Janik
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General
 * Public License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef CSL_PLAYSAMPLE_IMPL_H
#define CSL_PLAYSAMPLE_IMPL_H

#include "cslarts.h"
#include "stdsynthmodule.h"
#include "resample.h"
#include "pipebuffer.h"
#include "artsflow.h"

namespace CSL {

class Adapter_impl;

class PlaySample_impl : virtual public PlaySample_skel
{
protected:
	long _ID;
	Adapter_impl *adapter;
	Arts::Synth_PLAY_WAV wav;
	Arts::Synth_AMAN_PLAY play;

	PlaySample self() { return PlaySample::_from_base(_copy()); }

public:
	PlaySample_impl(Adapter_impl *adapter, const std::string& filename,
					const std::string& role, const std::string& title, long ID);

	long ID() { return _ID; }
	void finished(bool f);
	bool finished();
};

};
#endif /* CSL_PLAYSAMPLE_IMPL_H */
