#ifndef GTOOLKIT_GTKWIDGET_H
#define GTOOLKIT_GTKWIDGET_H

#include <GToolKit/GTKObject.h>
#include <gtk/gtkwidget.h>

@interface GTKWidget : GTKObject
+ (GtkType) getType;
+ widgetvWithType:(guint) type nargs:(guint) nargs args:(GtkArg *) args;
- initvWithType:(guint) type nargs:(guint) nargs args:(GtkArg *) args;
- (void) ref;
- (void) unref;
- (void) destroy;
- (void) destroyed:(GTKWidget **) widget_pointer;
- (void) get:(GtkArg *) arg;
- (void) getv:(guint) nargs args:(GtkArg *) args;
- (void) setv:(guint) nargs args:(GtkArg *) args;
- (void) unparent;
- (void) show;
- (void) showNow;
- (void) hide;
- (void) showAll;
- (void) hideAll;
- (void) map;
- (void) unmap;
- (void) realize;
- (void) unrealize;
- (void) queueDraw;
- (void) queueResize;
- (void) draw:(GdkRectangle *) area;
- (void) drawFocus;
- (void) drawDefault;
- (void) drawChildren;
- (void) sizeRequest:(GtkRequisition *) requisition;
- (void) sizeAllocate:(GtkAllocation *) allocation;
- (void) installAccelerator:(GTKAcceleratorTable *) table signalName:(const NSString *) signal_name key:(gchar) key modifiers:(guint8) modifiers;
- (void) removeAccelerator:(GTKAcceleratorTable *) table signalName:(const NSString *) signal_name;
- (gint) event:(GdkEvent *) event;
- (void) activate;
- (void) reparent:(GTKWidget *) new_parent;
- (void) popup:(gint) x y:(gint) y;
- (gint) intersect:(GdkRectangle *) area intersection:(GdkRectangle *) intersection;
- (gint) basic;
- (void) grabFocus;
- (void) grabDefault;
- (void) setName:(const NSString *) name;
- (NSString *) getName;
- (void) setState:(GtkStateType) state;
- (void) setSensitive:(gint) sensitive;
- (void) setParent:(GTKWidget *) parent;
- (void) setParentWindow:(GdkWindow *) parent_window;
- (GdkWindow *) getParentWindow;
- (void) setUposition:(gint) x y:(gint) y;
- (void) setUsize:(gint) width height:(gint) height;
- (void) setEvents:(gint) events;
- (void) setExtensionEvents:(GdkExtensionMode	) mode;
- (GdkExtensionMode) getExtensionEvents;
- (GTKWidget*) getToplevel;
- (GTKWidget*) getAncestor:(GtkType	) widget_type;
- (GdkColormap*) getColormap;
- (GdkVisual*) getVisual;
- (gint) getEvents;
- (void) getPointer:(gint *) x y:(gint *) y;
- (gint) isAncestor:(GTKWidget	*) ancestor;
- (gint) isChild:(GTKWidget	*) child;
- (gint) hideOnDelete;
- (void) setStyle:(GTKStyle	*) style;
- (void) setRcStyle;
- (void) ensureStyle;
- (GTKStyle*) getStyle;
- (void) restoreDefaultStyle;
+ (void) propagateDefaultStyle;
+ (void) pushStyle:(GTKStyle	*) style;
+ (void) pushColormap:(GdkColormap	*) cmap;
+ (void) pushVisual:(GdkVisual	*) visual;
+ (void) popStyle;
+ (void) popColormap;
+ (void) popVisual;
+ (void) setDefaultStyle:(GTKStyle *) style;
+ (void) setDefaultColormap:(GdkColormap *) colormap;
+ (void) setDefaultVisual:(GdkVisual *) visual;
+ (GTKStyle*) getDefaultStyle;
+ (GdkColormap*) getDefaultColormap;
+ (GdkVisual*) getDefaultVisual;
- (void) shapeCombineMask:(GdkBitmap *) shape_mask offsetX:(gint) offset_x offsetY:(gint) offset_y;
- (void) dndDragAdd;
- (void) dndDragSet:(guint8) drag_enable typeAcceptList:(NSArray  *) type_accept_list numtypes:(guint) numtypes;
- (void) dndDropSet:(guint8) drop_enable typeAcceptList:(NSArray  *) type_accept_list numtypes:(guint) numtypes isDestructiveOperation:(guint8) is_destructive_operation;
- (void) dndDataSet:(GdkEvent *) event data:(gpointer) data dataNumbytes:(gulong) data_numbytes;
@end

#endif
