/*
 * Electric(tm) VLSI Design System
 *
 * File: data.c
 * global data definitions
 * Written by: Steven M. Rubin, Static Free Software
 *
 * Copyright (c) 2000 Static Free Software.
 *
 * Electric(tm) is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Electric(tm) is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Electric(tm); see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, Mass 02111-1307, USA.
 *
 * Static Free Software
 * 4119 Alpine Road
 * Portola Valley, California 94028
 * info@staticfreesoft.com
 */

#include "global.h"

/******************************* GLOBAL *******************************/

char       **el_namespace;			/* names in name space */
INTBIG       el_numnames;			/* number of names in name space */

/* some keys to commonly used variable names */
INTBIG       el_node_name;						/* variable "NODE_name" */
INTBIG       el_arc_name;						/* variable "ARC_name" */
INTBIG       el_arc_radius;						/* variable "ARC_radius" */
INTBIG       el_trace;							/* variable "trace" */
INTBIG       el_facet_message;					/* variable "FACET_message" */
INTBIG       el_schematic_page_size;			/* variable "FACET_schematic_page_size" */
INTBIG       el_transistor_width;				/* variable "transistor_width" */
INTBIG       el_prototype_center;				/* variable "prototype_center" */
INTBIG       el_node_size_default;				/* variable "NODE_size_default" */
INTBIG       el_arc_width_default;				/* variable "ARC_width_default" */

CLUSTER     *el_tempcluster;		/* cluster for temporary allocation */
CLUSTER     *db_cluster;			/* database general allocation */

INTSML       el_maxaid;				/* current number of aids */
LIBRARY     *el_curlib;				/* pointer to current library (list head) */

VIEW        *el_views;				/* list of existing view */
VIEW        *el_unknownview;		/* the unknown view */
VIEW        *el_layoutview;			/* the layout view */
VIEW        *el_schematicview;		/* the schematic view */
VIEW        *el_iconview;			/* the icon view */
VIEW        *el_simsnapview;		/* the simulation-snapshot view */
VIEW        *el_skeletonview;		/* the skeleton view */
VIEW        *el_compview;			/* the compensated view */
VIEW        *el_vhdlview;			/* the VHDL view (text) */
VIEW        *el_verilogview;		/* the Verilog view (text) */
VIEW        *el_netlistview;		/* the netlist view, generic (text) */
VIEW        *el_netlistnetlispview;	/* the netlist view, netlisp (text) */
VIEW        *el_netlistalsview;		/* the netlist view, als (text) */
VIEW        *el_netlistquiscview;	/* the netlist view, quisc (text) */
VIEW        *el_netlistrsimview;	/* the netlist view, rsim (text) */
VIEW        *el_netlistsilosview;	/* the netlist view, silos (text) */
VIEW        *el_docview;			/* the documentation view (text) */

WINDOWPART  *el_topwindowpart;		/* top window in list */
WINDOWPART  *el_curwindowpart;		/* current window partition */

WINDOWFRAME *el_firstwindowframe = NOWINDOWFRAME;
WINDOWFRAME *el_curwindowframe;

TECHNOLOGY  *el_technologies;		/* defined in "tectable.c" */
TECHNOLOGY  *el_curtech;			/* pointer to current technology */
INTSML       el_maxtech;			/* current number of technologies */

CONSTRAINT  *el_curconstraint;		/* current constraint solver */

char        *el_libdir;				/* pointer to library directory */

INTBIG       el_filetypetext;		/* Plain text disk file descriptor */

XARRAY       el_matid;				/* identity matrix */
INTSML       el_pleasestop;			/* nonzero if abort is requested */
INTBIG       el_units;				/* display and internal units */

/******************************* GRAPHICS *******************************/

INTSML       el_maplength;			/* number of entries in color map */
INTSML       el_colfacettxt;		/* color to use for facet text and port names */
INTSML       el_colfacet;			/* color to use for facet outline */
INTSML       el_colwinbor;			/* color to use for window border */
INTSML       el_colhwinbor;			/* color to use for highlighted window border */
INTSML       el_colmenbor;			/* color to use for menu border */
INTSML       el_colhmenbor;			/* color to use for highlighted menu border */
INTSML       el_colmentxt;			/* color to use for menu text */
INTSML       el_colmengly;			/* color to use for menu glyphs */
INTSML       el_colcursor;			/* color to use for cursor */
