/* This testcase is part of GDB, the GNU debugger.

   Copyright 2011-2023 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.  */

#if PTRBITS == 64
# define PTRBYTE .8byte
#elif PTRBITS == 32
# define PTRBYTE .4byte
#else
# error "Unsupported pointer size"
#endif

	.section .debug_info
.Lcu1_begin:
	/* CU header */
	.4byte	.Lcu1_end - .Lcu1_start		/* Length of Compilation Unit */
.Lcu1_start:
	.2byte	2				/* DWARF Version */
	.4byte	.Labbrev1_begin			/* Offset into abbrev section */
	.byte	PTRBITS / 8			/* Pointer size */

	/* CU die */
	.uleb128 1				/* Abbrev: DW_TAG_compile_unit */
	.ascii	"file1.txt\0"			/* DW_AT_name */
	.ascii	"GNU C 3.3.3\0"			/* DW_AT_producer */
	.byte	8				/* DW_AT_language (DW_LANG_Fortran90) */
	PTRBYTE		cu_text_start		/* DW_AT_low_pc */
	PTRBYTE		cu_text_end		/* DW_AT_high_pc */

	.uleb128	3			/* Abbrev: DW_TAG_subprogram */
	.byte		1			/* DW_AT_external */
	.ascii		"FUNC_lang\0"		/* DW_AT_name */
	PTRBYTE		FUNC_lang_start		/* DW_AT_low_pc */
	PTRBYTE		FUNC_lang_end		/* DW_AT_high_pc */
	.byte		1			/* DW_AT_prototyped */
	.4byte		.Ltype - .Lcu1_begin	/* DW_AT_type */

.Ltype:
	.uleb128 	0x5			/* Abbrev: DW_TAG_base_type */
	.byte		0x4			/* DW_AT_byte_size */
	.byte		0x5			/* DW_AT_encoding */
	.ascii 		"foo\0"			/* DW_AT_name */

	.byte		0			/* End of children of CU */
.Lcu1_end:

	/* The .debug_names-based index support depends on
	   .debug_aranges generated by GCC.  (.gdb_index includes a
	   gdb-generated map instead.)	*/
	.section	.debug_aranges,"",@progbits
	.4byte	.Laranges_end - .Laranges_start	// Length of Address Ranges Info
.Laranges_start:
	.2byte	0x2	// DWARF Version
	.4byte	.Lcu1_begin // .Ldebug_info0 - Offset of Compilation Unit Info
	.byte	PTRBITS / 8	// Size of Address
	.byte	0	// Size of Segment Descriptor
	.2byte	0	// Pad to 16 byte boundary
	.2byte	0
	PTRBYTE	cu_text_start	// Address
	PTRBYTE	0x1000 // cu_text_end - cu_text_start	// Length
	PTRBYTE	0
	PTRBYTE	0
.Laranges_end:

/* Abbrev table */
	.section .debug_abbrev
.Labbrev1_begin:
	.uleb128	1			/* Abbrev code */
	.uleb128	0x11			/* DW_TAG_compile_unit */
	.byte		1			/* has_children */
	.uleb128	0x3			/* DW_AT_name */
	.uleb128	0x8			/* DW_FORM_string */
	.uleb128	0x25			/* DW_AT_producer */
	.uleb128	0x8			/* DW_FORM_string */
	.uleb128	0x13			/* DW_AT_language */
	.uleb128	0xb			/* DW_FORM_data1 */
	.uleb128	0x11			/* DW_AT_low_pc */
	.uleb128	0x1			/* DW_FORM_addr */
	.uleb128	0x12			/* DW_AT_high_pc */
	.uleb128	0x1			/* DW_FORM_addr */
	.byte		0x0			/* Terminator */
	.byte		0x0			/* Terminator */

	.uleb128	3			/* Abbrev code */
	.uleb128	0x2e			/* DW_TAG_subprogram */
	.byte		0			/* has_children */
	.uleb128	0x3f			/* DW_AT_external */
	.uleb128	0xc			/* DW_FORM_flag */
	.uleb128	0x3			/* DW_AT_name */
	.uleb128	0x8			/* DW_FORM_string */
	.uleb128	0x11			/* DW_AT_low_pc */
	.uleb128	0x1			/* DW_FORM_addr */
	.uleb128	0x12			/* DW_AT_high_pc */
	.uleb128	0x1			/* DW_FORM_addr */
	.uleb128	0x27			/* DW_AT_prototyped */
	.uleb128	0xc			/* DW_FORM_flag */
	.uleb128	0x49			/* DW_AT_type */
	.uleb128	0x13			/* DW_FORM_ref4 */
	.byte		0x0			/* Terminator */
	.byte		0x0			/* Terminator */

	.uleb128	0x5			/* Abbrev code */
	.uleb128	0x24			/* DW_TAG_base_type */
	.byte		0x0			/* DW_children_no */
	.uleb128	0xb			/* DW_AT_byte_size */
	.uleb128	0xb			/* DW_FORM_data1 */
	.uleb128	0x3e			/* DW_AT_encoding */
	.uleb128	0xb			/* DW_FORM_data1 */
	.uleb128	0x3			/* DW_AT_name */
	.uleb128	0x8			/* DW_FORM_string */
	.byte		0x0			/* Terminator */
	.byte		0x0			/* Terminator */

	.byte		0x0			/* Terminator */
	.byte		0x0			/* Terminator */
	.section	.note.GNU-stack,"",@progbits
