// +build !manifestcodegen
// Code generated by "menifestcodegen". DO NOT EDIT.
// To reproduce: go run github.com/9elements/converged-security-suite/v2/pkg/intel/metadata/manifest/common/manifestcodegen/cmd/manifestcodegen github.com/9elements/converged-security-suite/v2/pkg/intel/metadata/manifest/key

package key

import (
	"encoding/binary"
	"fmt"
	"io"
	"strings"

	"github.com/9elements/converged-security-suite/v2/pkg/intel/metadata/manifest"
	"github.com/9elements/converged-security-suite/v2/pkg/intel/metadata/manifest/common/pretty"
)

var (
	// Just to avoid errors in "import" above in case if it wasn't used below
	_ = binary.LittleEndian
	_ = (fmt.Stringer)(nil)
	_ = (io.Reader)(nil)
	_ = pretty.Header
	_ = strings.Join
	_ = manifest.StructInfo{}
)

// NewHash returns a new instance of Hash with
// all default values set.
func NewHash() *Hash {
	s := &Hash{}
	// Recursively initializing a child structure:
	s.Digest = *manifest.NewHashStructure()
	s.Rehash()
	return s
}

// Validate (recursively) checks the structure if there are any unexpected
// values. It returns an error if so.
func (s *Hash) Validate() error {
	// Recursively validating a child structure:
	if err := s.Digest.Validate(); err != nil {
		return fmt.Errorf("error on field 'Digest': %w", err)
	}

	return nil
}

// ReadFrom reads the Hash from 'r' in format defined in the document #575623.
func (s *Hash) ReadFrom(r io.Reader) (int64, error) {
	totalN := int64(0)

	// Usage (ManifestFieldType: endValue)
	{
		n, err := 8, binary.Read(r, binary.LittleEndian, &s.Usage)
		if err != nil {
			return totalN, fmt.Errorf("unable to read field 'Usage': %w", err)
		}
		totalN += int64(n)
	}

	// Digest (ManifestFieldType: subStruct)
	{
		n, err := s.Digest.ReadFrom(r)
		if err != nil {
			return totalN, fmt.Errorf("unable to read field 'Digest': %w", err)
		}
		totalN += int64(n)
	}

	return totalN, nil
}

// RehashRecursive calls Rehash (see below) recursively.
func (s *Hash) RehashRecursive() {
	s.Digest.Rehash()
	s.Rehash()
}

// Rehash sets values which are calculated automatically depending on the rest
// data. It is usually about the total size field of an element.
func (s *Hash) Rehash() {
}

// WriteTo writes the Hash into 'w' in format defined in
// the document #575623.
func (s *Hash) WriteTo(w io.Writer) (int64, error) {
	totalN := int64(0)
	s.Rehash()

	// Usage (ManifestFieldType: endValue)
	{
		n, err := 8, binary.Write(w, binary.LittleEndian, &s.Usage)
		if err != nil {
			return totalN, fmt.Errorf("unable to write field 'Usage': %w", err)
		}
		totalN += int64(n)
	}

	// Digest (ManifestFieldType: subStruct)
	{
		n, err := s.Digest.WriteTo(w)
		if err != nil {
			return totalN, fmt.Errorf("unable to write field 'Digest': %w", err)
		}
		totalN += int64(n)
	}

	return totalN, nil
}

// UsageSize returns the size in bytes of the value of field Usage
func (s *Hash) UsageTotalSize() uint64 {
	return 8
}

// DigestSize returns the size in bytes of the value of field Digest
func (s *Hash) DigestTotalSize() uint64 {
	return s.Digest.TotalSize()
}

// UsageOffset returns the offset in bytes of field Usage
func (s *Hash) UsageOffset() uint64 {
	return 0
}

// DigestOffset returns the offset in bytes of field Digest
func (s *Hash) DigestOffset() uint64 {
	return s.UsageOffset() + s.UsageTotalSize()
}

// Size returns the total size of the Hash.
func (s *Hash) TotalSize() uint64 {
	if s == nil {
		return 0
	}

	var size uint64
	size += s.UsageTotalSize()
	size += s.DigestTotalSize()
	return size
}

// PrettyString returns the content of the structure in an easy-to-read format.
func (s *Hash) PrettyString(depth uint, withHeader bool, opts ...pretty.Option) string {
	var lines []string
	if withHeader {
		lines = append(lines, pretty.Header(depth, "Hash", s))
	}
	if s == nil {
		return strings.Join(lines, "\n")
	}
	// ManifestFieldType is endValue
	lines = append(lines, pretty.SubValue(depth+1, "Usage", "", &s.Usage, opts...)...)
	// ManifestFieldType is subStruct
	lines = append(lines, pretty.SubValue(depth+1, "Digest", "", &s.Digest, opts...)...)
	if depth < 2 {
		lines = append(lines, "")
	}
	return strings.Join(lines, "\n")
}

// PrettyString returns the bits of the flags in an easy-to-read format.
func (v Usage) PrettyString(depth uint, withHeader bool, opts ...pretty.Option) string {
	return v.String()
}

// TotalSize returns the total size measured through binary.Size.
func (v Usage) TotalSize() uint64 {
	return uint64(binary.Size(v))
}

// WriteTo writes the Usage into 'w' in binary format.
func (v Usage) WriteTo(w io.Writer) (int64, error) {
	return int64(v.TotalSize()), binary.Write(w, binary.LittleEndian, v)
}

// ReadFrom reads the Usage from 'r' in binary format.
func (v Usage) ReadFrom(r io.Reader) (int64, error) {
	return int64(v.TotalSize()), binary.Read(r, binary.LittleEndian, v)
}
