/** @file

Copyright (c) 2021, Intel Corporation. All rights reserved.<BR>

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice, this
  list of conditions and the following disclaimer.
* Redistributions in binary form must reproduce the above copyright notice, this
  list of conditions and the following disclaimer in the documentation and/or
  other materials provided with the distribution.
* Neither the name of Intel Corporation nor the names of its contributors may
  be used to endorse or promote products derived from this software without
  specific prior written permission.

  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
  AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
  ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
  LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
  CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
  SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
  INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
  CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
  THE POSSIBILITY OF SUCH DAMAGE.

  This file is automatically generated. Please do NOT modify !!!

**/

#ifndef __FSPMUPD_H__
#define __FSPMUPD_H__

#include <FspUpd.h>

#pragma pack(1)


#include <MemInfoHob.h>

///
/// The ChipsetInit Info structure provides the information of ME ChipsetInit CRC and BIOS ChipsetInit CRC.
///
typedef struct {
  UINT8             Revision;         ///< Chipset Init Info Revision
  UINT8             Rsvd[3];          ///< Reserved
  UINT16            MeChipInitCrc;    ///< 16 bit CRC value of MeChipInit Table
  UINT16            BiosChipInitCrc;  ///< 16 bit CRC value of PchChipInit Table
} CHIPSET_INIT_INFO;


/** Fsp M Configuration
**/
typedef struct {

/** Offset 0x0040 - Platform Reserved Memory Size
  The minimum platform memory size required to pass control into DXE
**/
  UINT64                      PlatformMemorySize;

/** Offset 0x0048 - SPD Data Length
  Length of SPD Data
  0x100:256 Bytes, 0x200:512 Bytes
**/
  UINT16                      MemorySpdDataLen;

/** Offset 0x004A - Enable above 4GB MMIO resource support
  Enable/disable above 4GB MMIO resource support
  $EN_DIS
**/
  UINT8                       EnableAbove4GBMmio;

/** Offset 0x004B - Enable/Disable CrashLog Device 10
  Enable(Default): Enable CPU CrashLog Device 10, Disable: Disable CPU CrashLog
  $EN_DIS
**/
  UINT8                       CpuCrashLogDevice;

/** Offset 0x004C - Memory SPD Pointer Channel 0 Dimm 0
  Pointer to SPD data, will be used only when SpdAddressTable SPD Address are marked as 00
**/
  UINT32                      MemorySpdPtr00;

/** Offset 0x0050 - Memory SPD Pointer Channel 0 Dimm 1
  Pointer to SPD data, will be used only when SpdAddressTable SPD Address are marked as 00
**/
  UINT32                      MemorySpdPtr01;

/** Offset 0x0054 - Memory SPD Pointer Channel 1 Dimm 0
  Pointer to SPD data, will be used only when SpdAddressTable SPD Address are marked as 00
**/
  UINT32                      MemorySpdPtr10;

/** Offset 0x0058 - Memory SPD Pointer Channel 1 Dimm 1
  Pointer to SPD data, will be used only when SpdAddressTable SPD Address are marked as 00
**/
  UINT32                      MemorySpdPtr11;

/** Offset 0x005C - Dq Byte Map CH0
  Dq byte mapping between CPU and DRAM, Channel 0: board-dependent
**/
  UINT8                       DqByteMapCh0[12];

/** Offset 0x0068 - Dq Byte Map CH1
  Dq byte mapping between CPU and DRAM, Channel 1: board-dependent
**/
  UINT8                       DqByteMapCh1[12];

/** Offset 0x0074 - Dqs Map CPU to DRAM CH 0
  Set Dqs mapping relationship between CPU and DRAM, Channel 0: board-dependent
**/
  UINT8                       DqsMapCpu2DramCh0[8];

/** Offset 0x007C - Dqs Map CPU to DRAM CH 1
  Set Dqs mapping relationship between CPU and DRAM, Channel 1: board-dependent
**/
  UINT8                       DqsMapCpu2DramCh1[8];

/** Offset 0x0084 - RcompResister settings
  Indicates  RcompReister settings: Board-dependent
**/
  UINT16                      RcompResistor[3];

/** Offset 0x008A - RcompTarget settings
  RcompTarget settings: board-dependent
**/
  UINT16                      RcompTarget[5];

/** Offset 0x0094 - VREF_CA
  CA Vref routing: board-dependent
  0:VREF_CA goes to both CH_A and CH_B, 1: VREF_CA to CH_A and VREF_DQ_A to CH_B,
  2:VREF_CA to CH_A and VREF_DQ_B to CH_B
**/
  UINT8                       CaVrefConfig;

/** Offset 0x0095 - Smram Mask
  The SMM Regions AB-SEG and/or H-SEG reserved
  0: Neither, 1:AB-SEG, 2:H-SEG, 3: Both
**/
  UINT8                       SmramMask;

/** Offset 0x0096 - Dqs Pins Interleaved Setting
  Indicates DqPinsInterleaved setting: board-dependent
  $EN_DIS
**/
  UINT8                       DqPinsInterleaved;

/** Offset 0x0097 - LPDDR4 Write DQ/DQS Retraining
  Enables/Disable LPDDR4 Write DQ/DQS Retraining
  $EN_DIS
**/
  UINT8                       Lp4DqsOscEn;

/** Offset 0x0098 - Ibecc
  Enables/Disable Ibecc
  $EN_DIS
**/
  UINT8                       Ibecc;

/** Offset 0x0099 - IbeccParity
  In-Band ECC Parity Control
  $EN_DIS
**/
  UINT8                       IbeccParity;

/** Offset 0x009A - IbeccOperationMode
  In-Band ECC Operation Mode
  0:Protect base on address range, 1: Non-protected, 2: All protected
**/
  UINT8                       IbeccOperationMode;

/** Offset 0x009B - IbeccErrorInj Note: Modification accepts the disclaimer shown in the Help text
  Disclaimer: Warning: This must NOT be enabled for production!!! Enabling Error Injection
  allows attackers who have access to the Host Operating System to inject IBECC errors
  that can cause unintended memory corruption and enable the leak of security data
  in the BIOS stolen memory regions.
  $EN_DIS
**/
  UINT8                       IbeccErrorInj;

/** Offset 0x009C - IbeccProtectedRegionEnable
  In-Band ECC Protected Region Enable
  $EN_DIS
**/
  UINT8                       IbeccProtectedRegionEnable[8];

/** Offset 0x00A4 - IbeccProtectedRegionBases
  IBECC Protected Region Bases
**/
  UINT16                      IbeccProtectedRegionBase[8];

/** Offset 0x00B4 - IbeccProtectedRegionMasks
  IBECC Protected Region Masks
**/
  UINT16                      IbeccProtectedRegionMask[8];

/** Offset 0x00C4 - MrcTaskDebugPrintEnable
  Mrc Task Debug Print Enable. 0(Default)=Disable, non-Zero=Enable Task Debug print
**/
  UINT8                       MrcTaskDebugEnable;

/** Offset 0x00C5 - Rank Margin Tool per Task
  This option enables the user to execute Rank Margin Tool per major training step
  in the MRC.
  $EN_DIS
**/
  UINT8                       RmtPerTask;

/** Offset 0x00C6 - Training Trace
  This option enables the trained state tracing feature in MRC.  This feature will
  print out the key training parameters state across major training steps.
  $EN_DIS
**/
  UINT8                       TrainTrace;

/** Offset 0x00C7
**/
  UINT8                       UnusedUpdSpace0;

/** Offset 0x00C8 - Intel Enhanced Debug
  Intel Enhanced Debug (IED): 0=Disabled, 0x400000=Enabled and 4MB SMRAM occupied
  0 : Disable, 0x400000 : Enable
**/
  UINT32                      IedSize;

/** Offset 0x00CC - Tseg Size
  Size of SMRAM memory reserved. 0x400000 for Release build and 0x1000000 for Debug build
  0x0400000:4MB, 0x01000000:16MB
**/
  UINT32                      TsegSize;

/** Offset 0x00D0 - MMIO Size
  Size of MMIO space reserved for devices. 0(Default)=Auto, non-Zero=size in MB
**/
  UINT16                      MmioSize;

/** Offset 0x00D2 - LowSupplyEnData
  Enable: Enable Low Supply for LPDDR4 Data, Disable(Default)
  $EN_DIS
**/
  UINT8                       LowSupplyEnData;

/** Offset 0x00D3 - LowSupplyEnCcc
  Enable: Enable Low Supply for LPDDR4 Clock/Command/Control, Disable(Default)
  $EN_DIS
**/
  UINT8                       LowSupplyEnCcc;

/** Offset 0x00D4 - Memory Test on Warm Boot
  Run Base Memory Test on Warm Boot
  0:Disable, 1:Enable
**/
  UINT8                       MemTestOnWarmBoot;

/** Offset 0x00D5 - Probeless Trace
  Probeless Trace: 0=Disabled, 1=Enable. Enabling Probeless Trace will reserve 128MB.
  This also requires IED to be enabled.
  $EN_DIS
**/
  UINT8                       ProbelessTrace;

/** Offset 0x00D6 - Enable SMBus
  Enable/disable SMBus controller.
  $EN_DIS
**/
  UINT8                       SmbusEnable;

/** Offset 0x00D7 - Spd Address Tabl
  Specify SPD Address table for CH0D0/CH0D1/CH1D0&CH1D1. MemorySpdPtr will be used
  if SPD Address is 00
**/
  UINT8                       SpdAddressTable[4];

/** Offset 0x00DB - Platform Debug Consent
  To 'opt-in' for debug, please select 'Enabled' with the desired debug probe type.
  Enabling this BIOS option may alter the default value of other debug-related BIOS
  options.\Manual: Do not use Platform Debug Consent to override other debug-relevant
  policies, but the user must set each debug option manually, aimed at advanced users.\n
  Note: DCI OOB (aka BSSB) uses CCA probe;[DCI OOB+DbC] and [USB2 DbC] have the same setting.
  0:Disabled, 1:Enabled (DCI OOB+[DbC]), 2:Enabled (DCI OOB), 3:Enabled (USB3 DbC),
  4:Enabled (XDP/MIPI60), 5:Enabled (USB2 DbC), 6:Enable (2-wire DCI OOB), 7:Manual
**/
  UINT8                       PlatformDebugConsent;

/** Offset 0x00DC - DCI Enable
  Determine if to enable DCI debug from host
  $EN_DIS
**/
  UINT8                       DciEn;

/** Offset 0x00DD - DCI DbC Mode
  Disabled: Clear both USB2/3DBCEN; USB2: set USB2DBCEN; USB3: set USB3DBCEN; Both:
  Set both USB2/3DBCEN; No Change: Comply with HW value
  0:Disabled, 1:USB2 DbC, 2:USB3 DbC, 3:Both, 4:No Change
**/
  UINT8                       DciDbcMode;

/** Offset 0x00DE - Enable DCI ModPHY Pwoer Gate
  Enable ModPHY Pwoer Gate when DCI is enabled
  $EN_DIS
**/
  UINT8                       DciModphyPg;

/** Offset 0x00DF - USB3 Type-C UFP2DFP Kernel/Platform Debug Support
  This BIOS option enables kernel and platform debug for USB3 interface over a UFP
  Type-C receptacle, select 'No Change' will do nothing to UFP2DFP setting.
  0:Disabled, 1:Enabled, 2:No Change
**/
  UINT8                       DciUsb3TypecUfpDbg;

/** Offset 0x00E0 - PCH Trace Hub Mode
  Select 'Host Debugger' if Trace Hub is used with host debugger tool or 'Target Debugger'
  if Trace Hub is used by target debugger software or 'Disable' trace hub functionality.
  0: Disable, 1: Target Debugger Mode, 2: Host Debugger Mode
**/
  UINT8                       PchTraceHubMode;

/** Offset 0x00E1 - PCH Trace Hub Memory Region 0 buffer Size
  Specify size of Pch trace memory region 0 buffer, the size can be 0, 1MB, 8MB, 64MB,
  128MB, 256MB, 512MB. Note : Limitation of total buffer size (PCH + CPU) is 512MB.
  0:0, 1:1MB, 2:8MB, 3:64MB, 4:128MB, 5:256MB, 6:512MB
**/
  UINT8                       PchTraceHubMemReg0Size;

/** Offset 0x00E2 - PCH Trace Hub Memory Region 1 buffer Size
  Specify size of Pch trace memory region 1 buffer, the size can be 0, 1MB, 8MB, 64MB,
  128MB, 256MB, 512MB. Note : Limitation of total buffer size (PCH + CPU) is 512MB.
  0:0, 1:1MB, 2:8MB, 3:64MB, 4:128MB, 5:256MB, 6:512MB
**/
  UINT8                       PchTraceHubMemReg1Size;

/** Offset 0x00E3 - PchPreMemRsvd
  Reserved for PCH Pre-Mem Reserved
  $EN_DIS
**/
  UINT8                       PchPreMemRsvd[7];

/** Offset 0x00EA - State of X2APIC_OPT_OUT bit in the DMAR table
  0=Disable/Clear, 1=Enable/Set
  $EN_DIS
**/
  UINT8                       X2ApicOptOut;

/** Offset 0x00EB - State of DMA_CONTROL_GUARANTEE bit in the DMAR table
  0=Disable/Clear, 1=Enable/Set
  $EN_DIS
**/
  UINT8                       DmaControlGuarantee;

/** Offset 0x00EC - Base addresses for VT-d function MMIO access
  Base addresses for VT-d MMIO access per VT-d engine
**/
  UINT32                      VtdBaseAddress[9];

/** Offset 0x0110 - Disable VT-d
  0=Enable/FALSE(VT-d enabled), 1=Disable/TRUE (VT-d disabled)
  $EN_DIS
**/
  UINT8                       VtdDisable;

/** Offset 0x0111 - Vtd Programming for Igd
  1=Enable/TRUE (Igd VT-d Bar programming enabled), 0=Disable/FLASE (Igd VT-d Bar
  programming disabled)
  $EN_DIS
**/
  UINT8                       VtdIgdEnable;

/** Offset 0x0112 - Vtd Programming for Ipu
  1=Enable/TRUE (Ipu VT-d Bar programming enabled), 0=Disable/FLASE (Ipu VT-d Bar
  programming disabled)
  $EN_DIS
**/
  UINT8                       VtdIpuEnable;

/** Offset 0x0113 - Vtd Programming for Iop
  1=Enable/TRUE (Iop VT-d Bar programming enabled), 0=Disable/FLASE (Iop VT-d Bar
  programming disabled)
  $EN_DIS
**/
  UINT8                       VtdIopEnable;

/** Offset 0x0114 - Vtd Programming for ITbt
  1=Enable/TRUE (ITbt VT-d Bar programming enabled), 0=Disable/FLASE (ITbt VT-d Bar
  programming disabled)
  $EN_DIS
**/
  UINT8                       VtdItbtEnable;

/** Offset 0x0115 - Disable Te Igd
  0=Enable/FALSE(Te Igd enabled), 1=Disable/TRUE (Te Igd disabled)
  $EN_DIS
**/
  UINT8                       DisableTeIgd;

/** Offset 0x0116 - Internal Graphics Pre-allocated Memory
  Size of memory preallocated for internal graphics.
  0x00:0MB, 0x01:32MB, 0x02:64MB, 0x03:96MB, 0x04:128MB, 0x05:160MB, 0xF0:4MB, 0xF1:8MB,
  0xF2:12MB, 0xF3:16MB, 0xF4:20MB, 0xF5:24MB, 0xF6:28MB, 0xF7:32MB, 0xF8:36MB, 0xF9:40MB,
  0xFA:44MB, 0xFB:48MB, 0xFC:52MB, 0xFD:56MB, 0xFE:60MB
**/
  UINT8                       IgdDvmt50PreAlloc;

/** Offset 0x0117 - Internal Graphics
  Enable/disable internal graphics.
  $EN_DIS
**/
  UINT8                       InternalGfx;

/** Offset 0x0118 - Aperture Size
  Select the Aperture Size.
  0:128 MB, 1:256 MB, 2:512 MB
**/
  UINT8                       ApertureSize;

/** Offset 0x0119 - Board Type
  MrcBoardType, Options are 0=Mobile/Mobile Halo, 1=Desktop/DT Halo, 5=ULT/ULX/Mobile
  Halo, 7=UP Server
  0:Mobile/Mobile Halo, 1:Desktop/DT Halo, 5:ULT/ULX/Mobile Halo, 7:UP Server
**/
  UINT8                       UserBd;

/** Offset 0x011A - DDR Frequency Limit
  Maximum Memory Frequency Selections in Mhz. Options are 1067, 1333, 1600, 1867,
  2133, 2400, 2667, 2933 and 0 for Auto.
  1067:1067, 1333:1333, 1600:1600, 1867:1867, 2133:2133, 2400:2400, 2667:2667, 2933:2933, 0:Auto
**/
  UINT16                      DdrFreqLimit;

/** Offset 0x011C - SA GV
  System Agent dynamic frequency support and when enabled memory will be training
  at three different frequencies.
  0:Disabled, 1:FixedLow, 2:FixedMid, 3:FixedHigh, 4:Enabled
**/
  UINT8                       SaGv;

/** Offset 0x011D - DDR Speed Control
  DDR Frequency and Gear control for all SAGV points.
  0:Auto, 1:Manual
**/
  UINT8                       DdrSpeedControl;

/** Offset 0x011E - Low Frequency
  SAGV Low Frequency Selections in Mhz. Options are 1067, 1333, 1600, 1867, 2133,
  2400, 2667, 2933 and 0 for Auto.
  1067:1067, 1333:1333, 1600:1600, 1867:1867, 2133:2133, 2400:2400, 2667:2667, 2933:2933, 0:Auto
**/
  UINT16                      FreqSaGvLow;

/** Offset 0x0120 - Mid Frequency
  SAGV Mid Frequency Selections in Mhz. Options are 1067, 1333, 1600, 1867, 2133,
  2400, 2667, 2933 and 0 for Auto.
  1067:1067, 1333:1333, 1600:1600, 1867:1867, 2133:2133, 2400:2400, 2667:2667, 2933:2933, 0:Auto
**/
  UINT16                      FreqSaGvMid;

/** Offset 0x0122 - Channel A DIMM Control
  Channel A DIMM Control Support - Enable or Disable Dimms on Channel A.
  0:Enable both DIMMs, 1:Disable DIMM0, 2:Disable DIMM1, 3:Disable both DIMMs
**/
  UINT8                       DisableDimmChannel0;

/** Offset 0x0123 - Channel B DIMM Control
  Channel B DIMM Control Support - Enable or Disable Dimms on Channel B.
  0:Enable both DIMMs, 1:Disable DIMM0, 2:Disable DIMM1, 3:Disable both DIMMs
**/
  UINT8                       DisableDimmChannel1;

/** Offset 0x0124 - Scrambler Support
  This option enables data scrambling in memory.
  $EN_DIS
**/
  UINT8                       ScramblerSupport;

/** Offset 0x0125 - Ddr4OneDpc
  DDR4 1DPC performance feature for 2R DIMMs. Can be enabled on DIMM0 or DIMM1 only,
  or on both (default)
  0: Disabled, 1: Enabled on DIMM0 only, 2: Enabled on DIMM1 only, 3: Enabled
**/
  UINT8                       Ddr4OneDpc;

/** Offset 0x0126
**/
  UINT8                       UnusedUpdSpace1[2];

/** Offset 0x0128 - MMA Test Content Pointer
  Pointer to MMA Test Content in Memory
**/
  UINT32                      MmaTestContentPtr;

/** Offset 0x012C - MMA Test Content Size
  Size of MMA Test Content in Memory
**/
  UINT32                      MmaTestContentSize;

/** Offset 0x0130 - MMA Test Config Pointer
  Pointer to MMA Test Config in Memory
**/
  UINT32                      MmaTestConfigPtr;

/** Offset 0x0134 - MMA Test Config Size
  Size of MMA Test Config in Memory
**/
  UINT32                      MmaTestConfigSize;

/** Offset 0x0138 - SPD Profile Selected
  Select DIMM timing profile. Options are 0=Default profile, 1=Custom profile, 2=XMP
  Profile 1, 3=XMP Profile 2
  0:Default profile, 1:Custom profile, 2:XMP profile 1, 3:XMP profile 2
**/
  UINT8                       SpdProfileSelected;

/** Offset 0x0139
**/
  UINT8                       UnusedUpdSpace2;

/** Offset 0x013A - Memory Voltage
  Memory Voltage Override (Vddq). Default = no override
  0:Default, 1200:1.20 Volts, 1250:1.25 Volts, 1300:1.30 Volts, 1350:1.35 Volts, 1400:1.40
  Volts, 1450:1.45 Volts, 1500:1.50 Volts, 1550:1.55 Volts, 1600:1.60 Volts, 1650:1.65 Volts
**/
  UINT16                      VddVoltage;

/** Offset 0x013C - Memory Reference Clock
  100MHz, 133MHz.
  0:133MHz, 1:100MHz
**/
  UINT8                       RefClk;

/** Offset 0x013D - Memory Ratio
  Automatic or the frequency will equal ratio times reference clock. Set to Auto to
  recalculate memory timings listed below.
  0:Auto, 4:4, 5:5, 6:6, 7:7, 8:8, 9:9, 10:10, 11:11, 12:12, 13:13, 14:14, 15:15
**/
  UINT8                       Ratio;

/** Offset 0x013E - tCL
  CAS Latency, 0: AUTO, max: 31
**/
  UINT8                       tCL;

/** Offset 0x013F - tCWL
  Min CAS Write Latency Delay Time, 0: AUTO, max: 34
**/
  UINT8                       tCWL;

/** Offset 0x0140 - tFAW
  Min Four Activate Window Delay Time, 0: AUTO, max: 63
**/
  UINT16                      tFAW;

/** Offset 0x0142 - tRAS
  RAS Active Time, 0: AUTO, max: 64
**/
  UINT16                      tRAS;

/** Offset 0x0144 - tRCD/tRP
  RAS to CAS delay time and Row Precharge delay time, 0: AUTO, max: 63
**/
  UINT8                       tRCDtRP;

/** Offset 0x0145
**/
  UINT8                       UnusedUpdSpace3;

/** Offset 0x0146 - tREFI
  Refresh Interval, 0: AUTO, max: 65535
**/
  UINT16                      tREFI;

/** Offset 0x0148 - tRFC
  Min Refresh Recovery Delay Time, 0: AUTO, max: 1023
**/
  UINT16                      tRFC;

/** Offset 0x014A - tRRD
  Min Row Active to Row Active Delay Time, 0: AUTO, max: 15
**/
  UINT8                       tRRD;

/** Offset 0x014B - tRTP
  Min Internal Read to Precharge Command Delay Time, 0: AUTO, max: 15. DDR4 legal
  values: 5, 6, 7, 8, 9, 10, 12
**/
  UINT8                       tRTP;

/** Offset 0x014C - tWR
  Min Write Recovery Time, 0: AUTO, legal values: 5, 6, 7, 8, 10, 12, 14, 16, 18,
  20, 24, 30, 34, 40
  0:Auto, 5:5, 6:6, 7:7, 8:8, 10:10, 12:12, 14:14, 16:16, 18:18, 20:20, 24:24, 30:30,
  34:34, 40:40
**/
  UINT8                       tWR;

/** Offset 0x014D - tWTR
  Min Internal Write to Read Command Delay Time, 0: AUTO, max: 28
**/
  UINT8                       tWTR;

/** Offset 0x014E - NMode
  System command rate, range 0-2, 0 means auto, 1 = 1N, 2 = 2N
**/
  UINT8                       NModeSupport;

/** Offset 0x014F - DllBwEn[0]
  DllBwEn[0], for 1067 (0..7)
**/
  UINT8                       DllBwEn0;

/** Offset 0x0150 - DllBwEn[1]
  DllBwEn[1], for 1333 (0..7)
**/
  UINT8                       DllBwEn1;

/** Offset 0x0151 - DllBwEn[2]
  DllBwEn[2], for 1600 (0..7)
**/
  UINT8                       DllBwEn2;

/** Offset 0x0152 - DllBwEn[3]
  DllBwEn[3], for 1867 and up (0..7)
**/
  UINT8                       DllBwEn3;

/** Offset 0x0153 - ISVT IO Port Address
  ISVT IO Port Address. 0=Minimal, 0xFF=Maximum, 0x99=Default
**/
  UINT8                       IsvtIoPort;

/** Offset 0x0154 - Enable Intel HD Audio (Azalia)
  0: Disable, 1: Enable (Default) Azalia controller
  $EN_DIS
**/
  UINT8                       PchHdaEnable;

/** Offset 0x0155 - Enable PSE Controller
  0: Disable; 1: Enable (Default) PSE controller
  $EN_DIS
**/
  UINT8                       PchPseEnable;

/** Offset 0x0156 - CPU Trace Hub Mode
  Select 'Host Debugger' if Trace Hub is used with host debugger tool or 'Target Debugger'
  if Trace Hub is used by target debugger software or 'Disable' trace hub functionality.
  0: Disable, 1:Target Debugger Mode, 2:Host Debugger Mode
**/
  UINT8                       CpuTraceHubMode;

/** Offset 0x0157 - CPU Trace Hub Memory Region 0
  CPU Trace Hub Memory Region 0, The avaliable memory size is : 0MB, 1MB, 8MB, 64MB,
  128MB, 256MB, 512MB. Note : Limitation of total buffer size (CPU + PCH) is 512MB.
  0:0, 1:1MB, 2:8MB, 3:64MB, 4:128MB, 5:256MB, 6:512MB
**/
  UINT8                       CpuTraceHubMemReg0Size;

/** Offset 0x0158 - CPU Trace Hub Memory Region 1
  CPU Trace Hub Memory Region 1. The avaliable memory size is : 0MB, 1MB, 8MB, 64MB,
  128MB, 256MB, 512MB. Note : Limitation of total buffer size (CPU + PCH) is 512MB.
  0:0, 1:1MB, 2:8MB, 3:64MB, 4:128MB, 5:256MB, 6:512MB
**/
  UINT8                       CpuTraceHubMemReg1Size;

/** Offset 0x0159 - SA GV Low Gear
  Gear Selection for SAGV Low point
  0:Gear1, 1:Gear2
**/
  UINT8                       SaGvLowGear2;

/** Offset 0x015A - SA GV Mid Gear
  Gear Selection for SAGV Mid point
  0:Gear1, 1:Gear2
**/
  UINT8                       SaGvMidGear2;

/** Offset 0x015B - SA GV High Gear
  Gear Selection for SAGV High point, or when SAGV is disabled
  0:Gear1, 1:Gear2
**/
  UINT8                       SaGvHighGear2;

/** Offset 0x015C - HECI Timeouts
  0: Disable, 1: Enable (Default) timeout check for HECI
  $EN_DIS
**/
  UINT8                       HeciTimeouts;

/** Offset 0x015D
**/
  UINT8                       UnusedUpdSpace4[3];

/** Offset 0x0160 - HECI1 BAR address
  BAR address of HECI1
**/
  UINT32                      Heci1BarAddress;

/** Offset 0x0164 - HECI2 BAR address
  BAR address of HECI2
**/
  UINT32                      Heci2BarAddress;

/** Offset 0x0168 - HECI3 BAR address
  BAR address of HECI3
**/
  UINT32                      Heci3BarAddress;

/** Offset 0x016C - HG dGPU Power Delay
  HG dGPU delay interval after power enabling: 0=Minimal, 1000=Maximum, default is
  300=300 microseconds
**/
  UINT16                      HgDelayAfterPwrEn;

/** Offset 0x016E - HG dGPU Reset Delay
  HG dGPU delay interval for Reset complete: 0=Minimal, 1000=Maximum, default is 100=100
  microseconds
**/
  UINT16                      HgDelayAfterHoldReset;

/** Offset 0x0170 - MMIO size adjustment for AUTO mode
  Positive number means increasing MMIO size, Negative value means decreasing MMIO
  size: 0 (Default)=no change to AUTO mode MMIO size
**/
  UINT16                      MmioSizeAdjustment;

/** Offset 0x0172 - PCIe ASPM programming will happen in relation to the Oprom
  Select when PCIe ASPM programming will happen in relation to the Oprom. Before(0x0)(Default):
  Do PCIe ASPM programming before Oprom, After(0x1): Do PCIe ASPM programming after
  Oprom, requires an SMI handler to save/restore ASPM settings during S3 resume
  0:Before, 1:After
**/
  UINT8                       InitPcieAspmAfterOprom;

/** Offset 0x0173 - Selection of the primary display device
  0=iGFX, 1=PEG, 2=PCIe Graphics on PCH, 3(Default)=AUTO, 4=Hybrid Graphics
  0:iGFX, 1:PEG, 2:PCIe Graphics on PCH, 3:AUTO, 4:Hybrid Graphics
**/
  UINT8                       PrimaryDisplay;

/** Offset 0x0174 - Selection of PSMI Region size
  0=32MB, 1=288MB, 2=544MB, 3=800MB, 4=1024MB Default is 0
  0:32MB, 1:288MB, 2:544MB, 3:800MB, 4:1024MB
**/
  UINT8                       PsmiRegionSize;

/** Offset 0x0175
**/
  UINT8                       UnusedUpdSpace5[3];

/** Offset 0x0178 - Temporary MMIO address for GMADR
  The reference code will use this as Temporary MMIO address space to access GMADR
  Registers.Platform should provide conflict free Temporary MMIO Range: GmAdr to
  (GmAdr + ApertureSize). Default is (PciExpressBaseAddress - ApertureSize) to (PciExpressBaseAddress
  - 0x1) (Where ApertureSize = 256MB)
**/
  UINT32                      GmAdr;

/** Offset 0x017C - Temporary MMIO address for GTTMMADR
  The reference code will use this as Temporary MMIO address space to access GTTMMADR
  Registers.Platform should provide conflict free Temporary MMIO Range: GttMmAdr
  to (GttMmAdr + 2MB MMIO + 6MB Reserved + GttSize). Default is (GmAdr - (2MB MMIO
  + 6MB Reserved + GttSize)) to (GmAdr - 0x1) (Where GttSize = 8MB)
**/
  UINT32                      GttMmAdr;

/** Offset 0x0180 - Selection of iGFX GTT Memory size
  1=2MB, 2=4MB, 3=8MB, Default is 3
  1:2MB, 2:4MB, 3:8MB
**/
  UINT16                      GttSize;

/** Offset 0x0182 - Hybrid Graphics GPIO information for PEG 0
  Hybrid Graphics GPIO information for PEG 0, for Reset, power and wake GPIOs
**/
  UINT8                       CpuPcie0Rtd3Gpio[24];

/** Offset 0x019A - Enable/Disable MRC TXT dependency
  When enabled MRC execution will wait for TXT initialization to be done first. Disabled(0x0)(Default):
  MRC will not wait for TXT initialization, Enabled(0x1): MRC will wait for TXT initialization
  $EN_DIS
**/
  UINT8                       TxtImplemented;

/** Offset 0x019B - Enable/Disable SA OcSupport
  Enable: Enable SA OcSupport, Disable(Default): Disable SA OcSupport
  $EN_DIS
**/
  UINT8                       SaOcSupport;

/** Offset 0x019C - GT slice Voltage Mode
  0(Default): Adaptive, 1: Override
  0: Adaptive, 1: Override
**/
  UINT8                       GtVoltageMode;

/** Offset 0x019D - Maximum GTs turbo ratio override
  0(Default)=Minimal/Auto, 60=Maximum
**/
  UINT8                       GtMaxOcRatio;

/** Offset 0x019E - The voltage offset applied to GT slice
  0(Default)=Minimal, 1000=Maximum
**/
  UINT16                      GtVoltageOffset;

/** Offset 0x01A0 - The GT slice voltage override which is applied to the entire range of GT frequencies
  0(Default)=Minimal, 2000=Maximum
**/
  UINT16                      GtVoltageOverride;

/** Offset 0x01A2 - adaptive voltage applied during turbo frequencies
  0(Default)=Minimal, 2000=Maximum
**/
  UINT16                      GtExtraTurboVoltage;

/** Offset 0x01A4 - voltage offset applied to the SA
  0(Default)=Minimal, 1000=Maximum
**/
  UINT16                      SaVoltageOffset;

/** Offset 0x01A6 - PCIe root port Function number for Hybrid Graphics dGPU
  Root port Index number to indicate which PCIe root port has dGPU
**/
  UINT8                       RootPortIndex;

/** Offset 0x01A7 - Realtime Memory Timing
  0(Default): Disabled, 1: Enabled. When enabled, it will allow the system to perform
  realtime memory timing changes after MRC_DONE.
  0: Disabled, 1: Enabled
**/
  UINT8                       RealtimeMemoryTiming;

/** Offset 0x01A8 - This is policy to control iTBT PCIe Multiple Segment setting.
  When Disabled all the TBT PCIe RP are located at Segment0, When Enabled all the
  TBT PCIe RP are located at Segment1. <b>0: Disable</b>; 1: Enable.
  $EN_DIS
**/
  UINT8                       PcieMultipleSegmentEnabled;

/** Offset 0x01A9 - Enable/Disable SA IPU
  Enable(Default): Enable SA IPU, Disable: Disable SA IPU
  $EN_DIS
**/
  UINT8                       SaIpuEnable;

/** Offset 0x01AA - IPU IMR Configuration
  0:IPU Camera, 1:IPU Gen Default is 0
  0:IPU Camera, 1:IPU Gen
**/
  UINT8                       SaIpuImrConfiguration;

/** Offset 0x01AB - IMGU CLKOUT Configuration
  The configuration of IMGU CLKOUT, 0: Disable;<b>1: Enable</b>.
  $EN_DIS
**/
  UINT8                       ImguClkOutEn[5];

/** Offset 0x01B0 - IPU FUSA Configuration
  0:FUSA Disable, 1:FUSA Enable Default is 0
  0:FUSA Disable, 1:FUSA Enable
**/
  UINT8                       SaIpuFusaConfigEnable;

/** Offset 0x01B1
**/
  UINT8                       UnusedUpdSpace6[3];

/** Offset 0x01B4 - Enable PCIE RP Mask
  Enable/disable PCIE Root Ports. 0: disable, 1: enable. One bit for each port, bit0
  for port1, bit1 for port2, and so on.
**/
  UINT32                      CpuPcieRpEnableMask;

/** Offset 0x01B8 - Assertion on Link Down GPIOs
  GPIO Assertion on Link Down. Disabled(0x0)(Default): Disable assertion on Link Down
  GPIOs, Enabled(0x1): Enable assertion on Link Down GPIOs
  0:Disable, 1:Enable
**/
  UINT8                       CpuPcieRpLinkDownGpios;

/** Offset 0x01B9 - Enable ClockReq Messaging
  ClockReq Messaging. Disabled(0x0): Disable ClockReq Messaging, Enabled(0x1)(Default):
  Enable ClockReq Messaging
  0:Disable, 1:Enable
**/
  UINT8                       CpuPcieRpClockReqMsgEnable;

/** Offset 0x01BA - PCIE RP Pcie Speed
  Determines each PCIE Port speed capability. 0: Auto; 1: Gen1; 2: Gen2; 3: Gen3;
  4: Gen4 (see: CPU_PCIE_SPEED).
**/
  UINT8                       CpuPcieRpPcieSpeed[4];

/** Offset 0x01BE - Selection of PSMI Support On/Off
  0(Default) = FALSE, 1 = TRUE. When TRUE, it will allow the PSMI Support
  $EN_DIS
**/
  UINT8                       GtPsmiSupport;

/** Offset 0x01BF - Selection of DiSM Region Size
  DiSM Size to be allocated for 2LM Sku Default is 0
  0:0GB, 1:1GB, 2:2GB, 3:3GB, 4:4GB, 5:5GB, 6:6GB, 7:7GB
**/
  UINT8                       DismSize;

/** Offset 0x01C0 - Pram Size
  Persisted Ram Size. Default is Disabled
  0x30:Disable, 0x31:4MB, 0x32:16MB, 0x33:64MB
**/
  UINT8                       PramSize;

/** Offset 0x01C1 - SaPreMemProductionRsvd
  Reserved for SA Pre-Mem Production
  $EN_DIS
**/
  UINT8                       SaPreMemProductionRsvd[138];

/** Offset 0x024B - DMI Max Link Speed
  Auto (Default)(0x0): Maximum possible link speed, Gen1(0x1): Limit Link to Gen1
  Speed, Gen2(0x2): Limit Link to Gen2 Speed, Gen3(0x3):Limit Link to Gen3 Speed
  0:Auto, 1:Gen1, 2:Gen2, 3:Gen3
**/
  UINT8                       DmiMaxLinkSpeed;

/** Offset 0x024C - DMI Equalization Phase 2
  DMI Equalization Phase 2. (0x0): Disable phase 2, (0x1): Enable phase 2, (0x2)(Default):
  AUTO - Use the current default method
  0:Disable phase2, 1:Enable phase2, 2:Auto
**/
  UINT8                       DmiGen3EqPh2Enable;

/** Offset 0x024D - DMI Gen3 Equalization Phase3
  DMI Gen3 Equalization Phase3. Auto(0x0)(Default): Use the current default method,
  HwEq(0x1): Use Adaptive Hardware Equalization, SwEq(0x2): Use Adaptive Software
  Equalization (Implemented in BIOS Reference Code), Static(0x3): Use the Static
  EQs provided in DmiGen3EndPointPreset array for Phase1 AND Phase3 (Instead of just
  Phase1), Disabled(0x4): Bypass Equalization Phase 3
  0:Auto, 1:HwEq, 2:SwEq, 3:StaticEq, 4:BypassPhase3
**/
  UINT8                       DmiGen3EqPh3Method;

/** Offset 0x024E - Enable/Disable DMI GEN3 Static EQ Phase1 programming
  Program DMI Gen3 EQ Phase1 Static Presets. Disabled(0x0): Disable EQ Phase1 Static
  Presets Programming, Enabled(0x1)(Default): Enable  EQ Phase1 Static Presets Programming
  $EN_DIS
**/
  UINT8                       DmiGen3ProgramStaticEq;

/** Offset 0x024F - DeEmphasis control for DMI
  DeEmphasis control for DMI. 0=-6dB, 1(Default)=-3.5 dB
  0: -6dB, 1: -3.5dB
**/
  UINT8                       DmiDeEmphasis;

/** Offset 0x0250 - DMI Gen3 Root port preset values per lane
  Used for programming DMI Gen3 preset values per lane. Range: 0-9, 8 is default for each lane
**/
  UINT8                       DmiGen3RootPortPreset[8];

/** Offset 0x0258 - DMI Gen3 End port preset values per lane
  Used for programming DMI Gen3 preset values per lane. Range: 0-9, 7 is default for each lane
**/
  UINT8                       DmiGen3EndPointPreset[8];

/** Offset 0x0260 - DMI Gen3 End port Hint values per lane
  Used for programming DMI Gen3 Hint values per lane. Range: 0-6, 2 is default for each lane
**/
  UINT8                       DmiGen3EndPointHint[8];

/** Offset 0x0268 - DMI Gen3 RxCTLEp per-Bundle control
  Range: 0-15, 0 is default for each bundle, must be specified based upon platform design
**/
  UINT8                       DmiGen3RxCtlePeaking[4];

/** Offset 0x026C - BIST on Reset
  Enable or Disable BIST on Reset; <b>0: Disable</b>; 1: Enable.
  $EN_DIS
**/
  UINT8                       BistOnReset;

/** Offset 0x026D - Skip Stop PBET Timer Enable/Disable
  Skip Stop PBET Timer; <b>0: Disable</b>; 1: Enable
  $EN_DIS
**/
  UINT8                       SkipStopPbet;

/** Offset 0x026E - Over clocking support
  Over clocking support; <b>0: Disable</b>; 1: Enable
  $EN_DIS
**/
  UINT8                       OcSupport;

/** Offset 0x026F - Over clocking Lock
  Over clocking Lock Enable/Disable; 0: Disable; <b>1: Enable</b>
  $EN_DIS
**/
  UINT8                       OcLock;

/** Offset 0x0270 - Maximum Core Turbo Ratio Override
  Maximum core turbo ratio override allows to increase CPU core frequency beyond the
  fused max turbo ratio limit. <b>0: Hardware defaults.</b> Range: 0-85
**/
  UINT8                       CoreMaxOcRatio;

/** Offset 0x0271 - Core voltage mode
  Core voltage mode; <b>0: Adaptive</b>; 1: Override.
  $EN_DIS
**/
  UINT8                       CoreVoltageMode;

/** Offset 0x0272 - Maximum clr turbo ratio override
  Maximum clr turbo ratio override allows to increase CPU clr frequency beyond the
  fused max turbo ratio limit. <b>0: Hardware defaults.</b>  Range: 0-85
**/
  UINT8                       RingMaxOcRatio;

/** Offset 0x0273 - Hyper Threading Enable/Disable
  Enable or Disable Hyper Threading; 0: Disable; <b>1: Enable</b>
  $EN_DIS
**/
  UINT8                       HyperThreading;

/** Offset 0x0274 - Enable or Disable CPU Ratio Override
  Enable or Disable CPU Ratio Override; <b>0: Disable</b>; 1: Enable.
  $EN_DIS
**/
  UINT8                       CpuRatioOverride;

/** Offset 0x0275 - CPU ratio value
  CPU ratio value. Valid Range 0 to 63
**/
  UINT8                       CpuRatio;

/** Offset 0x0276 - Boot frequency
  Sets the boot frequency starting from reset vector.- 0: Maximum battery performance.-
  <b>1: Maximum non-turbo performance</b>.- 2: Turbo performance. @note If Turbo
  is selected BIOS will start in max non-turbo mode and switch to Turbo mode.
  0:0, 1:1, 2:2
**/
  UINT8                       BootFrequency;

/** Offset 0x0277 - Number of active cores
  Number of active cores(Depends on Number of cores). <b>0: All</b>;<b>1: 1 </b>;<b>2:
  2 </b>;<b>3: 3 </b>
  0:All, 1:1, 2:2, 3:3
**/
  UINT8                       ActiveCoreCount;

/** Offset 0x0278 - Processor Early Power On Configuration FCLK setting
  <b>0: 800 MHz (ULT/ULX)</b>. <b>1: 1 GHz (DT/Halo)</b>. Not supported on ULT/ULX.-
  2: 400 MHz. - 3: Reserved
  0:800 MHz, 1: 1 GHz, 2: 400 MHz, 3: Reserved
**/
  UINT8                       FClkFrequency;

/** Offset 0x0279 - Set JTAG power in C10 and deeper power states
  False: JTAG is power gated in C10 state. True: keeps the JTAG power up during C10
  and deeper power states for debug purpose. <b>0: False</b>; 1: True.
  0: False, 1: True
**/
  UINT8                       JtagC10PowerGateDisable;

/** Offset 0x027A - Enable or Disable VMX
  Enable or Disable VMX; 0: Disable; <b>1: Enable</b>.
  $EN_DIS
**/
  UINT8                       VmxEnable;

/** Offset 0x027B - AVX2 Ratio Offset
  0(Default)= No Offset. Range 0 - 31. Specifies number of bins to decrease AVX ratio
  vs. Core Ratio. Uses Mailbox MSR 0x150, cmd 0x1B.
**/
  UINT8                       Avx2RatioOffset;

/** Offset 0x027C - AVX3 Ratio Offset
  0(Default)= No Offset. Range 0 - 31. Specifies number of bins to decrease AVX ratio
  vs. Core Ratio. Uses Mailbox MSR 0x150, cmd 0x1B.
**/
  UINT8                       Avx3RatioOffset;

/** Offset 0x027D - BCLK Adaptive Voltage Enable
  When enabled, the CPU V/F curves are aware of BCLK frequency when calculated. </b>0:
  Disable;<b> 1: Enable
  $EN_DIS
**/
  UINT8                       BclkAdaptiveVoltage;

/** Offset 0x027E - core voltage override
  The core voltage override which is applied to the entire range of cpu core frequencies.
  Valid Range 0 to 2000
**/
  UINT16                      CoreVoltageOverride;

/** Offset 0x0280 - Core Turbo voltage Adaptive
  Extra Turbo voltage applied to the cpu core when the cpu is operating in turbo mode.
  Valid Range 0 to 2000
**/
  UINT16                      CoreVoltageAdaptive;

/** Offset 0x0282 - Core Turbo voltage Offset
  The voltage offset applied to the core while operating in turbo mode.Valid Range 0 to 1000
**/
  UINT16                      CoreVoltageOffset;

/** Offset 0x0284 - Core PLL voltage offset
  Core PLL voltage offset. <b>0: No offset</b>. Range 0-63
**/
  UINT8                       CorePllVoltageOffset;

/** Offset 0x0285 - Ring Downbin
  Ring Downbin enable/disable. When enabled, CPU will ensure the ring ratio is always
  lower than the core ratio.0: Disable; <b>1: Enable.</b>
  $EN_DIS
**/
  UINT8                       RingDownBin;

/** Offset 0x0286 - Ring voltage mode
  Ring voltage mode; <b>0: Adaptive</b>; 1: Override.
  $EN_DIS
**/
  UINT8                       RingVoltageMode;

/** Offset 0x0287 - TjMax Offset
  TjMax offset.Specified value here is clipped by pCode (125 - TjMax Offset) to support
  TjMax in the range of 62 to 115 deg Celsius. Valid Range 10 - 63
**/
  UINT8                       TjMaxOffset;

/** Offset 0x0288 - Ring voltage override
  The ring voltage override which is applied to the entire range of cpu ring frequencies.
  Valid Range 0 to 2000
**/
  UINT16                      RingVoltageOverride;

/** Offset 0x028A - Ring Turbo voltage Adaptive
  Extra Turbo voltage applied to the cpu ring when the cpu is operating in turbo mode.
  Valid Range 0 to 2000
**/
  UINT16                      RingVoltageAdaptive;

/** Offset 0x028C - Ring Turbo voltage Offset
  The voltage offset applied to the ring while operating in turbo mode. Valid Range 0 to 1000
**/
  UINT16                      RingVoltageOffset;

/** Offset 0x028E
**/
  UINT8                       UnusedUpdSpace7[2];

/** Offset 0x0290 - ElixirSpringsPatchAddr
  Address of Elixir Springs Patches
**/
  UINT32                      ElixirSpringsPatchAddr;

/** Offset 0x0294 - ElixirSpringsPatchSize
  Size of Elixir Springs Patches
**/
  UINT32                      ElixirSpringsPatchSize;

/** Offset 0x0298 - CPU Run Control
  Enable, Disable or Do not configure CPU Run Control; 0: Disable; 1: Enable ; <b>2:
  No Change</b>
  0:Disabled, 1:Enabled, 2:No Change
**/
  UINT8                       DebugInterfaceEnable;

/** Offset 0x0299 - CPU Run Control Lock
  Lock or Unlock CPU Run Control; 0: Disable; <b>1: Enable</b>.
  $EN_DIS
**/
  UINT8                       DebugInterfaceLockEnable;

/** Offset 0x029A - BiosGuard
  Enable/Disable. 0: Disable, Enable/Disable BIOS Guard feature, 1: enable
  $EN_DIS
**/
  UINT8                       BiosGuard;

/** Offset 0x029B
**/
  UINT8                       BiosGuardToolsInterface;

/** Offset 0x029C - EnableSgx
  Enable/Disable. 0: Disable, Enable/Disable SGX feature, 1: enable, 2: Software Control
  0: Disable, 1: Enable, 2: Software Control
**/
  UINT8                       EnableSgx;

/** Offset 0x029D - Txt
  Enable/Disable. 0: Disable, Enable/Disable Txt feature, 1: enable
  $EN_DIS
**/
  UINT8                       Txt;

/** Offset 0x029E
**/
  UINT8                       UnusedUpdSpace8[2];

/** Offset 0x02A0 - PrmrrSize
  Enable/Disable. 0: Disable, define default value of PrmrrSize , 1: enable
**/
  UINT32                      PrmrrSize;

/** Offset 0x02A4 - SinitMemorySize
  Enable/Disable. 0: Disable, define default value of SinitMemorySize , 1: enable
**/
  UINT32                      SinitMemorySize;

/** Offset 0x02A8 - TxtDprMemoryBase
  Enable/Disable. 0: Disable, define default value of TxtDprMemoryBase , 1: enable
**/
  UINT64                      TxtDprMemoryBase;

/** Offset 0x02B0 - TxtHeapMemorySize
  Enable/Disable. 0: Disable, define default value of TxtHeapMemorySize , 1: enable
**/
  UINT32                      TxtHeapMemorySize;

/** Offset 0x02B4 - TxtDprMemorySize
  Enable/Disable. 0: Disable, define default value of TxtDprMemorySize , 1: enable
**/
  UINT32                      TxtDprMemorySize;

/** Offset 0x02B8 - BiosAcmBase
  Enable/Disable. 0: Disable, define default value of BiosAcmBase , 1: enable
**/
  UINT32                      BiosAcmBase;

/** Offset 0x02BC - BiosAcmSize
  Enable/Disable. 0: Disable, define default value of BiosAcmSize , 1: enable
**/
  UINT32                      BiosAcmSize;

/** Offset 0x02C0 - ApStartupBase
  Enable/Disable. 0: Disable, define default value of BiosAcmBase , 1: enable
**/
  UINT32                      ApStartupBase;

/** Offset 0x02C4 - TgaSize
  Enable/Disable. 0: Disable, define default value of TgaSize , 1: enable
**/
  UINT32                      TgaSize;

/** Offset 0x02C8 - TxtLcpPdBase
  Enable/Disable. 0: Disable, define default value of TxtLcpPdBase , 1: enable
**/
  UINT64                      TxtLcpPdBase;

/** Offset 0x02D0 - TxtLcpPdSize
  Enable/Disable. 0: Disable, define default value of TxtLcpPdSize , 1: enable
**/
  UINT64                      TxtLcpPdSize;

/** Offset 0x02D8 - IsTPMPresence
  IsTPMPresence default values
**/
  UINT8                       IsTPMPresence;

/** Offset 0x02D9 - ReservedSecurityPreMem
  Reserved for Security Pre-Mem
  $EN_DIS
**/
  UINT8                       ReservedSecurityPreMem[6];

/** Offset 0x02DF - PCH Master Clock Gating Control
  Provide a master control for clock gating for all PCH devices, 0: Disabled; 1: Default
  $EN_DIS
**/
  UINT8                       PchMasterClockGating;

/** Offset 0x02E0 - PCH Master Power Gating Control
  Provide a master control for pwoer gating for all PCH devices, 0: Disabled; 1: Default
  $EN_DIS
**/
  UINT8                       PchMasterPowerGating;

/** Offset 0x02E1
**/
  UINT8                       UnusedUpdSpace9;

/** Offset 0x02E2 - FIA Lane Reversal Enable/Disable config mask
  Enable/Disable. 0: Disable, 1: enable, Enable or disable Lane Reversal. If Enabled,
  the x2 FIA Lane will be flipped
**/
  UINT16                      FiaLaneReversalEnable;

/** Offset 0x02E4 - Enable PCH HSIO PCIE Rx Set Ctle
  Enable PCH PCIe Gen 3 Set CTLE Value.
**/
  UINT8                       PchPcieHsioRxSetCtleEnable[24];

/** Offset 0x02FC - PCH HSIO PCIE Rx Set Ctle Value
  PCH PCIe Gen 3 Set CTLE Value.
**/
  UINT8                       PchPcieHsioRxSetCtle[24];

/** Offset 0x0314 - Enble PCH HSIO PCIE TX Gen 1 Downscale Amplitude Adjustment value override
  0: Disable; 1: Enable.
**/
  UINT8                       PchPcieHsioTxGen1DownscaleAmpEnable[24];

/** Offset 0x032C - PCH HSIO PCIE Gen 2 TX Output Downscale Amplitude Adjustment value
  PCH PCIe Gen 2 TX Output Downscale Amplitude Adjustment value.
**/
  UINT8                       PchPcieHsioTxGen1DownscaleAmp[24];

/** Offset 0x0344 - Enable PCH HSIO PCIE TX Gen 2 Downscale Amplitude Adjustment value override
  0: Disable; 1: Enable.
**/
  UINT8                       PchPcieHsioTxGen2DownscaleAmpEnable[24];

/** Offset 0x035C - PCH HSIO PCIE Gen 2 TX Output Downscale Amplitude Adjustment value
  PCH PCIe Gen 2 TX Output Downscale Amplitude Adjustment value.
**/
  UINT8                       PchPcieHsioTxGen2DownscaleAmp[24];

/** Offset 0x0374 - Enable PCH HSIO PCIE TX Gen 3 Downscale Amplitude Adjustment value override
  0: Disable; 1: Enable.
**/
  UINT8                       PchPcieHsioTxGen3DownscaleAmpEnable[24];

/** Offset 0x038C - PCH HSIO PCIE Gen 3 TX Output Downscale Amplitude Adjustment value
  PCH PCIe Gen 3 TX Output Downscale Amplitude Adjustment value.
**/
  UINT8                       PchPcieHsioTxGen3DownscaleAmp[24];

/** Offset 0x03A4 - Enable PCH HSIO PCIE Gen 1 TX Output De-Emphasis Adjustment Setting value override
  0: Disable; 1: Enable.
**/
  UINT8                       PchPcieHsioTxGen1DeEmphEnable[24];

/** Offset 0x03BC - PCH HSIO PCIE Gen 1 TX Output De-Emphasis Adjustment value
  PCH PCIe Gen 1 TX Output De-Emphasis Adjustment Setting.
**/
  UINT8                       PchPcieHsioTxGen1DeEmph[24];

/** Offset 0x03D4 - Enable PCH HSIO PCIE Gen 2 TX Output -3.5dB De-Emphasis Adjustment Setting value override
  0: Disable; 1: Enable.
**/
  UINT8                       PchPcieHsioTxGen2DeEmph3p5Enable[24];

/** Offset 0x03EC - PCH HSIO PCIE Gen 2 TX Output -3.5dB De-Emphasis Adjustment value
  PCH PCIe Gen 2 TX Output -3.5dB De-Emphasis Adjustment Setting.
**/
  UINT8                       PchPcieHsioTxGen2DeEmph3p5[24];

/** Offset 0x0404 - Enable PCH HSIO PCIE Gen 2 TX Output -6.0dB De-Emphasis Adjustment Setting value override
  0: Disable; 1: Enable.
**/
  UINT8                       PchPcieHsioTxGen2DeEmph6p0Enable[24];

/** Offset 0x041C - PCH HSIO PCIE Gen 2 TX Output -6.0dB De-Emphasis Adjustment value
  PCH PCIe Gen 2 TX Output -6.0dB De-Emphasis Adjustment Setting.
**/
  UINT8                       PchPcieHsioTxGen2DeEmph6p0[24];

/** Offset 0x0434 - Enable PCH HSIO SATA Receiver Equalization Boost Magnitude Adjustment Value override
  0: Disable; 1: Enable.
**/
  UINT8                       PchSataHsioRxGen1EqBoostMagEnable[8];

/** Offset 0x043C - PCH HSIO SATA 1.5 Gb/s Receiver Equalization Boost Magnitude Adjustment value
  PCH HSIO SATA 1.5 Gb/s Receiver Equalization Boost Magnitude Adjustment value.
**/
  UINT8                       PchSataHsioRxGen1EqBoostMag[8];

/** Offset 0x0444 - Enable PCH HSIO SATA Receiver Equalization Boost Magnitude Adjustment Value override
  0: Disable; 1: Enable.
**/
  UINT8                       PchSataHsioRxGen2EqBoostMagEnable[8];

/** Offset 0x044C - PCH HSIO SATA 3.0 Gb/s Receiver Equalization Boost Magnitude Adjustment value
  PCH HSIO SATA 3.0 Gb/s Receiver Equalization Boost Magnitude Adjustment value.
**/
  UINT8                       PchSataHsioRxGen2EqBoostMag[8];

/** Offset 0x0454 - Enable PCH HSIO SATA Receiver Equalization Boost Magnitude Adjustment Value override
  0: Disable; 1: Enable.
**/
  UINT8                       PchSataHsioRxGen3EqBoostMagEnable[8];

/** Offset 0x045C - PCH HSIO SATA 6.0 Gb/s Receiver Equalization Boost Magnitude Adjustment value
  PCH HSIO SATA 6.0 Gb/s Receiver Equalization Boost Magnitude Adjustment value.
**/
  UINT8                       PchSataHsioRxGen3EqBoostMag[8];

/** Offset 0x0464 - Enable PCH HSIO SATA 1.5 Gb/s TX Output Downscale Amplitude Adjustment value override
  0: Disable; 1: Enable.
**/
  UINT8                       PchSataHsioTxGen1DownscaleAmpEnable[8];

/** Offset 0x046C - PCH HSIO SATA 1.5 Gb/s TX Output Downscale Amplitude Adjustment value
  PCH HSIO SATA 1.5 Gb/s TX Output Downscale Amplitude Adjustment value.
**/
  UINT8                       PchSataHsioTxGen1DownscaleAmp[8];

/** Offset 0x0474 - Enable PCH HSIO SATA 3.0 Gb/s TX Output Downscale Amplitude Adjustment value override
  0: Disable; 1: Enable.
**/
  UINT8                       PchSataHsioTxGen2DownscaleAmpEnable[8];

/** Offset 0x047C - PCH HSIO SATA 3.0 Gb/s TX Output Downscale Amplitude Adjustment value
  PCH HSIO SATA 3.0 Gb/s TX Output Downscale Amplitude Adjustment value.
**/
  UINT8                       PchSataHsioTxGen2DownscaleAmp[8];

/** Offset 0x0484 - Enable PCH HSIO SATA 6.0 Gb/s TX Output Downscale Amplitude Adjustment value override
  0: Disable; 1: Enable.
**/
  UINT8                       PchSataHsioTxGen3DownscaleAmpEnable[8];

/** Offset 0x048C - PCH HSIO SATA 6.0 Gb/s TX Output Downscale Amplitude Adjustment value
  PCH HSIO SATA 6.0 Gb/s TX Output Downscale Amplitude Adjustment value.
**/
  UINT8                       PchSataHsioTxGen3DownscaleAmp[8];

/** Offset 0x0494 - Enable PCH HSIO SATA 1.5 Gb/s TX Output De-Emphasis Adjustment Setting value override
  0: Disable; 1: Enable.
**/
  UINT8                       PchSataHsioTxGen1DeEmphEnable[8];

/** Offset 0x049C - PCH HSIO SATA 1.5 Gb/s TX Output De-Emphasis Adjustment Setting
  PCH HSIO SATA 1.5 Gb/s TX Output De-Emphasis Adjustment Setting.
**/
  UINT8                       PchSataHsioTxGen1DeEmph[8];

/** Offset 0x04A4 - Enable PCH HSIO SATA 3.0 Gb/s TX Output De-Emphasis Adjustment Setting value override
  0: Disable; 1: Enable.
**/
  UINT8                       PchSataHsioTxGen2DeEmphEnable[8];

/** Offset 0x04AC - PCH HSIO SATA 3.0 Gb/s TX Output De-Emphasis Adjustment Setting
  PCH HSIO SATA 3.0 Gb/s TX Output De-Emphasis Adjustment Setting.
**/
  UINT8                       PchSataHsioTxGen2DeEmph[8];

/** Offset 0x04B4 - Enable PCH HSIO SATA 6.0 Gb/s TX Output De-Emphasis Adjustment Setting value override
  0: Disable; 1: Enable.
**/
  UINT8                       PchSataHsioTxGen3DeEmphEnable[8];

/** Offset 0x04BC - PCH HSIO SATA 6.0 Gb/s TX Output De-Emphasis Adjustment Setting
  PCH HSIO SATA 6.0 Gb/s TX Output De-Emphasis Adjustment Setting.
**/
  UINT8                       PchSataHsioTxGen3DeEmph[8];

/** Offset 0x04C4 - PCH LPC Enhance the port 8xh decoding
  Original LPC only decodes one byte of port 80h.
  $EN_DIS
**/
  UINT8                       PchLpcEnhancePort8xhDecoding;

/** Offset 0x04C5 - PCH Port80 Route
  Control where the Port 80h cycles are sent, 0: LPC; 1: PCI.
  $EN_DIS
**/
  UINT8                       PchPort80Route;

/** Offset 0x04C6 - Enable SMBus ARP support
  Enable SMBus ARP support.
  $EN_DIS
**/
  UINT8                       SmbusArpEnable;

/** Offset 0x04C7 - Number of RsvdSmbusAddressTable.
  The number of elements in the RsvdSmbusAddressTable.
**/
  UINT8                       PchNumRsvdSmbusAddresses;

/** Offset 0x04C8 - SMBUS Base Address
  SMBUS Base Address (IO space).
**/
  UINT16                      PchSmbusIoBase;

/** Offset 0x04CA - Enable SMBus Alert Pin
  Enable SMBus Alert Pin.
  $EN_DIS
**/
  UINT8                       PchSmbAlertEnable;

/** Offset 0x04CB - Usage type for ClkSrc
  0-23: PCH rootport, 0x40-0x43: PEG port, 0x70:LAN, 0x80: unspecified but in use
  (free running), 0xFF: not used
**/
  UINT8                       PcieClkSrcUsage[16];

/** Offset 0x04DB - ClkReq-to-ClkSrc mapping
  Number of ClkReq signal assigned to ClkSrc
**/
  UINT8                       PcieClkSrcClkReq[16];

/** Offset 0x04EB
**/
  UINT8                       UnusedUpdSpace10;

/** Offset 0x04EC - Point of RsvdSmbusAddressTable
  Array of addresses reserved for non-ARP-capable SMBus devices.
**/
  UINT32                      RsvdSmbusAddressTablePtr;

/** Offset 0x04F0 - Enable PCIE RP Mask
  Enable/disable PCIE Root Ports. 0: disable, 1: enable. One bit for each port, bit0
  for port1, bit1 for port2, and so on.
**/
  UINT32                      PcieRpEnableMask;

/** Offset 0x04F4 - Debug Interfaces
  Debug Interfaces. BIT0-RAM, BIT1-UART, BIT3-USB3, BIT4-Serial IO, BIT5-TraceHub,
  BIT2 - Not used.
**/
  UINT8                       PcdDebugInterfaceFlags;

/** Offset 0x04F5 - Serial Io Uart Debug Controller Number
  Select SerialIo Uart Controller for debug. Note: If UART0 is selected as CNVi BT
  Core interface, it cannot be used for debug purpose.
  0:SerialIoUart0, 1:SerialIoUart1, 2:SerialIoUart2
**/
  UINT8                       SerialIoUartDebugControllerNumber;

/** Offset 0x04F6 - Serial Io Uart Debug Auto Flow
  Enables UART hardware flow control, CTS and RTS lines.
  $EN_DIS
**/
  UINT8                       SerialIoUartDebugAutoFlow;

/** Offset 0x04F7
**/
  UINT8                       UnusedUpdSpace11;

/** Offset 0x04F8 - Serial Io Uart Debug BaudRate
  Set default BaudRate Supported from 0 - default to 6000000. Recommended values 9600,
  19200, 57600, 115200, 460800, 921600, 1500000, 1843200, 3000000, 3686400, 6000000
**/
  UINT32                      SerialIoUartDebugBaudRate;

/** Offset 0x04FC - Serial Io Uart Debug Parity
  Set default Parity.
  0: DefaultParity, 1: NoParity, 2: EvenParity, 3: OddParity
**/
  UINT8                       SerialIoUartDebugParity;

/** Offset 0x04FD - Serial Io Uart Debug Stop Bits
  Set default stop bits.
  0: DefaultStopBits, 1: OneStopBit, 2: OneFiveStopBits, 3: TwoStopBits
**/
  UINT8                       SerialIoUartDebugStopBits;

/** Offset 0x04FE - Serial Io Uart Debug Data Bits
  Set default word length. 0: Default, 5,6,7,8
  5:5BITS, 6:6BITS, 7:7BITS, 8:8BITS
**/
  UINT8                       SerialIoUartDebugDataBits;

/** Offset 0x04FF
**/
  UINT8                       UnusedUpdSpace12;

/** Offset 0x0500 - Serial Io Uart Debug Mmio Base
  Select SerialIo Uart default MMIO resource in SEC/PEI phase when PcdSerialIoUartMode
  = SerialIoUartPci.
**/
  UINT32                      SerialIoUartDebugMmioBase;

/** Offset 0x0504 - ISA Serial Base selection
  Select ISA Serial Base address. Default is 0x3F8.
  0:0x3F8, 1:0x2F8
**/
  UINT8                       PcdIsaSerialUartBase;

/** Offset 0x0505 - GT PLL voltage offset
  Core PLL voltage offset. <b>0: No offset</b>. Range 0-63
**/
  UINT8                       GtPllVoltageOffset;

/** Offset 0x0506 - Ring PLL voltage offset
  Core PLL voltage offset. <b>0: No offset</b>. Range 0-63
**/
  UINT8                       RingPllVoltageOffset;

/** Offset 0x0507 - System Agent PLL voltage offset
  Core PLL voltage offset. <b>0: No offset</b>. Range 0-63
**/
  UINT8                       SaPllVoltageOffset;

/** Offset 0x0508 - Memory Controller PLL voltage offset
  Core PLL voltage offset. <b>0: No offset</b>. Range 0-63
**/
  UINT8                       McPllVoltageOffset;

/** Offset 0x0509 - MRC Safe Config
  Enables/Disable MRC Safe Config
  $EN_DIS
**/
  UINT8                       MrcSafeConfig;

/** Offset 0x050A - TCSS Thunderbolt PCIE Root Port 0 Enable
  Set TCSS Thunderbolt PCIE Root Port 0. 0:Disabled  1:Enabled
  $EN_DIS
**/
  UINT8                       TcssItbtPcie0En;

/** Offset 0x050B - TCSS Thunderbolt PCIE Root Port 1 Enable
  Set TCSS Thunderbolt PCIE Root Port 1. 0:Disabled  1:Enabled
  $EN_DIS
**/
  UINT8                       TcssItbtPcie1En;

/** Offset 0x050C - TCSS Thunderbolt PCIE Root Port 2 Enable
  Set TCSS Thunderbolt PCIE Root Port 2. 0:Disabled  1:Enabled
  $EN_DIS
**/
  UINT8                       TcssItbtPcie2En;

/** Offset 0x050D - TCSS Thunderbolt PCIE Root Port 3 Enable
  Set TCSS Thunderbolt PCIE Root Port 3. 0:Disabled  1:Enabled
  $EN_DIS
**/
  UINT8                       TcssItbtPcie3En;

/** Offset 0x050E - TCSS USB HOST (xHCI) Enable
  Set TCSS XHCI. 0:Disabled  1:Enabled - Must be enabled if xDCI is enabled below
  $EN_DIS
**/
  UINT8                       TcssXhciEn;

/** Offset 0x050F - TCSS USB DEVICE (xDCI) Enable
  Set TCSS XDCI. 0:Disabled  1:Enabled - xHCI must be enabled if xDCI is enabled
  $EN_DIS
**/
  UINT8                       TcssXdciEn;

/** Offset 0x0510 - TCSS DMA0 Enable
  Set TCSS DMA0. 0:Disabled  1:Enabled
  $EN_DIS
**/
  UINT8                       TcssDma0En;

/** Offset 0x0511 - TCSS DMA1 Enable
  Set TCSS DMA1. 0:Disabled  1:Enabled
  $EN_DIS
**/
  UINT8                       TcssDma1En;

/** Offset 0x0512 - PcdSerialDebugBaudRate
  Baud Rate for Serial Debug Messages. 3:9600, 4:19200, 6:56700, 7:115200.
  3:9600, 4:19200, 6:56700, 7:115200
**/
  UINT8                       PcdSerialDebugBaudRate;

/** Offset 0x0513 - HobBufferSize
  Size to set HOB Buffer. 0:Default, 1: 1 Byte, 2: 1 KB, 3: Max value(assuming 63KB
  total HOB size).
  0:Default, 1: 1 Byte, 2: 1 KB, 3: Max value
**/
  UINT8                       HobBufferSize;

/** Offset 0x0514 - Early Command Training
  Enables/Disable Early Command Training
  $EN_DIS
**/
  UINT8                       ECT;

/** Offset 0x0515 - SenseAmp Offset Training
  Enables/Disable SenseAmp Offset Training
  $EN_DIS
**/
  UINT8                       SOT;

/** Offset 0x0516 - Early ReadMPR Timing Centering 2D
  Enables/Disable Early ReadMPR Timing Centering 2D
  $EN_DIS
**/
  UINT8                       ERDMPRTC2D;

/** Offset 0x0517 - Read MPR Training
  Enables/Disable Read MPR Training
  $EN_DIS
**/
  UINT8                       RDMPRT;

/** Offset 0x0518 - Receive Enable Training
  Enables/Disable Receive Enable Training
  $EN_DIS
**/
  UINT8                       RCVET;

/** Offset 0x0519 - Jedec Write Leveling
  Enables/Disable Jedec Write Leveling
  $EN_DIS
**/
  UINT8                       JWRL;

/** Offset 0x051A - Early Write Time Centering 2D
  Enables/Disable Early Write Time Centering 2D
  $EN_DIS
**/
  UINT8                       EWRTC2D;

/** Offset 0x051B - Early Read Time Centering 2D
  Enables/Disable Early Read Time Centering 2D
  $EN_DIS
**/
  UINT8                       ERDTC2D;

/** Offset 0x051C - Write Timing Centering 1D
  Enables/Disable Write Timing Centering 1D
  $EN_DIS
**/
  UINT8                       WRTC1D;

/** Offset 0x051D - Write Voltage Centering 1D
  Enables/Disable Write Voltage Centering 1D
  $EN_DIS
**/
  UINT8                       WRVC1D;

/** Offset 0x051E - Read Timing Centering 1D
  Enables/Disable Read Timing Centering 1D
  $EN_DIS
**/
  UINT8                       RDTC1D;

/** Offset 0x051F - Dimm ODT Training
  Enables/Disable Dimm ODT Training
  $EN_DIS
**/
  UINT8                       DIMMODTT;

/** Offset 0x0520 - DIMM RON Training
  Enables/Disable DIMM RON Training
  $EN_DIS
**/
  UINT8                       DIMMRONT;

/** Offset 0x0521 - Write Drive Strength/Equalization 2D
  Enables/Disable Write Drive Strength/Equalization 2D
  $EN_DIS
**/
  UINT8                       WRDSEQT;

/** Offset 0x0522 - Write Slew Rate Training
  Enables/Disable Write Slew Rate Training
  $EN_DIS
**/
  UINT8                       WRSRT;

/** Offset 0x0523 - Read ODT Training
  Enables/Disable Read ODT Training
  $EN_DIS
**/
  UINT8                       RDODTT;

/** Offset 0x0524 - Read Equalization Training
  Enables/Disable Read Equalization Training
  $EN_DIS
**/
  UINT8                       RDEQT;

/** Offset 0x0525 - Read Amplifier Training
  Enables/Disable Read Amplifier Training
  $EN_DIS
**/
  UINT8                       RDAPT;

/** Offset 0x0526 - Write Timing Centering 2D
  Enables/Disable Write Timing Centering 2D
  $EN_DIS
**/
  UINT8                       WRTC2D;

/** Offset 0x0527 - Read Timing Centering 2D
  Enables/Disable Read Timing Centering 2D
  $EN_DIS
**/
  UINT8                       RDTC2D;

/** Offset 0x0528 - Write Voltage Centering 2D
  Enables/Disable Write Voltage Centering 2D
  $EN_DIS
**/
  UINT8                       WRVC2D;

/** Offset 0x0529 - Read Voltage Centering 2D
  Enables/Disable Read Voltage Centering 2D
  $EN_DIS
**/
  UINT8                       RDVC2D;

/** Offset 0x052A - Command Voltage Centering
  Enables/Disable Command Voltage Centering
  $EN_DIS
**/
  UINT8                       CMDVC;

/** Offset 0x052B - Late Command Training
  Enables/Disable Late Command Training
  $EN_DIS
**/
  UINT8                       LCT;

/** Offset 0x052C - Round Trip Latency Training
  Enables/Disable Round Trip Latency Training
  $EN_DIS
**/
  UINT8                       RTL;

/** Offset 0x052D - Turn Around Timing Training
  Enables/Disable Turn Around Timing Training
  $EN_DIS
**/
  UINT8                       TAT;

/** Offset 0x052E - Receive Enable Centering 1D
  Enables/Disable Receive Enable Centering 1D
  $EN_DIS
**/
  UINT8                       RCVENC1D;

/** Offset 0x052F - Rank Margin Tool
  Enable/disable Rank Margin Tool.
  $EN_DIS
**/
  UINT8                       RMT;

/** Offset 0x0530 - Margin Limit Check
  Margin Limit Check. Choose level of margin check
  0:Disable, 1:L1, 2:L2, 3:Both
**/
  UINT8                       MarginLimitCheck;

/** Offset 0x0531
**/
  UINT8                       UnusedUpdSpace13;

/** Offset 0x0532 - Margin Limit L2
  % of L1 check for margin limit check
**/
  UINT16                      MarginLimitL2;

/** Offset 0x0534 - Memory Test
  Enables/Disable Memory Test
  $EN_DIS
**/
  UINT8                       MEMTST;

/** Offset 0x0535 - DIMM SPD Alias Test
  Enables/Disable DIMM SPD Alias Test
  $EN_DIS
**/
  UINT8                       ALIASCHK;

/** Offset 0x0536 - Retrain Margin Check
  Enables/Disable Retrain Margin Check
  $EN_DIS
**/
  UINT8                       RMC;

/** Offset 0x0537 - Write Drive Strength Up/Dn independently
  Enables/Disable Write Drive Strength Up/Dn independently
  $EN_DIS
**/
  UINT8                       WRDSUDT;

/** Offset 0x0538 - Command Slew Rate Training
  Enables/Disable Command Slew Rate Training
  $EN_DIS
**/
  UINT8                       CMDSR;

/** Offset 0x0539 - Command Drive Strength and Equalization 2D
  Enables/Disable Command Drive Strength and Equalization 2D
  $EN_DIS
**/
  UINT8                       CMDDSEQ;

/** Offset 0x053A - Command Normalization
  Enables/Disable Command Normalization
  $EN_DIS
**/
  UINT8                       CMDNORM;

/** Offset 0x053B - Early DQ Write Drive Strength and Equalization Training
  Enables/Disable Early DQ Write Drive Strength and Equalization Training
  $EN_DIS
**/
  UINT8                       EWRDSEQ;

/** Offset 0x053C - Read Voltage Centering
  Enables/Disable Read Voltage Centering
  $EN_DIS
**/
  UINT8                       RDVC1D;

/** Offset 0x053D - Write TCO Comp Training
  Enables/Disable Write TCO Comp Training
  $EN_DIS
**/
  UINT8                       TXTCO;

/** Offset 0x053E - Clock TCO Comp Training
  Enables/Disable Clock TCO Comp Training
  $EN_DIS
**/
  UINT8                       CLKTCO;

/** Offset 0x053F - Dimm ODT CA Training
  Enables/Disable Dimm ODT CA Training
  $EN_DIS
**/
  UINT8                       DIMMODTCA;

/** Offset 0x0540 - Write TCO Dqs Training
  Enables/Disable Write TCO Dqs Training
  $EN_DIS
**/
  UINT8                       TXTCODQS;

/** Offset 0x0541 - Duty Cycle Correction
  Enables/Disable Duty Cycle Correction
  $EN_DIS
**/
  UINT8                       DCC;

/** Offset 0x0542 - DQ DFE Training
  Enable/Disable DQ DFE Training
  $EN_DIS
**/
  UINT8                       DQDFE;

/** Offset 0x0543 - Sense Amplifier Correction Training
  Enable/Disable Sense Amplifier Correction Training
  $EN_DIS
**/
  UINT8                       SOTC;

/** Offset 0x0544 - ECC Support
  Enables/Disable ECC Support
  $EN_DIS
**/
  UINT8                       EccSupport;

/** Offset 0x0545 - Memory Remap
  Enables/Disable Memory Remap
  $EN_DIS
**/
  UINT8                       RemapEnable;

/** Offset 0x0546 - MRC Time Measure
  Enable/Disable MRC Time Measure
  $EN_DIS
**/
  UINT8                       MrcTimeMeasure;

/** Offset 0x0547 - MRC Fast Boot
  Enable/Disable MRC Fast flow
  $EN_DIS
**/
  UINT8                       MrcFastBoot;

/** Offset 0x0548 - MRC Force Training on Warm
  Enables/Disable the MRC training on warm boot
  $EN_DIS
**/
  UINT8                       MrcTrainOnWarm;

/** Offset 0x0549 - Rank Interleave support
  Enables/Disable Rank Interleave support. NOTE: RI and HORI can not be enabled at
  the same time.
  $EN_DIS
**/
  UINT8                       RankInterleave;

/** Offset 0x054A - Enhanced Interleave support
  Enables/Disable Enhanced Interleave support
  $EN_DIS
**/
  UINT8                       EnhancedInterleave;

/** Offset 0x054B - Memory Trace
  Enable Memory Trace of Ch 0 to Ch 1 using Stacked Mode. Both channels must be of
  equal size. This option may change TOLUD and REMAP values as needed.
  $EN_DIS
**/
  UINT8                       MemoryTrace;

/** Offset 0x054C - Ch Hash Support
  Enable/Disable Channel Hash Support. NOTE: ONLY if Memory interleaved Mode
  $EN_DIS
**/
  UINT8                       ChHashEnable;

/** Offset 0x054D - Extern Therm Status
  Enables/Disable Extern Therm Status
  $EN_DIS
**/
  UINT8                       EnableExtts;

/** Offset 0x054E - Closed Loop Therm Manage
  Enables/Disable Closed Loop Therm Manage
  $EN_DIS
**/
  UINT8                       EnableCltm;

/** Offset 0x054F - Open Loop Therm Manage
  Enables/Disable Open Loop Therm Manage
  $EN_DIS
**/
  UINT8                       EnableOltm;

/** Offset 0x0550 - DDR PowerDown and idle counter
  Enables/Disable DDR PowerDown and idle counter
  $EN_DIS
**/
  UINT8                       EnablePwrDn;

/** Offset 0x0551 - DDR PowerDown and idle counter - LPDDR
  Enables/Disable DDR PowerDown and idle counter(For LPDDR Only)
  $EN_DIS
**/
  UINT8                       EnablePwrDnLpddr;

/** Offset 0x0552 - Use user provided power weights, scale factor, and channel power floor values
  Enables/Disable Use user provided power weights, scale factor, and channel power
  floor values
  $EN_DIS
**/
  UINT8                       UserPowerWeightsEn;

/** Offset 0x0553 - RAPL PL Lock
  Enables/Disable RAPL PL Lock
  $EN_DIS
**/
  UINT8                       RaplLim2Lock;

/** Offset 0x0554 - RAPL PL 2 enable
  Enables/Disable RAPL PL 2 enable
  $EN_DIS
**/
  UINT8                       RaplLim2Ena;

/** Offset 0x0555 - RAPL PL 1 enable
  Enables/Disable RAPL PL 1 enable
  $EN_DIS
**/
  UINT8                       RaplLim1Ena;

/** Offset 0x0556 - SelfRefresh Enable
  Enables/Disable SelfRefresh Enable
  $EN_DIS
**/
  UINT8                       SrefCfgEna;

/** Offset 0x0557 - Throttler CKEMin Defeature - LPDDR
  Enables/Disable Throttler CKEMin Defeature(For LPDDR Only)
  $EN_DIS
**/
  UINT8                       ThrtCkeMinDefeatLpddr;

/** Offset 0x0558 - Throttler CKEMin Defeature
  Enables/Disable Throttler CKEMin Defeature
  $EN_DIS
**/
  UINT8                       ThrtCkeMinDefeat;

/** Offset 0x0559 - Enable RH Prevention
  Enables/Disable RH Prevention
  $EN_DIS
**/
  UINT8                       RhPrevention;

/** Offset 0x055A - Exit On Failure (MRC)
  Enables/Disable Exit On Failure (MRC)
  $EN_DIS
**/
  UINT8                       ExitOnFailure;

/** Offset 0x055B - LPDDR Thermal Sensor
  Enables/Disable LPDDR Thermal Sensor
  $EN_DIS
**/
  UINT8                       DdrThermalSensor;

/** Offset 0x055C - Select if CLK0 is shared between Rank0 and Rank1 in DDR4 DDP
  Select if CLK0 is shared between Rank0 and Rank1 in DDR4 DDP
  $EN_DIS
**/
  UINT8                       Ddr4DdpSharedClock;

/** Offset 0x055D - Select if ZQ pin is shared between Rank0 and Rank1 in DDR4 DDP
  ESelect if ZQ pin is shared between Rank0 and Rank1 in DDR4 DDP
  $EN_DIS
**/
  UINT8                       Ddr4DdpSharedZq;

/** Offset 0x055E
**/
  UINT8                       UnusedUpdSpace14[2];

/** Offset 0x0560 - Base reference clock value
  Base reference clock value, in Hertz(Default is 125Hz)
  100000000:100Hz, 125000000:125Hz, 167000000:167Hz, 250000000:250Hz
**/
  UINT32                      BClkFrequency;

/** Offset 0x0564 - Ch Hash Interleaved Bit
  Select the BIT to be used for Channel Interleaved mode. NOTE: BIT7 will interlave
  the channels at a 2 cacheline granularity, BIT8 at 4 and BIT9 at 8. Default is BIT8
  0:BIT6, 1:BIT7, 2:BIT8, 3:BIT9, 4:BIT10, 5:BIT11, 6:BIT12, 7:BIT13
**/
  UINT8                       ChHashInterleaveBit;

/** Offset 0x0565
**/
  UINT8                       UnusedUpdSpace15;

/** Offset 0x0566 - Ch Hash Mask
  Set the BIT(s) to be included in the XOR function. NOTE BIT mask corresponds to
  BITS [19:6] Default is 0x30CC
**/
  UINT16                      ChHashMask;

/** Offset 0x0568 - Extended Bank Hashing
  Eanble/Disable ExtendedBankHashing
  $EN_DIS
**/
  UINT8                       ExtendedBankHashing;

/** Offset 0x0569 - Energy Scale Factor
  Energy Scale Factor, Default is 4
**/
  UINT8                       EnergyScaleFact;

/** Offset 0x056A - EPG DIMM Idd3N
  Active standby current (Idd3N) in milliamps from datasheet. Must be calculated on
  a per DIMM basis. Default is 26
**/
  UINT16                      Idd3n;

/** Offset 0x056C - EPG DIMM Idd3P
  Active power-down current (Idd3P) in milliamps from datasheet. Must be calculated
  on a per DIMM basis. Default is 11
**/
  UINT16                      Idd3p;

/** Offset 0x056E - RH Activation Probability
  RH Activation Probability, Probability value is 1/2^(inputvalue)
**/
  UINT8                       RhActProbability;

/** Offset 0x056F - RAPL PL 2 WindowX
  Power PL 2 time window X value, (1/1024)*(1+(x/4))*(2^y) (0=Def)
**/
  UINT8                       RaplLim2WindX;

/** Offset 0x0570 - RAPL PL 2 WindowY
  Power PL 2 time window Y value, (1/1024)*(1+(x/4))*(2^y) (0=Def)
**/
  UINT8                       RaplLim2WindY;

/** Offset 0x0571 - RAPL PL 1 WindowX
  Power PL 1 time window X value, (1/1024)*(1+(x/4))*(2^y) (0=Def)
**/
  UINT8                       RaplLim1WindX;

/** Offset 0x0572 - RAPL PL 1 WindowY
  Power PL 1 time window Y value, (1/1024)*(1+(x/4))*(2^y) (0=Def)
**/
  UINT8                       RaplLim1WindY;

/** Offset 0x0573
**/
  UINT8                       UnusedUpdSpace16;

/** Offset 0x0574 - RAPL PL 2 Power
  range[0;2^14-1]= [2047.875;0]in W, (224= Def)
**/
  UINT16                      RaplLim2Pwr;

/** Offset 0x0576 - RAPL PL 1 Power
  range[0;2^14-1]= [2047.875;0]in W, (224= Def)
**/
  UINT16                      RaplLim1Pwr;

/** Offset 0x0578 - Warm Threshold Ch0 Dimm0
  range[255;0]=[31.875;0] in W for OLTM, [127.5;0] in C for CLTM. Fefault is 255
**/
  UINT8                       WarmThresholdCh0Dimm0;

/** Offset 0x0579 - Warm Threshold Ch0 Dimm1
  range[255;0]=[31.875;0] in W for OLTM, [127.5;0] in C for CLTM. Fefault is 255
**/
  UINT8                       WarmThresholdCh0Dimm1;

/** Offset 0x057A - Warm Threshold Ch1 Dimm0
  range[255;0]=[31.875;0] in W for OLTM, [127.5;0] in C for CLTM. Fefault is 255
**/
  UINT8                       WarmThresholdCh1Dimm0;

/** Offset 0x057B - Warm Threshold Ch1 Dimm1
  range[255;0]=[31.875;0] in W for OLTM, [127.5;0] in C for CLTM. Fefault is 255
**/
  UINT8                       WarmThresholdCh1Dimm1;

/** Offset 0x057C - Hot Threshold Ch0 Dimm0
  range[255;0]=[31.875;0] in W for OLTM, [127.5;0] in C for CLTM. Fefault is 255
**/
  UINT8                       HotThresholdCh0Dimm0;

/** Offset 0x057D - Hot Threshold Ch0 Dimm1
  range[255;0]=[31.875;0] in W for OLTM, [127.5;0] in C for CLTM. Fefault is 255
**/
  UINT8                       HotThresholdCh0Dimm1;

/** Offset 0x057E - Hot Threshold Ch1 Dimm0
  range[255;0]=[31.875;0] in W for OLTM, [127.5;0] in C for CLTM. Fefault is 255
**/
  UINT8                       HotThresholdCh1Dimm0;

/** Offset 0x057F - Hot Threshold Ch1 Dimm1
  range[255;0]=[31.875;0] in W for OLTM, [127.5;0] in C for CLTM. Fefault is 255
**/
  UINT8                       HotThresholdCh1Dimm1;

/** Offset 0x0580 - Warm Budget Ch0 Dimm0
  range[255;0]=[31.875;0] in W for OLTM, [127.5;0] in C for CLTM
**/
  UINT8                       WarmBudgetCh0Dimm0;

/** Offset 0x0581 - Warm Budget Ch0 Dimm1
  range[255;0]=[31.875;0] in W for OLTM, [127.5;0] in C for CLTM
**/
  UINT8                       WarmBudgetCh0Dimm1;

/** Offset 0x0582 - Warm Budget Ch1 Dimm0
  range[255;0]=[31.875;0] in W for OLTM, [127.5;0] in C for CLTM
**/
  UINT8                       WarmBudgetCh1Dimm0;

/** Offset 0x0583 - Warm Budget Ch1 Dimm1
  range[255;0]=[31.875;0] in W for OLTM, [127.5;0] in C for CLTM
**/
  UINT8                       WarmBudgetCh1Dimm1;

/** Offset 0x0584 - Hot Budget Ch0 Dimm0
  range[255;0]=[31.875;0] in W for OLTM, [127.5;0] in C for CLTM
**/
  UINT8                       HotBudgetCh0Dimm0;

/** Offset 0x0585 - Hot Budget Ch0 Dimm1
  range[255;0]=[31.875;0] in W for OLTM, [127.5;0] in C for CLTM
**/
  UINT8                       HotBudgetCh0Dimm1;

/** Offset 0x0586 - Hot Budget Ch1 Dimm0
  range[255;0]=[31.875;0] in W for OLTM, [127.5;0] in C for CLTM
**/
  UINT8                       HotBudgetCh1Dimm0;

/** Offset 0x0587 - Hot Budget Ch1 Dimm1
  range[255;0]=[31.875;0] in W for OLTM, [127.5;0] in C for CLTM
**/
  UINT8                       HotBudgetCh1Dimm1;

/** Offset 0x0588 - Idle Energy Ch0Dimm0
  Idle Energy Consumed for 1 clk w/dimm idle/cke on, range[63;0],(10= Def)
**/
  UINT8                       IdleEnergyCh0Dimm0;

/** Offset 0x0589 - Idle Energy Ch0Dimm1
  Idle Energy Consumed for 1 clk w/dimm idle/cke on, range[63;0],(10= Def)
**/
  UINT8                       IdleEnergyCh0Dimm1;

/** Offset 0x058A - Idle Energy Ch1Dimm0
  Idle Energy Consumed for 1 clk w/dimm idle/cke on, range[63;0],(10= Def)
**/
  UINT8                       IdleEnergyCh1Dimm0;

/** Offset 0x058B - Idle Energy Ch1Dimm1
  Idle Energy Consumed for 1 clk w/dimm idle/cke on, range[63;0],(10= Def)
**/
  UINT8                       IdleEnergyCh1Dimm1;

/** Offset 0x058C - PowerDown Energy Ch0Dimm0
  PowerDown Energy Consumed w/dimm idle/cke off, range[63;0],(5= Def)
**/
  UINT8                       PdEnergyCh0Dimm0;

/** Offset 0x058D - PowerDown Energy Ch0Dimm1
  PowerDown Energy Consumed w/dimm idle/cke off, range[63;0],(5= Def)
**/
  UINT8                       PdEnergyCh0Dimm1;

/** Offset 0x058E - PowerDown Energy Ch1Dimm0
  PowerDown Energy Consumed w/dimm idle/cke off, range[63;0],(5= Def)
**/
  UINT8                       PdEnergyCh1Dimm0;

/** Offset 0x058F - PowerDown Energy Ch1Dimm1
  PowerDown Energy Consumed w/dimm idle/cke off, range[63;0],(5= Def)
**/
  UINT8                       PdEnergyCh1Dimm1;

/** Offset 0x0590 - Activate Energy Ch0Dimm0
  Activate Energy Contribution, range[255;0],(172= Def)
**/
  UINT8                       ActEnergyCh0Dimm0;

/** Offset 0x0591 - Activate Energy Ch0Dimm1
  Activate Energy Contribution, range[255;0],(172= Def)
**/
  UINT8                       ActEnergyCh0Dimm1;

/** Offset 0x0592 - Activate Energy Ch1Dimm0
  Activate Energy Contribution, range[255;0],(172= Def)
**/
  UINT8                       ActEnergyCh1Dimm0;

/** Offset 0x0593 - Activate Energy Ch1Dimm1
  Activate Energy Contribution, range[255;0],(172= Def)
**/
  UINT8                       ActEnergyCh1Dimm1;

/** Offset 0x0594 - Read Energy Ch0Dimm0
  Read Energy Contribution, range[255;0],(212= Def)
**/
  UINT8                       RdEnergyCh0Dimm0;

/** Offset 0x0595 - Read Energy Ch0Dimm1
  Read Energy Contribution, range[255;0],(212= Def)
**/
  UINT8                       RdEnergyCh0Dimm1;

/** Offset 0x0596 - Read Energy Ch1Dimm0
  Read Energy Contribution, range[255;0],(212= Def)
**/
  UINT8                       RdEnergyCh1Dimm0;

/** Offset 0x0597 - Read Energy Ch1Dimm1
  Read Energy Contribution, range[255;0],(212= Def)
**/
  UINT8                       RdEnergyCh1Dimm1;

/** Offset 0x0598 - Write Energy Ch0Dimm0
  Write Energy Contribution, range[255;0],(221= Def)
**/
  UINT8                       WrEnergyCh0Dimm0;

/** Offset 0x0599 - Write Energy Ch0Dimm1
  Write Energy Contribution, range[255;0],(221= Def)
**/
  UINT8                       WrEnergyCh0Dimm1;

/** Offset 0x059A - Write Energy Ch1Dimm0
  Write Energy Contribution, range[255;0],(221= Def)
**/
  UINT8                       WrEnergyCh1Dimm0;

/** Offset 0x059B - Write Energy Ch1Dimm1
  Write Energy Contribution, range[255;0],(221= Def)
**/
  UINT8                       WrEnergyCh1Dimm1;

/** Offset 0x059C - Throttler CKEMin Timer
  Timer value for CKEMin, range[255;0]. Req'd min of SC_ROUND_T + BYTE_LENGTH (4).
  Dfault is 0x30
**/
  UINT8                       ThrtCkeMinTmr;

/** Offset 0x059D - Cke Rank Mapping
  Bits [7:4] - Channel 1, bits [3:0] - Channel 0. <b>0xAA=Default</b> Bit [i] specifies
  which rank CKE[i] goes to.
**/
  UINT8                       CkeRankMapping;

/** Offset 0x059E - Rapl Power Floor Ch0
  Power budget ,range[255;0],(0= 5.3W Def)
**/
  UINT8                       RaplPwrFlCh0;

/** Offset 0x059F - Rapl Power Floor Ch1
  Power budget ,range[255;0],(0= 5.3W Def)
**/
  UINT8                       RaplPwrFlCh1;

/** Offset 0x05A0 - Command Rate Support
  CMD Rate and Limit Support Option. NOTE: ONLY supported in 1N Mode, Default is 3 CMDs
  0:Disable, 1:1 CMD, 2:2 CMDS, 3:3 CMDS, 4:4 CMDS, 5:5 CMDS, 6:6 CMDS, 7:7 CMDS
**/
  UINT8                       EnCmdRate;

/** Offset 0x05A1 - REFRESH_2X_MODE
  0- (Default)Disabled 1-iMC enables 2xRef when Warm and Hot 2- iMC enables 2xRef when Hot
  0:Disable, 1:Enabled for WARM or HOT, 2:Enabled HOT only
**/
  UINT8                       Refresh2X;

/** Offset 0x05A2 - Energy Performance Gain
  Enable/disable(default) Energy Performance Gain.
  $EN_DIS
**/
  UINT8                       EpgEnable;

/** Offset 0x05A3 - Row Hammer Solution
  Type of method used to prevent Row Hammer. Default is 2x Refresh
  0:Hardware RHP, 1:2x Refresh
**/
  UINT8                       RhSolution;

/** Offset 0x05A4 - User Manual Threshold
  Disabled: Predefined threshold will be used.\n
  Enabled: User Input will be used.
  $EN_DIS
**/
  UINT8                       UserThresholdEnable;

/** Offset 0x05A5 - User Manual Budget
  Disabled: Configuration of memories will defined the Budget value.\n
  Enabled: User Input will be used.
  $EN_DIS
**/
  UINT8                       UserBudgetEnable;

/** Offset 0x05A6 - Power Down Mode
  This option controls command bus tristating during idle periods
  0x0:No Power Down, 0x1:APD, 0x6:PPD DLL OFF, 0xFF:Auto
**/
  UINT8                       PowerDownMode;

/** Offset 0x05A7 -   TcritMax
  Maximum Critical Temperature in Centigrade of the On-DIMM Thermal Sensor. TCRITMax
  has to be greater than THIGHMax .\n
  Critical temperature will be  TcritMax
**/
  UINT8                       TsodTcritMax;

/** Offset 0x05A8 - Event mode
  Disable:Comparator mode.\n
  Enable:Interrupt mode
  $EN_DIS
**/
  UINT8                       TsodEventMode;

/** Offset 0x05A9 - EVENT polarity
  Disable:Active LOW.\n
  Enable:Active HIGH
  $EN_DIS
**/
  UINT8                       TsodEventPolarity;

/** Offset 0x05AA - Critical event only
  Disable:Trips on alarm or critical.\n
  Enable:Trips only if criticaal temperature is reached
  $EN_DIS
**/
  UINT8                       TsodCriticalEventOnly;

/** Offset 0x05AB - Event output control
  Disable:Event output disable.\n
  Enable:Event output enabled
  $EN_DIS
**/
  UINT8                       TsodEventOutputControl;

/** Offset 0x05AC - Alarm window lock bit
  Disable:Alarm trips are not locked and can be changed.\n
  Enable:Alarm trips are locked and cannot be changed
  $EN_DIS
**/
  UINT8                       TsodAlarmwindowLockBit;

/** Offset 0x05AD - Critical trip lock bit
  Disable:Critical trip is not locked and can be changed.\n
  Enable:Critical trip is locked and cannot be changed
  $EN_DIS
**/
  UINT8                       TsodCriticaltripLockBit;

/** Offset 0x05AE - Shutdown mode
  Disable:Temperature sensor enable.\n
  Enable:Temperature sensor disable
  $EN_DIS
**/
  UINT8                       TsodShutdownMode;

/** Offset 0x05AF - ThighMax
  Thigh = ThighMax (Default is 93)
**/
  UINT8                       TsodThigMax;

/** Offset 0x05B0 - User Manual Thig and Tcrit
  Disabled(Default): Temperature will be given by the configuration of memories and
  1x or 2xrefresh rate.\n
  Enabled: User Input will define for Thigh and Tcrit.
  $EN_DIS
**/
  UINT8                       TsodManualEnable;

/** Offset 0x05B1 - Force OLTM or 2X Refresh when needed
  Disabled(Default): = Force OLTM.\n
  Enabled: = Force 2x Refresh.
  $EN_DIS
**/
  UINT8                       ForceOltmOrRefresh2x;

/** Offset 0x05B2 - Pwr Down Idle Timer
  The minimum value should = to the worst case Roundtrip delay + Burst_Length. 0 means
  AUTO: 64 for ULX/ULT, 128 for DT/Halo
**/
  UINT8                       PwdwnIdleCounter;

/** Offset 0x05B3 - Page Close Idle Timeout
  This option controls Page Close Idle Timeout
  0:Enabled, 1:Disabled
**/
  UINT8                       DisPgCloseIdleTimeout;

/** Offset 0x05B4 - Bitmask of ranks that have CA bus terminated
  Offset 225 LPDDR4: Bitmask of ranks that have CA bus terminated. <b>0x01=Default,
  Rank0 is terminating and Rank1 is non-terminating</b>
**/
  UINT8                       CmdRanksTerminated;

/** Offset 0x05B5 - RMTLoopCount
  Specifies the Loop Count to be used during Rank Margin Tool Testing. 0 - AUTO
**/
  UINT8                       RMTLoopCount;

/** Offset 0x05B6 - Throttler CKEMin Timer for LPDDR
  LPDDR Timer value for CKEMin, range[255;0]. Req'd min of SC_ROUND_T + BYTE_LENGTH
  (4). Dfault is 0x40
**/
  UINT8                       ThrtCkeMinTmrLpddr;

/** Offset 0x05B7 - Retrain on Fast Fail
  Restart MRC in Cold mode if SW MemTest fails during Fast flow. Default = Enabled
  $EN_DIS
**/
  UINT8                       RetrainOnFastFail;

/** Offset 0x05B8 - Rank Margin Tool Per Bit
  Enable/disable Rank Margin Tool Per Bit.
  $EN_DIS
**/
  UINT8                       RMTBIT;

/** Offset 0x05B9 - Read Timing Optimization
  Enables/Disable Read Timing Optimization
  $EN_DIS
**/
  UINT8                       RDTOPT;

/** Offset 0x05BA - REFRESH_PANIC_WM
  Refresh Panic Watermark, range 1-9, Default is 9
**/
  UINT8                       RefreshPanicWm;

/** Offset 0x05BB - REFRESH_HP_WM
  Refresh High Priority Watermark, range 1-9, Default is 8
**/
  UINT8                       RefreshHpWm;

/** Offset 0x05BC - PcdSerialDebugLevel
  Serial Debug Message Level. 0:Disable, 1:Error Only, 2:Error & Warnings, 3:Load,
  Error, Warnings & Info, 4:Load, Error, Warnings, Info & Event, 5:Load, Error, Warnings,
  Info & Verbose.
  0:Disable, 1:Error Only, 2:Error and Warnings, 3:Load Error Warnings and Info, 4:Load
  Error Warnings and Info, 5:Load Error Warnings Info and Verbose
**/
  UINT8                       PcdSerialDebugLevel;

/** Offset 0x05BD - Fivr Faults
  Fivr Faults; 0: Disabled; <b>1: Enabled.</b>
  $EN_DIS
**/
  UINT8                       FivrFaults;

/** Offset 0x05BE - Fivr Efficiency
  Fivr Efficiency Management; 0: Disabled; <b>1: Enabled.</b>
  $EN_DIS
**/
  UINT8                       FivrEfficiency;

/** Offset 0x05BF - Safe Mode Support
  This option configures the varous items in the IO and MC to be more conservative.(def=Disable)
  $EN_DIS
**/
  UINT8                       SafeMode;

/** Offset 0x05C0 - Ask MRC to clear memory content
  Ask MRC to clear memory content <b>0: Do not Clear Memory;</b> 1: Clear Memory.
  $EN_DIS
**/
  UINT8                       CleanMemory;

/** Offset 0x05C1 - TCSS USB Port Enable
  Bitmap for per port enabling
**/
  UINT8                       UsbTcPortEnPreMem;

/** Offset 0x05C2 - Post Code Output Port
  This option configures Post Code Output Port
**/
  UINT16                      PostCodeOutputPort;

/** Offset 0x05C4 - Enable/Disable SA CRID
  Enable: SA CRID, Disable (Default): SA CRID
  $EN_DIS
**/
  UINT8                       CridEnable;

/** Offset 0x05C5
**/
  UINT8                       UnusedUpdSpace17[3];

/** Offset 0x05C8 - BCLK RFI Frequency
  Bclk RFI Frequency for each SAGV point in Hz units. 98000000Hz = 98MHz <b>0 - No
  RFI Tuning</b>. Range is 98Mhz-100Mhz.
**/
  UINT32                      BclkRfiFreq[4];

/** Offset 0x05D8 - Size of PCIe IMR.
  Size of PCIe IMR in megabytes
**/
  UINT16                      PcieImrSize;

/** Offset 0x05DA - Enable PCIe IMR
  0: Disable(AUTO), 1: Enable
  $EN_DIS
**/
  UINT8                       PcieImrEnabled;

/** Offset 0x05DB - Enable PCIe IMR
  1: PCH PCIE, 2: SA PCIE. If PCIeImrEnabled is TRUE then this will use to select
  the Root port location from PCH PCIe or SA PCIe
  $EN_DIS
**/
  UINT8                       PcieImrRpLocation;

/** Offset 0x05DC - Root port number for IMR.
  Root port number for IMR.If PCieImrRpLocation is PCH PCIe then select root port
  from 0 to 23 and if it is SA PCIe then select root port from 0 to 3
**/
  UINT8                       PcieImrRpSelection;

/** Offset 0x05DD - Mem Boot Mode
  0: BOOT_MODE_1LM(Default), 1: BOOT_MODE_2LM, 2: BOOT_MODE_PROVISION
  0: BOOT_MODE_1LM, 1: BOOT_MODE_2LM, 2: BOOT_MODE_PROVISION
**/
  UINT8                       MemBootMode;

/** Offset 0x05DE - PCIe ASPM programming will happen in relation to the Oprom
  This option is specifically needed for ASPM configuration in 2LM feature
  0:Disabled, 1:L0, 2:L1, 3:L0L1, 4:Auto
**/
  UINT8                       Peg3Aspm;

/** Offset 0x05DF - MFVC WRR VC Arbitration
  0: DEFAULT_PHASES(Default), 1: PROGRAM_128PHASES
  0: DEFAULT_PHASES, 1: PROGRAM_128PHASES
**/
  UINT8                       MfvcWrrArb;

/** Offset 0x05E0 - VcId_7_0 values
  Select VC ID for arbitration
**/
  UINT8                       VcId_7_0[16];

/** Offset 0x05F0 - Set Hw Parameters enable/disable
  1: enable, 0: disable, Enable/disable setting of HW parameters
  $EN_DIS
**/
  UINT8                       SetHwParameters;

/** Offset 0x05F1
**/
  UINT8                       UnusedUpdSpace18;

/** Offset 0x05F2 - LTR L1.2 Threshold Value
  LTR L1.2 Threshold Value
**/
  UINT16                      Ltr_L1D2_ThVal;

/** Offset 0x05F4 - LTR L1.2 Threshold Scale
  LTR L1.2 Threshold Scale
**/
  UINT8                       Ltr_L1D2_ThScale;

/** Offset 0x05F5 - system power state
  system power state indicates the platform power state
**/
  UINT8                       SysPwrState;

/** Offset 0x05F6 - Media Death Notification Enable/Disable
  1: enable, 0: disable, Enable/disable for Media Death Notification
  $EN_DIS
**/
  UINT8                       MediaDeathNotification;

/** Offset 0x05F7 - Health Log Notification Enable/Disable
  1: enable, 0: disable, Enable/disable for Health Log Notification
  $EN_DIS
**/
  UINT8                       HealthLogNotification;

/** Offset 0x05F8 - Temp crosses below TempThrottle Notification Enable/Disable
  1: enable, 0: disable, Enable/disable for Temp crosses below TempThrottle Notification
  $EN_DIS
**/
  UINT8                       TempBelowThrottleNotification;

/** Offset 0x05F9 - Temp crosses above TempThrottle Notification Enable/Disable
  1: enable, 0: disable, Enable/disable for Temp crosses above TempThrottle Notification
  $EN_DIS
**/
  UINT8                       TempAboveThrottleNotification;

/** Offset 0x05FA - Missing Commit Bit Notification Enable/Disable
  1: enable, 0: disable, Enable/disable for Missing Commit Bit Notification
  $EN_DIS
**/
  UINT8                       MissingCommitBitNotification;

/** Offset 0x05FB - NVMeHoldDisableBit
  1: enable, 0: disable, Enable/disable for NVMeHoldDisableBit
  $EN_DIS
**/
  UINT8                       NVMeHoldDisableBit;

/** Offset 0x05FC - PreMemRsvd
  Reserved for Pre-Mem
  $EN_DIS
**/
  UINT8                       ReservedFspmUpd[18];

/** Offset 0x060E - Skip external display device scanning
  Enable: Do not scan for external display device, Disable (Default): Scan external
  display devices
  $EN_DIS
**/
  UINT8                       SkipExtGfxScan;

/** Offset 0x060F - Generate BIOS Data ACPI Table
  Enable: Generate BDAT for MRC RMT or SA PCIe data. Disable (Default): Do not generate it
  $EN_DIS
**/
  UINT8                       BdatEnable;

/** Offset 0x0610 - Detect External Graphics device for LegacyOpROM
  Detect and report if external graphics device only support LegacyOpROM or not (to
  support CSM auto-enable). Enable(Default)=1, Disable=0
  $EN_DIS
**/
  UINT8                       ScanExtGfxForLegacyOpRom;

/** Offset 0x0611 - Lock PCU Thermal Management registers
  Lock PCU Thermal Management registers. Enable(Default)=1, Disable=0
  $EN_DIS
**/
  UINT8                       LockPTMregs;

/** Offset 0x0612 - Rsvd
  Disable(0x0)(Default): Normal Operation - RxCTLE adaptive behavior enabled, Enable(0x1):
  Override RxCTLE - Disable RxCTLE adaptive behavior to keep the configured RxCTLE
  peak values unmodified
  $EN_DIS
**/
  UINT8                       PegGen3Rsvd;

/** Offset 0x0613 - Panel Power Enable
  Control for enabling/disabling VDD force bit (Required only for early enabling of
  eDP panel). 0=Disable, 1(Default)=Enable
  $EN_DIS
**/
  UINT8                       PanelPowerEnable;

/** Offset 0x0614 - BdatTestType
  Indicates the type of Memory Training data to populate into the BDAT ACPI table.
  0:RMT per Rank, 1:RMT per Bit, 2:Margin2D
**/
  UINT8                       BdatTestType;

/** Offset 0x0615 - SaPreMemTestRsvd
  Reserved for SA Pre-Mem Test
  $EN_DIS
**/
  UINT8                       SaPreMemTestRsvd[98];

/** Offset 0x0677
**/
  UINT8                       UnusedUpdSpace19;

/** Offset 0x0678 - TotalFlashSize
  Enable/Disable. 0: Disable, define default value of TotalFlashSize , 1: enable
**/
  UINT16                      TotalFlashSize;

/** Offset 0x067A - BiosSize
  Enable/Disable. 0: Disable, define default value of BiosSize , 1: enable
**/
  UINT16                      BiosSize;

/** Offset 0x067C - TxtAcheckRequest
  Enable/Disable. When Enabled, it will forcing calling TXT Acheck once.
  $EN_DIS
**/
  UINT8                       TxtAcheckRequest;

/** Offset 0x067D - SecurityTestRsvd
  Reserved for SA Pre-Mem Test
  $EN_DIS
**/
  UINT8                       SecurityTestRsvd[11];

/** Offset 0x0688 - Smbus dynamic power gating
  Disable or Enable Smbus dynamic power gating.
  $EN_DIS
**/
  UINT8                       SmbusDynamicPowerGating;

/** Offset 0x0689 - Disable and Lock Watch Dog Register
  Set 1 to clear WDT status, then disable and lock WDT registers.
  $EN_DIS
**/
  UINT8                       WdtDisableAndLock;

/** Offset 0x068A - SMBUS SPD Write Disable
  Set/Clear Smbus SPD Write Disable. 0: leave SPD Write Disable bit; 1: set SPD Write
  Disable bit. For security recommendations, SPD write disable bit must be set.
  $EN_DIS
**/
  UINT8                       SmbusSpdWriteDisable;

/** Offset 0x068B - VC Type
  Virtual Channel Type Select: 0: VC0, 1: VC1.
  0: VC0, 1: VC1
**/
  UINT8                       PchHdaVcType;

/** Offset 0x068C - Universal Audio Architecture compliance for DSP enabled system
  0: Not-UAA Compliant (Intel SST driver supported only), 1: UAA Compliant (HDA Inbox
  driver or SST driver supported).
  $EN_DIS
**/
  UINT8                       PchHdaDspUaaCompliance;

/** Offset 0x068D - Enable HD Audio Link
  Enable/disable HD Audio Link. Muxed with SSP0/SSP1/SNDW1.
  $EN_DIS
**/
  UINT8                       PchHdaAudioLinkHdaEnable;

/** Offset 0x068E - Enable HDA SDI lanes
  Enable/disable HDA SDI lanes.
**/
  UINT8                       PchHdaSdiEnable[2];

/** Offset 0x0690 - HDA Power/Clock Gating (PGD/CGD)
  Enable/Disable HD Audio Power and Clock Gating(POR: Enable). 0: PLATFORM_POR, 1:
  FORCE_ENABLE, 2: FORCE_DISABLE.
  0: POR, 1: Force Enable, 2: Force Disable
**/
  UINT8                       PchHdaTestPowerClockGating;

/** Offset 0x0691 - Enable HD Audio DMIC_N Link
  Enable/disable HD Audio DMIC1 link. Muxed with SNDW3.
**/
  UINT8                       PchHdaAudioLinkDmicEnable[2];

/** Offset 0x0693
**/
  UINT8                       UnusedUpdSpace20[1];

/** Offset 0x0694 - DMIC<N> ClkA Pin Muxing (N - DMIC number)
  Determines DMIC<N> ClkA Pin muxing. See  GPIO_*_MUXING_DMIC<N>_CLKA_*
**/
  UINT32                      PchHdaAudioLinkDmicClkAPinMux[2];

/** Offset 0x069C - DMIC<N> ClkB Pin Muxing
  Determines DMIC<N> ClkA Pin muxing. See GPIO_*_MUXING_DMIC<N>_CLKB_*
**/
  UINT32                      PchHdaAudioLinkDmicClkBPinMux[2];

/** Offset 0x06A4 - Enable HD Audio DSP
  Enable/disable HD Audio DSP feature.
  $EN_DIS
**/
  UINT8                       PchHdaDspEnable;

/** Offset 0x06A5
**/
  UINT8                       UnusedUpdSpace21[3];

/** Offset 0x06A8 - DMIC<N> Data Pin Muxing
  Determines DMIC<N> Data Pin muxing. See GPIO_*_MUXING_DMIC<N>_DATA_*
**/
  UINT32                      PchHdaAudioLinkDmicDataPinMux[2];

/** Offset 0x06B0 - Enable HD Audio SSP0 Link
  Enable/disable HD Audio SSP_N/I2S link. Muxed with HDA. N-number 0-5
**/
  UINT8                       PchHdaAudioLinkSspEnable[6];

/** Offset 0x06B6 - Enable HD Audio SoundWire#N Link
  Enable/disable HD Audio SNDW#N link. Muxed with HDA.
**/
  UINT8                       PchHdaAudioLinkSndwEnable[4];

/** Offset 0x06BA - iDisp-Link Frequency
  iDisp-Link Freq (PCH_HDAUDIO_LINK_FREQUENCY enum): 4: 96MHz, 3: 48MHz.
  4: 96MHz, 3: 48MHz
**/
  UINT8                       PchHdaIDispLinkFrequency;

/** Offset 0x06BB - iDisp-Link T-mode
  iDisp-Link T-Mode (PCH_HDAUDIO_IDISP_TMODE enum): 0: 2T, 2: 4T, 3: 8T, 4: 16T
  0: 2T, 2: 4T, 3: 8T, 4: 16T
**/
  UINT8                       PchHdaIDispLinkTmode;

/** Offset 0x06BC - iDisplay Audio Codec disconnection
  0: Not disconnected, enumerable, 1: Disconnected SDI, not enumerable.
  $EN_DIS
**/
  UINT8                       PchHdaIDispCodecDisconnect;

/** Offset 0x06BD - Tcc Tuning enable/disable
  Tcc (Time Coordinated Computing) Tuning Enabled
  $EN_DIS
**/
  UINT8                       TccTuningEnablePreMem;

/** Offset 0x06BE
**/
  UINT8                       UnusedUpdSpace22[2];

/** Offset 0x06C0 - Tcc Buffer Config File Base Address
  Tcc (Time Coordinated Computing) Buffer Config File File Base Address
**/
  UINT32                      TccBufferCfgBase;

/** Offset 0x06C4 - Tcc Buffer Config File Size
  Tcc (Time Coordinated Computing) Buffer Config File Size
**/
  UINT32                      TccBufferCfgSize;

/** Offset 0x06C8 - Tcc BIOS Config File Base Address
  Tcc (Time Coordinated Computing) TCC BIOS Config File Base Address
**/
  UINT32                      TccStreamCfgBasePreMem;

/** Offset 0x06CC - Tcc BIOS Config File Size
  Tcc (Time Coordinated Computing) TCC BIOS Config File Size
**/
  UINT32                      TccStreamCfgSizePreMem;

/** Offset 0x06D0 - Force ME DID Init Status
  Test, 0: disable, 1: Success, 2: No Memory in Channels, 3: Memory Init Error, Set
  ME DID init stat value
  $EN_DIS
**/
  UINT8                       DidInitStat;

/** Offset 0x06D1 - CPU Replaced Polling Disable
  Test, 0: disable, 1: enable, Setting this option disables CPU replacement polling loop
  $EN_DIS
**/
  UINT8                       DisableCpuReplacedPolling;

/** Offset 0x06D2 - ME DID Message
  Test, 0: disable, 1: enable, Enable/Disable ME DID Message (disable will prevent
  the DID message from being sent)
  $EN_DIS
**/
  UINT8                       SendDidMsg;

/** Offset 0x06D3 - Check HECI message before send
  Test, 0: disable, 1: enable, Enable/Disable message check.
  $EN_DIS
**/
  UINT8                       DisableMessageCheck;

/** Offset 0x06D4 - Skip MBP HOB
  Test, 0: disable, 1: enable, Enable/Disable MOB HOB.
  $EN_DIS
**/
  UINT8                       SkipMbpHob;

/** Offset 0x06D5 - HECI2 Interface Communication
  Test, 0: disable, 1: enable, Adds or Removes HECI2 Device from PCI space.
  $EN_DIS
**/
  UINT8                       HeciCommunication2;

/** Offset 0x06D6 - Enable KT device
  Test, 0: disable, 1: enable, Enable or Disable KT device.
  $EN_DIS
**/
  UINT8                       KtDeviceEnable;

/** Offset 0x06D7 - Skip CPU replacement check
  Test, 0: disable, 1: enable, Setting this option to skip CPU replacement check
  $EN_DIS
**/
  UINT8                       SkipCpuReplacementCheck;

/** Offset 0x06D8
**/
  UINT8                       UnusedUpdSpace23[4];

/** Offset 0x06DC
**/
  UINT8                       ReservedFspmUpd2[20];
} FSP_M_CONFIG;

/** Fsp M UPD Configuration
**/
typedef struct {

/** Offset 0x0000
**/
  FSP_UPD_HEADER              FspUpdHeader;

/** Offset 0x0020
**/
  FSPM_ARCH_UPD               FspmArchUpd;

/** Offset 0x0040
**/
  FSP_M_CONFIG                FspmConfig;

/** Offset 0x06F0
**/
  UINT8                       UnusedUpdSpace24[6];

/** Offset 0x06F6
**/
  UINT16                      UpdTerminator;
} FSPM_UPD;

#pragma pack()

#endif
