/*  gnutrition - a nutrition and diet analysis program.
 *  Copyright (C) 2000, 2001 Edgar Denny (e.denny@ic.ac.uk)
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <gnome.h>
#if defined(LIBXML_VERSION) && LIBXML_VERSION >= 20000
	#include <xmlmemory.h>
	#include <libxml/parser.h>
	#include <libxml/tree.h>
	#define root children
	#define childs children
#else
	#include <gnome-xml/parser.h>
	#include <gnome-xml/tree.h>
	#include <gnome-xml/xmlmemory.h>
#endif

#include "load_data.h"
#include "wrap_mysql.h"
#include "person.h"
#include "base_win.h"
#include "gnutr_druid.h"

static void error_message( void);

static void
error_message()
{
	GtkWidget *dlg;
	GtkWidget *label;
	char *message;
	int reply;

	message = g_strconcat( "Failed to connect to the database.\n\n",
		"I suggest that you delete the directory\n ",
		"'~/.gnutrition' and run 'gnutrition' again.", NULL);

	dlg = gnome_dialog_new( "Gnutrition: Cannot Access Database", 
		GNOME_STOCK_BUTTON_OK, NULL);
	label = gtk_label_new( message);
        gtk_box_pack_start( GTK_BOX( GNOME_DIALOG( dlg)->vbox), 
		label, TRUE, TRUE, 5);
	g_free( message);

	gtk_widget_show_all (dlg);

	reply = gnome_dialog_run( GNOME_DIALOG( dlg));

	if ( reply ==0) {
		gtk_widget_hide( dlg);
		exit(2);
	} else {
		gtk_widget_hide( dlg);
		exit(2);
	}
}

void
gnutr_startup()
{
	xmlDocPtr doc;
	xmlNodePtr cur;
	char *home = g_strdup( g_get_home_dir());
	char *fn = g_strconcat( home, "/.gnutrition/mysql_access.xml", NULL);
	char *mysql_username, *mysql_password;
	gboolean success;

#if defined(LIBXML_VERSION) && LIBXML_VERSION >= 20000
	xmlKeepBlanksDefault( 0);
#endif

	/* load the MySQL access file. */
	doc = xmlParseFile( fn);
	g_free( fn);
	g_free( home);

	/* make a series of checks. */
	if ( !doc) error_message();

	cur = doc->root;
	if ( !cur) {
		g_warning( "empty document.");
		xmlFreeDoc( doc);
		error_message();
	}

	if ( strcmp( cur->name, "Gnutrition") != 0 ) {
		g_warning( "document of the wrong type.");
		xmlFreeDoc( doc);
		error_message();
	}

	cur = cur->childs;
	if ( strcmp( cur->name, "MySQL_Access") != 0 ) {
		g_warning( "document of the wrong type.");
		xmlFreeDoc( doc);
		error_message();
	}

	/* get data from file. */
	cur = cur->childs;
	mysql_username = xmlNodeListGetString( doc, cur->childs, 1);
	cur = cur->next;
	mysql_password = xmlNodeListGetString( doc, cur->childs, 1);

	/* connect to database. */
	success = connect_db( mysql_username, mysql_password);

	if ( !success) error_message();

	/* change to the "gnutr_db". */
	success = change_user_db( mysql_username, mysql_password, "gnutr_db");

	if ( !success) error_message();

	/* create a set of tempory database tables. */
	gnutr_user_initialize();

	xmlFreeDoc (doc);
}
