/*
 * $Id: SerializationTestPerform.java,v 1.1 1998/10/28 23:11:47 metlov Exp $
 * This tests serialization of expressions.
 *
 * Basically, if the main TestSuite is passing there should not be any
 * problem with expressions serialization.
 *
 * To perform this test first compile and run SerializationTestPrepare
 * which will create serializetest.dat file. Then compile and 
 * run SerializationTestPerform program which will read and evaluate
 * expression from the serializetest.dat file.
 *
 */

package gnu.jel.tests;

import gnu.jel.ExpressionBits;
import gnu.jel.CompiledExpression;
import java.io.ObjectInputStream;
import java.io.FileInputStream;
import java.io.IOException;

public class SerializationTestPerform {
  public static void main(String[] args) {
    try {
      FileInputStream fis=new FileInputStream("serializetest.dat");
      ObjectInputStream ois=new ObjectInputStream(fis);

      Object[] variables=new Object[1];
      VariableProvider vp=new VariableProvider();
      variables[0]=vp;

      // Set up current values of variables
      vp.x=5.0;

      ExpressionBits eb;
      CompiledExpression ce;

      System.out.println("You should see three OKs after this line.");

      // Testing the first expression
      eb=(ExpressionBits)ois.readObject();
      ce=eb.getExpression();

      if (ce.evaluate_double(variables)==12.0) 
	System.out.println("OK");
      else
	System.out.println("FAIL");


      // Testing the second expression
      eb=(ExpressionBits)ois.readObject();
      ce=eb.getExpression();

      if (ce.evaluate(variables).equals(new Double(5.0)))
	System.out.println("OK");
      else
	System.out.println("FAIL");

      // Testing the third expression
      eb=(ExpressionBits)ois.readObject();
      ce=eb.getExpression();

      if (ce.evaluate(variables).equals(new Double(2.0)))
	System.out.println("OK");
      else
	System.out.println("FAIL");

      // END

      fis.close();
      
    } catch(Throwable e) {
      System.out.println(e);
    };

  };
};
