/*
 * Decompiled with CFR 0.152.
 */
package gnu.jel;

import gnu.jel.ClassFile;
import gnu.jel.CompilationException;
import gnu.jel.CompiledExpression;
import gnu.jel.ImageLoader;
import gnu.jel.Library;
import gnu.jel.OPlist;
import gnu.jel.OPunary;
import gnu.jel.TypesStack;
import gnu.jel.debug.Debug;
import gnu.jel.generated.EC;
import gnu.jel.reflect.LocalMethod;
import gnu.jel.reflect.Method;
import java.io.StringReader;

public class Evaluator {
    protected static ClassFile cf_orig;
    protected static int retID_patchback;
    protected static LocalMethod[] eval_methods;

    static {
        retID_patchback = 0;
        eval_methods = new LocalMethod[TypesStack.primitiveTypes.length];
        try {
            Class[] paramsE = new Class[]{new Object[0].getClass()};
            int i = 0;
            while (i < TypesStack.primitiveTypes.length - 1) {
                String name = "evaluate";
                Class<?> cls = TypesStack.primitiveTypes[i];
                if (i != 8) {
                    name = String.valueOf(name) + '_' + TypesStack.primitiveTypeNames[i];
                } else {
                    cls = new Object().getClass();
                }
                Evaluator.eval_methods[i] = new LocalMethod(1, cls, name, paramsE, null);
                ++i;
            }
            Class<?> cmplExpr = Class.forName("gnu.jel.CompiledExpression");
            ClassFile cf = new ClassFile(1, "dump", cmplExpr, null, null);
            LocalMethod cnstr = new LocalMethod(1, Void.TYPE, "<init>", null, null);
            cf.newMethod(cnstr, null);
            cf.code(42);
            cf.typesStk.push(null);
            Method supInit = new Method(cmplExpr.getConstructor(new Class[0]));
            cf.code(183);
            cf.codeI(cf.getIndex(supInit, 10));
            cf.typesStk.pop();
            cf.code(177);
            LocalMethod getType = new LocalMethod(1, Integer.TYPE, "getType", null, null);
            cf.newMethod(getType, null);
            cf.code(16);
            retID_patchback = cf.textData.size();
            cf.code(8);
            cf.typesStk.push(Integer.TYPE);
            cf.code(172);
            cf.typesStk.pop();
            cf_orig = (ClassFile)cf.clone();
        }
        catch (Exception exc) {
            Debug.reportThrowable(exc);
        }
    }

    public static CompiledExpression compile(String expression, Library lib) throws CompilationException {
        return Evaluator.compile(expression, lib, null);
    }

    public static CompiledExpression compile(String expression, Library lib, Class resultType) throws CompilationException {
        byte[] image = Evaluator.compileBits(expression, lib, resultType);
        try {
            return (CompiledExpression)ImageLoader.load(image).newInstance();
        }
        catch (Exception exc) {
            Debug.reportThrowable(exc);
            return null;
        }
    }

    public static byte[] compileBits(String expression, Library lib) throws CompilationException {
        return Evaluator.compileBits(expression, lib, null);
    }

    public static byte[] compileBits(String expression, Library lib, Class resultType) throws CompilationException {
        return Evaluator.getImage(Evaluator.parse(expression, lib, resultType));
    }

    protected static byte[] getImage(OPlist list) {
        int retID = ((OPunary)list.getLast()).resID;
        ClassFile cf = (ClassFile)cf_orig.clone();
        cf.textData.patchAddress(retID_patchback, (byte)retID);
        cf.newMethod(eval_methods[retID], null);
        list.compile(cf);
        return cf.getImage();
    }

    protected static OPlist parse(String expression, Library lib, Class resultType) throws CompilationException {
        return new EC(new StringReader(expression)).parse(resultType, lib);
    }
}

