/* sim.h

   originally written by Don Maszle

   Copyright (c) 1993.  Don Maszle, Frederic Bois.  All rights reserved.

   -- Revisions -----
     Logfile:  SCCS/s.simhelp.h
    Revision:  1.4
        Date:  28 Jan 1995
     Modtime:  03:43:58
      Author:  @a
   -- SCCS  ---------

   Header file for simhelp.c
*/

#ifndef _SIMHELP_H_
#define _SIMHELP_H_

/* -----------------------------------------------------------------------------
   Inclusions
*/

#include "hungtype.h"


/* -----------------------------------------------------------------------------
   Constants
*/

#define MAX_HELP_LINE 100        /* Length of help line */
#define MAX_KEYWORD   40         /* Length of help key */
#define NO_MATCH      (-1)


/* -----------------------------------------------------------------------------
   Typedefs
*/

typedef enum tagSOF_FLAGS {
  SOF_READ
} SOF_FLAGS;


/* -----------------------------------------------------------------------------
   Prototypes
*/

BOOL FindNextMatch (FILE *pfileHelp, char *szTestKeyword);
char *IgnoreCase_strstr (char *szSearch, char *szSub);
void MoreToNextTopic (FILE *pfile);
char PauseForKey (char *szKeys);
void ShowHelp (char *szKeyword);
void ShowHelpMessage (char *const szProgName);
void ShowTopics (FILE *pfileHelp);
int  SimOpenFile (FILE **ppfile, char *szFilename, SOF_FLAGS sofFlags);

#endif /* _SIMHELP_H_ */

/* End */

