/*  Motti -- a strategy game
    Copyright (C) 1999-2010 Free Software Foundation

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
#pragma once
#include <string>
#include <iostream>

class Serializer
{
	public:
	Serializer();
	~Serializer();
	Serializer &operator <<(const bool  &b) ;
	Serializer &operator <<(const int  &b) ;
	Serializer &operator <<(const long  &b) ;
	Serializer &operator <<(const double  &b) ;
	Serializer &operator <<(const std::string & b) ;


	Serializer &operator >>( bool  &b) ;
	Serializer &operator >>( int  &b) ;
	Serializer &operator >>( long  &b) ;
	Serializer &operator >>( double  &b) ;
	Serializer &operator >>( std::string & b) ;

	void saveFile (std::string);
	void readFile (std::string);
	friend std::istream& operator>> (std::istream& out, Serializer& per);
	friend std::ostream& operator<< (std::ostream& out, Serializer& per);
	
private :
	unsigned char INT_TYPE;
	unsigned char LONG_TYPE;
	unsigned char STRING_TYPE;
	unsigned char DOUBLE_TYPE;
	unsigned char *data_;
	size_t size_; 
	void addEnd( unsigned char &);
	unsigned char readBegin();
	unsigned char verifyBegin();
};

