#! /bin/sh

TEMPDIR=/tmp/pspp-tst-$$
mkdir -p $TEMPDIR
trap 'cd /; rm -rf $TEMPDIR' 0

# ensure that top_builddir  are absolute
if [ -z "$top_builddir" ] ; then top_builddir=. ; fi
if [ -z "$top_srcdir" ] ; then top_srcdir=. ; fi
top_builddir=`cd $top_builddir; pwd`
PSPP=$top_builddir/src/ui/terminal/pspp

# ensure that top_srcdir is absolute
top_srcdir=`cd $top_srcdir; pwd`

STAT_CONFIG_PATH=$top_srcdir/config
export STAT_CONFIG_PATH

fail()
{
    echo $activity
    echo FAILED
    exit 1;
}


no_result()
{
    echo $activity
    echo NO RESULT;
    exit 2;
}

pass()
{
    exit 0;
}

cd $TEMPDIR

activity="write pspp syntax"
cat > time-out.pspp <<EOF
set epoch=1930.
data list /x 1-30 (dtime).
begin data.
0 0:0:0
0 4:50:38.12301
0 12:31:35.23453
0 12:47:53.34505
0 1:26:0.45615
0 20:58:11.56677
0 7:36:5.18964
0 15:43:49.83132
0 4:25:9.01293
0 6:49:27.52375
0 2:57:52.01565
0 16:45:44.86529
0 21:30:57.82047
0 4:25:9.15395
0 6:49:27.10533
0 2:57:52.48229
0 16:45:44.65827
0 21:30:57.58219
0 22:30:4.18347
0 1:56:51.59319
1 0:0:0
1 4:50:38.12301
1 12:31:35.23453
1 12:47:53.34505
1 1:26:0.45615
1 20:58:11.56677
1 7:36:5.18964
1 15:43:49.83132
1 4:25:9.01293
1 6:49:27.52375
1 2:57:52.01565
1 16:45:44.86529
1 21:30:57.82047
1 4:25:9.15395
1 6:49:27.10533
1 2:57:52.48229
1 16:45:44.65827
1 21:30:57.58219
1 22:30:4.18347
1 1:56:51.59319
2 0:0:0
2 4:50:38.12301
2 12:31:35.23453
2 12:47:53.34505
2 1:26:0.45615
2 20:58:11.56677
2 7:36:5.18964
2 15:43:49.83132
2 4:25:9.01293
2 6:49:27.52375
2 2:57:52.01565
2 16:45:44.86529
2 21:30:57.82047
2 4:25:9.15395
2 6:49:27.10533
2 2:57:52.48229
2 16:45:44.65827
2 21:30:57.58219
2 22:30:4.18347
2 1:56:51.59319
54 0:0:0
54 4:50:38.12301
54 12:31:35.23453
54 12:47:53.34505
54 1:26:0.45615
54 20:58:11.56677
54 7:36:5.18964
54 15:43:49.83132
54 4:25:9.01293
54 6:49:27.52375
54 2:57:52.01565
54 16:45:44.86529
54 21:30:57.82047
54 4:25:9.15395
54 6:49:27.10533
54 2:57:52.48229
54 16:45:44.65827
54 21:30:57.58219
54 22:30:4.18347
54 1:56:51.59319
681 0:0:0
681 4:50:38.12301
681 12:31:35.23453
681 12:47:53.34505
681 1:26:0.45615
681 20:58:11.56677
681 7:36:5.18964
681 15:43:49.83132
681 4:25:9.01293
681 6:49:27.52375
681 2:57:52.01565
681 16:45:44.86529
681 21:30:57.82047
681 4:25:9.15395
681 6:49:27.10533
681 2:57:52.48229
681 16:45:44.65827
681 21:30:57.58219
681 22:30:4.18347
681 1:56:51.59319
-0 0:0:0
-0 4:50:38.12301
-0 12:31:35.23453
-0 12:47:53.34505
-0 1:26:0.45615
-0 20:58:11.56677
-0 7:36:5.18964
-0 15:43:49.83132
-0 4:25:9.01293
-0 6:49:27.52375
-0 2:57:52.01565
-0 16:45:44.86529
-0 21:30:57.82047
-0 4:25:9.15395
-0 6:49:27.10533
-0 2:57:52.48229
-0 16:45:44.65827
-0 21:30:57.58219
-0 22:30:4.18347
-0 1:56:51.59319
-1 0:0:0
-1 4:50:38.12301
-1 12:31:35.23453
-1 12:47:53.34505
-1 1:26:0.45615
-1 20:58:11.56677
-1 7:36:5.18964
-1 15:43:49.83132
-1 4:25:9.01293
-1 6:49:27.52375
-1 2:57:52.01565
-1 16:45:44.86529
-1 21:30:57.82047
-1 4:25:9.15395
-1 6:49:27.10533
-1 2:57:52.48229
-1 16:45:44.65827
-1 21:30:57.58219
-1 22:30:4.18347
-1 1:56:51.59319
-2 0:0:0
-2 4:50:38.12301
-2 12:31:35.23453
-2 12:47:53.34505
-2 1:26:0.45615
-2 20:58:11.56677
-2 7:36:5.18964
-2 15:43:49.83132
-2 4:25:9.01293
-2 6:49:27.52375
-2 2:57:52.01565
-2 16:45:44.86529
-2 21:30:57.82047
-2 4:25:9.15395
-2 6:49:27.10533
-2 2:57:52.48229
-2 16:45:44.65827
-2 21:30:57.58219
-2 22:30:4.18347
-2 1:56:51.59319
-54 0:0:0
-54 4:50:38.12301
-54 12:31:35.23453
-54 12:47:53.34505
-54 1:26:0.45615
-54 20:58:11.56677
-54 7:36:5.18964
-54 15:43:49.83132
-54 4:25:9.01293
-54 6:49:27.52375
-54 2:57:52.01565
-54 16:45:44.86529
-54 21:30:57.82047
-54 4:25:9.15395
-54 6:49:27.10533
-54 2:57:52.48229
-54 16:45:44.65827
-54 21:30:57.58219
-54 22:30:4.18347
-54 1:56:51.59319
-681 0:0:0
-681 4:50:38.12301
-681 12:31:35.23453
-681 12:47:53.34505
-681 1:26:0.45615
-681 20:58:11.56677
-681 7:36:5.18964
-681 15:43:49.83132
-681 4:25:9.01293
-681 6:49:27.52375
-681 2:57:52.01565
-681 16:45:44.86529
-681 21:30:57.82047
-681 4:25:9.15395
-681 6:49:27.10533
-681 2:57:52.48229
-681 16:45:44.65827
-681 21:30:57.58219
-681 22:30:4.18347
-681 1:56:51.59319
end data.
print outfile='time-out.out'/x(time5).
print outfile='time-out.out'/x(time6).
print outfile='time-out.out'/x(time7).
print outfile='time-out.out'/x(time8).
print outfile='time-out.out'/x(time9).
print outfile='time-out.out'/x(time10).
print outfile='time-out.out'/x(time10.1).
print outfile='time-out.out'/x(time11).
print outfile='time-out.out'/x(time11.1).
print outfile='time-out.out'/x(time11.2).
print outfile='time-out.out'/x(time12).
print outfile='time-out.out'/x(time12.1).
print outfile='time-out.out'/x(time12.2).
print outfile='time-out.out'/x(time12.3).
print outfile='time-out.out'/x(time13).
print outfile='time-out.out'/x(time13.1).
print outfile='time-out.out'/x(time13.2).
print outfile='time-out.out'/x(time13.3).
print outfile='time-out.out'/x(time13.4).
print outfile='time-out.out'/x(time14).
print outfile='time-out.out'/x(time14.1).
print outfile='time-out.out'/x(time14.2).
print outfile='time-out.out'/x(time14.3).
print outfile='time-out.out'/x(time14.4).
print outfile='time-out.out'/x(time14.5).
print outfile='time-out.out'/x(time15).
print outfile='time-out.out'/x(time15.1).
print outfile='time-out.out'/x(time15.2).
print outfile='time-out.out'/x(time15.3).
print outfile='time-out.out'/x(time15.4).
print outfile='time-out.out'/x(time15.5).
print outfile='time-out.out'/x(time15.6).
print outfile='time-out.out'/x(dtime8).
print outfile='time-out.out'/x(dtime9).
print outfile='time-out.out'/x(dtime10).
print outfile='time-out.out'/x(dtime11).
print outfile='time-out.out'/x(dtime12).
print outfile='time-out.out'/x(dtime13).
print outfile='time-out.out'/x(dtime13.1).
print outfile='time-out.out'/x(dtime14).
print outfile='time-out.out'/x(dtime14.1).
print outfile='time-out.out'/x(dtime14.2).
print outfile='time-out.out'/x(dtime15).
print outfile='time-out.out'/x(dtime15.1).
print outfile='time-out.out'/x(dtime15.2).
print outfile='time-out.out'/x(dtime15.3).
print outfile='time-out.out'/x(dtime16).
print outfile='time-out.out'/x(dtime16.1).
print outfile='time-out.out'/x(dtime16.2).
print outfile='time-out.out'/x(dtime16.3).
print outfile='time-out.out'/x(dtime16.4).
print outfile='time-out.out'/x(dtime17).
print outfile='time-out.out'/x(dtime17.1).
print outfile='time-out.out'/x(dtime17.2).
print outfile='time-out.out'/x(dtime17.3).
print outfile='time-out.out'/x(dtime17.4).
print outfile='time-out.out'/x(dtime17.5).
print outfile='time-out.out'/x(dtime18).
print outfile='time-out.out'/x(dtime18.1).
print outfile='time-out.out'/x(dtime18.2).
print outfile='time-out.out'/x(dtime18.3).
print outfile='time-out.out'/x(dtime18.4).
print outfile='time-out.out'/x(dtime18.5).
print outfile='time-out.out'/x(dtime18.6).
execute.
EOF
if [ $? -ne 0 ] ; then no_result ; fi

activity="run program"
$SUPERVISOR $PSPP --testing-mode time-out.pspp
if [ $? -ne 0 ] ; then no_result ; fi

activity="compare output"
diff -u time-out.out - <<EOF 
  0:00
   0:00
 0:00:00
  0:00:00
   0:00:00
    0:00:00
  0:00:00.0
     0:00:00
   0:00:00.0
  0:00:00.00
      0:00:00
    0:00:00.0
   0:00:00.00
  0:00:00.000
       0:00:00
     0:00:00.0
    0:00:00.00
   0:00:00.000
  0:00:00.0000
        0:00:00
      0:00:00.0
     0:00:00.00
    0:00:00.000
   0:00:00.0000
  0:00:00.00000
         0:00:00
       0:00:00.0
      0:00:00.00
     0:00:00.000
    0:00:00.0000
   0:00:00.00000
  0:00:00.000000
  0 00:00
   0 00:00
 0 00:00:00
  0 00:00:00
   0 00:00:00
    0 00:00:00
  0 00:00:00.0
     0 00:00:00
   0 00:00:00.0
  0 00:00:00.00
      0 00:00:00
    0 00:00:00.0
   0 00:00:00.00
  0 00:00:00.000
       0 00:00:00
     0 00:00:00.0
    0 00:00:00.00
   0 00:00:00.000
  0 00:00:00.0000
        0 00:00:00
      0 00:00:00.0
     0 00:00:00.00
    0 00:00:00.000
   0 00:00:00.0000
  0 00:00:00.00000
         0 00:00:00
       0 00:00:00.0
      0 00:00:00.00
     0 00:00:00.000
    0 00:00:00.0000
   0 00:00:00.00000
  0 00:00:00.000000
  4:50
   4:50
 4:50:38
  4:50:38
   4:50:38
    4:50:38
  4:50:38.1
     4:50:38
   4:50:38.1
  4:50:38.12
      4:50:38
    4:50:38.1
   4:50:38.12
  4:50:38.123
       4:50:38
     4:50:38.1
    4:50:38.12
   4:50:38.123
  4:50:38.1230
        4:50:38
      4:50:38.1
     4:50:38.12
    4:50:38.123
   4:50:38.1230
  4:50:38.12301
         4:50:38
       4:50:38.1
      4:50:38.12
     4:50:38.123
    4:50:38.1230
   4:50:38.12301
  4:50:38.123010
  0 04:50
   0 04:50
 0 04:50:38
  0 04:50:38
   0 04:50:38
    0 04:50:38
  0 04:50:38.1
     0 04:50:38
   0 04:50:38.1
  0 04:50:38.12
      0 04:50:38
    0 04:50:38.1
   0 04:50:38.12
  0 04:50:38.123
       0 04:50:38
     0 04:50:38.1
    0 04:50:38.12
   0 04:50:38.123
  0 04:50:38.1230
        0 04:50:38
      0 04:50:38.1
     0 04:50:38.12
    0 04:50:38.123
   0 04:50:38.1230
  0 04:50:38.12301
         0 04:50:38
       0 04:50:38.1
      0 04:50:38.12
     0 04:50:38.123
    0 04:50:38.1230
   0 04:50:38.12301
  0 04:50:38.123010
 12:31
  12:31
   12:31
 12:31:35
  12:31:35
   12:31:35
 12:31:35.2
    12:31:35
  12:31:35.2
 12:31:35.23
     12:31:35
   12:31:35.2
  12:31:35.23
 12:31:35.235
      12:31:35
    12:31:35.2
   12:31:35.23
  12:31:35.235
 12:31:35.2345
       12:31:35
     12:31:35.2
    12:31:35.23
   12:31:35.235
  12:31:35.2345
 12:31:35.23453
        12:31:35
      12:31:35.2
     12:31:35.23
    12:31:35.235
   12:31:35.2345
  12:31:35.23453
 12:31:35.234530
  0 12:31
   0 12:31
 0 12:31:35
  0 12:31:35
   0 12:31:35
    0 12:31:35
  0 12:31:35.2
     0 12:31:35
   0 12:31:35.2
  0 12:31:35.23
      0 12:31:35
    0 12:31:35.2
   0 12:31:35.23
  0 12:31:35.235
       0 12:31:35
     0 12:31:35.2
    0 12:31:35.23
   0 12:31:35.235
  0 12:31:35.2345
        0 12:31:35
      0 12:31:35.2
     0 12:31:35.23
    0 12:31:35.235
   0 12:31:35.2345
  0 12:31:35.23453
         0 12:31:35
       0 12:31:35.2
      0 12:31:35.23
     0 12:31:35.235
    0 12:31:35.2345
   0 12:31:35.23453
  0 12:31:35.234530
 12:47
  12:47
   12:47
 12:47:53
  12:47:53
   12:47:53
 12:47:53.3
    12:47:53
  12:47:53.3
 12:47:53.35
     12:47:53
   12:47:53.3
  12:47:53.35
 12:47:53.345
      12:47:53
    12:47:53.3
   12:47:53.35
  12:47:53.345
 12:47:53.3451
       12:47:53
     12:47:53.3
    12:47:53.35
   12:47:53.345
  12:47:53.3451
 12:47:53.34505
        12:47:53
      12:47:53.3
     12:47:53.35
    12:47:53.345
   12:47:53.3451
  12:47:53.34505
 12:47:53.345050
  0 12:47
   0 12:47
 0 12:47:53
  0 12:47:53
   0 12:47:53
    0 12:47:53
  0 12:47:53.3
     0 12:47:53
   0 12:47:53.3
  0 12:47:53.35
      0 12:47:53
    0 12:47:53.3
   0 12:47:53.35
  0 12:47:53.345
       0 12:47:53
     0 12:47:53.3
    0 12:47:53.35
   0 12:47:53.345
  0 12:47:53.3451
        0 12:47:53
      0 12:47:53.3
     0 12:47:53.35
    0 12:47:53.345
   0 12:47:53.3451
  0 12:47:53.34505
         0 12:47:53
       0 12:47:53.3
      0 12:47:53.35
     0 12:47:53.345
    0 12:47:53.3451
   0 12:47:53.34505
  0 12:47:53.345050
  1:26
   1:26
 1:26:00
  1:26:00
   1:26:00
    1:26:00
  1:26:00.5
     1:26:00
   1:26:00.5
  1:26:00.46
      1:26:00
    1:26:00.5
   1:26:00.46
  1:26:00.456
       1:26:00
     1:26:00.5
    1:26:00.46
   1:26:00.456
  1:26:00.4561
        1:26:00
      1:26:00.5
     1:26:00.46
    1:26:00.456
   1:26:00.4561
  1:26:00.45615
         1:26:00
       1:26:00.5
      1:26:00.46
     1:26:00.456
    1:26:00.4561
   1:26:00.45615
  1:26:00.456150
  0 01:26
   0 01:26
 0 01:26:00
  0 01:26:00
   0 01:26:00
    0 01:26:00
  0 01:26:00.5
     0 01:26:00
   0 01:26:00.5
  0 01:26:00.46
      0 01:26:00
    0 01:26:00.5
   0 01:26:00.46
  0 01:26:00.456
       0 01:26:00
     0 01:26:00.5
    0 01:26:00.46
   0 01:26:00.456
  0 01:26:00.4561
        0 01:26:00
      0 01:26:00.5
     0 01:26:00.46
    0 01:26:00.456
   0 01:26:00.4561
  0 01:26:00.45615
         0 01:26:00
       0 01:26:00.5
      0 01:26:00.46
     0 01:26:00.456
    0 01:26:00.4561
   0 01:26:00.45615
  0 01:26:00.456150
 20:58
  20:58
   20:58
 20:58:11
  20:58:11
   20:58:11
 20:58:11.6
    20:58:11
  20:58:11.6
 20:58:11.57
     20:58:11
   20:58:11.6
  20:58:11.57
 20:58:11.567
      20:58:11
    20:58:11.6
   20:58:11.57
  20:58:11.567
 20:58:11.5668
       20:58:11
     20:58:11.6
    20:58:11.57
   20:58:11.567
  20:58:11.5668
 20:58:11.56677
        20:58:11
      20:58:11.6
     20:58:11.57
    20:58:11.567
   20:58:11.5668
  20:58:11.56677
 20:58:11.566770
  0 20:58
   0 20:58
 0 20:58:11
  0 20:58:11
   0 20:58:11
    0 20:58:11
  0 20:58:11.6
     0 20:58:11
   0 20:58:11.6
  0 20:58:11.57
      0 20:58:11
    0 20:58:11.6
   0 20:58:11.57
  0 20:58:11.567
       0 20:58:11
     0 20:58:11.6
    0 20:58:11.57
   0 20:58:11.567
  0 20:58:11.5668
        0 20:58:11
      0 20:58:11.6
     0 20:58:11.57
    0 20:58:11.567
   0 20:58:11.5668
  0 20:58:11.56677
         0 20:58:11
       0 20:58:11.6
      0 20:58:11.57
     0 20:58:11.567
    0 20:58:11.5668
   0 20:58:11.56677
  0 20:58:11.566770
  7:36
   7:36
 7:36:05
  7:36:05
   7:36:05
    7:36:05
  7:36:05.2
     7:36:05
   7:36:05.2
  7:36:05.19
      7:36:05
    7:36:05.2
   7:36:05.19
  7:36:05.190
       7:36:05
     7:36:05.2
    7:36:05.19
   7:36:05.190
  7:36:05.1896
        7:36:05
      7:36:05.2
     7:36:05.19
    7:36:05.190
   7:36:05.1896
  7:36:05.18964
         7:36:05
       7:36:05.2
      7:36:05.19
     7:36:05.190
    7:36:05.1896
   7:36:05.18964
  7:36:05.189640
  0 07:36
   0 07:36
 0 07:36:05
  0 07:36:05
   0 07:36:05
    0 07:36:05
  0 07:36:05.2
     0 07:36:05
   0 07:36:05.2
  0 07:36:05.19
      0 07:36:05
    0 07:36:05.2
   0 07:36:05.19
  0 07:36:05.190
       0 07:36:05
     0 07:36:05.2
    0 07:36:05.19
   0 07:36:05.190
  0 07:36:05.1896
        0 07:36:05
      0 07:36:05.2
     0 07:36:05.19
    0 07:36:05.190
   0 07:36:05.1896
  0 07:36:05.18964
         0 07:36:05
       0 07:36:05.2
      0 07:36:05.19
     0 07:36:05.190
    0 07:36:05.1896
   0 07:36:05.18964
  0 07:36:05.189640
 15:43
  15:43
   15:43
 15:43:49
  15:43:49
   15:43:49
 15:43:49.8
    15:43:49
  15:43:49.8
 15:43:49.83
     15:43:49
   15:43:49.8
  15:43:49.83
 15:43:49.831
      15:43:49
    15:43:49.8
   15:43:49.83
  15:43:49.831
 15:43:49.8313
       15:43:49
     15:43:49.8
    15:43:49.83
   15:43:49.831
  15:43:49.8313
 15:43:49.83132
        15:43:49
      15:43:49.8
     15:43:49.83
    15:43:49.831
   15:43:49.8313
  15:43:49.83132
 15:43:49.831320
  0 15:43
   0 15:43
 0 15:43:49
  0 15:43:49
   0 15:43:49
    0 15:43:49
  0 15:43:49.8
     0 15:43:49
   0 15:43:49.8
  0 15:43:49.83
      0 15:43:49
    0 15:43:49.8
   0 15:43:49.83
  0 15:43:49.831
       0 15:43:49
     0 15:43:49.8
    0 15:43:49.83
   0 15:43:49.831
  0 15:43:49.8313
        0 15:43:49
      0 15:43:49.8
     0 15:43:49.83
    0 15:43:49.831
   0 15:43:49.8313
  0 15:43:49.83132
         0 15:43:49
       0 15:43:49.8
      0 15:43:49.83
     0 15:43:49.831
    0 15:43:49.8313
   0 15:43:49.83132
  0 15:43:49.831320
  4:25
   4:25
 4:25:09
  4:25:09
   4:25:09
    4:25:09
  4:25:09.0
     4:25:09
   4:25:09.0
  4:25:09.01
      4:25:09
    4:25:09.0
   4:25:09.01
  4:25:09.013
       4:25:09
     4:25:09.0
    4:25:09.01
   4:25:09.013
  4:25:09.0129
        4:25:09
      4:25:09.0
     4:25:09.01
    4:25:09.013
   4:25:09.0129
  4:25:09.01293
         4:25:09
       4:25:09.0
      4:25:09.01
     4:25:09.013
    4:25:09.0129
   4:25:09.01293
  4:25:09.012930
  0 04:25
   0 04:25
 0 04:25:09
  0 04:25:09
   0 04:25:09
    0 04:25:09
  0 04:25:09.0
     0 04:25:09
   0 04:25:09.0
  0 04:25:09.01
      0 04:25:09
    0 04:25:09.0
   0 04:25:09.01
  0 04:25:09.013
       0 04:25:09
     0 04:25:09.0
    0 04:25:09.01
   0 04:25:09.013
  0 04:25:09.0129
        0 04:25:09
      0 04:25:09.0
     0 04:25:09.01
    0 04:25:09.013
   0 04:25:09.0129
  0 04:25:09.01293
         0 04:25:09
       0 04:25:09.0
      0 04:25:09.01
     0 04:25:09.013
    0 04:25:09.0129
   0 04:25:09.01293
  0 04:25:09.012930
  6:49
   6:49
 6:49:27
  6:49:27
   6:49:27
    6:49:27
  6:49:27.5
     6:49:27
   6:49:27.5
  6:49:27.52
      6:49:27
    6:49:27.5
   6:49:27.52
  6:49:27.524
       6:49:27
     6:49:27.5
    6:49:27.52
   6:49:27.524
  6:49:27.5238
        6:49:27
      6:49:27.5
     6:49:27.52
    6:49:27.524
   6:49:27.5238
  6:49:27.52375
         6:49:27
       6:49:27.5
      6:49:27.52
     6:49:27.524
    6:49:27.5238
   6:49:27.52375
  6:49:27.523750
  0 06:49
   0 06:49
 0 06:49:27
  0 06:49:27
   0 06:49:27
    0 06:49:27
  0 06:49:27.5
     0 06:49:27
   0 06:49:27.5
  0 06:49:27.52
      0 06:49:27
    0 06:49:27.5
   0 06:49:27.52
  0 06:49:27.524
       0 06:49:27
     0 06:49:27.5
    0 06:49:27.52
   0 06:49:27.524
  0 06:49:27.5238
        0 06:49:27
      0 06:49:27.5
     0 06:49:27.52
    0 06:49:27.524
   0 06:49:27.5238
  0 06:49:27.52375
         0 06:49:27
       0 06:49:27.5
      0 06:49:27.52
     0 06:49:27.524
    0 06:49:27.5238
   0 06:49:27.52375
  0 06:49:27.523750
  2:57
   2:57
 2:57:52
  2:57:52
   2:57:52
    2:57:52
  2:57:52.0
     2:57:52
   2:57:52.0
  2:57:52.02
      2:57:52
    2:57:52.0
   2:57:52.02
  2:57:52.016
       2:57:52
     2:57:52.0
    2:57:52.02
   2:57:52.016
  2:57:52.0156
        2:57:52
      2:57:52.0
     2:57:52.02
    2:57:52.016
   2:57:52.0156
  2:57:52.01565
         2:57:52
       2:57:52.0
      2:57:52.02
     2:57:52.016
    2:57:52.0156
   2:57:52.01565
  2:57:52.015650
  0 02:57
   0 02:57
 0 02:57:52
  0 02:57:52
   0 02:57:52
    0 02:57:52
  0 02:57:52.0
     0 02:57:52
   0 02:57:52.0
  0 02:57:52.02
      0 02:57:52
    0 02:57:52.0
   0 02:57:52.02
  0 02:57:52.016
       0 02:57:52
     0 02:57:52.0
    0 02:57:52.02
   0 02:57:52.016
  0 02:57:52.0156
        0 02:57:52
      0 02:57:52.0
     0 02:57:52.02
    0 02:57:52.016
   0 02:57:52.0156
  0 02:57:52.01565
         0 02:57:52
       0 02:57:52.0
      0 02:57:52.02
     0 02:57:52.016
    0 02:57:52.0156
   0 02:57:52.01565
  0 02:57:52.015650
 16:45
  16:45
   16:45
 16:45:44
  16:45:44
   16:45:44
 16:45:44.9
    16:45:44
  16:45:44.9
 16:45:44.87
     16:45:44
   16:45:44.9
  16:45:44.87
 16:45:44.865
      16:45:44
    16:45:44.9
   16:45:44.87
  16:45:44.865
 16:45:44.8653
       16:45:44
     16:45:44.9
    16:45:44.87
   16:45:44.865
  16:45:44.8653
 16:45:44.86529
        16:45:44
      16:45:44.9
     16:45:44.87
    16:45:44.865
   16:45:44.8653
  16:45:44.86529
 16:45:44.865290
  0 16:45
   0 16:45
 0 16:45:44
  0 16:45:44
   0 16:45:44
    0 16:45:44
  0 16:45:44.9
     0 16:45:44
   0 16:45:44.9
  0 16:45:44.87
      0 16:45:44
    0 16:45:44.9
   0 16:45:44.87
  0 16:45:44.865
       0 16:45:44
     0 16:45:44.9
    0 16:45:44.87
   0 16:45:44.865
  0 16:45:44.8653
        0 16:45:44
      0 16:45:44.9
     0 16:45:44.87
    0 16:45:44.865
   0 16:45:44.8653
  0 16:45:44.86529
         0 16:45:44
       0 16:45:44.9
      0 16:45:44.87
     0 16:45:44.865
    0 16:45:44.8653
   0 16:45:44.86529
  0 16:45:44.865290
 21:30
  21:30
   21:30
 21:30:57
  21:30:57
   21:30:57
 21:30:57.8
    21:30:57
  21:30:57.8
 21:30:57.82
     21:30:57
   21:30:57.8
  21:30:57.82
 21:30:57.820
      21:30:57
    21:30:57.8
   21:30:57.82
  21:30:57.820
 21:30:57.8205
       21:30:57
     21:30:57.8
    21:30:57.82
   21:30:57.820
  21:30:57.8205
 21:30:57.82047
        21:30:57
      21:30:57.8
     21:30:57.82
    21:30:57.820
   21:30:57.8205
  21:30:57.82047
 21:30:57.820470
  0 21:30
   0 21:30
 0 21:30:57
  0 21:30:57
   0 21:30:57
    0 21:30:57
  0 21:30:57.8
     0 21:30:57
   0 21:30:57.8
  0 21:30:57.82
      0 21:30:57
    0 21:30:57.8
   0 21:30:57.82
  0 21:30:57.820
       0 21:30:57
     0 21:30:57.8
    0 21:30:57.82
   0 21:30:57.820
  0 21:30:57.8205
        0 21:30:57
      0 21:30:57.8
     0 21:30:57.82
    0 21:30:57.820
   0 21:30:57.8205
  0 21:30:57.82047
         0 21:30:57
       0 21:30:57.8
      0 21:30:57.82
     0 21:30:57.820
    0 21:30:57.8205
   0 21:30:57.82047
  0 21:30:57.820470
  4:25
   4:25
 4:25:09
  4:25:09
   4:25:09
    4:25:09
  4:25:09.2
     4:25:09
   4:25:09.2
  4:25:09.15
      4:25:09
    4:25:09.2
   4:25:09.15
  4:25:09.154
       4:25:09
     4:25:09.2
    4:25:09.15
   4:25:09.154
  4:25:09.1539
        4:25:09
      4:25:09.2
     4:25:09.15
    4:25:09.154
   4:25:09.1539
  4:25:09.15395
         4:25:09
       4:25:09.2
      4:25:09.15
     4:25:09.154
    4:25:09.1539
   4:25:09.15395
  4:25:09.153950
  0 04:25
   0 04:25
 0 04:25:09
  0 04:25:09
   0 04:25:09
    0 04:25:09
  0 04:25:09.2
     0 04:25:09
   0 04:25:09.2
  0 04:25:09.15
      0 04:25:09
    0 04:25:09.2
   0 04:25:09.15
  0 04:25:09.154
       0 04:25:09
     0 04:25:09.2
    0 04:25:09.15
   0 04:25:09.154
  0 04:25:09.1539
        0 04:25:09
      0 04:25:09.2
     0 04:25:09.15
    0 04:25:09.154
   0 04:25:09.1539
  0 04:25:09.15395
         0 04:25:09
       0 04:25:09.2
      0 04:25:09.15
     0 04:25:09.154
    0 04:25:09.1539
   0 04:25:09.15395
  0 04:25:09.153950
  6:49
   6:49
 6:49:27
  6:49:27
   6:49:27
    6:49:27
  6:49:27.1
     6:49:27
   6:49:27.1
  6:49:27.11
      6:49:27
    6:49:27.1
   6:49:27.11
  6:49:27.105
       6:49:27
     6:49:27.1
    6:49:27.11
   6:49:27.105
  6:49:27.1053
        6:49:27
      6:49:27.1
     6:49:27.11
    6:49:27.105
   6:49:27.1053
  6:49:27.10533
         6:49:27
       6:49:27.1
      6:49:27.11
     6:49:27.105
    6:49:27.1053
   6:49:27.10533
  6:49:27.105330
  0 06:49
   0 06:49
 0 06:49:27
  0 06:49:27
   0 06:49:27
    0 06:49:27
  0 06:49:27.1
     0 06:49:27
   0 06:49:27.1
  0 06:49:27.11
      0 06:49:27
    0 06:49:27.1
   0 06:49:27.11
  0 06:49:27.105
       0 06:49:27
     0 06:49:27.1
    0 06:49:27.11
   0 06:49:27.105
  0 06:49:27.1053
        0 06:49:27
      0 06:49:27.1
     0 06:49:27.11
    0 06:49:27.105
   0 06:49:27.1053
  0 06:49:27.10533
         0 06:49:27
       0 06:49:27.1
      0 06:49:27.11
     0 06:49:27.105
    0 06:49:27.1053
   0 06:49:27.10533
  0 06:49:27.105330
  2:57
   2:57
 2:57:52
  2:57:52
   2:57:52
    2:57:52
  2:57:52.5
     2:57:52
   2:57:52.5
  2:57:52.48
      2:57:52
    2:57:52.5
   2:57:52.48
  2:57:52.482
       2:57:52
     2:57:52.5
    2:57:52.48
   2:57:52.482
  2:57:52.4823
        2:57:52
      2:57:52.5
     2:57:52.48
    2:57:52.482
   2:57:52.4823
  2:57:52.48229
         2:57:52
       2:57:52.5
      2:57:52.48
     2:57:52.482
    2:57:52.4823
   2:57:52.48229
  2:57:52.482290
  0 02:57
   0 02:57
 0 02:57:52
  0 02:57:52
   0 02:57:52
    0 02:57:52
  0 02:57:52.5
     0 02:57:52
   0 02:57:52.5
  0 02:57:52.48
      0 02:57:52
    0 02:57:52.5
   0 02:57:52.48
  0 02:57:52.482
       0 02:57:52
     0 02:57:52.5
    0 02:57:52.48
   0 02:57:52.482
  0 02:57:52.4823
        0 02:57:52
      0 02:57:52.5
     0 02:57:52.48
    0 02:57:52.482
   0 02:57:52.4823
  0 02:57:52.48229
         0 02:57:52
       0 02:57:52.5
      0 02:57:52.48
     0 02:57:52.482
    0 02:57:52.4823
   0 02:57:52.48229
  0 02:57:52.482290
 16:45
  16:45
   16:45
 16:45:44
  16:45:44
   16:45:44
 16:45:44.7
    16:45:44
  16:45:44.7
 16:45:44.66
     16:45:44
   16:45:44.7
  16:45:44.66
 16:45:44.658
      16:45:44
    16:45:44.7
   16:45:44.66
  16:45:44.658
 16:45:44.6583
       16:45:44
     16:45:44.7
    16:45:44.66
   16:45:44.658
  16:45:44.6583
 16:45:44.65827
        16:45:44
      16:45:44.7
     16:45:44.66
    16:45:44.658
   16:45:44.6583
  16:45:44.65827
 16:45:44.658270
  0 16:45
   0 16:45
 0 16:45:44
  0 16:45:44
   0 16:45:44
    0 16:45:44
  0 16:45:44.7
     0 16:45:44
   0 16:45:44.7
  0 16:45:44.66
      0 16:45:44
    0 16:45:44.7
   0 16:45:44.66
  0 16:45:44.658
       0 16:45:44
     0 16:45:44.7
    0 16:45:44.66
   0 16:45:44.658
  0 16:45:44.6583
        0 16:45:44
      0 16:45:44.7
     0 16:45:44.66
    0 16:45:44.658
   0 16:45:44.6583
  0 16:45:44.65827
         0 16:45:44
       0 16:45:44.7
      0 16:45:44.66
     0 16:45:44.658
    0 16:45:44.6583
   0 16:45:44.65827
  0 16:45:44.658270
 21:30
  21:30
   21:30
 21:30:57
  21:30:57
   21:30:57
 21:30:57.6
    21:30:57
  21:30:57.6
 21:30:57.58
     21:30:57
   21:30:57.6
  21:30:57.58
 21:30:57.582
      21:30:57
    21:30:57.6
   21:30:57.58
  21:30:57.582
 21:30:57.5822
       21:30:57
     21:30:57.6
    21:30:57.58
   21:30:57.582
  21:30:57.5822
 21:30:57.58219
        21:30:57
      21:30:57.6
     21:30:57.58
    21:30:57.582
   21:30:57.5822
  21:30:57.58219
 21:30:57.582190
  0 21:30
   0 21:30
 0 21:30:57
  0 21:30:57
   0 21:30:57
    0 21:30:57
  0 21:30:57.6
     0 21:30:57
   0 21:30:57.6
  0 21:30:57.58
      0 21:30:57
    0 21:30:57.6
   0 21:30:57.58
  0 21:30:57.582
       0 21:30:57
     0 21:30:57.6
    0 21:30:57.58
   0 21:30:57.582
  0 21:30:57.5822
        0 21:30:57
      0 21:30:57.6
     0 21:30:57.58
    0 21:30:57.582
   0 21:30:57.5822
  0 21:30:57.58219
         0 21:30:57
       0 21:30:57.6
      0 21:30:57.58
     0 21:30:57.582
    0 21:30:57.5822
   0 21:30:57.58219
  0 21:30:57.582190
 22:30
  22:30
   22:30
 22:30:04
  22:30:04
   22:30:04
 22:30:04.2
    22:30:04
  22:30:04.2
 22:30:04.18
     22:30:04
   22:30:04.2
  22:30:04.18
 22:30:04.183
      22:30:04
    22:30:04.2
   22:30:04.18
  22:30:04.183
 22:30:04.1835
       22:30:04
     22:30:04.2
    22:30:04.18
   22:30:04.183
  22:30:04.1835
 22:30:04.18347
        22:30:04
      22:30:04.2
     22:30:04.18
    22:30:04.183
   22:30:04.1835
  22:30:04.18347
 22:30:04.183470
  0 22:30
   0 22:30
 0 22:30:04
  0 22:30:04
   0 22:30:04
    0 22:30:04
  0 22:30:04.2
     0 22:30:04
   0 22:30:04.2
  0 22:30:04.18
      0 22:30:04
    0 22:30:04.2
   0 22:30:04.18
  0 22:30:04.183
       0 22:30:04
     0 22:30:04.2
    0 22:30:04.18
   0 22:30:04.183
  0 22:30:04.1835
        0 22:30:04
      0 22:30:04.2
     0 22:30:04.18
    0 22:30:04.183
   0 22:30:04.1835
  0 22:30:04.18347
         0 22:30:04
       0 22:30:04.2
      0 22:30:04.18
     0 22:30:04.183
    0 22:30:04.1835
   0 22:30:04.18347
  0 22:30:04.183470
  1:56
   1:56
 1:56:51
  1:56:51
   1:56:51
    1:56:51
  1:56:51.6
     1:56:51
   1:56:51.6
  1:56:51.59
      1:56:51
    1:56:51.6
   1:56:51.59
  1:56:51.593
       1:56:51
     1:56:51.6
    1:56:51.59
   1:56:51.593
  1:56:51.5932
        1:56:51
      1:56:51.6
     1:56:51.59
    1:56:51.593
   1:56:51.5932
  1:56:51.59319
         1:56:51
       1:56:51.6
      1:56:51.59
     1:56:51.593
    1:56:51.5932
   1:56:51.59319
  1:56:51.593190
  0 01:56
   0 01:56
 0 01:56:51
  0 01:56:51
   0 01:56:51
    0 01:56:51
  0 01:56:51.6
     0 01:56:51
   0 01:56:51.6
  0 01:56:51.59
      0 01:56:51
    0 01:56:51.6
   0 01:56:51.59
  0 01:56:51.593
       0 01:56:51
     0 01:56:51.6
    0 01:56:51.59
   0 01:56:51.593
  0 01:56:51.5932
        0 01:56:51
      0 01:56:51.6
     0 01:56:51.59
    0 01:56:51.593
   0 01:56:51.5932
  0 01:56:51.59319
         0 01:56:51
       0 01:56:51.6
      0 01:56:51.59
     0 01:56:51.593
    0 01:56:51.5932
   0 01:56:51.59319
  0 01:56:51.593190
 24:00
  24:00
   24:00
 24:00:00
  24:00:00
   24:00:00
 24:00:00.0
    24:00:00
  24:00:00.0
 24:00:00.00
     24:00:00
   24:00:00.0
  24:00:00.00
 24:00:00.000
      24:00:00
    24:00:00.0
   24:00:00.00
  24:00:00.000
 24:00:00.0000
       24:00:00
     24:00:00.0
    24:00:00.00
   24:00:00.000
  24:00:00.0000
 24:00:00.00000
        24:00:00
      24:00:00.0
     24:00:00.00
    24:00:00.000
   24:00:00.0000
  24:00:00.00000
 24:00:00.000000
  1 00:00
   1 00:00
 1 00:00:00
  1 00:00:00
   1 00:00:00
    1 00:00:00
  1 00:00:00.0
     1 00:00:00
   1 00:00:00.0
  1 00:00:00.00
      1 00:00:00
    1 00:00:00.0
   1 00:00:00.00
  1 00:00:00.000
       1 00:00:00
     1 00:00:00.0
    1 00:00:00.00
   1 00:00:00.000
  1 00:00:00.0000
        1 00:00:00
      1 00:00:00.0
     1 00:00:00.00
    1 00:00:00.000
   1 00:00:00.0000
  1 00:00:00.00000
         1 00:00:00
       1 00:00:00.0
      1 00:00:00.00
     1 00:00:00.000
    1 00:00:00.0000
   1 00:00:00.00000
  1 00:00:00.000000
 28:50
  28:50
   28:50
 28:50:38
  28:50:38
   28:50:38
 28:50:38.1
    28:50:38
  28:50:38.1
 28:50:38.12
     28:50:38
   28:50:38.1
  28:50:38.12
 28:50:38.123
      28:50:38
    28:50:38.1
   28:50:38.12
  28:50:38.123
 28:50:38.1230
       28:50:38
     28:50:38.1
    28:50:38.12
   28:50:38.123
  28:50:38.1230
 28:50:38.12301
        28:50:38
      28:50:38.1
     28:50:38.12
    28:50:38.123
   28:50:38.1230
  28:50:38.12301
 28:50:38.123010
  1 04:50
   1 04:50
 1 04:50:38
  1 04:50:38
   1 04:50:38
    1 04:50:38
  1 04:50:38.1
     1 04:50:38
   1 04:50:38.1
  1 04:50:38.12
      1 04:50:38
    1 04:50:38.1
   1 04:50:38.12
  1 04:50:38.123
       1 04:50:38
     1 04:50:38.1
    1 04:50:38.12
   1 04:50:38.123
  1 04:50:38.1230
        1 04:50:38
      1 04:50:38.1
     1 04:50:38.12
    1 04:50:38.123
   1 04:50:38.1230
  1 04:50:38.12301
         1 04:50:38
       1 04:50:38.1
      1 04:50:38.12
     1 04:50:38.123
    1 04:50:38.1230
   1 04:50:38.12301
  1 04:50:38.123010
 36:31
  36:31
   36:31
 36:31:35
  36:31:35
   36:31:35
 36:31:35.2
    36:31:35
  36:31:35.2
 36:31:35.23
     36:31:35
   36:31:35.2
  36:31:35.23
 36:31:35.235
      36:31:35
    36:31:35.2
   36:31:35.23
  36:31:35.235
 36:31:35.2345
       36:31:35
     36:31:35.2
    36:31:35.23
   36:31:35.235
  36:31:35.2345
 36:31:35.23453
        36:31:35
      36:31:35.2
     36:31:35.23
    36:31:35.235
   36:31:35.2345
  36:31:35.23453
 36:31:35.234530
  1 12:31
   1 12:31
 1 12:31:35
  1 12:31:35
   1 12:31:35
    1 12:31:35
  1 12:31:35.2
     1 12:31:35
   1 12:31:35.2
  1 12:31:35.23
      1 12:31:35
    1 12:31:35.2
   1 12:31:35.23
  1 12:31:35.235
       1 12:31:35
     1 12:31:35.2
    1 12:31:35.23
   1 12:31:35.235
  1 12:31:35.2345
        1 12:31:35
      1 12:31:35.2
     1 12:31:35.23
    1 12:31:35.235
   1 12:31:35.2345
  1 12:31:35.23453
         1 12:31:35
       1 12:31:35.2
      1 12:31:35.23
     1 12:31:35.235
    1 12:31:35.2345
   1 12:31:35.23453
  1 12:31:35.234530
 36:47
  36:47
   36:47
 36:47:53
  36:47:53
   36:47:53
 36:47:53.3
    36:47:53
  36:47:53.3
 36:47:53.35
     36:47:53
   36:47:53.3
  36:47:53.35
 36:47:53.345
      36:47:53
    36:47:53.3
   36:47:53.35
  36:47:53.345
 36:47:53.3451
       36:47:53
     36:47:53.3
    36:47:53.35
   36:47:53.345
  36:47:53.3451
 36:47:53.34505
        36:47:53
      36:47:53.3
     36:47:53.35
    36:47:53.345
   36:47:53.3451
  36:47:53.34505
 36:47:53.345050
  1 12:47
   1 12:47
 1 12:47:53
  1 12:47:53
   1 12:47:53
    1 12:47:53
  1 12:47:53.3
     1 12:47:53
   1 12:47:53.3
  1 12:47:53.35
      1 12:47:53
    1 12:47:53.3
   1 12:47:53.35
  1 12:47:53.345
       1 12:47:53
     1 12:47:53.3
    1 12:47:53.35
   1 12:47:53.345
  1 12:47:53.3451
        1 12:47:53
      1 12:47:53.3
     1 12:47:53.35
    1 12:47:53.345
   1 12:47:53.3451
  1 12:47:53.34505
         1 12:47:53
       1 12:47:53.3
      1 12:47:53.35
     1 12:47:53.345
    1 12:47:53.3451
   1 12:47:53.34505
  1 12:47:53.345050
 25:26
  25:26
   25:26
 25:26:00
  25:26:00
   25:26:00
 25:26:00.5
    25:26:00
  25:26:00.5
 25:26:00.46
     25:26:00
   25:26:00.5
  25:26:00.46
 25:26:00.456
      25:26:00
    25:26:00.5
   25:26:00.46
  25:26:00.456
 25:26:00.4561
       25:26:00
     25:26:00.5
    25:26:00.46
   25:26:00.456
  25:26:00.4561
 25:26:00.45615
        25:26:00
      25:26:00.5
     25:26:00.46
    25:26:00.456
   25:26:00.4561
  25:26:00.45615
 25:26:00.456150
  1 01:26
   1 01:26
 1 01:26:00
  1 01:26:00
   1 01:26:00
    1 01:26:00
  1 01:26:00.5
     1 01:26:00
   1 01:26:00.5
  1 01:26:00.46
      1 01:26:00
    1 01:26:00.5
   1 01:26:00.46
  1 01:26:00.456
       1 01:26:00
     1 01:26:00.5
    1 01:26:00.46
   1 01:26:00.456
  1 01:26:00.4561
        1 01:26:00
      1 01:26:00.5
     1 01:26:00.46
    1 01:26:00.456
   1 01:26:00.4561
  1 01:26:00.45615
         1 01:26:00
       1 01:26:00.5
      1 01:26:00.46
     1 01:26:00.456
    1 01:26:00.4561
   1 01:26:00.45615
  1 01:26:00.456150
 44:58
  44:58
   44:58
 44:58:11
  44:58:11
   44:58:11
 44:58:11.6
    44:58:11
  44:58:11.6
 44:58:11.57
     44:58:11
   44:58:11.6
  44:58:11.57
 44:58:11.567
      44:58:11
    44:58:11.6
   44:58:11.57
  44:58:11.567
 44:58:11.5668
       44:58:11
     44:58:11.6
    44:58:11.57
   44:58:11.567
  44:58:11.5668
 44:58:11.56677
        44:58:11
      44:58:11.6
     44:58:11.57
    44:58:11.567
   44:58:11.5668
  44:58:11.56677
 44:58:11.566770
  1 20:58
   1 20:58
 1 20:58:11
  1 20:58:11
   1 20:58:11
    1 20:58:11
  1 20:58:11.6
     1 20:58:11
   1 20:58:11.6
  1 20:58:11.57
      1 20:58:11
    1 20:58:11.6
   1 20:58:11.57
  1 20:58:11.567
       1 20:58:11
     1 20:58:11.6
    1 20:58:11.57
   1 20:58:11.567
  1 20:58:11.5668
        1 20:58:11
      1 20:58:11.6
     1 20:58:11.57
    1 20:58:11.567
   1 20:58:11.5668
  1 20:58:11.56677
         1 20:58:11
       1 20:58:11.6
      1 20:58:11.57
     1 20:58:11.567
    1 20:58:11.5668
   1 20:58:11.56677
  1 20:58:11.566770
 31:36
  31:36
   31:36
 31:36:05
  31:36:05
   31:36:05
 31:36:05.2
    31:36:05
  31:36:05.2
 31:36:05.19
     31:36:05
   31:36:05.2
  31:36:05.19
 31:36:05.190
      31:36:05
    31:36:05.2
   31:36:05.19
  31:36:05.190
 31:36:05.1896
       31:36:05
     31:36:05.2
    31:36:05.19
   31:36:05.190
  31:36:05.1896
 31:36:05.18964
        31:36:05
      31:36:05.2
     31:36:05.19
    31:36:05.190
   31:36:05.1896
  31:36:05.18964
 31:36:05.189640
  1 07:36
   1 07:36
 1 07:36:05
  1 07:36:05
   1 07:36:05
    1 07:36:05
  1 07:36:05.2
     1 07:36:05
   1 07:36:05.2
  1 07:36:05.19
      1 07:36:05
    1 07:36:05.2
   1 07:36:05.19
  1 07:36:05.190
       1 07:36:05
     1 07:36:05.2
    1 07:36:05.19
   1 07:36:05.190
  1 07:36:05.1896
        1 07:36:05
      1 07:36:05.2
     1 07:36:05.19
    1 07:36:05.190
   1 07:36:05.1896
  1 07:36:05.18964
         1 07:36:05
       1 07:36:05.2
      1 07:36:05.19
     1 07:36:05.190
    1 07:36:05.1896
   1 07:36:05.18964
  1 07:36:05.189640
 39:43
  39:43
   39:43
 39:43:49
  39:43:49
   39:43:49
 39:43:49.8
    39:43:49
  39:43:49.8
 39:43:49.83
     39:43:49
   39:43:49.8
  39:43:49.83
 39:43:49.831
      39:43:49
    39:43:49.8
   39:43:49.83
  39:43:49.831
 39:43:49.8313
       39:43:49
     39:43:49.8
    39:43:49.83
   39:43:49.831
  39:43:49.8313
 39:43:49.83132
        39:43:49
      39:43:49.8
     39:43:49.83
    39:43:49.831
   39:43:49.8313
  39:43:49.83132
 39:43:49.831320
  1 15:43
   1 15:43
 1 15:43:49
  1 15:43:49
   1 15:43:49
    1 15:43:49
  1 15:43:49.8
     1 15:43:49
   1 15:43:49.8
  1 15:43:49.83
      1 15:43:49
    1 15:43:49.8
   1 15:43:49.83
  1 15:43:49.831
       1 15:43:49
     1 15:43:49.8
    1 15:43:49.83
   1 15:43:49.831
  1 15:43:49.8313
        1 15:43:49
      1 15:43:49.8
     1 15:43:49.83
    1 15:43:49.831
   1 15:43:49.8313
  1 15:43:49.83132
         1 15:43:49
       1 15:43:49.8
      1 15:43:49.83
     1 15:43:49.831
    1 15:43:49.8313
   1 15:43:49.83132
  1 15:43:49.831320
 28:25
  28:25
   28:25
 28:25:09
  28:25:09
   28:25:09
 28:25:09.0
    28:25:09
  28:25:09.0
 28:25:09.01
     28:25:09
   28:25:09.0
  28:25:09.01
 28:25:09.013
      28:25:09
    28:25:09.0
   28:25:09.01
  28:25:09.013
 28:25:09.0129
       28:25:09
     28:25:09.0
    28:25:09.01
   28:25:09.013
  28:25:09.0129
 28:25:09.01293
        28:25:09
      28:25:09.0
     28:25:09.01
    28:25:09.013
   28:25:09.0129
  28:25:09.01293
 28:25:09.012930
  1 04:25
   1 04:25
 1 04:25:09
  1 04:25:09
   1 04:25:09
    1 04:25:09
  1 04:25:09.0
     1 04:25:09
   1 04:25:09.0
  1 04:25:09.01
      1 04:25:09
    1 04:25:09.0
   1 04:25:09.01
  1 04:25:09.013
       1 04:25:09
     1 04:25:09.0
    1 04:25:09.01
   1 04:25:09.013
  1 04:25:09.0129
        1 04:25:09
      1 04:25:09.0
     1 04:25:09.01
    1 04:25:09.013
   1 04:25:09.0129
  1 04:25:09.01293
         1 04:25:09
       1 04:25:09.0
      1 04:25:09.01
     1 04:25:09.013
    1 04:25:09.0129
   1 04:25:09.01293
  1 04:25:09.012930
 30:49
  30:49
   30:49
 30:49:27
  30:49:27
   30:49:27
 30:49:27.5
    30:49:27
  30:49:27.5
 30:49:27.52
     30:49:27
   30:49:27.5
  30:49:27.52
 30:49:27.524
      30:49:27
    30:49:27.5
   30:49:27.52
  30:49:27.524
 30:49:27.5237
       30:49:27
     30:49:27.5
    30:49:27.52
   30:49:27.524
  30:49:27.5237
 30:49:27.52375
        30:49:27
      30:49:27.5
     30:49:27.52
    30:49:27.524
   30:49:27.5237
  30:49:27.52375
 30:49:27.523750
  1 06:49
   1 06:49
 1 06:49:27
  1 06:49:27
   1 06:49:27
    1 06:49:27
  1 06:49:27.5
     1 06:49:27
   1 06:49:27.5
  1 06:49:27.52
      1 06:49:27
    1 06:49:27.5
   1 06:49:27.52
  1 06:49:27.524
       1 06:49:27
     1 06:49:27.5
    1 06:49:27.52
   1 06:49:27.524
  1 06:49:27.5237
        1 06:49:27
      1 06:49:27.5
     1 06:49:27.52
    1 06:49:27.524
   1 06:49:27.5237
  1 06:49:27.52375
         1 06:49:27
       1 06:49:27.5
      1 06:49:27.52
     1 06:49:27.524
    1 06:49:27.5237
   1 06:49:27.52375
  1 06:49:27.523750
 26:57
  26:57
   26:57
 26:57:52
  26:57:52
   26:57:52
 26:57:52.0
    26:57:52
  26:57:52.0
 26:57:52.02
     26:57:52
   26:57:52.0
  26:57:52.02
 26:57:52.016
      26:57:52
    26:57:52.0
   26:57:52.02
  26:57:52.016
 26:57:52.0157
       26:57:52
     26:57:52.0
    26:57:52.02
   26:57:52.016
  26:57:52.0157
 26:57:52.01565
        26:57:52
      26:57:52.0
     26:57:52.02
    26:57:52.016
   26:57:52.0157
  26:57:52.01565
 26:57:52.015650
  1 02:57
   1 02:57
 1 02:57:52
  1 02:57:52
   1 02:57:52
    1 02:57:52
  1 02:57:52.0
     1 02:57:52
   1 02:57:52.0
  1 02:57:52.02
      1 02:57:52
    1 02:57:52.0
   1 02:57:52.02
  1 02:57:52.016
       1 02:57:52
     1 02:57:52.0
    1 02:57:52.02
   1 02:57:52.016
  1 02:57:52.0157
        1 02:57:52
      1 02:57:52.0
     1 02:57:52.02
    1 02:57:52.016
   1 02:57:52.0157
  1 02:57:52.01565
         1 02:57:52
       1 02:57:52.0
      1 02:57:52.02
     1 02:57:52.016
    1 02:57:52.0157
   1 02:57:52.01565
  1 02:57:52.015650
 40:45
  40:45
   40:45
 40:45:44
  40:45:44
   40:45:44
 40:45:44.9
    40:45:44
  40:45:44.9
 40:45:44.87
     40:45:44
   40:45:44.9
  40:45:44.87
 40:45:44.865
      40:45:44
    40:45:44.9
   40:45:44.87
  40:45:44.865
 40:45:44.8653
       40:45:44
     40:45:44.9
    40:45:44.87
   40:45:44.865
  40:45:44.8653
 40:45:44.86529
        40:45:44
      40:45:44.9
     40:45:44.87
    40:45:44.865
   40:45:44.8653
  40:45:44.86529
 40:45:44.865290
  1 16:45
   1 16:45
 1 16:45:44
  1 16:45:44
   1 16:45:44
    1 16:45:44
  1 16:45:44.9
     1 16:45:44
   1 16:45:44.9
  1 16:45:44.87
      1 16:45:44
    1 16:45:44.9
   1 16:45:44.87
  1 16:45:44.865
       1 16:45:44
     1 16:45:44.9
    1 16:45:44.87
   1 16:45:44.865
  1 16:45:44.8653
        1 16:45:44
      1 16:45:44.9
     1 16:45:44.87
    1 16:45:44.865
   1 16:45:44.8653
  1 16:45:44.86529
         1 16:45:44
       1 16:45:44.9
      1 16:45:44.87
     1 16:45:44.865
    1 16:45:44.8653
   1 16:45:44.86529
  1 16:45:44.865290
 45:30
  45:30
   45:30
 45:30:57
  45:30:57
   45:30:57
 45:30:57.8
    45:30:57
  45:30:57.8
 45:30:57.82
     45:30:57
   45:30:57.8
  45:30:57.82
 45:30:57.820
      45:30:57
    45:30:57.8
   45:30:57.82
  45:30:57.820
 45:30:57.8205
       45:30:57
     45:30:57.8
    45:30:57.82
   45:30:57.820
  45:30:57.8205
 45:30:57.82047
        45:30:57
      45:30:57.8
     45:30:57.82
    45:30:57.820
   45:30:57.8205
  45:30:57.82047
 45:30:57.820470
  1 21:30
   1 21:30
 1 21:30:57
  1 21:30:57
   1 21:30:57
    1 21:30:57
  1 21:30:57.8
     1 21:30:57
   1 21:30:57.8
  1 21:30:57.82
      1 21:30:57
    1 21:30:57.8
   1 21:30:57.82
  1 21:30:57.820
       1 21:30:57
     1 21:30:57.8
    1 21:30:57.82
   1 21:30:57.820
  1 21:30:57.8205
        1 21:30:57
      1 21:30:57.8
     1 21:30:57.82
    1 21:30:57.820
   1 21:30:57.8205
  1 21:30:57.82047
         1 21:30:57
       1 21:30:57.8
      1 21:30:57.82
     1 21:30:57.820
    1 21:30:57.8205
   1 21:30:57.82047
  1 21:30:57.820470
 28:25
  28:25
   28:25
 28:25:09
  28:25:09
   28:25:09
 28:25:09.2
    28:25:09
  28:25:09.2
 28:25:09.15
     28:25:09
   28:25:09.2
  28:25:09.15
 28:25:09.154
      28:25:09
    28:25:09.2
   28:25:09.15
  28:25:09.154
 28:25:09.1540
       28:25:09
     28:25:09.2
    28:25:09.15
   28:25:09.154
  28:25:09.1540
 28:25:09.15395
        28:25:09
      28:25:09.2
     28:25:09.15
    28:25:09.154
   28:25:09.1540
  28:25:09.15395
 28:25:09.153950
  1 04:25
   1 04:25
 1 04:25:09
  1 04:25:09
   1 04:25:09
    1 04:25:09
  1 04:25:09.2
     1 04:25:09
   1 04:25:09.2
  1 04:25:09.15
      1 04:25:09
    1 04:25:09.2
   1 04:25:09.15
  1 04:25:09.154
       1 04:25:09
     1 04:25:09.2
    1 04:25:09.15
   1 04:25:09.154
  1 04:25:09.1540
        1 04:25:09
      1 04:25:09.2
     1 04:25:09.15
    1 04:25:09.154
   1 04:25:09.1540
  1 04:25:09.15395
         1 04:25:09
       1 04:25:09.2
      1 04:25:09.15
     1 04:25:09.154
    1 04:25:09.1540
   1 04:25:09.15395
  1 04:25:09.153950
 30:49
  30:49
   30:49
 30:49:27
  30:49:27
   30:49:27
 30:49:27.1
    30:49:27
  30:49:27.1
 30:49:27.11
     30:49:27
   30:49:27.1
  30:49:27.11
 30:49:27.105
      30:49:27
    30:49:27.1
   30:49:27.11
  30:49:27.105
 30:49:27.1053
       30:49:27
     30:49:27.1
    30:49:27.11
   30:49:27.105
  30:49:27.1053
 30:49:27.10533
        30:49:27
      30:49:27.1
     30:49:27.11
    30:49:27.105
   30:49:27.1053
  30:49:27.10533
 30:49:27.105330
  1 06:49
   1 06:49
 1 06:49:27
  1 06:49:27
   1 06:49:27
    1 06:49:27
  1 06:49:27.1
     1 06:49:27
   1 06:49:27.1
  1 06:49:27.11
      1 06:49:27
    1 06:49:27.1
   1 06:49:27.11
  1 06:49:27.105
       1 06:49:27
     1 06:49:27.1
    1 06:49:27.11
   1 06:49:27.105
  1 06:49:27.1053
        1 06:49:27
      1 06:49:27.1
     1 06:49:27.11
    1 06:49:27.105
   1 06:49:27.1053
  1 06:49:27.10533
         1 06:49:27
       1 06:49:27.1
      1 06:49:27.11
     1 06:49:27.105
    1 06:49:27.1053
   1 06:49:27.10533
  1 06:49:27.105330
 26:57
  26:57
   26:57
 26:57:52
  26:57:52
   26:57:52
 26:57:52.5
    26:57:52
  26:57:52.5
 26:57:52.48
     26:57:52
   26:57:52.5
  26:57:52.48
 26:57:52.482
      26:57:52
    26:57:52.5
   26:57:52.48
  26:57:52.482
 26:57:52.4823
       26:57:52
     26:57:52.5
    26:57:52.48
   26:57:52.482
  26:57:52.4823
 26:57:52.48229
        26:57:52
      26:57:52.5
     26:57:52.48
    26:57:52.482
   26:57:52.4823
  26:57:52.48229
 26:57:52.482290
  1 02:57
   1 02:57
 1 02:57:52
  1 02:57:52
   1 02:57:52
    1 02:57:52
  1 02:57:52.5
     1 02:57:52
   1 02:57:52.5
  1 02:57:52.48
      1 02:57:52
    1 02:57:52.5
   1 02:57:52.48
  1 02:57:52.482
       1 02:57:52
     1 02:57:52.5
    1 02:57:52.48
   1 02:57:52.482
  1 02:57:52.4823
        1 02:57:52
      1 02:57:52.5
     1 02:57:52.48
    1 02:57:52.482
   1 02:57:52.4823
  1 02:57:52.48229
         1 02:57:52
       1 02:57:52.5
      1 02:57:52.48
     1 02:57:52.482
    1 02:57:52.4823
   1 02:57:52.48229
  1 02:57:52.482290
 40:45
  40:45
   40:45
 40:45:44
  40:45:44
   40:45:44
 40:45:44.7
    40:45:44
  40:45:44.7
 40:45:44.66
     40:45:44
   40:45:44.7
  40:45:44.66
 40:45:44.658
      40:45:44
    40:45:44.7
   40:45:44.66
  40:45:44.658
 40:45:44.6583
       40:45:44
     40:45:44.7
    40:45:44.66
   40:45:44.658
  40:45:44.6583
 40:45:44.65827
        40:45:44
      40:45:44.7
     40:45:44.66
    40:45:44.658
   40:45:44.6583
  40:45:44.65827
 40:45:44.658270
  1 16:45
   1 16:45
 1 16:45:44
  1 16:45:44
   1 16:45:44
    1 16:45:44
  1 16:45:44.7
     1 16:45:44
   1 16:45:44.7
  1 16:45:44.66
      1 16:45:44
    1 16:45:44.7
   1 16:45:44.66
  1 16:45:44.658
       1 16:45:44
     1 16:45:44.7
    1 16:45:44.66
   1 16:45:44.658
  1 16:45:44.6583
        1 16:45:44
      1 16:45:44.7
     1 16:45:44.66
    1 16:45:44.658
   1 16:45:44.6583
  1 16:45:44.65827
         1 16:45:44
       1 16:45:44.7
      1 16:45:44.66
     1 16:45:44.658
    1 16:45:44.6583
   1 16:45:44.65827
  1 16:45:44.658270
 45:30
  45:30
   45:30
 45:30:57
  45:30:57
   45:30:57
 45:30:57.6
    45:30:57
  45:30:57.6
 45:30:57.58
     45:30:57
   45:30:57.6
  45:30:57.58
 45:30:57.582
      45:30:57
    45:30:57.6
   45:30:57.58
  45:30:57.582
 45:30:57.5822
       45:30:57
     45:30:57.6
    45:30:57.58
   45:30:57.582
  45:30:57.5822
 45:30:57.58219
        45:30:57
      45:30:57.6
     45:30:57.58
    45:30:57.582
   45:30:57.5822
  45:30:57.58219
 45:30:57.582190
  1 21:30
   1 21:30
 1 21:30:57
  1 21:30:57
   1 21:30:57
    1 21:30:57
  1 21:30:57.6
     1 21:30:57
   1 21:30:57.6
  1 21:30:57.58
      1 21:30:57
    1 21:30:57.6
   1 21:30:57.58
  1 21:30:57.582
       1 21:30:57
     1 21:30:57.6
    1 21:30:57.58
   1 21:30:57.582
  1 21:30:57.5822
        1 21:30:57
      1 21:30:57.6
     1 21:30:57.58
    1 21:30:57.582
   1 21:30:57.5822
  1 21:30:57.58219
         1 21:30:57
       1 21:30:57.6
      1 21:30:57.58
     1 21:30:57.582
    1 21:30:57.5822
   1 21:30:57.58219
  1 21:30:57.582190
 46:30
  46:30
   46:30
 46:30:04
  46:30:04
   46:30:04
 46:30:04.2
    46:30:04
  46:30:04.2
 46:30:04.18
     46:30:04
   46:30:04.2
  46:30:04.18
 46:30:04.183
      46:30:04
    46:30:04.2
   46:30:04.18
  46:30:04.183
 46:30:04.1835
       46:30:04
     46:30:04.2
    46:30:04.18
   46:30:04.183
  46:30:04.1835
 46:30:04.18347
        46:30:04
      46:30:04.2
     46:30:04.18
    46:30:04.183
   46:30:04.1835
  46:30:04.18347
 46:30:04.183470
  1 22:30
   1 22:30
 1 22:30:04
  1 22:30:04
   1 22:30:04
    1 22:30:04
  1 22:30:04.2
     1 22:30:04
   1 22:30:04.2
  1 22:30:04.18
      1 22:30:04
    1 22:30:04.2
   1 22:30:04.18
  1 22:30:04.183
       1 22:30:04
     1 22:30:04.2
    1 22:30:04.18
   1 22:30:04.183
  1 22:30:04.1835
        1 22:30:04
      1 22:30:04.2
     1 22:30:04.18
    1 22:30:04.183
   1 22:30:04.1835
  1 22:30:04.18347
         1 22:30:04
       1 22:30:04.2
      1 22:30:04.18
     1 22:30:04.183
    1 22:30:04.1835
   1 22:30:04.18347
  1 22:30:04.183470
 25:56
  25:56
   25:56
 25:56:51
  25:56:51
   25:56:51
 25:56:51.6
    25:56:51
  25:56:51.6
 25:56:51.59
     25:56:51
   25:56:51.6
  25:56:51.59
 25:56:51.593
      25:56:51
    25:56:51.6
   25:56:51.59
  25:56:51.593
 25:56:51.5932
       25:56:51
     25:56:51.6
    25:56:51.59
   25:56:51.593
  25:56:51.5932
 25:56:51.59319
        25:56:51
      25:56:51.6
     25:56:51.59
    25:56:51.593
   25:56:51.5932
  25:56:51.59319
 25:56:51.593190
  1 01:56
   1 01:56
 1 01:56:51
  1 01:56:51
   1 01:56:51
    1 01:56:51
  1 01:56:51.6
     1 01:56:51
   1 01:56:51.6
  1 01:56:51.59
      1 01:56:51
    1 01:56:51.6
   1 01:56:51.59
  1 01:56:51.593
       1 01:56:51
     1 01:56:51.6
    1 01:56:51.59
   1 01:56:51.593
  1 01:56:51.5932
        1 01:56:51
      1 01:56:51.6
     1 01:56:51.59
    1 01:56:51.593
   1 01:56:51.5932
  1 01:56:51.59319
         1 01:56:51
       1 01:56:51.6
      1 01:56:51.59
     1 01:56:51.593
    1 01:56:51.5932
   1 01:56:51.59319
  1 01:56:51.593190
 48:00
  48:00
   48:00
 48:00:00
  48:00:00
   48:00:00
 48:00:00.0
    48:00:00
  48:00:00.0
 48:00:00.00
     48:00:00
   48:00:00.0
  48:00:00.00
 48:00:00.000
      48:00:00
    48:00:00.0
   48:00:00.00
  48:00:00.000
 48:00:00.0000
       48:00:00
     48:00:00.0
    48:00:00.00
   48:00:00.000
  48:00:00.0000
 48:00:00.00000
        48:00:00
      48:00:00.0
     48:00:00.00
    48:00:00.000
   48:00:00.0000
  48:00:00.00000
 48:00:00.000000
  2 00:00
   2 00:00
 2 00:00:00
  2 00:00:00
   2 00:00:00
    2 00:00:00
  2 00:00:00.0
     2 00:00:00
   2 00:00:00.0
  2 00:00:00.00
      2 00:00:00
    2 00:00:00.0
   2 00:00:00.00
  2 00:00:00.000
       2 00:00:00
     2 00:00:00.0
    2 00:00:00.00
   2 00:00:00.000
  2 00:00:00.0000
        2 00:00:00
      2 00:00:00.0
     2 00:00:00.00
    2 00:00:00.000
   2 00:00:00.0000
  2 00:00:00.00000
         2 00:00:00
       2 00:00:00.0
      2 00:00:00.00
     2 00:00:00.000
    2 00:00:00.0000
   2 00:00:00.00000
  2 00:00:00.000000
 52:50
  52:50
   52:50
 52:50:38
  52:50:38
   52:50:38
 52:50:38.1
    52:50:38
  52:50:38.1
 52:50:38.12
     52:50:38
   52:50:38.1
  52:50:38.12
 52:50:38.123
      52:50:38
    52:50:38.1
   52:50:38.12
  52:50:38.123
 52:50:38.1230
       52:50:38
     52:50:38.1
    52:50:38.12
   52:50:38.123
  52:50:38.1230
 52:50:38.12301
        52:50:38
      52:50:38.1
     52:50:38.12
    52:50:38.123
   52:50:38.1230
  52:50:38.12301
 52:50:38.123010
  2 04:50
   2 04:50
 2 04:50:38
  2 04:50:38
   2 04:50:38
    2 04:50:38
  2 04:50:38.1
     2 04:50:38
   2 04:50:38.1
  2 04:50:38.12
      2 04:50:38
    2 04:50:38.1
   2 04:50:38.12
  2 04:50:38.123
       2 04:50:38
     2 04:50:38.1
    2 04:50:38.12
   2 04:50:38.123
  2 04:50:38.1230
        2 04:50:38
      2 04:50:38.1
     2 04:50:38.12
    2 04:50:38.123
   2 04:50:38.1230
  2 04:50:38.12301
         2 04:50:38
       2 04:50:38.1
      2 04:50:38.12
     2 04:50:38.123
    2 04:50:38.1230
   2 04:50:38.12301
  2 04:50:38.123010
 60:31
  60:31
   60:31
 60:31:35
  60:31:35
   60:31:35
 60:31:35.2
    60:31:35
  60:31:35.2
 60:31:35.23
     60:31:35
   60:31:35.2
  60:31:35.23
 60:31:35.235
      60:31:35
    60:31:35.2
   60:31:35.23
  60:31:35.235
 60:31:35.2345
       60:31:35
     60:31:35.2
    60:31:35.23
   60:31:35.235
  60:31:35.2345
 60:31:35.23453
        60:31:35
      60:31:35.2
     60:31:35.23
    60:31:35.235
   60:31:35.2345
  60:31:35.23453
 60:31:35.234530
  2 12:31
   2 12:31
 2 12:31:35
  2 12:31:35
   2 12:31:35
    2 12:31:35
  2 12:31:35.2
     2 12:31:35
   2 12:31:35.2
  2 12:31:35.23
      2 12:31:35
    2 12:31:35.2
   2 12:31:35.23
  2 12:31:35.235
       2 12:31:35
     2 12:31:35.2
    2 12:31:35.23
   2 12:31:35.235
  2 12:31:35.2345
        2 12:31:35
      2 12:31:35.2
     2 12:31:35.23
    2 12:31:35.235
   2 12:31:35.2345
  2 12:31:35.23453
         2 12:31:35
       2 12:31:35.2
      2 12:31:35.23
     2 12:31:35.235
    2 12:31:35.2345
   2 12:31:35.23453
  2 12:31:35.234530
 60:47
  60:47
   60:47
 60:47:53
  60:47:53
   60:47:53
 60:47:53.3
    60:47:53
  60:47:53.3
 60:47:53.35
     60:47:53
   60:47:53.3
  60:47:53.35
 60:47:53.345
      60:47:53
    60:47:53.3
   60:47:53.35
  60:47:53.345
 60:47:53.3451
       60:47:53
     60:47:53.3
    60:47:53.35
   60:47:53.345
  60:47:53.3451
 60:47:53.34505
        60:47:53
      60:47:53.3
     60:47:53.35
    60:47:53.345
   60:47:53.3451
  60:47:53.34505
 60:47:53.345050
  2 12:47
   2 12:47
 2 12:47:53
  2 12:47:53
   2 12:47:53
    2 12:47:53
  2 12:47:53.3
     2 12:47:53
   2 12:47:53.3
  2 12:47:53.35
      2 12:47:53
    2 12:47:53.3
   2 12:47:53.35
  2 12:47:53.345
       2 12:47:53
     2 12:47:53.3
    2 12:47:53.35
   2 12:47:53.345
  2 12:47:53.3451
        2 12:47:53
      2 12:47:53.3
     2 12:47:53.35
    2 12:47:53.345
   2 12:47:53.3451
  2 12:47:53.34505
         2 12:47:53
       2 12:47:53.3
      2 12:47:53.35
     2 12:47:53.345
    2 12:47:53.3451
   2 12:47:53.34505
  2 12:47:53.345050
 49:26
  49:26
   49:26
 49:26:00
  49:26:00
   49:26:00
 49:26:00.5
    49:26:00
  49:26:00.5
 49:26:00.46
     49:26:00
   49:26:00.5
  49:26:00.46
 49:26:00.456
      49:26:00
    49:26:00.5
   49:26:00.46
  49:26:00.456
 49:26:00.4562
       49:26:00
     49:26:00.5
    49:26:00.46
   49:26:00.456
  49:26:00.4562
 49:26:00.45615
        49:26:00
      49:26:00.5
     49:26:00.46
    49:26:00.456
   49:26:00.4562
  49:26:00.45615
 49:26:00.456150
  2 01:26
   2 01:26
 2 01:26:00
  2 01:26:00
   2 01:26:00
    2 01:26:00
  2 01:26:00.5
     2 01:26:00
   2 01:26:00.5
  2 01:26:00.46
      2 01:26:00
    2 01:26:00.5
   2 01:26:00.46
  2 01:26:00.456
       2 01:26:00
     2 01:26:00.5
    2 01:26:00.46
   2 01:26:00.456
  2 01:26:00.4562
        2 01:26:00
      2 01:26:00.5
     2 01:26:00.46
    2 01:26:00.456
   2 01:26:00.4562
  2 01:26:00.45615
         2 01:26:00
       2 01:26:00.5
      2 01:26:00.46
     2 01:26:00.456
    2 01:26:00.4562
   2 01:26:00.45615
  2 01:26:00.456150
 68:58
  68:58
   68:58
 68:58:11
  68:58:11
   68:58:11
 68:58:11.6
    68:58:11
  68:58:11.6
 68:58:11.57
     68:58:11
   68:58:11.6
  68:58:11.57
 68:58:11.567
      68:58:11
    68:58:11.6
   68:58:11.57
  68:58:11.567
 68:58:11.5668
       68:58:11
     68:58:11.6
    68:58:11.57
   68:58:11.567
  68:58:11.5668
 68:58:11.56677
        68:58:11
      68:58:11.6
     68:58:11.57
    68:58:11.567
   68:58:11.5668
  68:58:11.56677
 68:58:11.566770
  2 20:58
   2 20:58
 2 20:58:11
  2 20:58:11
   2 20:58:11
    2 20:58:11
  2 20:58:11.6
     2 20:58:11
   2 20:58:11.6
  2 20:58:11.57
      2 20:58:11
    2 20:58:11.6
   2 20:58:11.57
  2 20:58:11.567
       2 20:58:11
     2 20:58:11.6
    2 20:58:11.57
   2 20:58:11.567
  2 20:58:11.5668
        2 20:58:11
      2 20:58:11.6
     2 20:58:11.57
    2 20:58:11.567
   2 20:58:11.5668
  2 20:58:11.56677
         2 20:58:11
       2 20:58:11.6
      2 20:58:11.57
     2 20:58:11.567
    2 20:58:11.5668
   2 20:58:11.56677
  2 20:58:11.566770
 55:36
  55:36
   55:36
 55:36:05
  55:36:05
   55:36:05
 55:36:05.2
    55:36:05
  55:36:05.2
 55:36:05.19
     55:36:05
   55:36:05.2
  55:36:05.19
 55:36:05.190
      55:36:05
    55:36:05.2
   55:36:05.19
  55:36:05.190
 55:36:05.1896
       55:36:05
     55:36:05.2
    55:36:05.19
   55:36:05.190
  55:36:05.1896
 55:36:05.18964
        55:36:05
      55:36:05.2
     55:36:05.19
    55:36:05.190
   55:36:05.1896
  55:36:05.18964
 55:36:05.189640
  2 07:36
   2 07:36
 2 07:36:05
  2 07:36:05
   2 07:36:05
    2 07:36:05
  2 07:36:05.2
     2 07:36:05
   2 07:36:05.2
  2 07:36:05.19
      2 07:36:05
    2 07:36:05.2
   2 07:36:05.19
  2 07:36:05.190
       2 07:36:05
     2 07:36:05.2
    2 07:36:05.19
   2 07:36:05.190
  2 07:36:05.1896
        2 07:36:05
      2 07:36:05.2
     2 07:36:05.19
    2 07:36:05.190
   2 07:36:05.1896
  2 07:36:05.18964
         2 07:36:05
       2 07:36:05.2
      2 07:36:05.19
     2 07:36:05.190
    2 07:36:05.1896
   2 07:36:05.18964
  2 07:36:05.189640
 63:43
  63:43
   63:43
 63:43:49
  63:43:49
   63:43:49
 63:43:49.8
    63:43:49
  63:43:49.8
 63:43:49.83
     63:43:49
   63:43:49.8
  63:43:49.83
 63:43:49.831
      63:43:49
    63:43:49.8
   63:43:49.83
  63:43:49.831
 63:43:49.8313
       63:43:49
     63:43:49.8
    63:43:49.83
   63:43:49.831
  63:43:49.8313
 63:43:49.83132
        63:43:49
      63:43:49.8
     63:43:49.83
    63:43:49.831
   63:43:49.8313
  63:43:49.83132
 63:43:49.831320
  2 15:43
   2 15:43
 2 15:43:49
  2 15:43:49
   2 15:43:49
    2 15:43:49
  2 15:43:49.8
     2 15:43:49
   2 15:43:49.8
  2 15:43:49.83
      2 15:43:49
    2 15:43:49.8
   2 15:43:49.83
  2 15:43:49.831
       2 15:43:49
     2 15:43:49.8
    2 15:43:49.83
   2 15:43:49.831
  2 15:43:49.8313
        2 15:43:49
      2 15:43:49.8
     2 15:43:49.83
    2 15:43:49.831
   2 15:43:49.8313
  2 15:43:49.83132
         2 15:43:49
       2 15:43:49.8
      2 15:43:49.83
     2 15:43:49.831
    2 15:43:49.8313
   2 15:43:49.83132
  2 15:43:49.831320
 52:25
  52:25
   52:25
 52:25:09
  52:25:09
   52:25:09
 52:25:09.0
    52:25:09
  52:25:09.0
 52:25:09.01
     52:25:09
   52:25:09.0
  52:25:09.01
 52:25:09.013
      52:25:09
    52:25:09.0
   52:25:09.01
  52:25:09.013
 52:25:09.0129
       52:25:09
     52:25:09.0
    52:25:09.01
   52:25:09.013
  52:25:09.0129
 52:25:09.01293
        52:25:09
      52:25:09.0
     52:25:09.01
    52:25:09.013
   52:25:09.0129
  52:25:09.01293
 52:25:09.012930
  2 04:25
   2 04:25
 2 04:25:09
  2 04:25:09
   2 04:25:09
    2 04:25:09
  2 04:25:09.0
     2 04:25:09
   2 04:25:09.0
  2 04:25:09.01
      2 04:25:09
    2 04:25:09.0
   2 04:25:09.01
  2 04:25:09.013
       2 04:25:09
     2 04:25:09.0
    2 04:25:09.01
   2 04:25:09.013
  2 04:25:09.0129
        2 04:25:09
      2 04:25:09.0
     2 04:25:09.01
    2 04:25:09.013
   2 04:25:09.0129
  2 04:25:09.01293
         2 04:25:09
       2 04:25:09.0
      2 04:25:09.01
     2 04:25:09.013
    2 04:25:09.0129
   2 04:25:09.01293
  2 04:25:09.012930
 54:49
  54:49
   54:49
 54:49:27
  54:49:27
   54:49:27
 54:49:27.5
    54:49:27
  54:49:27.5
 54:49:27.52
     54:49:27
   54:49:27.5
  54:49:27.52
 54:49:27.524
      54:49:27
    54:49:27.5
   54:49:27.52
  54:49:27.524
 54:49:27.5237
       54:49:27
     54:49:27.5
    54:49:27.52
   54:49:27.524
  54:49:27.5237
 54:49:27.52375
        54:49:27
      54:49:27.5
     54:49:27.52
    54:49:27.524
   54:49:27.5237
  54:49:27.52375
 54:49:27.523750
  2 06:49
   2 06:49
 2 06:49:27
  2 06:49:27
   2 06:49:27
    2 06:49:27
  2 06:49:27.5
     2 06:49:27
   2 06:49:27.5
  2 06:49:27.52
      2 06:49:27
    2 06:49:27.5
   2 06:49:27.52
  2 06:49:27.524
       2 06:49:27
     2 06:49:27.5
    2 06:49:27.52
   2 06:49:27.524
  2 06:49:27.5237
        2 06:49:27
      2 06:49:27.5
     2 06:49:27.52
    2 06:49:27.524
   2 06:49:27.5237
  2 06:49:27.52375
         2 06:49:27
       2 06:49:27.5
      2 06:49:27.52
     2 06:49:27.524
    2 06:49:27.5237
   2 06:49:27.52375
  2 06:49:27.523750
 50:57
  50:57
   50:57
 50:57:52
  50:57:52
   50:57:52
 50:57:52.0
    50:57:52
  50:57:52.0
 50:57:52.02
     50:57:52
   50:57:52.0
  50:57:52.02
 50:57:52.016
      50:57:52
    50:57:52.0
   50:57:52.02
  50:57:52.016
 50:57:52.0156
       50:57:52
     50:57:52.0
    50:57:52.02
   50:57:52.016
  50:57:52.0156
 50:57:52.01565
        50:57:52
      50:57:52.0
     50:57:52.02
    50:57:52.016
   50:57:52.0156
  50:57:52.01565
 50:57:52.015650
  2 02:57
   2 02:57
 2 02:57:52
  2 02:57:52
   2 02:57:52
    2 02:57:52
  2 02:57:52.0
     2 02:57:52
   2 02:57:52.0
  2 02:57:52.02
      2 02:57:52
    2 02:57:52.0
   2 02:57:52.02
  2 02:57:52.016
       2 02:57:52
     2 02:57:52.0
    2 02:57:52.02
   2 02:57:52.016
  2 02:57:52.0156
        2 02:57:52
      2 02:57:52.0
     2 02:57:52.02
    2 02:57:52.016
   2 02:57:52.0156
  2 02:57:52.01565
         2 02:57:52
       2 02:57:52.0
      2 02:57:52.02
     2 02:57:52.016
    2 02:57:52.0156
   2 02:57:52.01565
  2 02:57:52.015650
 64:45
  64:45
   64:45
 64:45:44
  64:45:44
   64:45:44
 64:45:44.9
    64:45:44
  64:45:44.9
 64:45:44.87
     64:45:44
   64:45:44.9
  64:45:44.87
 64:45:44.865
      64:45:44
    64:45:44.9
   64:45:44.87
  64:45:44.865
 64:45:44.8653
       64:45:44
     64:45:44.9
    64:45:44.87
   64:45:44.865
  64:45:44.8653
 64:45:44.86529
        64:45:44
      64:45:44.9
     64:45:44.87
    64:45:44.865
   64:45:44.8653
  64:45:44.86529
 64:45:44.865290
  2 16:45
   2 16:45
 2 16:45:44
  2 16:45:44
   2 16:45:44
    2 16:45:44
  2 16:45:44.9
     2 16:45:44
   2 16:45:44.9
  2 16:45:44.87
      2 16:45:44
    2 16:45:44.9
   2 16:45:44.87
  2 16:45:44.865
       2 16:45:44
     2 16:45:44.9
    2 16:45:44.87
   2 16:45:44.865
  2 16:45:44.8653
        2 16:45:44
      2 16:45:44.9
     2 16:45:44.87
    2 16:45:44.865
   2 16:45:44.8653
  2 16:45:44.86529
         2 16:45:44
       2 16:45:44.9
      2 16:45:44.87
     2 16:45:44.865
    2 16:45:44.8653
   2 16:45:44.86529
  2 16:45:44.865290
 69:30
  69:30
   69:30
 69:30:57
  69:30:57
   69:30:57
 69:30:57.8
    69:30:57
  69:30:57.8
 69:30:57.82
     69:30:57
   69:30:57.8
  69:30:57.82
 69:30:57.820
      69:30:57
    69:30:57.8
   69:30:57.82
  69:30:57.820
 69:30:57.8205
       69:30:57
     69:30:57.8
    69:30:57.82
   69:30:57.820
  69:30:57.8205
 69:30:57.82047
        69:30:57
      69:30:57.8
     69:30:57.82
    69:30:57.820
   69:30:57.8205
  69:30:57.82047
 69:30:57.820470
  2 21:30
   2 21:30
 2 21:30:57
  2 21:30:57
   2 21:30:57
    2 21:30:57
  2 21:30:57.8
     2 21:30:57
   2 21:30:57.8
  2 21:30:57.82
      2 21:30:57
    2 21:30:57.8
   2 21:30:57.82
  2 21:30:57.820
       2 21:30:57
     2 21:30:57.8
    2 21:30:57.82
   2 21:30:57.820
  2 21:30:57.8205
        2 21:30:57
      2 21:30:57.8
     2 21:30:57.82
    2 21:30:57.820
   2 21:30:57.8205
  2 21:30:57.82047
         2 21:30:57
       2 21:30:57.8
      2 21:30:57.82
     2 21:30:57.820
    2 21:30:57.8205
   2 21:30:57.82047
  2 21:30:57.820470
 52:25
  52:25
   52:25
 52:25:09
  52:25:09
   52:25:09
 52:25:09.2
    52:25:09
  52:25:09.2
 52:25:09.15
     52:25:09
   52:25:09.2
  52:25:09.15
 52:25:09.154
      52:25:09
    52:25:09.2
   52:25:09.15
  52:25:09.154
 52:25:09.1540
       52:25:09
     52:25:09.2
    52:25:09.15
   52:25:09.154
  52:25:09.1540
 52:25:09.15395
        52:25:09
      52:25:09.2
     52:25:09.15
    52:25:09.154
   52:25:09.1540
  52:25:09.15395
 52:25:09.153950
  2 04:25
   2 04:25
 2 04:25:09
  2 04:25:09
   2 04:25:09
    2 04:25:09
  2 04:25:09.2
     2 04:25:09
   2 04:25:09.2
  2 04:25:09.15
      2 04:25:09
    2 04:25:09.2
   2 04:25:09.15
  2 04:25:09.154
       2 04:25:09
     2 04:25:09.2
    2 04:25:09.15
   2 04:25:09.154
  2 04:25:09.1540
        2 04:25:09
      2 04:25:09.2
     2 04:25:09.15
    2 04:25:09.154
   2 04:25:09.1540
  2 04:25:09.15395
         2 04:25:09
       2 04:25:09.2
      2 04:25:09.15
     2 04:25:09.154
    2 04:25:09.1540
   2 04:25:09.15395
  2 04:25:09.153950
 54:49
  54:49
   54:49
 54:49:27
  54:49:27
   54:49:27
 54:49:27.1
    54:49:27
  54:49:27.1
 54:49:27.11
     54:49:27
   54:49:27.1
  54:49:27.11
 54:49:27.105
      54:49:27
    54:49:27.1
   54:49:27.11
  54:49:27.105
 54:49:27.1053
       54:49:27
     54:49:27.1
    54:49:27.11
   54:49:27.105
  54:49:27.1053
 54:49:27.10533
        54:49:27
      54:49:27.1
     54:49:27.11
    54:49:27.105
   54:49:27.1053
  54:49:27.10533
 54:49:27.105330
  2 06:49
   2 06:49
 2 06:49:27
  2 06:49:27
   2 06:49:27
    2 06:49:27
  2 06:49:27.1
     2 06:49:27
   2 06:49:27.1
  2 06:49:27.11
      2 06:49:27
    2 06:49:27.1
   2 06:49:27.11
  2 06:49:27.105
       2 06:49:27
     2 06:49:27.1
    2 06:49:27.11
   2 06:49:27.105
  2 06:49:27.1053
        2 06:49:27
      2 06:49:27.1
     2 06:49:27.11
    2 06:49:27.105
   2 06:49:27.1053
  2 06:49:27.10533
         2 06:49:27
       2 06:49:27.1
      2 06:49:27.11
     2 06:49:27.105
    2 06:49:27.1053
   2 06:49:27.10533
  2 06:49:27.105330
 50:57
  50:57
   50:57
 50:57:52
  50:57:52
   50:57:52
 50:57:52.5
    50:57:52
  50:57:52.5
 50:57:52.48
     50:57:52
   50:57:52.5
  50:57:52.48
 50:57:52.482
      50:57:52
    50:57:52.5
   50:57:52.48
  50:57:52.482
 50:57:52.4823
       50:57:52
     50:57:52.5
    50:57:52.48
   50:57:52.482
  50:57:52.4823
 50:57:52.48229
        50:57:52
      50:57:52.5
     50:57:52.48
    50:57:52.482
   50:57:52.4823
  50:57:52.48229
 50:57:52.482290
  2 02:57
   2 02:57
 2 02:57:52
  2 02:57:52
   2 02:57:52
    2 02:57:52
  2 02:57:52.5
     2 02:57:52
   2 02:57:52.5
  2 02:57:52.48
      2 02:57:52
    2 02:57:52.5
   2 02:57:52.48
  2 02:57:52.482
       2 02:57:52
     2 02:57:52.5
    2 02:57:52.48
   2 02:57:52.482
  2 02:57:52.4823
        2 02:57:52
      2 02:57:52.5
     2 02:57:52.48
    2 02:57:52.482
   2 02:57:52.4823
  2 02:57:52.48229
         2 02:57:52
       2 02:57:52.5
      2 02:57:52.48
     2 02:57:52.482
    2 02:57:52.4823
   2 02:57:52.48229
  2 02:57:52.482290
 64:45
  64:45
   64:45
 64:45:44
  64:45:44
   64:45:44
 64:45:44.7
    64:45:44
  64:45:44.7
 64:45:44.66
     64:45:44
   64:45:44.7
  64:45:44.66
 64:45:44.658
      64:45:44
    64:45:44.7
   64:45:44.66
  64:45:44.658
 64:45:44.6583
       64:45:44
     64:45:44.7
    64:45:44.66
   64:45:44.658
  64:45:44.6583
 64:45:44.65827
        64:45:44
      64:45:44.7
     64:45:44.66
    64:45:44.658
   64:45:44.6583
  64:45:44.65827
 64:45:44.658270
  2 16:45
   2 16:45
 2 16:45:44
  2 16:45:44
   2 16:45:44
    2 16:45:44
  2 16:45:44.7
     2 16:45:44
   2 16:45:44.7
  2 16:45:44.66
      2 16:45:44
    2 16:45:44.7
   2 16:45:44.66
  2 16:45:44.658
       2 16:45:44
     2 16:45:44.7
    2 16:45:44.66
   2 16:45:44.658
  2 16:45:44.6583
        2 16:45:44
      2 16:45:44.7
     2 16:45:44.66
    2 16:45:44.658
   2 16:45:44.6583
  2 16:45:44.65827
         2 16:45:44
       2 16:45:44.7
      2 16:45:44.66
     2 16:45:44.658
    2 16:45:44.6583
   2 16:45:44.65827
  2 16:45:44.658270
 69:30
  69:30
   69:30
 69:30:57
  69:30:57
   69:30:57
 69:30:57.6
    69:30:57
  69:30:57.6
 69:30:57.58
     69:30:57
   69:30:57.6
  69:30:57.58
 69:30:57.582
      69:30:57
    69:30:57.6
   69:30:57.58
  69:30:57.582
 69:30:57.5822
       69:30:57
     69:30:57.6
    69:30:57.58
   69:30:57.582
  69:30:57.5822
 69:30:57.58219
        69:30:57
      69:30:57.6
     69:30:57.58
    69:30:57.582
   69:30:57.5822
  69:30:57.58219
 69:30:57.582190
  2 21:30
   2 21:30
 2 21:30:57
  2 21:30:57
   2 21:30:57
    2 21:30:57
  2 21:30:57.6
     2 21:30:57
   2 21:30:57.6
  2 21:30:57.58
      2 21:30:57
    2 21:30:57.6
   2 21:30:57.58
  2 21:30:57.582
       2 21:30:57
     2 21:30:57.6
    2 21:30:57.58
   2 21:30:57.582
  2 21:30:57.5822
        2 21:30:57
      2 21:30:57.6
     2 21:30:57.58
    2 21:30:57.582
   2 21:30:57.5822
  2 21:30:57.58219
         2 21:30:57
       2 21:30:57.6
      2 21:30:57.58
     2 21:30:57.582
    2 21:30:57.5822
   2 21:30:57.58219
  2 21:30:57.582190
 70:30
  70:30
   70:30
 70:30:04
  70:30:04
   70:30:04
 70:30:04.2
    70:30:04
  70:30:04.2
 70:30:04.18
     70:30:04
   70:30:04.2
  70:30:04.18
 70:30:04.183
      70:30:04
    70:30:04.2
   70:30:04.18
  70:30:04.183
 70:30:04.1835
       70:30:04
     70:30:04.2
    70:30:04.18
   70:30:04.183
  70:30:04.1835
 70:30:04.18347
        70:30:04
      70:30:04.2
     70:30:04.18
    70:30:04.183
   70:30:04.1835
  70:30:04.18347
 70:30:04.183470
  2 22:30
   2 22:30
 2 22:30:04
  2 22:30:04
   2 22:30:04
    2 22:30:04
  2 22:30:04.2
     2 22:30:04
   2 22:30:04.2
  2 22:30:04.18
      2 22:30:04
    2 22:30:04.2
   2 22:30:04.18
  2 22:30:04.183
       2 22:30:04
     2 22:30:04.2
    2 22:30:04.18
   2 22:30:04.183
  2 22:30:04.1835
        2 22:30:04
      2 22:30:04.2
     2 22:30:04.18
    2 22:30:04.183
   2 22:30:04.1835
  2 22:30:04.18347
         2 22:30:04
       2 22:30:04.2
      2 22:30:04.18
     2 22:30:04.183
    2 22:30:04.1835
   2 22:30:04.18347
  2 22:30:04.183470
 49:56
  49:56
   49:56
 49:56:51
  49:56:51
   49:56:51
 49:56:51.6
    49:56:51
  49:56:51.6
 49:56:51.59
     49:56:51
   49:56:51.6
  49:56:51.59
 49:56:51.593
      49:56:51
    49:56:51.6
   49:56:51.59
  49:56:51.593
 49:56:51.5932
       49:56:51
     49:56:51.6
    49:56:51.59
   49:56:51.593
  49:56:51.5932
 49:56:51.59319
        49:56:51
      49:56:51.6
     49:56:51.59
    49:56:51.593
   49:56:51.5932
  49:56:51.59319
 49:56:51.593190
  2 01:56
   2 01:56
 2 01:56:51
  2 01:56:51
   2 01:56:51
    2 01:56:51
  2 01:56:51.6
     2 01:56:51
   2 01:56:51.6
  2 01:56:51.59
      2 01:56:51
    2 01:56:51.6
   2 01:56:51.59
  2 01:56:51.593
       2 01:56:51
     2 01:56:51.6
    2 01:56:51.59
   2 01:56:51.593
  2 01:56:51.5932
        2 01:56:51
      2 01:56:51.6
     2 01:56:51.59
    2 01:56:51.593
   2 01:56:51.5932
  2 01:56:51.59319
         2 01:56:51
       2 01:56:51.6
      2 01:56:51.59
     2 01:56:51.593
    2 01:56:51.5932
   2 01:56:51.59319
  2 01:56:51.593190
 *****
 ******
 1296:00
  1296:00
   1296:00
 1296:00:00
 1296:00:00
  1296:00:00
  1296:00:00
  1296:00:00
   1296:00:00
 1296:00:00.0
 1296:00:00.0
 1296:00:00.0
    1296:00:00
  1296:00:00.0
 1296:00:00.00
 1296:00:00.00
 1296:00:00.00
     1296:00:00
   1296:00:00.0
  1296:00:00.00
 1296:00:00.000
 1296:00:00.000
 1296:00:00.000
      1296:00:00
    1296:00:00.0
   1296:00:00.00
  1296:00:00.000
 1296:00:00.0000
 1296:00:00.0000
 1296:00:00.0000
 54 00:00
  54 00:00
   54 00:00
 54 00:00:00
  54 00:00:00
   54 00:00:00
 54 00:00:00.0
    54 00:00:00
  54 00:00:00.0
 54 00:00:00.00
     54 00:00:00
   54 00:00:00.0
  54 00:00:00.00
 54 00:00:00.000
      54 00:00:00
    54 00:00:00.0
   54 00:00:00.00
  54 00:00:00.000
 54 00:00:00.0000
       54 00:00:00
     54 00:00:00.0
    54 00:00:00.00
   54 00:00:00.000
  54 00:00:00.0000
 54 00:00:00.00000
        54 00:00:00
      54 00:00:00.0
     54 00:00:00.00
    54 00:00:00.000
   54 00:00:00.0000
  54 00:00:00.00000
 54 00:00:00.000000
 *****
 ******
 1300:50
  1300:50
   1300:50
 1300:50:38
 1300:50:38
  1300:50:38
  1300:50:38
  1300:50:38
   1300:50:38
 1300:50:38.1
 1300:50:38.1
 1300:50:38.1
    1300:50:38
  1300:50:38.1
 1300:50:38.12
 1300:50:38.12
 1300:50:38.12
     1300:50:38
   1300:50:38.1
  1300:50:38.12
 1300:50:38.123
 1300:50:38.123
 1300:50:38.123
      1300:50:38
    1300:50:38.1
   1300:50:38.12
  1300:50:38.123
 1300:50:38.1230
 1300:50:38.1230
 1300:50:38.1230
 54 04:50
  54 04:50
   54 04:50
 54 04:50:38
  54 04:50:38
   54 04:50:38
 54 04:50:38.1
    54 04:50:38
  54 04:50:38.1
 54 04:50:38.12
     54 04:50:38
   54 04:50:38.1
  54 04:50:38.12
 54 04:50:38.123
      54 04:50:38
    54 04:50:38.1
   54 04:50:38.12
  54 04:50:38.123
 54 04:50:38.1230
       54 04:50:38
     54 04:50:38.1
    54 04:50:38.12
   54 04:50:38.123
  54 04:50:38.1230
 54 04:50:38.12301
        54 04:50:38
      54 04:50:38.1
     54 04:50:38.12
    54 04:50:38.123
   54 04:50:38.1230
  54 04:50:38.12301
 54 04:50:38.123010
 *****
 ******
 1308:31
  1308:31
   1308:31
 1308:31:35
 1308:31:35
  1308:31:35
  1308:31:35
  1308:31:35
   1308:31:35
 1308:31:35.2
 1308:31:35.2
 1308:31:35.2
    1308:31:35
  1308:31:35.2
 1308:31:35.23
 1308:31:35.23
 1308:31:35.23
     1308:31:35
   1308:31:35.2
  1308:31:35.23
 1308:31:35.235
 1308:31:35.235
 1308:31:35.235
      1308:31:35
    1308:31:35.2
   1308:31:35.23
  1308:31:35.235
 1308:31:35.2345
 1308:31:35.2345
 1308:31:35.2345
 54 12:31
  54 12:31
   54 12:31
 54 12:31:35
  54 12:31:35
   54 12:31:35
 54 12:31:35.2
    54 12:31:35
  54 12:31:35.2
 54 12:31:35.23
     54 12:31:35
   54 12:31:35.2
  54 12:31:35.23
 54 12:31:35.235
      54 12:31:35
    54 12:31:35.2
   54 12:31:35.23
  54 12:31:35.235
 54 12:31:35.2345
       54 12:31:35
     54 12:31:35.2
    54 12:31:35.23
   54 12:31:35.235
  54 12:31:35.2345
 54 12:31:35.23453
        54 12:31:35
      54 12:31:35.2
     54 12:31:35.23
    54 12:31:35.235
   54 12:31:35.2345
  54 12:31:35.23453
 54 12:31:35.234530
 *****
 ******
 1308:47
  1308:47
   1308:47
 1308:47:53
 1308:47:53
  1308:47:53
  1308:47:53
  1308:47:53
   1308:47:53
 1308:47:53.3
 1308:47:53.3
 1308:47:53.3
    1308:47:53
  1308:47:53.3
 1308:47:53.35
 1308:47:53.35
 1308:47:53.35
     1308:47:53
   1308:47:53.3
  1308:47:53.35
 1308:47:53.345
 1308:47:53.345
 1308:47:53.345
      1308:47:53
    1308:47:53.3
   1308:47:53.35
  1308:47:53.345
 1308:47:53.3450
 1308:47:53.3450
 1308:47:53.3450
 54 12:47
  54 12:47
   54 12:47
 54 12:47:53
  54 12:47:53
   54 12:47:53
 54 12:47:53.3
    54 12:47:53
  54 12:47:53.3
 54 12:47:53.35
     54 12:47:53
   54 12:47:53.3
  54 12:47:53.35
 54 12:47:53.345
      54 12:47:53
    54 12:47:53.3
   54 12:47:53.35
  54 12:47:53.345
 54 12:47:53.3450
       54 12:47:53
     54 12:47:53.3
    54 12:47:53.35
   54 12:47:53.345
  54 12:47:53.3450
 54 12:47:53.34505
        54 12:47:53
      54 12:47:53.3
     54 12:47:53.35
    54 12:47:53.345
   54 12:47:53.3450
  54 12:47:53.34505
 54 12:47:53.345050
 *****
 ******
 1297:26
  1297:26
   1297:26
 1297:26:00
 1297:26:00
  1297:26:00
  1297:26:00
  1297:26:00
   1297:26:00
 1297:26:00.5
 1297:26:00.5
 1297:26:00.5
    1297:26:00
  1297:26:00.5
 1297:26:00.46
 1297:26:00.46
 1297:26:00.46
     1297:26:00
   1297:26:00.5
  1297:26:00.46
 1297:26:00.456
 1297:26:00.456
 1297:26:00.456
      1297:26:00
    1297:26:00.5
   1297:26:00.46
  1297:26:00.456
 1297:26:00.4561
 1297:26:00.4561
 1297:26:00.4561
 54 01:26
  54 01:26
   54 01:26
 54 01:26:00
  54 01:26:00
   54 01:26:00
 54 01:26:00.5
    54 01:26:00
  54 01:26:00.5
 54 01:26:00.46
     54 01:26:00
   54 01:26:00.5
  54 01:26:00.46
 54 01:26:00.456
      54 01:26:00
    54 01:26:00.5
   54 01:26:00.46
  54 01:26:00.456
 54 01:26:00.4561
       54 01:26:00
     54 01:26:00.5
    54 01:26:00.46
   54 01:26:00.456
  54 01:26:00.4561
 54 01:26:00.45615
        54 01:26:00
      54 01:26:00.5
     54 01:26:00.46
    54 01:26:00.456
   54 01:26:00.4561
  54 01:26:00.45615
 54 01:26:00.456150
 *****
 ******
 1316:58
  1316:58
   1316:58
 1316:58:11
 1316:58:11
  1316:58:11
  1316:58:11
  1316:58:11
   1316:58:11
 1316:58:11.6
 1316:58:11.6
 1316:58:11.6
    1316:58:11
  1316:58:11.6
 1316:58:11.57
 1316:58:11.57
 1316:58:11.57
     1316:58:11
   1316:58:11.6
  1316:58:11.57
 1316:58:11.567
 1316:58:11.567
 1316:58:11.567
      1316:58:11
    1316:58:11.6
   1316:58:11.57
  1316:58:11.567
 1316:58:11.5668
 1316:58:11.5668
 1316:58:11.5668
 54 20:58
  54 20:58
   54 20:58
 54 20:58:11
  54 20:58:11
   54 20:58:11
 54 20:58:11.6
    54 20:58:11
  54 20:58:11.6
 54 20:58:11.57
     54 20:58:11
   54 20:58:11.6
  54 20:58:11.57
 54 20:58:11.567
      54 20:58:11
    54 20:58:11.6
   54 20:58:11.57
  54 20:58:11.567
 54 20:58:11.5668
       54 20:58:11
     54 20:58:11.6
    54 20:58:11.57
   54 20:58:11.567
  54 20:58:11.5668
 54 20:58:11.56677
        54 20:58:11
      54 20:58:11.6
     54 20:58:11.57
    54 20:58:11.567
   54 20:58:11.5668
  54 20:58:11.56677
 54 20:58:11.566770
 *****
 ******
 1303:36
  1303:36
   1303:36
 1303:36:05
 1303:36:05
  1303:36:05
  1303:36:05
  1303:36:05
   1303:36:05
 1303:36:05.2
 1303:36:05.2
 1303:36:05.2
    1303:36:05
  1303:36:05.2
 1303:36:05.19
 1303:36:05.19
 1303:36:05.19
     1303:36:05
   1303:36:05.2
  1303:36:05.19
 1303:36:05.190
 1303:36:05.190
 1303:36:05.190
      1303:36:05
    1303:36:05.2
   1303:36:05.19
  1303:36:05.190
 1303:36:05.1896
 1303:36:05.1896
 1303:36:05.1896
 54 07:36
  54 07:36
   54 07:36
 54 07:36:05
  54 07:36:05
   54 07:36:05
 54 07:36:05.2
    54 07:36:05
  54 07:36:05.2
 54 07:36:05.19
     54 07:36:05
   54 07:36:05.2
  54 07:36:05.19
 54 07:36:05.190
      54 07:36:05
    54 07:36:05.2
   54 07:36:05.19
  54 07:36:05.190
 54 07:36:05.1896
       54 07:36:05
     54 07:36:05.2
    54 07:36:05.19
   54 07:36:05.190
  54 07:36:05.1896
 54 07:36:05.18964
        54 07:36:05
      54 07:36:05.2
     54 07:36:05.19
    54 07:36:05.190
   54 07:36:05.1896
  54 07:36:05.18964
 54 07:36:05.189640
 *****
 ******
 1311:43
  1311:43
   1311:43
 1311:43:49
 1311:43:49
  1311:43:49
  1311:43:49
  1311:43:49
   1311:43:49
 1311:43:49.8
 1311:43:49.8
 1311:43:49.8
    1311:43:49
  1311:43:49.8
 1311:43:49.83
 1311:43:49.83
 1311:43:49.83
     1311:43:49
   1311:43:49.8
  1311:43:49.83
 1311:43:49.831
 1311:43:49.831
 1311:43:49.831
      1311:43:49
    1311:43:49.8
   1311:43:49.83
  1311:43:49.831
 1311:43:49.8313
 1311:43:49.8313
 1311:43:49.8313
 54 15:43
  54 15:43
   54 15:43
 54 15:43:49
  54 15:43:49
   54 15:43:49
 54 15:43:49.8
    54 15:43:49
  54 15:43:49.8
 54 15:43:49.83
     54 15:43:49
   54 15:43:49.8
  54 15:43:49.83
 54 15:43:49.831
      54 15:43:49
    54 15:43:49.8
   54 15:43:49.83
  54 15:43:49.831
 54 15:43:49.8313
       54 15:43:49
     54 15:43:49.8
    54 15:43:49.83
   54 15:43:49.831
  54 15:43:49.8313
 54 15:43:49.83132
        54 15:43:49
      54 15:43:49.8
     54 15:43:49.83
    54 15:43:49.831
   54 15:43:49.8313
  54 15:43:49.83132
 54 15:43:49.831320
 *****
 ******
 1300:25
  1300:25
   1300:25
 1300:25:09
 1300:25:09
  1300:25:09
  1300:25:09
  1300:25:09
   1300:25:09
 1300:25:09.0
 1300:25:09.0
 1300:25:09.0
    1300:25:09
  1300:25:09.0
 1300:25:09.01
 1300:25:09.01
 1300:25:09.01
     1300:25:09
   1300:25:09.0
  1300:25:09.01
 1300:25:09.013
 1300:25:09.013
 1300:25:09.013
      1300:25:09
    1300:25:09.0
   1300:25:09.01
  1300:25:09.013
 1300:25:09.0129
 1300:25:09.0129
 1300:25:09.0129
 54 04:25
  54 04:25
   54 04:25
 54 04:25:09
  54 04:25:09
   54 04:25:09
 54 04:25:09.0
    54 04:25:09
  54 04:25:09.0
 54 04:25:09.01
     54 04:25:09
   54 04:25:09.0
  54 04:25:09.01
 54 04:25:09.013
      54 04:25:09
    54 04:25:09.0
   54 04:25:09.01
  54 04:25:09.013
 54 04:25:09.0129
       54 04:25:09
     54 04:25:09.0
    54 04:25:09.01
   54 04:25:09.013
  54 04:25:09.0129
 54 04:25:09.01293
        54 04:25:09
      54 04:25:09.0
     54 04:25:09.01
    54 04:25:09.013
   54 04:25:09.0129
  54 04:25:09.01293
 54 04:25:09.012930
 *****
 ******
 1302:49
  1302:49
   1302:49
 1302:49:27
 1302:49:27
  1302:49:27
  1302:49:27
  1302:49:27
   1302:49:27
 1302:49:27.5
 1302:49:27.5
 1302:49:27.5
    1302:49:27
  1302:49:27.5
 1302:49:27.52
 1302:49:27.52
 1302:49:27.52
     1302:49:27
   1302:49:27.5
  1302:49:27.52
 1302:49:27.524
 1302:49:27.524
 1302:49:27.524
      1302:49:27
    1302:49:27.5
   1302:49:27.52
  1302:49:27.524
 1302:49:27.5237
 1302:49:27.5237
 1302:49:27.5237
 54 06:49
  54 06:49
   54 06:49
 54 06:49:27
  54 06:49:27
   54 06:49:27
 54 06:49:27.5
    54 06:49:27
  54 06:49:27.5
 54 06:49:27.52
     54 06:49:27
   54 06:49:27.5
  54 06:49:27.52
 54 06:49:27.524
      54 06:49:27
    54 06:49:27.5
   54 06:49:27.52
  54 06:49:27.524
 54 06:49:27.5237
       54 06:49:27
     54 06:49:27.5
    54 06:49:27.52
   54 06:49:27.524
  54 06:49:27.5237
 54 06:49:27.52375
        54 06:49:27
      54 06:49:27.5
     54 06:49:27.52
    54 06:49:27.524
   54 06:49:27.5237
  54 06:49:27.52375
 54 06:49:27.523750
 *****
 ******
 1298:57
  1298:57
   1298:57
 1298:57:52
 1298:57:52
  1298:57:52
  1298:57:52
  1298:57:52
   1298:57:52
 1298:57:52.0
 1298:57:52.0
 1298:57:52.0
    1298:57:52
  1298:57:52.0
 1298:57:52.02
 1298:57:52.02
 1298:57:52.02
     1298:57:52
   1298:57:52.0
  1298:57:52.02
 1298:57:52.016
 1298:57:52.016
 1298:57:52.016
      1298:57:52
    1298:57:52.0
   1298:57:52.02
  1298:57:52.016
 1298:57:52.0157
 1298:57:52.0157
 1298:57:52.0157
 54 02:57
  54 02:57
   54 02:57
 54 02:57:52
  54 02:57:52
   54 02:57:52
 54 02:57:52.0
    54 02:57:52
  54 02:57:52.0
 54 02:57:52.02
     54 02:57:52
   54 02:57:52.0
  54 02:57:52.02
 54 02:57:52.016
      54 02:57:52
    54 02:57:52.0
   54 02:57:52.02
  54 02:57:52.016
 54 02:57:52.0157
       54 02:57:52
     54 02:57:52.0
    54 02:57:52.02
   54 02:57:52.016
  54 02:57:52.0157
 54 02:57:52.01565
        54 02:57:52
      54 02:57:52.0
     54 02:57:52.02
    54 02:57:52.016
   54 02:57:52.0157
  54 02:57:52.01565
 54 02:57:52.015650
 *****
 ******
 1312:45
  1312:45
   1312:45
 1312:45:44
 1312:45:44
  1312:45:44
  1312:45:44
  1312:45:44
   1312:45:44
 1312:45:44.9
 1312:45:44.9
 1312:45:44.9
    1312:45:44
  1312:45:44.9
 1312:45:44.87
 1312:45:44.87
 1312:45:44.87
     1312:45:44
   1312:45:44.9
  1312:45:44.87
 1312:45:44.865
 1312:45:44.865
 1312:45:44.865
      1312:45:44
    1312:45:44.9
   1312:45:44.87
  1312:45:44.865
 1312:45:44.8653
 1312:45:44.8653
 1312:45:44.8653
 54 16:45
  54 16:45
   54 16:45
 54 16:45:44
  54 16:45:44
   54 16:45:44
 54 16:45:44.9
    54 16:45:44
  54 16:45:44.9
 54 16:45:44.87
     54 16:45:44
   54 16:45:44.9
  54 16:45:44.87
 54 16:45:44.865
      54 16:45:44
    54 16:45:44.9
   54 16:45:44.87
  54 16:45:44.865
 54 16:45:44.8653
       54 16:45:44
     54 16:45:44.9
    54 16:45:44.87
   54 16:45:44.865
  54 16:45:44.8653
 54 16:45:44.86529
        54 16:45:44
      54 16:45:44.9
     54 16:45:44.87
    54 16:45:44.865
   54 16:45:44.8653
  54 16:45:44.86529
 54 16:45:44.865290
 *****
 ******
 1317:30
  1317:30
   1317:30
 1317:30:57
 1317:30:57
  1317:30:57
  1317:30:57
  1317:30:57
   1317:30:57
 1317:30:57.8
 1317:30:57.8
 1317:30:57.8
    1317:30:57
  1317:30:57.8
 1317:30:57.82
 1317:30:57.82
 1317:30:57.82
     1317:30:57
   1317:30:57.8
  1317:30:57.82
 1317:30:57.820
 1317:30:57.820
 1317:30:57.820
      1317:30:57
    1317:30:57.8
   1317:30:57.82
  1317:30:57.820
 1317:30:57.8205
 1317:30:57.8205
 1317:30:57.8205
 54 21:30
  54 21:30
   54 21:30
 54 21:30:57
  54 21:30:57
   54 21:30:57
 54 21:30:57.8
    54 21:30:57
  54 21:30:57.8
 54 21:30:57.82
     54 21:30:57
   54 21:30:57.8
  54 21:30:57.82
 54 21:30:57.820
      54 21:30:57
    54 21:30:57.8
   54 21:30:57.82
  54 21:30:57.820
 54 21:30:57.8205
       54 21:30:57
     54 21:30:57.8
    54 21:30:57.82
   54 21:30:57.820
  54 21:30:57.8205
 54 21:30:57.82047
        54 21:30:57
      54 21:30:57.8
     54 21:30:57.82
    54 21:30:57.820
   54 21:30:57.8205
  54 21:30:57.82047
 54 21:30:57.820470
 *****
 ******
 1300:25
  1300:25
   1300:25
 1300:25:09
 1300:25:09
  1300:25:09
  1300:25:09
  1300:25:09
   1300:25:09
 1300:25:09.2
 1300:25:09.2
 1300:25:09.2
    1300:25:09
  1300:25:09.2
 1300:25:09.15
 1300:25:09.15
 1300:25:09.15
     1300:25:09
   1300:25:09.2
  1300:25:09.15
 1300:25:09.154
 1300:25:09.154
 1300:25:09.154
      1300:25:09
    1300:25:09.2
   1300:25:09.15
  1300:25:09.154
 1300:25:09.1540
 1300:25:09.1540
 1300:25:09.1540
 54 04:25
  54 04:25
   54 04:25
 54 04:25:09
  54 04:25:09
   54 04:25:09
 54 04:25:09.2
    54 04:25:09
  54 04:25:09.2
 54 04:25:09.15
     54 04:25:09
   54 04:25:09.2
  54 04:25:09.15
 54 04:25:09.154
      54 04:25:09
    54 04:25:09.2
   54 04:25:09.15
  54 04:25:09.154
 54 04:25:09.1540
       54 04:25:09
     54 04:25:09.2
    54 04:25:09.15
   54 04:25:09.154
  54 04:25:09.1540
 54 04:25:09.15395
        54 04:25:09
      54 04:25:09.2
     54 04:25:09.15
    54 04:25:09.154
   54 04:25:09.1540
  54 04:25:09.15395
 54 04:25:09.153950
 *****
 ******
 1302:49
  1302:49
   1302:49
 1302:49:27
 1302:49:27
  1302:49:27
  1302:49:27
  1302:49:27
   1302:49:27
 1302:49:27.1
 1302:49:27.1
 1302:49:27.1
    1302:49:27
  1302:49:27.1
 1302:49:27.11
 1302:49:27.11
 1302:49:27.11
     1302:49:27
   1302:49:27.1
  1302:49:27.11
 1302:49:27.105
 1302:49:27.105
 1302:49:27.105
      1302:49:27
    1302:49:27.1
   1302:49:27.11
  1302:49:27.105
 1302:49:27.1053
 1302:49:27.1053
 1302:49:27.1053
 54 06:49
  54 06:49
   54 06:49
 54 06:49:27
  54 06:49:27
   54 06:49:27
 54 06:49:27.1
    54 06:49:27
  54 06:49:27.1
 54 06:49:27.11
     54 06:49:27
   54 06:49:27.1
  54 06:49:27.11
 54 06:49:27.105
      54 06:49:27
    54 06:49:27.1
   54 06:49:27.11
  54 06:49:27.105
 54 06:49:27.1053
       54 06:49:27
     54 06:49:27.1
    54 06:49:27.11
   54 06:49:27.105
  54 06:49:27.1053
 54 06:49:27.10533
        54 06:49:27
      54 06:49:27.1
     54 06:49:27.11
    54 06:49:27.105
   54 06:49:27.1053
  54 06:49:27.10533
 54 06:49:27.105330
 *****
 ******
 1298:57
  1298:57
   1298:57
 1298:57:52
 1298:57:52
  1298:57:52
  1298:57:52
  1298:57:52
   1298:57:52
 1298:57:52.5
 1298:57:52.5
 1298:57:52.5
    1298:57:52
  1298:57:52.5
 1298:57:52.48
 1298:57:52.48
 1298:57:52.48
     1298:57:52
   1298:57:52.5
  1298:57:52.48
 1298:57:52.482
 1298:57:52.482
 1298:57:52.482
      1298:57:52
    1298:57:52.5
   1298:57:52.48
  1298:57:52.482
 1298:57:52.4823
 1298:57:52.4823
 1298:57:52.4823
 54 02:57
  54 02:57
   54 02:57
 54 02:57:52
  54 02:57:52
   54 02:57:52
 54 02:57:52.5
    54 02:57:52
  54 02:57:52.5
 54 02:57:52.48
     54 02:57:52
   54 02:57:52.5
  54 02:57:52.48
 54 02:57:52.482
      54 02:57:52
    54 02:57:52.5
   54 02:57:52.48
  54 02:57:52.482
 54 02:57:52.4823
       54 02:57:52
     54 02:57:52.5
    54 02:57:52.48
   54 02:57:52.482
  54 02:57:52.4823
 54 02:57:52.48229
        54 02:57:52
      54 02:57:52.5
     54 02:57:52.48
    54 02:57:52.482
   54 02:57:52.4823
  54 02:57:52.48229
 54 02:57:52.482290
 *****
 ******
 1312:45
  1312:45
   1312:45
 1312:45:44
 1312:45:44
  1312:45:44
  1312:45:44
  1312:45:44
   1312:45:44
 1312:45:44.7
 1312:45:44.7
 1312:45:44.7
    1312:45:44
  1312:45:44.7
 1312:45:44.66
 1312:45:44.66
 1312:45:44.66
     1312:45:44
   1312:45:44.7
  1312:45:44.66
 1312:45:44.658
 1312:45:44.658
 1312:45:44.658
      1312:45:44
    1312:45:44.7
   1312:45:44.66
  1312:45:44.658
 1312:45:44.6583
 1312:45:44.6583
 1312:45:44.6583
 54 16:45
  54 16:45
   54 16:45
 54 16:45:44
  54 16:45:44
   54 16:45:44
 54 16:45:44.7
    54 16:45:44
  54 16:45:44.7
 54 16:45:44.66
     54 16:45:44
   54 16:45:44.7
  54 16:45:44.66
 54 16:45:44.658
      54 16:45:44
    54 16:45:44.7
   54 16:45:44.66
  54 16:45:44.658
 54 16:45:44.6583
       54 16:45:44
     54 16:45:44.7
    54 16:45:44.66
   54 16:45:44.658
  54 16:45:44.6583
 54 16:45:44.65827
        54 16:45:44
      54 16:45:44.7
     54 16:45:44.66
    54 16:45:44.658
   54 16:45:44.6583
  54 16:45:44.65827
 54 16:45:44.658270
 *****
 ******
 1317:30
  1317:30
   1317:30
 1317:30:57
 1317:30:57
  1317:30:57
  1317:30:57
  1317:30:57
   1317:30:57
 1317:30:57.6
 1317:30:57.6
 1317:30:57.6
    1317:30:57
  1317:30:57.6
 1317:30:57.58
 1317:30:57.58
 1317:30:57.58
     1317:30:57
   1317:30:57.6
  1317:30:57.58
 1317:30:57.582
 1317:30:57.582
 1317:30:57.582
      1317:30:57
    1317:30:57.6
   1317:30:57.58
  1317:30:57.582
 1317:30:57.5822
 1317:30:57.5822
 1317:30:57.5822
 54 21:30
  54 21:30
   54 21:30
 54 21:30:57
  54 21:30:57
   54 21:30:57
 54 21:30:57.6
    54 21:30:57
  54 21:30:57.6
 54 21:30:57.58
     54 21:30:57
   54 21:30:57.6
  54 21:30:57.58
 54 21:30:57.582
      54 21:30:57
    54 21:30:57.6
   54 21:30:57.58
  54 21:30:57.582
 54 21:30:57.5822
       54 21:30:57
     54 21:30:57.6
    54 21:30:57.58
   54 21:30:57.582
  54 21:30:57.5822
 54 21:30:57.58219
        54 21:30:57
      54 21:30:57.6
     54 21:30:57.58
    54 21:30:57.582
   54 21:30:57.5822
  54 21:30:57.58219
 54 21:30:57.582190
 *****
 ******
 1318:30
  1318:30
   1318:30
 1318:30:04
 1318:30:04
  1318:30:04
  1318:30:04
  1318:30:04
   1318:30:04
 1318:30:04.2
 1318:30:04.2
 1318:30:04.2
    1318:30:04
  1318:30:04.2
 1318:30:04.18
 1318:30:04.18
 1318:30:04.18
     1318:30:04
   1318:30:04.2
  1318:30:04.18
 1318:30:04.183
 1318:30:04.183
 1318:30:04.183
      1318:30:04
    1318:30:04.2
   1318:30:04.18
  1318:30:04.183
 1318:30:04.1835
 1318:30:04.1835
 1318:30:04.1835
 54 22:30
  54 22:30
   54 22:30
 54 22:30:04
  54 22:30:04
   54 22:30:04
 54 22:30:04.2
    54 22:30:04
  54 22:30:04.2
 54 22:30:04.18
     54 22:30:04
   54 22:30:04.2
  54 22:30:04.18
 54 22:30:04.183
      54 22:30:04
    54 22:30:04.2
   54 22:30:04.18
  54 22:30:04.183
 54 22:30:04.1835
       54 22:30:04
     54 22:30:04.2
    54 22:30:04.18
   54 22:30:04.183
  54 22:30:04.1835
 54 22:30:04.18347
        54 22:30:04
      54 22:30:04.2
     54 22:30:04.18
    54 22:30:04.183
   54 22:30:04.1835
  54 22:30:04.18347
 54 22:30:04.183470
 *****
 ******
 1297:56
  1297:56
   1297:56
 1297:56:51
 1297:56:51
  1297:56:51
  1297:56:51
  1297:56:51
   1297:56:51
 1297:56:51.6
 1297:56:51.6
 1297:56:51.6
    1297:56:51
  1297:56:51.6
 1297:56:51.59
 1297:56:51.59
 1297:56:51.59
     1297:56:51
   1297:56:51.6
  1297:56:51.59
 1297:56:51.593
 1297:56:51.593
 1297:56:51.593
      1297:56:51
    1297:56:51.6
   1297:56:51.59
  1297:56:51.593
 1297:56:51.5932
 1297:56:51.5932
 1297:56:51.5932
 54 01:56
  54 01:56
   54 01:56
 54 01:56:51
  54 01:56:51
   54 01:56:51
 54 01:56:51.6
    54 01:56:51
  54 01:56:51.6
 54 01:56:51.59
     54 01:56:51
   54 01:56:51.6
  54 01:56:51.59
 54 01:56:51.593
      54 01:56:51
    54 01:56:51.6
   54 01:56:51.59
  54 01:56:51.593
 54 01:56:51.5932
       54 01:56:51
     54 01:56:51.6
    54 01:56:51.59
   54 01:56:51.593
  54 01:56:51.5932
 54 01:56:51.59319
        54 01:56:51
      54 01:56:51.6
     54 01:56:51.59
    54 01:56:51.593
   54 01:56:51.5932
  54 01:56:51.59319
 54 01:56:51.593190
 *****
 ******
 *******
 16344:00
  16344:00
   16344:00
   16344:00
 16344:00:00
 16344:00:00
 16344:00:00
  16344:00:00
  16344:00:00
  16344:00:00
  16344:00:00
   16344:00:00
 16344:00:00.0
 16344:00:00.0
 16344:00:00.0
 16344:00:00.0
    16344:00:00
  16344:00:00.0
 16344:00:00.00
 16344:00:00.00
 16344:00:00.00
 16344:00:00.00
     16344:00:00
   16344:00:00.0
  16344:00:00.00
 16344:00:00.000
 16344:00:00.000
 16344:00:00.000
 16344:00:00.000
 ********
 681 00:00
  681 00:00
   681 00:00
 681 00:00:00
  681 00:00:00
  681 00:00:00
   681 00:00:00
 681 00:00:00.0
 681 00:00:00.0
    681 00:00:00
  681 00:00:00.0
 681 00:00:00.00
 681 00:00:00.00
     681 00:00:00
   681 00:00:00.0
  681 00:00:00.00
 681 00:00:00.000
 681 00:00:00.000
      681 00:00:00
    681 00:00:00.0
   681 00:00:00.00
  681 00:00:00.000
 681 00:00:00.0000
 681 00:00:00.0000
       681 00:00:00
     681 00:00:00.0
    681 00:00:00.00
   681 00:00:00.000
  681 00:00:00.0000
 681 00:00:00.00000
 681 00:00:00.00000
 *****
 ******
 *******
 16348:50
  16348:50
   16348:50
   16348:50
 16348:50:38
 16348:50:38
 16348:50:38
  16348:50:38
  16348:50:38
  16348:50:38
  16348:50:38
   16348:50:38
 16348:50:38.1
 16348:50:38.1
 16348:50:38.1
 16348:50:38.1
    16348:50:38
  16348:50:38.1
 16348:50:38.12
 16348:50:38.12
 16348:50:38.12
 16348:50:38.12
     16348:50:38
   16348:50:38.1
  16348:50:38.12
 16348:50:38.123
 16348:50:38.123
 16348:50:38.123
 16348:50:38.123
 ********
 681 04:50
  681 04:50
   681 04:50
 681 04:50:38
  681 04:50:38
  681 04:50:38
   681 04:50:38
 681 04:50:38.1
 681 04:50:38.1
    681 04:50:38
  681 04:50:38.1
 681 04:50:38.12
 681 04:50:38.12
     681 04:50:38
   681 04:50:38.1
  681 04:50:38.12
 681 04:50:38.123
 681 04:50:38.123
      681 04:50:38
    681 04:50:38.1
   681 04:50:38.12
  681 04:50:38.123
 681 04:50:38.1230
 681 04:50:38.1230
       681 04:50:38
     681 04:50:38.1
    681 04:50:38.12
   681 04:50:38.123
  681 04:50:38.1230
 681 04:50:38.12301
 681 04:50:38.12301
 *****
 ******
 *******
 16356:31
  16356:31
   16356:31
   16356:31
 16356:31:35
 16356:31:35
 16356:31:35
  16356:31:35
  16356:31:35
  16356:31:35
  16356:31:35
   16356:31:35
 16356:31:35.2
 16356:31:35.2
 16356:31:35.2
 16356:31:35.2
    16356:31:35
  16356:31:35.2
 16356:31:35.23
 16356:31:35.23
 16356:31:35.23
 16356:31:35.23
     16356:31:35
   16356:31:35.2
  16356:31:35.23
 16356:31:35.235
 16356:31:35.235
 16356:31:35.235
 16356:31:35.235
 ********
 681 12:31
  681 12:31
   681 12:31
 681 12:31:35
  681 12:31:35
  681 12:31:35
   681 12:31:35
 681 12:31:35.2
 681 12:31:35.2
    681 12:31:35
  681 12:31:35.2
 681 12:31:35.23
 681 12:31:35.23
     681 12:31:35
   681 12:31:35.2
  681 12:31:35.23
 681 12:31:35.235
 681 12:31:35.235
      681 12:31:35
    681 12:31:35.2
   681 12:31:35.23
  681 12:31:35.235
 681 12:31:35.2345
 681 12:31:35.2345
       681 12:31:35
     681 12:31:35.2
    681 12:31:35.23
   681 12:31:35.235
  681 12:31:35.2345
 681 12:31:35.23453
 681 12:31:35.23453
 *****
 ******
 *******
 16356:47
  16356:47
   16356:47
   16356:47
 16356:47:53
 16356:47:53
 16356:47:53
  16356:47:53
  16356:47:53
  16356:47:53
  16356:47:53
   16356:47:53
 16356:47:53.3
 16356:47:53.3
 16356:47:53.3
 16356:47:53.3
    16356:47:53
  16356:47:53.3
 16356:47:53.35
 16356:47:53.35
 16356:47:53.35
 16356:47:53.35
     16356:47:53
   16356:47:53.3
  16356:47:53.35
 16356:47:53.345
 16356:47:53.345
 16356:47:53.345
 16356:47:53.345
 ********
 681 12:47
  681 12:47
   681 12:47
 681 12:47:53
  681 12:47:53
  681 12:47:53
   681 12:47:53
 681 12:47:53.3
 681 12:47:53.3
    681 12:47:53
  681 12:47:53.3
 681 12:47:53.35
 681 12:47:53.35
     681 12:47:53
   681 12:47:53.3
  681 12:47:53.35
 681 12:47:53.345
 681 12:47:53.345
      681 12:47:53
    681 12:47:53.3
   681 12:47:53.35
  681 12:47:53.345
 681 12:47:53.3450
 681 12:47:53.3450
       681 12:47:53
     681 12:47:53.3
    681 12:47:53.35
   681 12:47:53.345
  681 12:47:53.3450
 681 12:47:53.34505
 681 12:47:53.34505
 *****
 ******
 *******
 16345:26
  16345:26
   16345:26
   16345:26
 16345:26:00
 16345:26:00
 16345:26:00
  16345:26:00
  16345:26:00
  16345:26:00
  16345:26:00
   16345:26:00
 16345:26:00.5
 16345:26:00.5
 16345:26:00.5
 16345:26:00.5
    16345:26:00
  16345:26:00.5
 16345:26:00.46
 16345:26:00.46
 16345:26:00.46
 16345:26:00.46
     16345:26:00
   16345:26:00.5
  16345:26:00.46
 16345:26:00.456
 16345:26:00.456
 16345:26:00.456
 16345:26:00.456
 ********
 681 01:26
  681 01:26
   681 01:26
 681 01:26:00
  681 01:26:00
  681 01:26:00
   681 01:26:00
 681 01:26:00.5
 681 01:26:00.5
    681 01:26:00
  681 01:26:00.5
 681 01:26:00.46
 681 01:26:00.46
     681 01:26:00
   681 01:26:00.5
  681 01:26:00.46
 681 01:26:00.456
 681 01:26:00.456
      681 01:26:00
    681 01:26:00.5
   681 01:26:00.46
  681 01:26:00.456
 681 01:26:00.4562
 681 01:26:00.4562
       681 01:26:00
     681 01:26:00.5
    681 01:26:00.46
   681 01:26:00.456
  681 01:26:00.4562
 681 01:26:00.45615
 681 01:26:00.45615
 *****
 ******
 *******
 16364:58
  16364:58
   16364:58
   16364:58
 16364:58:11
 16364:58:11
 16364:58:11
  16364:58:11
  16364:58:11
  16364:58:11
  16364:58:11
   16364:58:11
 16364:58:11.6
 16364:58:11.6
 16364:58:11.6
 16364:58:11.6
    16364:58:11
  16364:58:11.6
 16364:58:11.57
 16364:58:11.57
 16364:58:11.57
 16364:58:11.57
     16364:58:11
   16364:58:11.6
  16364:58:11.57
 16364:58:11.567
 16364:58:11.567
 16364:58:11.567
 16364:58:11.567
 ********
 681 20:58
  681 20:58
   681 20:58
 681 20:58:11
  681 20:58:11
  681 20:58:11
   681 20:58:11
 681 20:58:11.6
 681 20:58:11.6
    681 20:58:11
  681 20:58:11.6
 681 20:58:11.57
 681 20:58:11.57
     681 20:58:11
   681 20:58:11.6
  681 20:58:11.57
 681 20:58:11.567
 681 20:58:11.567
      681 20:58:11
    681 20:58:11.6
   681 20:58:11.57
  681 20:58:11.567
 681 20:58:11.5668
 681 20:58:11.5668
       681 20:58:11
     681 20:58:11.6
    681 20:58:11.57
   681 20:58:11.567
  681 20:58:11.5668
 681 20:58:11.56677
 681 20:58:11.56677
 *****
 ******
 *******
 16351:36
  16351:36
   16351:36
   16351:36
 16351:36:05
 16351:36:05
 16351:36:05
  16351:36:05
  16351:36:05
  16351:36:05
  16351:36:05
   16351:36:05
 16351:36:05.2
 16351:36:05.2
 16351:36:05.2
 16351:36:05.2
    16351:36:05
  16351:36:05.2
 16351:36:05.19
 16351:36:05.19
 16351:36:05.19
 16351:36:05.19
     16351:36:05
   16351:36:05.2
  16351:36:05.19
 16351:36:05.190
 16351:36:05.190
 16351:36:05.190
 16351:36:05.190
 ********
 681 07:36
  681 07:36
   681 07:36
 681 07:36:05
  681 07:36:05
  681 07:36:05
   681 07:36:05
 681 07:36:05.2
 681 07:36:05.2
    681 07:36:05
  681 07:36:05.2
 681 07:36:05.19
 681 07:36:05.19
     681 07:36:05
   681 07:36:05.2
  681 07:36:05.19
 681 07:36:05.190
 681 07:36:05.190
      681 07:36:05
    681 07:36:05.2
   681 07:36:05.19
  681 07:36:05.190
 681 07:36:05.1896
 681 07:36:05.1896
       681 07:36:05
     681 07:36:05.2
    681 07:36:05.19
   681 07:36:05.190
  681 07:36:05.1896
 681 07:36:05.18964
 681 07:36:05.18964
 *****
 ******
 *******
 16359:43
  16359:43
   16359:43
   16359:43
 16359:43:49
 16359:43:49
 16359:43:49
  16359:43:49
  16359:43:49
  16359:43:49
  16359:43:49
   16359:43:49
 16359:43:49.8
 16359:43:49.8
 16359:43:49.8
 16359:43:49.8
    16359:43:49
  16359:43:49.8
 16359:43:49.83
 16359:43:49.83
 16359:43:49.83
 16359:43:49.83
     16359:43:49
   16359:43:49.8
  16359:43:49.83
 16359:43:49.831
 16359:43:49.831
 16359:43:49.831
 16359:43:49.831
 ********
 681 15:43
  681 15:43
   681 15:43
 681 15:43:49
  681 15:43:49
  681 15:43:49
   681 15:43:49
 681 15:43:49.8
 681 15:43:49.8
    681 15:43:49
  681 15:43:49.8
 681 15:43:49.83
 681 15:43:49.83
     681 15:43:49
   681 15:43:49.8
  681 15:43:49.83
 681 15:43:49.831
 681 15:43:49.831
      681 15:43:49
    681 15:43:49.8
   681 15:43:49.83
  681 15:43:49.831
 681 15:43:49.8313
 681 15:43:49.8313
       681 15:43:49
     681 15:43:49.8
    681 15:43:49.83
   681 15:43:49.831
  681 15:43:49.8313
 681 15:43:49.83132
 681 15:43:49.83132
 *****
 ******
 *******
 16348:25
  16348:25
   16348:25
   16348:25
 16348:25:09
 16348:25:09
 16348:25:09
  16348:25:09
  16348:25:09
  16348:25:09
  16348:25:09
   16348:25:09
 16348:25:09.0
 16348:25:09.0
 16348:25:09.0
 16348:25:09.0
    16348:25:09
  16348:25:09.0
 16348:25:09.01
 16348:25:09.01
 16348:25:09.01
 16348:25:09.01
     16348:25:09
   16348:25:09.0
  16348:25:09.01
 16348:25:09.013
 16348:25:09.013
 16348:25:09.013
 16348:25:09.013
 ********
 681 04:25
  681 04:25
   681 04:25
 681 04:25:09
  681 04:25:09
  681 04:25:09
   681 04:25:09
 681 04:25:09.0
 681 04:25:09.0
    681 04:25:09
  681 04:25:09.0
 681 04:25:09.01
 681 04:25:09.01
     681 04:25:09
   681 04:25:09.0
  681 04:25:09.01
 681 04:25:09.013
 681 04:25:09.013
      681 04:25:09
    681 04:25:09.0
   681 04:25:09.01
  681 04:25:09.013
 681 04:25:09.0129
 681 04:25:09.0129
       681 04:25:09
     681 04:25:09.0
    681 04:25:09.01
   681 04:25:09.013
  681 04:25:09.0129
 681 04:25:09.01293
 681 04:25:09.01293
 *****
 ******
 *******
 16350:49
  16350:49
   16350:49
   16350:49
 16350:49:27
 16350:49:27
 16350:49:27
  16350:49:27
  16350:49:27
  16350:49:27
  16350:49:27
   16350:49:27
 16350:49:27.5
 16350:49:27.5
 16350:49:27.5
 16350:49:27.5
    16350:49:27
  16350:49:27.5
 16350:49:27.52
 16350:49:27.52
 16350:49:27.52
 16350:49:27.52
     16350:49:27
   16350:49:27.5
  16350:49:27.52
 16350:49:27.524
 16350:49:27.524
 16350:49:27.524
 16350:49:27.524
 ********
 681 06:49
  681 06:49
   681 06:49
 681 06:49:27
  681 06:49:27
  681 06:49:27
   681 06:49:27
 681 06:49:27.5
 681 06:49:27.5
    681 06:49:27
  681 06:49:27.5
 681 06:49:27.52
 681 06:49:27.52
     681 06:49:27
   681 06:49:27.5
  681 06:49:27.52
 681 06:49:27.524
 681 06:49:27.524
      681 06:49:27
    681 06:49:27.5
   681 06:49:27.52
  681 06:49:27.524
 681 06:49:27.5237
 681 06:49:27.5237
       681 06:49:27
     681 06:49:27.5
    681 06:49:27.52
   681 06:49:27.524
  681 06:49:27.5237
 681 06:49:27.52375
 681 06:49:27.52375
 *****
 ******
 *******
 16346:57
  16346:57
   16346:57
   16346:57
 16346:57:52
 16346:57:52
 16346:57:52
  16346:57:52
  16346:57:52
  16346:57:52
  16346:57:52
   16346:57:52
 16346:57:52.0
 16346:57:52.0
 16346:57:52.0
 16346:57:52.0
    16346:57:52
  16346:57:52.0
 16346:57:52.02
 16346:57:52.02
 16346:57:52.02
 16346:57:52.02
     16346:57:52
   16346:57:52.0
  16346:57:52.02
 16346:57:52.016
 16346:57:52.016
 16346:57:52.016
 16346:57:52.016
 ********
 681 02:57
  681 02:57
   681 02:57
 681 02:57:52
  681 02:57:52
  681 02:57:52
   681 02:57:52
 681 02:57:52.0
 681 02:57:52.0
    681 02:57:52
  681 02:57:52.0
 681 02:57:52.02
 681 02:57:52.02
     681 02:57:52
   681 02:57:52.0
  681 02:57:52.02
 681 02:57:52.016
 681 02:57:52.016
      681 02:57:52
    681 02:57:52.0
   681 02:57:52.02
  681 02:57:52.016
 681 02:57:52.0156
 681 02:57:52.0156
       681 02:57:52
     681 02:57:52.0
    681 02:57:52.02
   681 02:57:52.016
  681 02:57:52.0156
 681 02:57:52.01565
 681 02:57:52.01565
 *****
 ******
 *******
 16360:45
  16360:45
   16360:45
   16360:45
 16360:45:44
 16360:45:44
 16360:45:44
  16360:45:44
  16360:45:44
  16360:45:44
  16360:45:44
   16360:45:44
 16360:45:44.9
 16360:45:44.9
 16360:45:44.9
 16360:45:44.9
    16360:45:44
  16360:45:44.9
 16360:45:44.87
 16360:45:44.87
 16360:45:44.87
 16360:45:44.87
     16360:45:44
   16360:45:44.9
  16360:45:44.87
 16360:45:44.865
 16360:45:44.865
 16360:45:44.865
 16360:45:44.865
 ********
 681 16:45
  681 16:45
   681 16:45
 681 16:45:44
  681 16:45:44
  681 16:45:44
   681 16:45:44
 681 16:45:44.9
 681 16:45:44.9
    681 16:45:44
  681 16:45:44.9
 681 16:45:44.87
 681 16:45:44.87
     681 16:45:44
   681 16:45:44.9
  681 16:45:44.87
 681 16:45:44.865
 681 16:45:44.865
      681 16:45:44
    681 16:45:44.9
   681 16:45:44.87
  681 16:45:44.865
 681 16:45:44.8653
 681 16:45:44.8653
       681 16:45:44
     681 16:45:44.9
    681 16:45:44.87
   681 16:45:44.865
  681 16:45:44.8653
 681 16:45:44.86529
 681 16:45:44.86529
 *****
 ******
 *******
 16365:30
  16365:30
   16365:30
   16365:30
 16365:30:57
 16365:30:57
 16365:30:57
  16365:30:57
  16365:30:57
  16365:30:57
  16365:30:57
   16365:30:57
 16365:30:57.8
 16365:30:57.8
 16365:30:57.8
 16365:30:57.8
    16365:30:57
  16365:30:57.8
 16365:30:57.82
 16365:30:57.82
 16365:30:57.82
 16365:30:57.82
     16365:30:57
   16365:30:57.8
  16365:30:57.82
 16365:30:57.820
 16365:30:57.820
 16365:30:57.820
 16365:30:57.820
 ********
 681 21:30
  681 21:30
   681 21:30
 681 21:30:57
  681 21:30:57
  681 21:30:57
   681 21:30:57
 681 21:30:57.8
 681 21:30:57.8
    681 21:30:57
  681 21:30:57.8
 681 21:30:57.82
 681 21:30:57.82
     681 21:30:57
   681 21:30:57.8
  681 21:30:57.82
 681 21:30:57.820
 681 21:30:57.820
      681 21:30:57
    681 21:30:57.8
   681 21:30:57.82
  681 21:30:57.820
 681 21:30:57.8205
 681 21:30:57.8205
       681 21:30:57
     681 21:30:57.8
    681 21:30:57.82
   681 21:30:57.820
  681 21:30:57.8205
 681 21:30:57.82047
 681 21:30:57.82047
 *****
 ******
 *******
 16348:25
  16348:25
   16348:25
   16348:25
 16348:25:09
 16348:25:09
 16348:25:09
  16348:25:09
  16348:25:09
  16348:25:09
  16348:25:09
   16348:25:09
 16348:25:09.2
 16348:25:09.2
 16348:25:09.2
 16348:25:09.2
    16348:25:09
  16348:25:09.2
 16348:25:09.15
 16348:25:09.15
 16348:25:09.15
 16348:25:09.15
     16348:25:09
   16348:25:09.2
  16348:25:09.15
 16348:25:09.154
 16348:25:09.154
 16348:25:09.154
 16348:25:09.154
 ********
 681 04:25
  681 04:25
   681 04:25
 681 04:25:09
  681 04:25:09
  681 04:25:09
   681 04:25:09
 681 04:25:09.2
 681 04:25:09.2
    681 04:25:09
  681 04:25:09.2
 681 04:25:09.15
 681 04:25:09.15
     681 04:25:09
   681 04:25:09.2
  681 04:25:09.15
 681 04:25:09.154
 681 04:25:09.154
      681 04:25:09
    681 04:25:09.2
   681 04:25:09.15
  681 04:25:09.154
 681 04:25:09.1539
 681 04:25:09.1539
       681 04:25:09
     681 04:25:09.2
    681 04:25:09.15
   681 04:25:09.154
  681 04:25:09.1539
 681 04:25:09.15395
 681 04:25:09.15395
 *****
 ******
 *******
 16350:49
  16350:49
   16350:49
   16350:49
 16350:49:27
 16350:49:27
 16350:49:27
  16350:49:27
  16350:49:27
  16350:49:27
  16350:49:27
   16350:49:27
 16350:49:27.1
 16350:49:27.1
 16350:49:27.1
 16350:49:27.1
    16350:49:27
  16350:49:27.1
 16350:49:27.11
 16350:49:27.11
 16350:49:27.11
 16350:49:27.11
     16350:49:27
   16350:49:27.1
  16350:49:27.11
 16350:49:27.105
 16350:49:27.105
 16350:49:27.105
 16350:49:27.105
 ********
 681 06:49
  681 06:49
   681 06:49
 681 06:49:27
  681 06:49:27
  681 06:49:27
   681 06:49:27
 681 06:49:27.1
 681 06:49:27.1
    681 06:49:27
  681 06:49:27.1
 681 06:49:27.11
 681 06:49:27.11
     681 06:49:27
   681 06:49:27.1
  681 06:49:27.11
 681 06:49:27.105
 681 06:49:27.105
      681 06:49:27
    681 06:49:27.1
   681 06:49:27.11
  681 06:49:27.105
 681 06:49:27.1053
 681 06:49:27.1053
       681 06:49:27
     681 06:49:27.1
    681 06:49:27.11
   681 06:49:27.105
  681 06:49:27.1053
 681 06:49:27.10533
 681 06:49:27.10533
 *****
 ******
 *******
 16346:57
  16346:57
   16346:57
   16346:57
 16346:57:52
 16346:57:52
 16346:57:52
  16346:57:52
  16346:57:52
  16346:57:52
  16346:57:52
   16346:57:52
 16346:57:52.5
 16346:57:52.5
 16346:57:52.5
 16346:57:52.5
    16346:57:52
  16346:57:52.5
 16346:57:52.48
 16346:57:52.48
 16346:57:52.48
 16346:57:52.48
     16346:57:52
   16346:57:52.5
  16346:57:52.48
 16346:57:52.482
 16346:57:52.482
 16346:57:52.482
 16346:57:52.482
 ********
 681 02:57
  681 02:57
   681 02:57
 681 02:57:52
  681 02:57:52
  681 02:57:52
   681 02:57:52
 681 02:57:52.5
 681 02:57:52.5
    681 02:57:52
  681 02:57:52.5
 681 02:57:52.48
 681 02:57:52.48
     681 02:57:52
   681 02:57:52.5
  681 02:57:52.48
 681 02:57:52.482
 681 02:57:52.482
      681 02:57:52
    681 02:57:52.5
   681 02:57:52.48
  681 02:57:52.482
 681 02:57:52.4823
 681 02:57:52.4823
       681 02:57:52
     681 02:57:52.5
    681 02:57:52.48
   681 02:57:52.482
  681 02:57:52.4823
 681 02:57:52.48229
 681 02:57:52.48229
 *****
 ******
 *******
 16360:45
  16360:45
   16360:45
   16360:45
 16360:45:44
 16360:45:44
 16360:45:44
  16360:45:44
  16360:45:44
  16360:45:44
  16360:45:44
   16360:45:44
 16360:45:44.7
 16360:45:44.7
 16360:45:44.7
 16360:45:44.7
    16360:45:44
  16360:45:44.7
 16360:45:44.66
 16360:45:44.66
 16360:45:44.66
 16360:45:44.66
     16360:45:44
   16360:45:44.7
  16360:45:44.66
 16360:45:44.658
 16360:45:44.658
 16360:45:44.658
 16360:45:44.658
 ********
 681 16:45
  681 16:45
   681 16:45
 681 16:45:44
  681 16:45:44
  681 16:45:44
   681 16:45:44
 681 16:45:44.7
 681 16:45:44.7
    681 16:45:44
  681 16:45:44.7
 681 16:45:44.66
 681 16:45:44.66
     681 16:45:44
   681 16:45:44.7
  681 16:45:44.66
 681 16:45:44.658
 681 16:45:44.658
      681 16:45:44
    681 16:45:44.7
   681 16:45:44.66
  681 16:45:44.658
 681 16:45:44.6583
 681 16:45:44.6583
       681 16:45:44
     681 16:45:44.7
    681 16:45:44.66
   681 16:45:44.658
  681 16:45:44.6583
 681 16:45:44.65827
 681 16:45:44.65827
 *****
 ******
 *******
 16365:30
  16365:30
   16365:30
   16365:30
 16365:30:57
 16365:30:57
 16365:30:57
  16365:30:57
  16365:30:57
  16365:30:57
  16365:30:57
   16365:30:57
 16365:30:57.6
 16365:30:57.6
 16365:30:57.6
 16365:30:57.6
    16365:30:57
  16365:30:57.6
 16365:30:57.58
 16365:30:57.58
 16365:30:57.58
 16365:30:57.58
     16365:30:57
   16365:30:57.6
  16365:30:57.58
 16365:30:57.582
 16365:30:57.582
 16365:30:57.582
 16365:30:57.582
 ********
 681 21:30
  681 21:30
   681 21:30
 681 21:30:57
  681 21:30:57
  681 21:30:57
   681 21:30:57
 681 21:30:57.6
 681 21:30:57.6
    681 21:30:57
  681 21:30:57.6
 681 21:30:57.58
 681 21:30:57.58
     681 21:30:57
   681 21:30:57.6
  681 21:30:57.58
 681 21:30:57.582
 681 21:30:57.582
      681 21:30:57
    681 21:30:57.6
   681 21:30:57.58
  681 21:30:57.582
 681 21:30:57.5822
 681 21:30:57.5822
       681 21:30:57
     681 21:30:57.6
    681 21:30:57.58
   681 21:30:57.582
  681 21:30:57.5822
 681 21:30:57.58219
 681 21:30:57.58219
 *****
 ******
 *******
 16366:30
  16366:30
   16366:30
   16366:30
 16366:30:04
 16366:30:04
 16366:30:04
  16366:30:04
  16366:30:04
  16366:30:04
  16366:30:04
   16366:30:04
 16366:30:04.2
 16366:30:04.2
 16366:30:04.2
 16366:30:04.2
    16366:30:04
  16366:30:04.2
 16366:30:04.18
 16366:30:04.18
 16366:30:04.18
 16366:30:04.18
     16366:30:04
   16366:30:04.2
  16366:30:04.18
 16366:30:04.183
 16366:30:04.183
 16366:30:04.183
 16366:30:04.183
 ********
 681 22:30
  681 22:30
   681 22:30
 681 22:30:04
  681 22:30:04
  681 22:30:04
   681 22:30:04
 681 22:30:04.2
 681 22:30:04.2
    681 22:30:04
  681 22:30:04.2
 681 22:30:04.18
 681 22:30:04.18
     681 22:30:04
   681 22:30:04.2
  681 22:30:04.18
 681 22:30:04.183
 681 22:30:04.183
      681 22:30:04
    681 22:30:04.2
   681 22:30:04.18
  681 22:30:04.183
 681 22:30:04.1835
 681 22:30:04.1835
       681 22:30:04
     681 22:30:04.2
    681 22:30:04.18
   681 22:30:04.183
  681 22:30:04.1835
 681 22:30:04.18347
 681 22:30:04.18347
 *****
 ******
 *******
 16345:56
  16345:56
   16345:56
   16345:56
 16345:56:51
 16345:56:51
 16345:56:51
  16345:56:51
  16345:56:51
  16345:56:51
  16345:56:51
   16345:56:51
 16345:56:51.6
 16345:56:51.6
 16345:56:51.6
 16345:56:51.6
    16345:56:51
  16345:56:51.6
 16345:56:51.59
 16345:56:51.59
 16345:56:51.59
 16345:56:51.59
     16345:56:51
   16345:56:51.6
  16345:56:51.59
 16345:56:51.593
 16345:56:51.593
 16345:56:51.593
 16345:56:51.593
 ********
 681 01:56
  681 01:56
   681 01:56
 681 01:56:51
  681 01:56:51
  681 01:56:51
   681 01:56:51
 681 01:56:51.6
 681 01:56:51.6
    681 01:56:51
  681 01:56:51.6
 681 01:56:51.59
 681 01:56:51.59
     681 01:56:51
   681 01:56:51.6
  681 01:56:51.59
 681 01:56:51.593
 681 01:56:51.593
      681 01:56:51
    681 01:56:51.6
   681 01:56:51.59
  681 01:56:51.593
 681 01:56:51.5932
 681 01:56:51.5932
       681 01:56:51
     681 01:56:51.6
    681 01:56:51.59
   681 01:56:51.593
  681 01:56:51.5932
 681 01:56:51.59319
 681 01:56:51.59319
  0:00
   0:00
 0:00:00
  0:00:00
   0:00:00
    0:00:00
  0:00:00.0
     0:00:00
   0:00:00.0
  0:00:00.00
      0:00:00
    0:00:00.0
   0:00:00.00
  0:00:00.000
       0:00:00
     0:00:00.0
    0:00:00.00
   0:00:00.000
  0:00:00.0000
        0:00:00
      0:00:00.0
     0:00:00.00
    0:00:00.000
   0:00:00.0000
  0:00:00.00000
         0:00:00
       0:00:00.0
      0:00:00.00
     0:00:00.000
    0:00:00.0000
   0:00:00.00000
  0:00:00.000000
  0 00:00
   0 00:00
 0 00:00:00
  0 00:00:00
   0 00:00:00
    0 00:00:00
  0 00:00:00.0
     0 00:00:00
   0 00:00:00.0
  0 00:00:00.00
      0 00:00:00
    0 00:00:00.0
   0 00:00:00.00
  0 00:00:00.000
       0 00:00:00
     0 00:00:00.0
    0 00:00:00.00
   0 00:00:00.000
  0 00:00:00.0000
        0 00:00:00
      0 00:00:00.0
     0 00:00:00.00
    0 00:00:00.000
   0 00:00:00.0000
  0 00:00:00.00000
         0 00:00:00
       0 00:00:00.0
      0 00:00:00.00
     0 00:00:00.000
    0 00:00:00.0000
   0 00:00:00.00000
  0 00:00:00.000000
 -4:50
  -4:50
   -4:50
 -4:50:38
  -4:50:38
   -4:50:38
 -4:50:38.1
    -4:50:38
  -4:50:38.1
 -4:50:38.12
     -4:50:38
   -4:50:38.1
  -4:50:38.12
 -4:50:38.123
      -4:50:38
    -4:50:38.1
   -4:50:38.12
  -4:50:38.123
 -4:50:38.1230
       -4:50:38
     -4:50:38.1
    -4:50:38.12
   -4:50:38.123
  -4:50:38.1230
 -4:50:38.12301
        -4:50:38
      -4:50:38.1
     -4:50:38.12
    -4:50:38.123
   -4:50:38.1230
  -4:50:38.12301
 -4:50:38.123010
 -0 04:50
  -0 04:50
   -0 04:50
 -0 04:50:38
  -0 04:50:38
   -0 04:50:38
 -0 04:50:38.1
    -0 04:50:38
  -0 04:50:38.1
 -0 04:50:38.12
     -0 04:50:38
   -0 04:50:38.1
  -0 04:50:38.12
 -0 04:50:38.123
      -0 04:50:38
    -0 04:50:38.1
   -0 04:50:38.12
  -0 04:50:38.123
 -0 04:50:38.1230
       -0 04:50:38
     -0 04:50:38.1
    -0 04:50:38.12
   -0 04:50:38.123
  -0 04:50:38.1230
 -0 04:50:38.12301
        -0 04:50:38
      -0 04:50:38.1
     -0 04:50:38.12
    -0 04:50:38.123
   -0 04:50:38.1230
  -0 04:50:38.12301
 -0 04:50:38.123010
 *****
 -12:31
  -12:31
   -12:31
 -12:31:35
  -12:31:35
  -12:31:35
   -12:31:35
 -12:31:35.2
 -12:31:35.2
    -12:31:35
  -12:31:35.2
 -12:31:35.23
 -12:31:35.23
     -12:31:35
   -12:31:35.2
  -12:31:35.23
 -12:31:35.235
 -12:31:35.235
      -12:31:35
    -12:31:35.2
   -12:31:35.23
  -12:31:35.235
 -12:31:35.2345
 -12:31:35.2345
       -12:31:35
     -12:31:35.2
    -12:31:35.23
   -12:31:35.235
  -12:31:35.2345
 -12:31:35.23453
 -12:31:35.23453
 -0 12:31
  -0 12:31
   -0 12:31
 -0 12:31:35
  -0 12:31:35
   -0 12:31:35
 -0 12:31:35.2
    -0 12:31:35
  -0 12:31:35.2
 -0 12:31:35.23
     -0 12:31:35
   -0 12:31:35.2
  -0 12:31:35.23
 -0 12:31:35.235
      -0 12:31:35
    -0 12:31:35.2
   -0 12:31:35.23
  -0 12:31:35.235
 -0 12:31:35.2345
       -0 12:31:35
     -0 12:31:35.2
    -0 12:31:35.23
   -0 12:31:35.235
  -0 12:31:35.2345
 -0 12:31:35.23453
        -0 12:31:35
      -0 12:31:35.2
     -0 12:31:35.23
    -0 12:31:35.235
   -0 12:31:35.2345
  -0 12:31:35.23453
 -0 12:31:35.234530
 *****
 -12:47
  -12:47
   -12:47
 -12:47:53
  -12:47:53
  -12:47:53
   -12:47:53
 -12:47:53.3
 -12:47:53.3
    -12:47:53
  -12:47:53.3
 -12:47:53.35
 -12:47:53.35
     -12:47:53
   -12:47:53.3
  -12:47:53.35
 -12:47:53.345
 -12:47:53.345
      -12:47:53
    -12:47:53.3
   -12:47:53.35
  -12:47:53.345
 -12:47:53.3451
 -12:47:53.3451
       -12:47:53
     -12:47:53.3
    -12:47:53.35
   -12:47:53.345
  -12:47:53.3451
 -12:47:53.34505
 -12:47:53.34505
 -0 12:47
  -0 12:47
   -0 12:47
 -0 12:47:53
  -0 12:47:53
   -0 12:47:53
 -0 12:47:53.3
    -0 12:47:53
  -0 12:47:53.3
 -0 12:47:53.35
     -0 12:47:53
   -0 12:47:53.3
  -0 12:47:53.35
 -0 12:47:53.345
      -0 12:47:53
    -0 12:47:53.3
   -0 12:47:53.35
  -0 12:47:53.345
 -0 12:47:53.3451
       -0 12:47:53
     -0 12:47:53.3
    -0 12:47:53.35
   -0 12:47:53.345
  -0 12:47:53.3451
 -0 12:47:53.34505
        -0 12:47:53
      -0 12:47:53.3
     -0 12:47:53.35
    -0 12:47:53.345
   -0 12:47:53.3451
  -0 12:47:53.34505
 -0 12:47:53.345050
 -1:26
  -1:26
   -1:26
 -1:26:00
  -1:26:00
   -1:26:00
 -1:26:00.5
    -1:26:00
  -1:26:00.5
 -1:26:00.46
     -1:26:00
   -1:26:00.5
  -1:26:00.46
 -1:26:00.456
      -1:26:00
    -1:26:00.5
   -1:26:00.46
  -1:26:00.456
 -1:26:00.4561
       -1:26:00
     -1:26:00.5
    -1:26:00.46
   -1:26:00.456
  -1:26:00.4561
 -1:26:00.45615
        -1:26:00
      -1:26:00.5
     -1:26:00.46
    -1:26:00.456
   -1:26:00.4561
  -1:26:00.45615
 -1:26:00.456150
 -0 01:26
  -0 01:26
   -0 01:26
 -0 01:26:00
  -0 01:26:00
   -0 01:26:00
 -0 01:26:00.5
    -0 01:26:00
  -0 01:26:00.5
 -0 01:26:00.46
     -0 01:26:00
   -0 01:26:00.5
  -0 01:26:00.46
 -0 01:26:00.456
      -0 01:26:00
    -0 01:26:00.5
   -0 01:26:00.46
  -0 01:26:00.456
 -0 01:26:00.4561
       -0 01:26:00
     -0 01:26:00.5
    -0 01:26:00.46
   -0 01:26:00.456
  -0 01:26:00.4561
 -0 01:26:00.45615
        -0 01:26:00
      -0 01:26:00.5
     -0 01:26:00.46
    -0 01:26:00.456
   -0 01:26:00.4561
  -0 01:26:00.45615
 -0 01:26:00.456150
 *****
 -20:58
  -20:58
   -20:58
 -20:58:11
  -20:58:11
  -20:58:11
   -20:58:11
 -20:58:11.6
 -20:58:11.6
    -20:58:11
  -20:58:11.6
 -20:58:11.57
 -20:58:11.57
     -20:58:11
   -20:58:11.6
  -20:58:11.57
 -20:58:11.567
 -20:58:11.567
      -20:58:11
    -20:58:11.6
   -20:58:11.57
  -20:58:11.567
 -20:58:11.5668
 -20:58:11.5668
       -20:58:11
     -20:58:11.6
    -20:58:11.57
   -20:58:11.567
  -20:58:11.5668
 -20:58:11.56677
 -20:58:11.56677
 -0 20:58
  -0 20:58
   -0 20:58
 -0 20:58:11
  -0 20:58:11
   -0 20:58:11
 -0 20:58:11.6
    -0 20:58:11
  -0 20:58:11.6
 -0 20:58:11.57
     -0 20:58:11
   -0 20:58:11.6
  -0 20:58:11.57
 -0 20:58:11.567
      -0 20:58:11
    -0 20:58:11.6
   -0 20:58:11.57
  -0 20:58:11.567
 -0 20:58:11.5668
       -0 20:58:11
     -0 20:58:11.6
    -0 20:58:11.57
   -0 20:58:11.567
  -0 20:58:11.5668
 -0 20:58:11.56677
        -0 20:58:11
      -0 20:58:11.6
     -0 20:58:11.57
    -0 20:58:11.567
   -0 20:58:11.5668
  -0 20:58:11.56677
 -0 20:58:11.566770
 -7:36
  -7:36
   -7:36
 -7:36:05
  -7:36:05
   -7:36:05
 -7:36:05.2
    -7:36:05
  -7:36:05.2
 -7:36:05.19
     -7:36:05
   -7:36:05.2
  -7:36:05.19
 -7:36:05.190
      -7:36:05
    -7:36:05.2
   -7:36:05.19
  -7:36:05.190
 -7:36:05.1896
       -7:36:05
     -7:36:05.2
    -7:36:05.19
   -7:36:05.190
  -7:36:05.1896
 -7:36:05.18964
        -7:36:05
      -7:36:05.2
     -7:36:05.19
    -7:36:05.190
   -7:36:05.1896
  -7:36:05.18964
 -7:36:05.189640
 -0 07:36
  -0 07:36
   -0 07:36
 -0 07:36:05
  -0 07:36:05
   -0 07:36:05
 -0 07:36:05.2
    -0 07:36:05
  -0 07:36:05.2
 -0 07:36:05.19
     -0 07:36:05
   -0 07:36:05.2
  -0 07:36:05.19
 -0 07:36:05.190
      -0 07:36:05
    -0 07:36:05.2
   -0 07:36:05.19
  -0 07:36:05.190
 -0 07:36:05.1896
       -0 07:36:05
     -0 07:36:05.2
    -0 07:36:05.19
   -0 07:36:05.190
  -0 07:36:05.1896
 -0 07:36:05.18964
        -0 07:36:05
      -0 07:36:05.2
     -0 07:36:05.19
    -0 07:36:05.190
   -0 07:36:05.1896
  -0 07:36:05.18964
 -0 07:36:05.189640
 *****
 -15:43
  -15:43
   -15:43
 -15:43:49
  -15:43:49
  -15:43:49
   -15:43:49
 -15:43:49.8
 -15:43:49.8
    -15:43:49
  -15:43:49.8
 -15:43:49.83
 -15:43:49.83
     -15:43:49
   -15:43:49.8
  -15:43:49.83
 -15:43:49.831
 -15:43:49.831
      -15:43:49
    -15:43:49.8
   -15:43:49.83
  -15:43:49.831
 -15:43:49.8313
 -15:43:49.8313
       -15:43:49
     -15:43:49.8
    -15:43:49.83
   -15:43:49.831
  -15:43:49.8313
 -15:43:49.83132
 -15:43:49.83132
 -0 15:43
  -0 15:43
   -0 15:43
 -0 15:43:49
  -0 15:43:49
   -0 15:43:49
 -0 15:43:49.8
    -0 15:43:49
  -0 15:43:49.8
 -0 15:43:49.83
     -0 15:43:49
   -0 15:43:49.8
  -0 15:43:49.83
 -0 15:43:49.831
      -0 15:43:49
    -0 15:43:49.8
   -0 15:43:49.83
  -0 15:43:49.831
 -0 15:43:49.8313
       -0 15:43:49
     -0 15:43:49.8
    -0 15:43:49.83
   -0 15:43:49.831
  -0 15:43:49.8313
 -0 15:43:49.83132
        -0 15:43:49
      -0 15:43:49.8
     -0 15:43:49.83
    -0 15:43:49.831
   -0 15:43:49.8313
  -0 15:43:49.83132
 -0 15:43:49.831320
 -4:25
  -4:25
   -4:25
 -4:25:09
  -4:25:09
   -4:25:09
 -4:25:09.0
    -4:25:09
  -4:25:09.0
 -4:25:09.01
     -4:25:09
   -4:25:09.0
  -4:25:09.01
 -4:25:09.013
      -4:25:09
    -4:25:09.0
   -4:25:09.01
  -4:25:09.013
 -4:25:09.0129
       -4:25:09
     -4:25:09.0
    -4:25:09.01
   -4:25:09.013
  -4:25:09.0129
 -4:25:09.01293
        -4:25:09
      -4:25:09.0
     -4:25:09.01
    -4:25:09.013
   -4:25:09.0129
  -4:25:09.01293
 -4:25:09.012930
 -0 04:25
  -0 04:25
   -0 04:25
 -0 04:25:09
  -0 04:25:09
   -0 04:25:09
 -0 04:25:09.0
    -0 04:25:09
  -0 04:25:09.0
 -0 04:25:09.01
     -0 04:25:09
   -0 04:25:09.0
  -0 04:25:09.01
 -0 04:25:09.013
      -0 04:25:09
    -0 04:25:09.0
   -0 04:25:09.01
  -0 04:25:09.013
 -0 04:25:09.0129
       -0 04:25:09
     -0 04:25:09.0
    -0 04:25:09.01
   -0 04:25:09.013
  -0 04:25:09.0129
 -0 04:25:09.01293
        -0 04:25:09
      -0 04:25:09.0
     -0 04:25:09.01
    -0 04:25:09.013
   -0 04:25:09.0129
  -0 04:25:09.01293
 -0 04:25:09.012930
 -6:49
  -6:49
   -6:49
 -6:49:27
  -6:49:27
   -6:49:27
 -6:49:27.5
    -6:49:27
  -6:49:27.5
 -6:49:27.52
     -6:49:27
   -6:49:27.5
  -6:49:27.52
 -6:49:27.524
      -6:49:27
    -6:49:27.5
   -6:49:27.52
  -6:49:27.524
 -6:49:27.5238
       -6:49:27
     -6:49:27.5
    -6:49:27.52
   -6:49:27.524
  -6:49:27.5238
 -6:49:27.52375
        -6:49:27
      -6:49:27.5
     -6:49:27.52
    -6:49:27.524
   -6:49:27.5238
  -6:49:27.52375
 -6:49:27.523750
 -0 06:49
  -0 06:49
   -0 06:49
 -0 06:49:27
  -0 06:49:27
   -0 06:49:27
 -0 06:49:27.5
    -0 06:49:27
  -0 06:49:27.5
 -0 06:49:27.52
     -0 06:49:27
   -0 06:49:27.5
  -0 06:49:27.52
 -0 06:49:27.524
      -0 06:49:27
    -0 06:49:27.5
   -0 06:49:27.52
  -0 06:49:27.524
 -0 06:49:27.5238
       -0 06:49:27
     -0 06:49:27.5
    -0 06:49:27.52
   -0 06:49:27.524
  -0 06:49:27.5238
 -0 06:49:27.52375
        -0 06:49:27
      -0 06:49:27.5
     -0 06:49:27.52
    -0 06:49:27.524
   -0 06:49:27.5238
  -0 06:49:27.52375
 -0 06:49:27.523750
 -2:57
  -2:57
   -2:57
 -2:57:52
  -2:57:52
   -2:57:52
 -2:57:52.0
    -2:57:52
  -2:57:52.0
 -2:57:52.02
     -2:57:52
   -2:57:52.0
  -2:57:52.02
 -2:57:52.016
      -2:57:52
    -2:57:52.0
   -2:57:52.02
  -2:57:52.016
 -2:57:52.0156
       -2:57:52
     -2:57:52.0
    -2:57:52.02
   -2:57:52.016
  -2:57:52.0156
 -2:57:52.01565
        -2:57:52
      -2:57:52.0
     -2:57:52.02
    -2:57:52.016
   -2:57:52.0156
  -2:57:52.01565
 -2:57:52.015650
 -0 02:57
  -0 02:57
   -0 02:57
 -0 02:57:52
  -0 02:57:52
   -0 02:57:52
 -0 02:57:52.0
    -0 02:57:52
  -0 02:57:52.0
 -0 02:57:52.02
     -0 02:57:52
   -0 02:57:52.0
  -0 02:57:52.02
 -0 02:57:52.016
      -0 02:57:52
    -0 02:57:52.0
   -0 02:57:52.02
  -0 02:57:52.016
 -0 02:57:52.0156
       -0 02:57:52
     -0 02:57:52.0
    -0 02:57:52.02
   -0 02:57:52.016
  -0 02:57:52.0156
 -0 02:57:52.01565
        -0 02:57:52
      -0 02:57:52.0
     -0 02:57:52.02
    -0 02:57:52.016
   -0 02:57:52.0156
  -0 02:57:52.01565
 -0 02:57:52.015650
 *****
 -16:45
  -16:45
   -16:45
 -16:45:44
  -16:45:44
  -16:45:44
   -16:45:44
 -16:45:44.9
 -16:45:44.9
    -16:45:44
  -16:45:44.9
 -16:45:44.87
 -16:45:44.87
     -16:45:44
   -16:45:44.9
  -16:45:44.87
 -16:45:44.865
 -16:45:44.865
      -16:45:44
    -16:45:44.9
   -16:45:44.87
  -16:45:44.865
 -16:45:44.8653
 -16:45:44.8653
       -16:45:44
     -16:45:44.9
    -16:45:44.87
   -16:45:44.865
  -16:45:44.8653
 -16:45:44.86529
 -16:45:44.86529
 -0 16:45
  -0 16:45
   -0 16:45
 -0 16:45:44
  -0 16:45:44
   -0 16:45:44
 -0 16:45:44.9
    -0 16:45:44
  -0 16:45:44.9
 -0 16:45:44.87
     -0 16:45:44
   -0 16:45:44.9
  -0 16:45:44.87
 -0 16:45:44.865
      -0 16:45:44
    -0 16:45:44.9
   -0 16:45:44.87
  -0 16:45:44.865
 -0 16:45:44.8653
       -0 16:45:44
     -0 16:45:44.9
    -0 16:45:44.87
   -0 16:45:44.865
  -0 16:45:44.8653
 -0 16:45:44.86529
        -0 16:45:44
      -0 16:45:44.9
     -0 16:45:44.87
    -0 16:45:44.865
   -0 16:45:44.8653
  -0 16:45:44.86529
 -0 16:45:44.865290
 *****
 -21:30
  -21:30
   -21:30
 -21:30:57
  -21:30:57
  -21:30:57
   -21:30:57
 -21:30:57.8
 -21:30:57.8
    -21:30:57
  -21:30:57.8
 -21:30:57.82
 -21:30:57.82
     -21:30:57
   -21:30:57.8
  -21:30:57.82
 -21:30:57.820
 -21:30:57.820
      -21:30:57
    -21:30:57.8
   -21:30:57.82
  -21:30:57.820
 -21:30:57.8205
 -21:30:57.8205
       -21:30:57
     -21:30:57.8
    -21:30:57.82
   -21:30:57.820
  -21:30:57.8205
 -21:30:57.82047
 -21:30:57.82047
 -0 21:30
  -0 21:30
   -0 21:30
 -0 21:30:57
  -0 21:30:57
   -0 21:30:57
 -0 21:30:57.8
    -0 21:30:57
  -0 21:30:57.8
 -0 21:30:57.82
     -0 21:30:57
   -0 21:30:57.8
  -0 21:30:57.82
 -0 21:30:57.820
      -0 21:30:57
    -0 21:30:57.8
   -0 21:30:57.82
  -0 21:30:57.820
 -0 21:30:57.8205
       -0 21:30:57
     -0 21:30:57.8
    -0 21:30:57.82
   -0 21:30:57.820
  -0 21:30:57.8205
 -0 21:30:57.82047
        -0 21:30:57
      -0 21:30:57.8
     -0 21:30:57.82
    -0 21:30:57.820
   -0 21:30:57.8205
  -0 21:30:57.82047
 -0 21:30:57.820470
 -4:25
  -4:25
   -4:25
 -4:25:09
  -4:25:09
   -4:25:09
 -4:25:09.2
    -4:25:09
  -4:25:09.2
 -4:25:09.15
     -4:25:09
   -4:25:09.2
  -4:25:09.15
 -4:25:09.154
      -4:25:09
    -4:25:09.2
   -4:25:09.15
  -4:25:09.154
 -4:25:09.1539
       -4:25:09
     -4:25:09.2
    -4:25:09.15
   -4:25:09.154
  -4:25:09.1539
 -4:25:09.15395
        -4:25:09
      -4:25:09.2
     -4:25:09.15
    -4:25:09.154
   -4:25:09.1539
  -4:25:09.15395
 -4:25:09.153950
 -0 04:25
  -0 04:25
   -0 04:25
 -0 04:25:09
  -0 04:25:09
   -0 04:25:09
 -0 04:25:09.2
    -0 04:25:09
  -0 04:25:09.2
 -0 04:25:09.15
     -0 04:25:09
   -0 04:25:09.2
  -0 04:25:09.15
 -0 04:25:09.154
      -0 04:25:09
    -0 04:25:09.2
   -0 04:25:09.15
  -0 04:25:09.154
 -0 04:25:09.1539
       -0 04:25:09
     -0 04:25:09.2
    -0 04:25:09.15
   -0 04:25:09.154
  -0 04:25:09.1539
 -0 04:25:09.15395
        -0 04:25:09
      -0 04:25:09.2
     -0 04:25:09.15
    -0 04:25:09.154
   -0 04:25:09.1539
  -0 04:25:09.15395
 -0 04:25:09.153950
 -6:49
  -6:49
   -6:49
 -6:49:27
  -6:49:27
   -6:49:27
 -6:49:27.1
    -6:49:27
  -6:49:27.1
 -6:49:27.11
     -6:49:27
   -6:49:27.1
  -6:49:27.11
 -6:49:27.105
      -6:49:27
    -6:49:27.1
   -6:49:27.11
  -6:49:27.105
 -6:49:27.1053
       -6:49:27
     -6:49:27.1
    -6:49:27.11
   -6:49:27.105
  -6:49:27.1053
 -6:49:27.10533
        -6:49:27
      -6:49:27.1
     -6:49:27.11
    -6:49:27.105
   -6:49:27.1053
  -6:49:27.10533
 -6:49:27.105330
 -0 06:49
  -0 06:49
   -0 06:49
 -0 06:49:27
  -0 06:49:27
   -0 06:49:27
 -0 06:49:27.1
    -0 06:49:27
  -0 06:49:27.1
 -0 06:49:27.11
     -0 06:49:27
   -0 06:49:27.1
  -0 06:49:27.11
 -0 06:49:27.105
      -0 06:49:27
    -0 06:49:27.1
   -0 06:49:27.11
  -0 06:49:27.105
 -0 06:49:27.1053
       -0 06:49:27
     -0 06:49:27.1
    -0 06:49:27.11
   -0 06:49:27.105
  -0 06:49:27.1053
 -0 06:49:27.10533
        -0 06:49:27
      -0 06:49:27.1
     -0 06:49:27.11
    -0 06:49:27.105
   -0 06:49:27.1053
  -0 06:49:27.10533
 -0 06:49:27.105330
 -2:57
  -2:57
   -2:57
 -2:57:52
  -2:57:52
   -2:57:52
 -2:57:52.5
    -2:57:52
  -2:57:52.5
 -2:57:52.48
     -2:57:52
   -2:57:52.5
  -2:57:52.48
 -2:57:52.482
      -2:57:52
    -2:57:52.5
   -2:57:52.48
  -2:57:52.482
 -2:57:52.4823
       -2:57:52
     -2:57:52.5
    -2:57:52.48
   -2:57:52.482
  -2:57:52.4823
 -2:57:52.48229
        -2:57:52
      -2:57:52.5
     -2:57:52.48
    -2:57:52.482
   -2:57:52.4823
  -2:57:52.48229
 -2:57:52.482290
 -0 02:57
  -0 02:57
   -0 02:57
 -0 02:57:52
  -0 02:57:52
   -0 02:57:52
 -0 02:57:52.5
    -0 02:57:52
  -0 02:57:52.5
 -0 02:57:52.48
     -0 02:57:52
   -0 02:57:52.5
  -0 02:57:52.48
 -0 02:57:52.482
      -0 02:57:52
    -0 02:57:52.5
   -0 02:57:52.48
  -0 02:57:52.482
 -0 02:57:52.4823
       -0 02:57:52
     -0 02:57:52.5
    -0 02:57:52.48
   -0 02:57:52.482
  -0 02:57:52.4823
 -0 02:57:52.48229
        -0 02:57:52
      -0 02:57:52.5
     -0 02:57:52.48
    -0 02:57:52.482
   -0 02:57:52.4823
  -0 02:57:52.48229
 -0 02:57:52.482290
 *****
 -16:45
  -16:45
   -16:45
 -16:45:44
  -16:45:44
  -16:45:44
   -16:45:44
 -16:45:44.7
 -16:45:44.7
    -16:45:44
  -16:45:44.7
 -16:45:44.66
 -16:45:44.66
     -16:45:44
   -16:45:44.7
  -16:45:44.66
 -16:45:44.658
 -16:45:44.658
      -16:45:44
    -16:45:44.7
   -16:45:44.66
  -16:45:44.658
 -16:45:44.6583
 -16:45:44.6583
       -16:45:44
     -16:45:44.7
    -16:45:44.66
   -16:45:44.658
  -16:45:44.6583
 -16:45:44.65827
 -16:45:44.65827
 -0 16:45
  -0 16:45
   -0 16:45
 -0 16:45:44
  -0 16:45:44
   -0 16:45:44
 -0 16:45:44.7
    -0 16:45:44
  -0 16:45:44.7
 -0 16:45:44.66
     -0 16:45:44
   -0 16:45:44.7
  -0 16:45:44.66
 -0 16:45:44.658
      -0 16:45:44
    -0 16:45:44.7
   -0 16:45:44.66
  -0 16:45:44.658
 -0 16:45:44.6583
       -0 16:45:44
     -0 16:45:44.7
    -0 16:45:44.66
   -0 16:45:44.658
  -0 16:45:44.6583
 -0 16:45:44.65827
        -0 16:45:44
      -0 16:45:44.7
     -0 16:45:44.66
    -0 16:45:44.658
   -0 16:45:44.6583
  -0 16:45:44.65827
 -0 16:45:44.658270
 *****
 -21:30
  -21:30
   -21:30
 -21:30:57
  -21:30:57
  -21:30:57
   -21:30:57
 -21:30:57.6
 -21:30:57.6
    -21:30:57
  -21:30:57.6
 -21:30:57.58
 -21:30:57.58
     -21:30:57
   -21:30:57.6
  -21:30:57.58
 -21:30:57.582
 -21:30:57.582
      -21:30:57
    -21:30:57.6
   -21:30:57.58
  -21:30:57.582
 -21:30:57.5822
 -21:30:57.5822
       -21:30:57
     -21:30:57.6
    -21:30:57.58
   -21:30:57.582
  -21:30:57.5822
 -21:30:57.58219
 -21:30:57.58219
 -0 21:30
  -0 21:30
   -0 21:30
 -0 21:30:57
  -0 21:30:57
   -0 21:30:57
 -0 21:30:57.6
    -0 21:30:57
  -0 21:30:57.6
 -0 21:30:57.58
     -0 21:30:57
   -0 21:30:57.6
  -0 21:30:57.58
 -0 21:30:57.582
      -0 21:30:57
    -0 21:30:57.6
   -0 21:30:57.58
  -0 21:30:57.582
 -0 21:30:57.5822
       -0 21:30:57
     -0 21:30:57.6
    -0 21:30:57.58
   -0 21:30:57.582
  -0 21:30:57.5822
 -0 21:30:57.58219
        -0 21:30:57
      -0 21:30:57.6
     -0 21:30:57.58
    -0 21:30:57.582
   -0 21:30:57.5822
  -0 21:30:57.58219
 -0 21:30:57.582190
 *****
 -22:30
  -22:30
   -22:30
 -22:30:04
  -22:30:04
  -22:30:04
   -22:30:04
 -22:30:04.2
 -22:30:04.2
    -22:30:04
  -22:30:04.2
 -22:30:04.18
 -22:30:04.18
     -22:30:04
   -22:30:04.2
  -22:30:04.18
 -22:30:04.183
 -22:30:04.183
      -22:30:04
    -22:30:04.2
   -22:30:04.18
  -22:30:04.183
 -22:30:04.1835
 -22:30:04.1835
       -22:30:04
     -22:30:04.2
    -22:30:04.18
   -22:30:04.183
  -22:30:04.1835
 -22:30:04.18347
 -22:30:04.18347
 -0 22:30
  -0 22:30
   -0 22:30
 -0 22:30:04
  -0 22:30:04
   -0 22:30:04
 -0 22:30:04.2
    -0 22:30:04
  -0 22:30:04.2
 -0 22:30:04.18
     -0 22:30:04
   -0 22:30:04.2
  -0 22:30:04.18
 -0 22:30:04.183
      -0 22:30:04
    -0 22:30:04.2
   -0 22:30:04.18
  -0 22:30:04.183
 -0 22:30:04.1835
       -0 22:30:04
     -0 22:30:04.2
    -0 22:30:04.18
   -0 22:30:04.183
  -0 22:30:04.1835
 -0 22:30:04.18347
        -0 22:30:04
      -0 22:30:04.2
     -0 22:30:04.18
    -0 22:30:04.183
   -0 22:30:04.1835
  -0 22:30:04.18347
 -0 22:30:04.183470
 -1:56
  -1:56
   -1:56
 -1:56:51
  -1:56:51
   -1:56:51
 -1:56:51.6
    -1:56:51
  -1:56:51.6
 -1:56:51.59
     -1:56:51
   -1:56:51.6
  -1:56:51.59
 -1:56:51.593
      -1:56:51
    -1:56:51.6
   -1:56:51.59
  -1:56:51.593
 -1:56:51.5932
       -1:56:51
     -1:56:51.6
    -1:56:51.59
   -1:56:51.593
  -1:56:51.5932
 -1:56:51.59319
        -1:56:51
      -1:56:51.6
     -1:56:51.59
    -1:56:51.593
   -1:56:51.5932
  -1:56:51.59319
 -1:56:51.593190
 -0 01:56
  -0 01:56
   -0 01:56
 -0 01:56:51
  -0 01:56:51
   -0 01:56:51
 -0 01:56:51.6
    -0 01:56:51
  -0 01:56:51.6
 -0 01:56:51.59
     -0 01:56:51
   -0 01:56:51.6
  -0 01:56:51.59
 -0 01:56:51.593
      -0 01:56:51
    -0 01:56:51.6
   -0 01:56:51.59
  -0 01:56:51.593
 -0 01:56:51.5932
       -0 01:56:51
     -0 01:56:51.6
    -0 01:56:51.59
   -0 01:56:51.593
  -0 01:56:51.5932
 -0 01:56:51.59319
        -0 01:56:51
      -0 01:56:51.6
     -0 01:56:51.59
    -0 01:56:51.593
   -0 01:56:51.5932
  -0 01:56:51.59319
 -0 01:56:51.593190
 *****
 -24:00
  -24:00
   -24:00
 -24:00:00
  -24:00:00
  -24:00:00
   -24:00:00
 -24:00:00.0
 -24:00:00.0
    -24:00:00
  -24:00:00.0
 -24:00:00.00
 -24:00:00.00
     -24:00:00
   -24:00:00.0
  -24:00:00.00
 -24:00:00.000
 -24:00:00.000
      -24:00:00
    -24:00:00.0
   -24:00:00.00
  -24:00:00.000
 -24:00:00.0000
 -24:00:00.0000
       -24:00:00
     -24:00:00.0
    -24:00:00.00
   -24:00:00.000
  -24:00:00.0000
 -24:00:00.00000
 -24:00:00.00000
 -1 00:00
  -1 00:00
   -1 00:00
 -1 00:00:00
  -1 00:00:00
   -1 00:00:00
 -1 00:00:00.0
    -1 00:00:00
  -1 00:00:00.0
 -1 00:00:00.00
     -1 00:00:00
   -1 00:00:00.0
  -1 00:00:00.00
 -1 00:00:00.000
      -1 00:00:00
    -1 00:00:00.0
   -1 00:00:00.00
  -1 00:00:00.000
 -1 00:00:00.0000
       -1 00:00:00
     -1 00:00:00.0
    -1 00:00:00.00
   -1 00:00:00.000
  -1 00:00:00.0000
 -1 00:00:00.00000
        -1 00:00:00
      -1 00:00:00.0
     -1 00:00:00.00
    -1 00:00:00.000
   -1 00:00:00.0000
  -1 00:00:00.00000
 -1 00:00:00.000000
 *****
 -28:50
  -28:50
   -28:50
 -28:50:38
  -28:50:38
  -28:50:38
   -28:50:38
 -28:50:38.1
 -28:50:38.1
    -28:50:38
  -28:50:38.1
 -28:50:38.12
 -28:50:38.12
     -28:50:38
   -28:50:38.1
  -28:50:38.12
 -28:50:38.123
 -28:50:38.123
      -28:50:38
    -28:50:38.1
   -28:50:38.12
  -28:50:38.123
 -28:50:38.1230
 -28:50:38.1230
       -28:50:38
     -28:50:38.1
    -28:50:38.12
   -28:50:38.123
  -28:50:38.1230
 -28:50:38.12301
 -28:50:38.12301
 -1 04:50
  -1 04:50
   -1 04:50
 -1 04:50:38
  -1 04:50:38
   -1 04:50:38
 -1 04:50:38.1
    -1 04:50:38
  -1 04:50:38.1
 -1 04:50:38.12
     -1 04:50:38
   -1 04:50:38.1
  -1 04:50:38.12
 -1 04:50:38.123
      -1 04:50:38
    -1 04:50:38.1
   -1 04:50:38.12
  -1 04:50:38.123
 -1 04:50:38.1230
       -1 04:50:38
     -1 04:50:38.1
    -1 04:50:38.12
   -1 04:50:38.123
  -1 04:50:38.1230
 -1 04:50:38.12301
        -1 04:50:38
      -1 04:50:38.1
     -1 04:50:38.12
    -1 04:50:38.123
   -1 04:50:38.1230
  -1 04:50:38.12301
 -1 04:50:38.123010
 *****
 -36:31
  -36:31
   -36:31
 -36:31:35
  -36:31:35
  -36:31:35
   -36:31:35
 -36:31:35.2
 -36:31:35.2
    -36:31:35
  -36:31:35.2
 -36:31:35.23
 -36:31:35.23
     -36:31:35
   -36:31:35.2
  -36:31:35.23
 -36:31:35.235
 -36:31:35.235
      -36:31:35
    -36:31:35.2
   -36:31:35.23
  -36:31:35.235
 -36:31:35.2345
 -36:31:35.2345
       -36:31:35
     -36:31:35.2
    -36:31:35.23
   -36:31:35.235
  -36:31:35.2345
 -36:31:35.23453
 -36:31:35.23453
 -1 12:31
  -1 12:31
   -1 12:31
 -1 12:31:35
  -1 12:31:35
   -1 12:31:35
 -1 12:31:35.2
    -1 12:31:35
  -1 12:31:35.2
 -1 12:31:35.23
     -1 12:31:35
   -1 12:31:35.2
  -1 12:31:35.23
 -1 12:31:35.235
      -1 12:31:35
    -1 12:31:35.2
   -1 12:31:35.23
  -1 12:31:35.235
 -1 12:31:35.2345
       -1 12:31:35
     -1 12:31:35.2
    -1 12:31:35.23
   -1 12:31:35.235
  -1 12:31:35.2345
 -1 12:31:35.23453
        -1 12:31:35
      -1 12:31:35.2
     -1 12:31:35.23
    -1 12:31:35.235
   -1 12:31:35.2345
  -1 12:31:35.23453
 -1 12:31:35.234530
 *****
 -36:47
  -36:47
   -36:47
 -36:47:53
  -36:47:53
  -36:47:53
   -36:47:53
 -36:47:53.3
 -36:47:53.3
    -36:47:53
  -36:47:53.3
 -36:47:53.35
 -36:47:53.35
     -36:47:53
   -36:47:53.3
  -36:47:53.35
 -36:47:53.345
 -36:47:53.345
      -36:47:53
    -36:47:53.3
   -36:47:53.35
  -36:47:53.345
 -36:47:53.3451
 -36:47:53.3451
       -36:47:53
     -36:47:53.3
    -36:47:53.35
   -36:47:53.345
  -36:47:53.3451
 -36:47:53.34505
 -36:47:53.34505
 -1 12:47
  -1 12:47
   -1 12:47
 -1 12:47:53
  -1 12:47:53
   -1 12:47:53
 -1 12:47:53.3
    -1 12:47:53
  -1 12:47:53.3
 -1 12:47:53.35
     -1 12:47:53
   -1 12:47:53.3
  -1 12:47:53.35
 -1 12:47:53.345
      -1 12:47:53
    -1 12:47:53.3
   -1 12:47:53.35
  -1 12:47:53.345
 -1 12:47:53.3451
       -1 12:47:53
     -1 12:47:53.3
    -1 12:47:53.35
   -1 12:47:53.345
  -1 12:47:53.3451
 -1 12:47:53.34505
        -1 12:47:53
      -1 12:47:53.3
     -1 12:47:53.35
    -1 12:47:53.345
   -1 12:47:53.3451
  -1 12:47:53.34505
 -1 12:47:53.345050
 *****
 -25:26
  -25:26
   -25:26
 -25:26:00
  -25:26:00
  -25:26:00
   -25:26:00
 -25:26:00.5
 -25:26:00.5
    -25:26:00
  -25:26:00.5
 -25:26:00.46
 -25:26:00.46
     -25:26:00
   -25:26:00.5
  -25:26:00.46
 -25:26:00.456
 -25:26:00.456
      -25:26:00
    -25:26:00.5
   -25:26:00.46
  -25:26:00.456
 -25:26:00.4561
 -25:26:00.4561
       -25:26:00
     -25:26:00.5
    -25:26:00.46
   -25:26:00.456
  -25:26:00.4561
 -25:26:00.45615
 -25:26:00.45615
 -1 01:26
  -1 01:26
   -1 01:26
 -1 01:26:00
  -1 01:26:00
   -1 01:26:00
 -1 01:26:00.5
    -1 01:26:00
  -1 01:26:00.5
 -1 01:26:00.46
     -1 01:26:00
   -1 01:26:00.5
  -1 01:26:00.46
 -1 01:26:00.456
      -1 01:26:00
    -1 01:26:00.5
   -1 01:26:00.46
  -1 01:26:00.456
 -1 01:26:00.4561
       -1 01:26:00
     -1 01:26:00.5
    -1 01:26:00.46
   -1 01:26:00.456
  -1 01:26:00.4561
 -1 01:26:00.45615
        -1 01:26:00
      -1 01:26:00.5
     -1 01:26:00.46
    -1 01:26:00.456
   -1 01:26:00.4561
  -1 01:26:00.45615
 -1 01:26:00.456150
 *****
 -44:58
  -44:58
   -44:58
 -44:58:11
  -44:58:11
  -44:58:11
   -44:58:11
 -44:58:11.6
 -44:58:11.6
    -44:58:11
  -44:58:11.6
 -44:58:11.57
 -44:58:11.57
     -44:58:11
   -44:58:11.6
  -44:58:11.57
 -44:58:11.567
 -44:58:11.567
      -44:58:11
    -44:58:11.6
   -44:58:11.57
  -44:58:11.567
 -44:58:11.5668
 -44:58:11.5668
       -44:58:11
     -44:58:11.6
    -44:58:11.57
   -44:58:11.567
  -44:58:11.5668
 -44:58:11.56677
 -44:58:11.56677
 -1 20:58
  -1 20:58
   -1 20:58
 -1 20:58:11
  -1 20:58:11
   -1 20:58:11
 -1 20:58:11.6
    -1 20:58:11
  -1 20:58:11.6
 -1 20:58:11.57
     -1 20:58:11
   -1 20:58:11.6
  -1 20:58:11.57
 -1 20:58:11.567
      -1 20:58:11
    -1 20:58:11.6
   -1 20:58:11.57
  -1 20:58:11.567
 -1 20:58:11.5668
       -1 20:58:11
     -1 20:58:11.6
    -1 20:58:11.57
   -1 20:58:11.567
  -1 20:58:11.5668
 -1 20:58:11.56677
        -1 20:58:11
      -1 20:58:11.6
     -1 20:58:11.57
    -1 20:58:11.567
   -1 20:58:11.5668
  -1 20:58:11.56677
 -1 20:58:11.566770
 *****
 -31:36
  -31:36
   -31:36
 -31:36:05
  -31:36:05
  -31:36:05
   -31:36:05
 -31:36:05.2
 -31:36:05.2
    -31:36:05
  -31:36:05.2
 -31:36:05.19
 -31:36:05.19
     -31:36:05
   -31:36:05.2
  -31:36:05.19
 -31:36:05.190
 -31:36:05.190
      -31:36:05
    -31:36:05.2
   -31:36:05.19
  -31:36:05.190
 -31:36:05.1896
 -31:36:05.1896
       -31:36:05
     -31:36:05.2
    -31:36:05.19
   -31:36:05.190
  -31:36:05.1896
 -31:36:05.18964
 -31:36:05.18964
 -1 07:36
  -1 07:36
   -1 07:36
 -1 07:36:05
  -1 07:36:05
   -1 07:36:05
 -1 07:36:05.2
    -1 07:36:05
  -1 07:36:05.2
 -1 07:36:05.19
     -1 07:36:05
   -1 07:36:05.2
  -1 07:36:05.19
 -1 07:36:05.190
      -1 07:36:05
    -1 07:36:05.2
   -1 07:36:05.19
  -1 07:36:05.190
 -1 07:36:05.1896
       -1 07:36:05
     -1 07:36:05.2
    -1 07:36:05.19
   -1 07:36:05.190
  -1 07:36:05.1896
 -1 07:36:05.18964
        -1 07:36:05
      -1 07:36:05.2
     -1 07:36:05.19
    -1 07:36:05.190
   -1 07:36:05.1896
  -1 07:36:05.18964
 -1 07:36:05.189640
 *****
 -39:43
  -39:43
   -39:43
 -39:43:49
  -39:43:49
  -39:43:49
   -39:43:49
 -39:43:49.8
 -39:43:49.8
    -39:43:49
  -39:43:49.8
 -39:43:49.83
 -39:43:49.83
     -39:43:49
   -39:43:49.8
  -39:43:49.83
 -39:43:49.831
 -39:43:49.831
      -39:43:49
    -39:43:49.8
   -39:43:49.83
  -39:43:49.831
 -39:43:49.8313
 -39:43:49.8313
       -39:43:49
     -39:43:49.8
    -39:43:49.83
   -39:43:49.831
  -39:43:49.8313
 -39:43:49.83132
 -39:43:49.83132
 -1 15:43
  -1 15:43
   -1 15:43
 -1 15:43:49
  -1 15:43:49
   -1 15:43:49
 -1 15:43:49.8
    -1 15:43:49
  -1 15:43:49.8
 -1 15:43:49.83
     -1 15:43:49
   -1 15:43:49.8
  -1 15:43:49.83
 -1 15:43:49.831
      -1 15:43:49
    -1 15:43:49.8
   -1 15:43:49.83
  -1 15:43:49.831
 -1 15:43:49.8313
       -1 15:43:49
     -1 15:43:49.8
    -1 15:43:49.83
   -1 15:43:49.831
  -1 15:43:49.8313
 -1 15:43:49.83132
        -1 15:43:49
      -1 15:43:49.8
     -1 15:43:49.83
    -1 15:43:49.831
   -1 15:43:49.8313
  -1 15:43:49.83132
 -1 15:43:49.831320
 *****
 -28:25
  -28:25
   -28:25
 -28:25:09
  -28:25:09
  -28:25:09
   -28:25:09
 -28:25:09.0
 -28:25:09.0
    -28:25:09
  -28:25:09.0
 -28:25:09.01
 -28:25:09.01
     -28:25:09
   -28:25:09.0
  -28:25:09.01
 -28:25:09.013
 -28:25:09.013
      -28:25:09
    -28:25:09.0
   -28:25:09.01
  -28:25:09.013
 -28:25:09.0129
 -28:25:09.0129
       -28:25:09
     -28:25:09.0
    -28:25:09.01
   -28:25:09.013
  -28:25:09.0129
 -28:25:09.01293
 -28:25:09.01293
 -1 04:25
  -1 04:25
   -1 04:25
 -1 04:25:09
  -1 04:25:09
   -1 04:25:09
 -1 04:25:09.0
    -1 04:25:09
  -1 04:25:09.0
 -1 04:25:09.01
     -1 04:25:09
   -1 04:25:09.0
  -1 04:25:09.01
 -1 04:25:09.013
      -1 04:25:09
    -1 04:25:09.0
   -1 04:25:09.01
  -1 04:25:09.013
 -1 04:25:09.0129
       -1 04:25:09
     -1 04:25:09.0
    -1 04:25:09.01
   -1 04:25:09.013
  -1 04:25:09.0129
 -1 04:25:09.01293
        -1 04:25:09
      -1 04:25:09.0
     -1 04:25:09.01
    -1 04:25:09.013
   -1 04:25:09.0129
  -1 04:25:09.01293
 -1 04:25:09.012930
 *****
 -30:49
  -30:49
   -30:49
 -30:49:27
  -30:49:27
  -30:49:27
   -30:49:27
 -30:49:27.5
 -30:49:27.5
    -30:49:27
  -30:49:27.5
 -30:49:27.52
 -30:49:27.52
     -30:49:27
   -30:49:27.5
  -30:49:27.52
 -30:49:27.524
 -30:49:27.524
      -30:49:27
    -30:49:27.5
   -30:49:27.52
  -30:49:27.524
 -30:49:27.5237
 -30:49:27.5237
       -30:49:27
     -30:49:27.5
    -30:49:27.52
   -30:49:27.524
  -30:49:27.5237
 -30:49:27.52375
 -30:49:27.52375
 -1 06:49
  -1 06:49
   -1 06:49
 -1 06:49:27
  -1 06:49:27
   -1 06:49:27
 -1 06:49:27.5
    -1 06:49:27
  -1 06:49:27.5
 -1 06:49:27.52
     -1 06:49:27
   -1 06:49:27.5
  -1 06:49:27.52
 -1 06:49:27.524
      -1 06:49:27
    -1 06:49:27.5
   -1 06:49:27.52
  -1 06:49:27.524
 -1 06:49:27.5237
       -1 06:49:27
     -1 06:49:27.5
    -1 06:49:27.52
   -1 06:49:27.524
  -1 06:49:27.5237
 -1 06:49:27.52375
        -1 06:49:27
      -1 06:49:27.5
     -1 06:49:27.52
    -1 06:49:27.524
   -1 06:49:27.5237
  -1 06:49:27.52375
 -1 06:49:27.523750
 *****
 -26:57
  -26:57
   -26:57
 -26:57:52
  -26:57:52
  -26:57:52
   -26:57:52
 -26:57:52.0
 -26:57:52.0
    -26:57:52
  -26:57:52.0
 -26:57:52.02
 -26:57:52.02
     -26:57:52
   -26:57:52.0
  -26:57:52.02
 -26:57:52.016
 -26:57:52.016
      -26:57:52
    -26:57:52.0
   -26:57:52.02
  -26:57:52.016
 -26:57:52.0157
 -26:57:52.0157
       -26:57:52
     -26:57:52.0
    -26:57:52.02
   -26:57:52.016
  -26:57:52.0157
 -26:57:52.01565
 -26:57:52.01565
 -1 02:57
  -1 02:57
   -1 02:57
 -1 02:57:52
  -1 02:57:52
   -1 02:57:52
 -1 02:57:52.0
    -1 02:57:52
  -1 02:57:52.0
 -1 02:57:52.02
     -1 02:57:52
   -1 02:57:52.0
  -1 02:57:52.02
 -1 02:57:52.016
      -1 02:57:52
    -1 02:57:52.0
   -1 02:57:52.02
  -1 02:57:52.016
 -1 02:57:52.0157
       -1 02:57:52
     -1 02:57:52.0
    -1 02:57:52.02
   -1 02:57:52.016
  -1 02:57:52.0157
 -1 02:57:52.01565
        -1 02:57:52
      -1 02:57:52.0
     -1 02:57:52.02
    -1 02:57:52.016
   -1 02:57:52.0157
  -1 02:57:52.01565
 -1 02:57:52.015650
 *****
 -40:45
  -40:45
   -40:45
 -40:45:44
  -40:45:44
  -40:45:44
   -40:45:44
 -40:45:44.9
 -40:45:44.9
    -40:45:44
  -40:45:44.9
 -40:45:44.87
 -40:45:44.87
     -40:45:44
   -40:45:44.9
  -40:45:44.87
 -40:45:44.865
 -40:45:44.865
      -40:45:44
    -40:45:44.9
   -40:45:44.87
  -40:45:44.865
 -40:45:44.8653
 -40:45:44.8653
       -40:45:44
     -40:45:44.9
    -40:45:44.87
   -40:45:44.865
  -40:45:44.8653
 -40:45:44.86529
 -40:45:44.86529
 -1 16:45
  -1 16:45
   -1 16:45
 -1 16:45:44
  -1 16:45:44
   -1 16:45:44
 -1 16:45:44.9
    -1 16:45:44
  -1 16:45:44.9
 -1 16:45:44.87
     -1 16:45:44
   -1 16:45:44.9
  -1 16:45:44.87
 -1 16:45:44.865
      -1 16:45:44
    -1 16:45:44.9
   -1 16:45:44.87
  -1 16:45:44.865
 -1 16:45:44.8653
       -1 16:45:44
     -1 16:45:44.9
    -1 16:45:44.87
   -1 16:45:44.865
  -1 16:45:44.8653
 -1 16:45:44.86529
        -1 16:45:44
      -1 16:45:44.9
     -1 16:45:44.87
    -1 16:45:44.865
   -1 16:45:44.8653
  -1 16:45:44.86529
 -1 16:45:44.865290
 *****
 -45:30
  -45:30
   -45:30
 -45:30:57
  -45:30:57
  -45:30:57
   -45:30:57
 -45:30:57.8
 -45:30:57.8
    -45:30:57
  -45:30:57.8
 -45:30:57.82
 -45:30:57.82
     -45:30:57
   -45:30:57.8
  -45:30:57.82
 -45:30:57.820
 -45:30:57.820
      -45:30:57
    -45:30:57.8
   -45:30:57.82
  -45:30:57.820
 -45:30:57.8205
 -45:30:57.8205
       -45:30:57
     -45:30:57.8
    -45:30:57.82
   -45:30:57.820
  -45:30:57.8205
 -45:30:57.82047
 -45:30:57.82047
 -1 21:30
  -1 21:30
   -1 21:30
 -1 21:30:57
  -1 21:30:57
   -1 21:30:57
 -1 21:30:57.8
    -1 21:30:57
  -1 21:30:57.8
 -1 21:30:57.82
     -1 21:30:57
   -1 21:30:57.8
  -1 21:30:57.82
 -1 21:30:57.820
      -1 21:30:57
    -1 21:30:57.8
   -1 21:30:57.82
  -1 21:30:57.820
 -1 21:30:57.8205
       -1 21:30:57
     -1 21:30:57.8
    -1 21:30:57.82
   -1 21:30:57.820
  -1 21:30:57.8205
 -1 21:30:57.82047
        -1 21:30:57
      -1 21:30:57.8
     -1 21:30:57.82
    -1 21:30:57.820
   -1 21:30:57.8205
  -1 21:30:57.82047
 -1 21:30:57.820470
 *****
 -28:25
  -28:25
   -28:25
 -28:25:09
  -28:25:09
  -28:25:09
   -28:25:09
 -28:25:09.2
 -28:25:09.2
    -28:25:09
  -28:25:09.2
 -28:25:09.15
 -28:25:09.15
     -28:25:09
   -28:25:09.2
  -28:25:09.15
 -28:25:09.154
 -28:25:09.154
      -28:25:09
    -28:25:09.2
   -28:25:09.15
  -28:25:09.154
 -28:25:09.1540
 -28:25:09.1540
       -28:25:09
     -28:25:09.2
    -28:25:09.15
   -28:25:09.154
  -28:25:09.1540
 -28:25:09.15395
 -28:25:09.15395
 -1 04:25
  -1 04:25
   -1 04:25
 -1 04:25:09
  -1 04:25:09
   -1 04:25:09
 -1 04:25:09.2
    -1 04:25:09
  -1 04:25:09.2
 -1 04:25:09.15
     -1 04:25:09
   -1 04:25:09.2
  -1 04:25:09.15
 -1 04:25:09.154
      -1 04:25:09
    -1 04:25:09.2
   -1 04:25:09.15
  -1 04:25:09.154
 -1 04:25:09.1540
       -1 04:25:09
     -1 04:25:09.2
    -1 04:25:09.15
   -1 04:25:09.154
  -1 04:25:09.1540
 -1 04:25:09.15395
        -1 04:25:09
      -1 04:25:09.2
     -1 04:25:09.15
    -1 04:25:09.154
   -1 04:25:09.1540
  -1 04:25:09.15395
 -1 04:25:09.153950
 *****
 -30:49
  -30:49
   -30:49
 -30:49:27
  -30:49:27
  -30:49:27
   -30:49:27
 -30:49:27.1
 -30:49:27.1
    -30:49:27
  -30:49:27.1
 -30:49:27.11
 -30:49:27.11
     -30:49:27
   -30:49:27.1
  -30:49:27.11
 -30:49:27.105
 -30:49:27.105
      -30:49:27
    -30:49:27.1
   -30:49:27.11
  -30:49:27.105
 -30:49:27.1053
 -30:49:27.1053
       -30:49:27
     -30:49:27.1
    -30:49:27.11
   -30:49:27.105
  -30:49:27.1053
 -30:49:27.10533
 -30:49:27.10533
 -1 06:49
  -1 06:49
   -1 06:49
 -1 06:49:27
  -1 06:49:27
   -1 06:49:27
 -1 06:49:27.1
    -1 06:49:27
  -1 06:49:27.1
 -1 06:49:27.11
     -1 06:49:27
   -1 06:49:27.1
  -1 06:49:27.11
 -1 06:49:27.105
      -1 06:49:27
    -1 06:49:27.1
   -1 06:49:27.11
  -1 06:49:27.105
 -1 06:49:27.1053
       -1 06:49:27
     -1 06:49:27.1
    -1 06:49:27.11
   -1 06:49:27.105
  -1 06:49:27.1053
 -1 06:49:27.10533
        -1 06:49:27
      -1 06:49:27.1
     -1 06:49:27.11
    -1 06:49:27.105
   -1 06:49:27.1053
  -1 06:49:27.10533
 -1 06:49:27.105330
 *****
 -26:57
  -26:57
   -26:57
 -26:57:52
  -26:57:52
  -26:57:52
   -26:57:52
 -26:57:52.5
 -26:57:52.5
    -26:57:52
  -26:57:52.5
 -26:57:52.48
 -26:57:52.48
     -26:57:52
   -26:57:52.5
  -26:57:52.48
 -26:57:52.482
 -26:57:52.482
      -26:57:52
    -26:57:52.5
   -26:57:52.48
  -26:57:52.482
 -26:57:52.4823
 -26:57:52.4823
       -26:57:52
     -26:57:52.5
    -26:57:52.48
   -26:57:52.482
  -26:57:52.4823
 -26:57:52.48229
 -26:57:52.48229
 -1 02:57
  -1 02:57
   -1 02:57
 -1 02:57:52
  -1 02:57:52
   -1 02:57:52
 -1 02:57:52.5
    -1 02:57:52
  -1 02:57:52.5
 -1 02:57:52.48
     -1 02:57:52
   -1 02:57:52.5
  -1 02:57:52.48
 -1 02:57:52.482
      -1 02:57:52
    -1 02:57:52.5
   -1 02:57:52.48
  -1 02:57:52.482
 -1 02:57:52.4823
       -1 02:57:52
     -1 02:57:52.5
    -1 02:57:52.48
   -1 02:57:52.482
  -1 02:57:52.4823
 -1 02:57:52.48229
        -1 02:57:52
      -1 02:57:52.5
     -1 02:57:52.48
    -1 02:57:52.482
   -1 02:57:52.4823
  -1 02:57:52.48229
 -1 02:57:52.482290
 *****
 -40:45
  -40:45
   -40:45
 -40:45:44
  -40:45:44
  -40:45:44
   -40:45:44
 -40:45:44.7
 -40:45:44.7
    -40:45:44
  -40:45:44.7
 -40:45:44.66
 -40:45:44.66
     -40:45:44
   -40:45:44.7
  -40:45:44.66
 -40:45:44.658
 -40:45:44.658
      -40:45:44
    -40:45:44.7
   -40:45:44.66
  -40:45:44.658
 -40:45:44.6583
 -40:45:44.6583
       -40:45:44
     -40:45:44.7
    -40:45:44.66
   -40:45:44.658
  -40:45:44.6583
 -40:45:44.65827
 -40:45:44.65827
 -1 16:45
  -1 16:45
   -1 16:45
 -1 16:45:44
  -1 16:45:44
   -1 16:45:44
 -1 16:45:44.7
    -1 16:45:44
  -1 16:45:44.7
 -1 16:45:44.66
     -1 16:45:44
   -1 16:45:44.7
  -1 16:45:44.66
 -1 16:45:44.658
      -1 16:45:44
    -1 16:45:44.7
   -1 16:45:44.66
  -1 16:45:44.658
 -1 16:45:44.6583
       -1 16:45:44
     -1 16:45:44.7
    -1 16:45:44.66
   -1 16:45:44.658
  -1 16:45:44.6583
 -1 16:45:44.65827
        -1 16:45:44
      -1 16:45:44.7
     -1 16:45:44.66
    -1 16:45:44.658
   -1 16:45:44.6583
  -1 16:45:44.65827
 -1 16:45:44.658270
 *****
 -45:30
  -45:30
   -45:30
 -45:30:57
  -45:30:57
  -45:30:57
   -45:30:57
 -45:30:57.6
 -45:30:57.6
    -45:30:57
  -45:30:57.6
 -45:30:57.58
 -45:30:57.58
     -45:30:57
   -45:30:57.6
  -45:30:57.58
 -45:30:57.582
 -45:30:57.582
      -45:30:57
    -45:30:57.6
   -45:30:57.58
  -45:30:57.582
 -45:30:57.5822
 -45:30:57.5822
       -45:30:57
     -45:30:57.6
    -45:30:57.58
   -45:30:57.582
  -45:30:57.5822
 -45:30:57.58219
 -45:30:57.58219
 -1 21:30
  -1 21:30
   -1 21:30
 -1 21:30:57
  -1 21:30:57
   -1 21:30:57
 -1 21:30:57.6
    -1 21:30:57
  -1 21:30:57.6
 -1 21:30:57.58
     -1 21:30:57
   -1 21:30:57.6
  -1 21:30:57.58
 -1 21:30:57.582
      -1 21:30:57
    -1 21:30:57.6
   -1 21:30:57.58
  -1 21:30:57.582
 -1 21:30:57.5822
       -1 21:30:57
     -1 21:30:57.6
    -1 21:30:57.58
   -1 21:30:57.582
  -1 21:30:57.5822
 -1 21:30:57.58219
        -1 21:30:57
      -1 21:30:57.6
     -1 21:30:57.58
    -1 21:30:57.582
   -1 21:30:57.5822
  -1 21:30:57.58219
 -1 21:30:57.582190
 *****
 -46:30
  -46:30
   -46:30
 -46:30:04
  -46:30:04
  -46:30:04
   -46:30:04
 -46:30:04.2
 -46:30:04.2
    -46:30:04
  -46:30:04.2
 -46:30:04.18
 -46:30:04.18
     -46:30:04
   -46:30:04.2
  -46:30:04.18
 -46:30:04.183
 -46:30:04.183
      -46:30:04
    -46:30:04.2
   -46:30:04.18
  -46:30:04.183
 -46:30:04.1835
 -46:30:04.1835
       -46:30:04
     -46:30:04.2
    -46:30:04.18
   -46:30:04.183
  -46:30:04.1835
 -46:30:04.18347
 -46:30:04.18347
 -1 22:30
  -1 22:30
   -1 22:30
 -1 22:30:04
  -1 22:30:04
   -1 22:30:04
 -1 22:30:04.2
    -1 22:30:04
  -1 22:30:04.2
 -1 22:30:04.18
     -1 22:30:04
   -1 22:30:04.2
  -1 22:30:04.18
 -1 22:30:04.183
      -1 22:30:04
    -1 22:30:04.2
   -1 22:30:04.18
  -1 22:30:04.183
 -1 22:30:04.1835
       -1 22:30:04
     -1 22:30:04.2
    -1 22:30:04.18
   -1 22:30:04.183
  -1 22:30:04.1835
 -1 22:30:04.18347
        -1 22:30:04
      -1 22:30:04.2
     -1 22:30:04.18
    -1 22:30:04.183
   -1 22:30:04.1835
  -1 22:30:04.18347
 -1 22:30:04.183470
 *****
 -25:56
  -25:56
   -25:56
 -25:56:51
  -25:56:51
  -25:56:51
   -25:56:51
 -25:56:51.6
 -25:56:51.6
    -25:56:51
  -25:56:51.6
 -25:56:51.59
 -25:56:51.59
     -25:56:51
   -25:56:51.6
  -25:56:51.59
 -25:56:51.593
 -25:56:51.593
      -25:56:51
    -25:56:51.6
   -25:56:51.59
  -25:56:51.593
 -25:56:51.5932
 -25:56:51.5932
       -25:56:51
     -25:56:51.6
    -25:56:51.59
   -25:56:51.593
  -25:56:51.5932
 -25:56:51.59319
 -25:56:51.59319
 -1 01:56
  -1 01:56
   -1 01:56
 -1 01:56:51
  -1 01:56:51
   -1 01:56:51
 -1 01:56:51.6
    -1 01:56:51
  -1 01:56:51.6
 -1 01:56:51.59
     -1 01:56:51
   -1 01:56:51.6
  -1 01:56:51.59
 -1 01:56:51.593
      -1 01:56:51
    -1 01:56:51.6
   -1 01:56:51.59
  -1 01:56:51.593
 -1 01:56:51.5932
       -1 01:56:51
     -1 01:56:51.6
    -1 01:56:51.59
   -1 01:56:51.593
  -1 01:56:51.5932
 -1 01:56:51.59319
        -1 01:56:51
      -1 01:56:51.6
     -1 01:56:51.59
    -1 01:56:51.593
   -1 01:56:51.5932
  -1 01:56:51.59319
 -1 01:56:51.593190
 *****
 -48:00
  -48:00
   -48:00
 -48:00:00
  -48:00:00
  -48:00:00
   -48:00:00
 -48:00:00.0
 -48:00:00.0
    -48:00:00
  -48:00:00.0
 -48:00:00.00
 -48:00:00.00
     -48:00:00
   -48:00:00.0
  -48:00:00.00
 -48:00:00.000
 -48:00:00.000
      -48:00:00
    -48:00:00.0
   -48:00:00.00
  -48:00:00.000
 -48:00:00.0000
 -48:00:00.0000
       -48:00:00
     -48:00:00.0
    -48:00:00.00
   -48:00:00.000
  -48:00:00.0000
 -48:00:00.00000
 -48:00:00.00000
 -2 00:00
  -2 00:00
   -2 00:00
 -2 00:00:00
  -2 00:00:00
   -2 00:00:00
 -2 00:00:00.0
    -2 00:00:00
  -2 00:00:00.0
 -2 00:00:00.00
     -2 00:00:00
   -2 00:00:00.0
  -2 00:00:00.00
 -2 00:00:00.000
      -2 00:00:00
    -2 00:00:00.0
   -2 00:00:00.00
  -2 00:00:00.000
 -2 00:00:00.0000
       -2 00:00:00
     -2 00:00:00.0
    -2 00:00:00.00
   -2 00:00:00.000
  -2 00:00:00.0000
 -2 00:00:00.00000
        -2 00:00:00
      -2 00:00:00.0
     -2 00:00:00.00
    -2 00:00:00.000
   -2 00:00:00.0000
  -2 00:00:00.00000
 -2 00:00:00.000000
 *****
 -52:50
  -52:50
   -52:50
 -52:50:38
  -52:50:38
  -52:50:38
   -52:50:38
 -52:50:38.1
 -52:50:38.1
    -52:50:38
  -52:50:38.1
 -52:50:38.12
 -52:50:38.12
     -52:50:38
   -52:50:38.1
  -52:50:38.12
 -52:50:38.123
 -52:50:38.123
      -52:50:38
    -52:50:38.1
   -52:50:38.12
  -52:50:38.123
 -52:50:38.1230
 -52:50:38.1230
       -52:50:38
     -52:50:38.1
    -52:50:38.12
   -52:50:38.123
  -52:50:38.1230
 -52:50:38.12301
 -52:50:38.12301
 -2 04:50
  -2 04:50
   -2 04:50
 -2 04:50:38
  -2 04:50:38
   -2 04:50:38
 -2 04:50:38.1
    -2 04:50:38
  -2 04:50:38.1
 -2 04:50:38.12
     -2 04:50:38
   -2 04:50:38.1
  -2 04:50:38.12
 -2 04:50:38.123
      -2 04:50:38
    -2 04:50:38.1
   -2 04:50:38.12
  -2 04:50:38.123
 -2 04:50:38.1230
       -2 04:50:38
     -2 04:50:38.1
    -2 04:50:38.12
   -2 04:50:38.123
  -2 04:50:38.1230
 -2 04:50:38.12301
        -2 04:50:38
      -2 04:50:38.1
     -2 04:50:38.12
    -2 04:50:38.123
   -2 04:50:38.1230
  -2 04:50:38.12301
 -2 04:50:38.123010
 *****
 -60:31
  -60:31
   -60:31
 -60:31:35
  -60:31:35
  -60:31:35
   -60:31:35
 -60:31:35.2
 -60:31:35.2
    -60:31:35
  -60:31:35.2
 -60:31:35.23
 -60:31:35.23
     -60:31:35
   -60:31:35.2
  -60:31:35.23
 -60:31:35.235
 -60:31:35.235
      -60:31:35
    -60:31:35.2
   -60:31:35.23
  -60:31:35.235
 -60:31:35.2345
 -60:31:35.2345
       -60:31:35
     -60:31:35.2
    -60:31:35.23
   -60:31:35.235
  -60:31:35.2345
 -60:31:35.23453
 -60:31:35.23453
 -2 12:31
  -2 12:31
   -2 12:31
 -2 12:31:35
  -2 12:31:35
   -2 12:31:35
 -2 12:31:35.2
    -2 12:31:35
  -2 12:31:35.2
 -2 12:31:35.23
     -2 12:31:35
   -2 12:31:35.2
  -2 12:31:35.23
 -2 12:31:35.235
      -2 12:31:35
    -2 12:31:35.2
   -2 12:31:35.23
  -2 12:31:35.235
 -2 12:31:35.2345
       -2 12:31:35
     -2 12:31:35.2
    -2 12:31:35.23
   -2 12:31:35.235
  -2 12:31:35.2345
 -2 12:31:35.23453
        -2 12:31:35
      -2 12:31:35.2
     -2 12:31:35.23
    -2 12:31:35.235
   -2 12:31:35.2345
  -2 12:31:35.23453
 -2 12:31:35.234530
 *****
 -60:47
  -60:47
   -60:47
 -60:47:53
  -60:47:53
  -60:47:53
   -60:47:53
 -60:47:53.3
 -60:47:53.3
    -60:47:53
  -60:47:53.3
 -60:47:53.35
 -60:47:53.35
     -60:47:53
   -60:47:53.3
  -60:47:53.35
 -60:47:53.345
 -60:47:53.345
      -60:47:53
    -60:47:53.3
   -60:47:53.35
  -60:47:53.345
 -60:47:53.3451
 -60:47:53.3451
       -60:47:53
     -60:47:53.3
    -60:47:53.35
   -60:47:53.345
  -60:47:53.3451
 -60:47:53.34505
 -60:47:53.34505
 -2 12:47
  -2 12:47
   -2 12:47
 -2 12:47:53
  -2 12:47:53
   -2 12:47:53
 -2 12:47:53.3
    -2 12:47:53
  -2 12:47:53.3
 -2 12:47:53.35
     -2 12:47:53
   -2 12:47:53.3
  -2 12:47:53.35
 -2 12:47:53.345
      -2 12:47:53
    -2 12:47:53.3
   -2 12:47:53.35
  -2 12:47:53.345
 -2 12:47:53.3451
       -2 12:47:53
     -2 12:47:53.3
    -2 12:47:53.35
   -2 12:47:53.345
  -2 12:47:53.3451
 -2 12:47:53.34505
        -2 12:47:53
      -2 12:47:53.3
     -2 12:47:53.35
    -2 12:47:53.345
   -2 12:47:53.3451
  -2 12:47:53.34505
 -2 12:47:53.345050
 *****
 -49:26
  -49:26
   -49:26
 -49:26:00
  -49:26:00
  -49:26:00
   -49:26:00
 -49:26:00.5
 -49:26:00.5
    -49:26:00
  -49:26:00.5
 -49:26:00.46
 -49:26:00.46
     -49:26:00
   -49:26:00.5
  -49:26:00.46
 -49:26:00.456
 -49:26:00.456
      -49:26:00
    -49:26:00.5
   -49:26:00.46
  -49:26:00.456
 -49:26:00.4562
 -49:26:00.4562
       -49:26:00
     -49:26:00.5
    -49:26:00.46
   -49:26:00.456
  -49:26:00.4562
 -49:26:00.45615
 -49:26:00.45615
 -2 01:26
  -2 01:26
   -2 01:26
 -2 01:26:00
  -2 01:26:00
   -2 01:26:00
 -2 01:26:00.5
    -2 01:26:00
  -2 01:26:00.5
 -2 01:26:00.46
     -2 01:26:00
   -2 01:26:00.5
  -2 01:26:00.46
 -2 01:26:00.456
      -2 01:26:00
    -2 01:26:00.5
   -2 01:26:00.46
  -2 01:26:00.456
 -2 01:26:00.4562
       -2 01:26:00
     -2 01:26:00.5
    -2 01:26:00.46
   -2 01:26:00.456
  -2 01:26:00.4562
 -2 01:26:00.45615
        -2 01:26:00
      -2 01:26:00.5
     -2 01:26:00.46
    -2 01:26:00.456
   -2 01:26:00.4562
  -2 01:26:00.45615
 -2 01:26:00.456150
 *****
 -68:58
  -68:58
   -68:58
 -68:58:11
  -68:58:11
  -68:58:11
   -68:58:11
 -68:58:11.6
 -68:58:11.6
    -68:58:11
  -68:58:11.6
 -68:58:11.57
 -68:58:11.57
     -68:58:11
   -68:58:11.6
  -68:58:11.57
 -68:58:11.567
 -68:58:11.567
      -68:58:11
    -68:58:11.6
   -68:58:11.57
  -68:58:11.567
 -68:58:11.5668
 -68:58:11.5668
       -68:58:11
     -68:58:11.6
    -68:58:11.57
   -68:58:11.567
  -68:58:11.5668
 -68:58:11.56677
 -68:58:11.56677
 -2 20:58
  -2 20:58
   -2 20:58
 -2 20:58:11
  -2 20:58:11
   -2 20:58:11
 -2 20:58:11.6
    -2 20:58:11
  -2 20:58:11.6
 -2 20:58:11.57
     -2 20:58:11
   -2 20:58:11.6
  -2 20:58:11.57
 -2 20:58:11.567
      -2 20:58:11
    -2 20:58:11.6
   -2 20:58:11.57
  -2 20:58:11.567
 -2 20:58:11.5668
       -2 20:58:11
     -2 20:58:11.6
    -2 20:58:11.57
   -2 20:58:11.567
  -2 20:58:11.5668
 -2 20:58:11.56677
        -2 20:58:11
      -2 20:58:11.6
     -2 20:58:11.57
    -2 20:58:11.567
   -2 20:58:11.5668
  -2 20:58:11.56677
 -2 20:58:11.566770
 *****
 -55:36
  -55:36
   -55:36
 -55:36:05
  -55:36:05
  -55:36:05
   -55:36:05
 -55:36:05.2
 -55:36:05.2
    -55:36:05
  -55:36:05.2
 -55:36:05.19
 -55:36:05.19
     -55:36:05
   -55:36:05.2
  -55:36:05.19
 -55:36:05.190
 -55:36:05.190
      -55:36:05
    -55:36:05.2
   -55:36:05.19
  -55:36:05.190
 -55:36:05.1896
 -55:36:05.1896
       -55:36:05
     -55:36:05.2
    -55:36:05.19
   -55:36:05.190
  -55:36:05.1896
 -55:36:05.18964
 -55:36:05.18964
 -2 07:36
  -2 07:36
   -2 07:36
 -2 07:36:05
  -2 07:36:05
   -2 07:36:05
 -2 07:36:05.2
    -2 07:36:05
  -2 07:36:05.2
 -2 07:36:05.19
     -2 07:36:05
   -2 07:36:05.2
  -2 07:36:05.19
 -2 07:36:05.190
      -2 07:36:05
    -2 07:36:05.2
   -2 07:36:05.19
  -2 07:36:05.190
 -2 07:36:05.1896
       -2 07:36:05
     -2 07:36:05.2
    -2 07:36:05.19
   -2 07:36:05.190
  -2 07:36:05.1896
 -2 07:36:05.18964
        -2 07:36:05
      -2 07:36:05.2
     -2 07:36:05.19
    -2 07:36:05.190
   -2 07:36:05.1896
  -2 07:36:05.18964
 -2 07:36:05.189640
 *****
 -63:43
  -63:43
   -63:43
 -63:43:49
  -63:43:49
  -63:43:49
   -63:43:49
 -63:43:49.8
 -63:43:49.8
    -63:43:49
  -63:43:49.8
 -63:43:49.83
 -63:43:49.83
     -63:43:49
   -63:43:49.8
  -63:43:49.83
 -63:43:49.831
 -63:43:49.831
      -63:43:49
    -63:43:49.8
   -63:43:49.83
  -63:43:49.831
 -63:43:49.8313
 -63:43:49.8313
       -63:43:49
     -63:43:49.8
    -63:43:49.83
   -63:43:49.831
  -63:43:49.8313
 -63:43:49.83132
 -63:43:49.83132
 -2 15:43
  -2 15:43
   -2 15:43
 -2 15:43:49
  -2 15:43:49
   -2 15:43:49
 -2 15:43:49.8
    -2 15:43:49
  -2 15:43:49.8
 -2 15:43:49.83
     -2 15:43:49
   -2 15:43:49.8
  -2 15:43:49.83
 -2 15:43:49.831
      -2 15:43:49
    -2 15:43:49.8
   -2 15:43:49.83
  -2 15:43:49.831
 -2 15:43:49.8313
       -2 15:43:49
     -2 15:43:49.8
    -2 15:43:49.83
   -2 15:43:49.831
  -2 15:43:49.8313
 -2 15:43:49.83132
        -2 15:43:49
      -2 15:43:49.8
     -2 15:43:49.83
    -2 15:43:49.831
   -2 15:43:49.8313
  -2 15:43:49.83132
 -2 15:43:49.831320
 *****
 -52:25
  -52:25
   -52:25
 -52:25:09
  -52:25:09
  -52:25:09
   -52:25:09
 -52:25:09.0
 -52:25:09.0
    -52:25:09
  -52:25:09.0
 -52:25:09.01
 -52:25:09.01
     -52:25:09
   -52:25:09.0
  -52:25:09.01
 -52:25:09.013
 -52:25:09.013
      -52:25:09
    -52:25:09.0
   -52:25:09.01
  -52:25:09.013
 -52:25:09.0129
 -52:25:09.0129
       -52:25:09
     -52:25:09.0
    -52:25:09.01
   -52:25:09.013
  -52:25:09.0129
 -52:25:09.01293
 -52:25:09.01293
 -2 04:25
  -2 04:25
   -2 04:25
 -2 04:25:09
  -2 04:25:09
   -2 04:25:09
 -2 04:25:09.0
    -2 04:25:09
  -2 04:25:09.0
 -2 04:25:09.01
     -2 04:25:09
   -2 04:25:09.0
  -2 04:25:09.01
 -2 04:25:09.013
      -2 04:25:09
    -2 04:25:09.0
   -2 04:25:09.01
  -2 04:25:09.013
 -2 04:25:09.0129
       -2 04:25:09
     -2 04:25:09.0
    -2 04:25:09.01
   -2 04:25:09.013
  -2 04:25:09.0129
 -2 04:25:09.01293
        -2 04:25:09
      -2 04:25:09.0
     -2 04:25:09.01
    -2 04:25:09.013
   -2 04:25:09.0129
  -2 04:25:09.01293
 -2 04:25:09.012930
 *****
 -54:49
  -54:49
   -54:49
 -54:49:27
  -54:49:27
  -54:49:27
   -54:49:27
 -54:49:27.5
 -54:49:27.5
    -54:49:27
  -54:49:27.5
 -54:49:27.52
 -54:49:27.52
     -54:49:27
   -54:49:27.5
  -54:49:27.52
 -54:49:27.524
 -54:49:27.524
      -54:49:27
    -54:49:27.5
   -54:49:27.52
  -54:49:27.524
 -54:49:27.5237
 -54:49:27.5237
       -54:49:27
     -54:49:27.5
    -54:49:27.52
   -54:49:27.524
  -54:49:27.5237
 -54:49:27.52375
 -54:49:27.52375
 -2 06:49
  -2 06:49
   -2 06:49
 -2 06:49:27
  -2 06:49:27
   -2 06:49:27
 -2 06:49:27.5
    -2 06:49:27
  -2 06:49:27.5
 -2 06:49:27.52
     -2 06:49:27
   -2 06:49:27.5
  -2 06:49:27.52
 -2 06:49:27.524
      -2 06:49:27
    -2 06:49:27.5
   -2 06:49:27.52
  -2 06:49:27.524
 -2 06:49:27.5237
       -2 06:49:27
     -2 06:49:27.5
    -2 06:49:27.52
   -2 06:49:27.524
  -2 06:49:27.5237
 -2 06:49:27.52375
        -2 06:49:27
      -2 06:49:27.5
     -2 06:49:27.52
    -2 06:49:27.524
   -2 06:49:27.5237
  -2 06:49:27.52375
 -2 06:49:27.523750
 *****
 -50:57
  -50:57
   -50:57
 -50:57:52
  -50:57:52
  -50:57:52
   -50:57:52
 -50:57:52.0
 -50:57:52.0
    -50:57:52
  -50:57:52.0
 -50:57:52.02
 -50:57:52.02
     -50:57:52
   -50:57:52.0
  -50:57:52.02
 -50:57:52.016
 -50:57:52.016
      -50:57:52
    -50:57:52.0
   -50:57:52.02
  -50:57:52.016
 -50:57:52.0156
 -50:57:52.0156
       -50:57:52
     -50:57:52.0
    -50:57:52.02
   -50:57:52.016
  -50:57:52.0156
 -50:57:52.01565
 -50:57:52.01565
 -2 02:57
  -2 02:57
   -2 02:57
 -2 02:57:52
  -2 02:57:52
   -2 02:57:52
 -2 02:57:52.0
    -2 02:57:52
  -2 02:57:52.0
 -2 02:57:52.02
     -2 02:57:52
   -2 02:57:52.0
  -2 02:57:52.02
 -2 02:57:52.016
      -2 02:57:52
    -2 02:57:52.0
   -2 02:57:52.02
  -2 02:57:52.016
 -2 02:57:52.0156
       -2 02:57:52
     -2 02:57:52.0
    -2 02:57:52.02
   -2 02:57:52.016
  -2 02:57:52.0156
 -2 02:57:52.01565
        -2 02:57:52
      -2 02:57:52.0
     -2 02:57:52.02
    -2 02:57:52.016
   -2 02:57:52.0156
  -2 02:57:52.01565
 -2 02:57:52.015650
 *****
 -64:45
  -64:45
   -64:45
 -64:45:44
  -64:45:44
  -64:45:44
   -64:45:44
 -64:45:44.9
 -64:45:44.9
    -64:45:44
  -64:45:44.9
 -64:45:44.87
 -64:45:44.87
     -64:45:44
   -64:45:44.9
  -64:45:44.87
 -64:45:44.865
 -64:45:44.865
      -64:45:44
    -64:45:44.9
   -64:45:44.87
  -64:45:44.865
 -64:45:44.8653
 -64:45:44.8653
       -64:45:44
     -64:45:44.9
    -64:45:44.87
   -64:45:44.865
  -64:45:44.8653
 -64:45:44.86529
 -64:45:44.86529
 -2 16:45
  -2 16:45
   -2 16:45
 -2 16:45:44
  -2 16:45:44
   -2 16:45:44
 -2 16:45:44.9
    -2 16:45:44
  -2 16:45:44.9
 -2 16:45:44.87
     -2 16:45:44
   -2 16:45:44.9
  -2 16:45:44.87
 -2 16:45:44.865
      -2 16:45:44
    -2 16:45:44.9
   -2 16:45:44.87
  -2 16:45:44.865
 -2 16:45:44.8653
       -2 16:45:44
     -2 16:45:44.9
    -2 16:45:44.87
   -2 16:45:44.865
  -2 16:45:44.8653
 -2 16:45:44.86529
        -2 16:45:44
      -2 16:45:44.9
     -2 16:45:44.87
    -2 16:45:44.865
   -2 16:45:44.8653
  -2 16:45:44.86529
 -2 16:45:44.865290
 *****
 -69:30
  -69:30
   -69:30
 -69:30:57
  -69:30:57
  -69:30:57
   -69:30:57
 -69:30:57.8
 -69:30:57.8
    -69:30:57
  -69:30:57.8
 -69:30:57.82
 -69:30:57.82
     -69:30:57
   -69:30:57.8
  -69:30:57.82
 -69:30:57.820
 -69:30:57.820
      -69:30:57
    -69:30:57.8
   -69:30:57.82
  -69:30:57.820
 -69:30:57.8205
 -69:30:57.8205
       -69:30:57
     -69:30:57.8
    -69:30:57.82
   -69:30:57.820
  -69:30:57.8205
 -69:30:57.82047
 -69:30:57.82047
 -2 21:30
  -2 21:30
   -2 21:30
 -2 21:30:57
  -2 21:30:57
   -2 21:30:57
 -2 21:30:57.8
    -2 21:30:57
  -2 21:30:57.8
 -2 21:30:57.82
     -2 21:30:57
   -2 21:30:57.8
  -2 21:30:57.82
 -2 21:30:57.820
      -2 21:30:57
    -2 21:30:57.8
   -2 21:30:57.82
  -2 21:30:57.820
 -2 21:30:57.8205
       -2 21:30:57
     -2 21:30:57.8
    -2 21:30:57.82
   -2 21:30:57.820
  -2 21:30:57.8205
 -2 21:30:57.82047
        -2 21:30:57
      -2 21:30:57.8
     -2 21:30:57.82
    -2 21:30:57.820
   -2 21:30:57.8205
  -2 21:30:57.82047
 -2 21:30:57.820470
 *****
 -52:25
  -52:25
   -52:25
 -52:25:09
  -52:25:09
  -52:25:09
   -52:25:09
 -52:25:09.2
 -52:25:09.2
    -52:25:09
  -52:25:09.2
 -52:25:09.15
 -52:25:09.15
     -52:25:09
   -52:25:09.2
  -52:25:09.15
 -52:25:09.154
 -52:25:09.154
      -52:25:09
    -52:25:09.2
   -52:25:09.15
  -52:25:09.154
 -52:25:09.1540
 -52:25:09.1540
       -52:25:09
     -52:25:09.2
    -52:25:09.15
   -52:25:09.154
  -52:25:09.1540
 -52:25:09.15395
 -52:25:09.15395
 -2 04:25
  -2 04:25
   -2 04:25
 -2 04:25:09
  -2 04:25:09
   -2 04:25:09
 -2 04:25:09.2
    -2 04:25:09
  -2 04:25:09.2
 -2 04:25:09.15
     -2 04:25:09
   -2 04:25:09.2
  -2 04:25:09.15
 -2 04:25:09.154
      -2 04:25:09
    -2 04:25:09.2
   -2 04:25:09.15
  -2 04:25:09.154
 -2 04:25:09.1540
       -2 04:25:09
     -2 04:25:09.2
    -2 04:25:09.15
   -2 04:25:09.154
  -2 04:25:09.1540
 -2 04:25:09.15395
        -2 04:25:09
      -2 04:25:09.2
     -2 04:25:09.15
    -2 04:25:09.154
   -2 04:25:09.1540
  -2 04:25:09.15395
 -2 04:25:09.153950
 *****
 -54:49
  -54:49
   -54:49
 -54:49:27
  -54:49:27
  -54:49:27
   -54:49:27
 -54:49:27.1
 -54:49:27.1
    -54:49:27
  -54:49:27.1
 -54:49:27.11
 -54:49:27.11
     -54:49:27
   -54:49:27.1
  -54:49:27.11
 -54:49:27.105
 -54:49:27.105
      -54:49:27
    -54:49:27.1
   -54:49:27.11
  -54:49:27.105
 -54:49:27.1053
 -54:49:27.1053
       -54:49:27
     -54:49:27.1
    -54:49:27.11
   -54:49:27.105
  -54:49:27.1053
 -54:49:27.10533
 -54:49:27.10533
 -2 06:49
  -2 06:49
   -2 06:49
 -2 06:49:27
  -2 06:49:27
   -2 06:49:27
 -2 06:49:27.1
    -2 06:49:27
  -2 06:49:27.1
 -2 06:49:27.11
     -2 06:49:27
   -2 06:49:27.1
  -2 06:49:27.11
 -2 06:49:27.105
      -2 06:49:27
    -2 06:49:27.1
   -2 06:49:27.11
  -2 06:49:27.105
 -2 06:49:27.1053
       -2 06:49:27
     -2 06:49:27.1
    -2 06:49:27.11
   -2 06:49:27.105
  -2 06:49:27.1053
 -2 06:49:27.10533
        -2 06:49:27
      -2 06:49:27.1
     -2 06:49:27.11
    -2 06:49:27.105
   -2 06:49:27.1053
  -2 06:49:27.10533
 -2 06:49:27.105330
 *****
 -50:57
  -50:57
   -50:57
 -50:57:52
  -50:57:52
  -50:57:52
   -50:57:52
 -50:57:52.5
 -50:57:52.5
    -50:57:52
  -50:57:52.5
 -50:57:52.48
 -50:57:52.48
     -50:57:52
   -50:57:52.5
  -50:57:52.48
 -50:57:52.482
 -50:57:52.482
      -50:57:52
    -50:57:52.5
   -50:57:52.48
  -50:57:52.482
 -50:57:52.4823
 -50:57:52.4823
       -50:57:52
     -50:57:52.5
    -50:57:52.48
   -50:57:52.482
  -50:57:52.4823
 -50:57:52.48229
 -50:57:52.48229
 -2 02:57
  -2 02:57
   -2 02:57
 -2 02:57:52
  -2 02:57:52
   -2 02:57:52
 -2 02:57:52.5
    -2 02:57:52
  -2 02:57:52.5
 -2 02:57:52.48
     -2 02:57:52
   -2 02:57:52.5
  -2 02:57:52.48
 -2 02:57:52.482
      -2 02:57:52
    -2 02:57:52.5
   -2 02:57:52.48
  -2 02:57:52.482
 -2 02:57:52.4823
       -2 02:57:52
     -2 02:57:52.5
    -2 02:57:52.48
   -2 02:57:52.482
  -2 02:57:52.4823
 -2 02:57:52.48229
        -2 02:57:52
      -2 02:57:52.5
     -2 02:57:52.48
    -2 02:57:52.482
   -2 02:57:52.4823
  -2 02:57:52.48229
 -2 02:57:52.482290
 *****
 -64:45
  -64:45
   -64:45
 -64:45:44
  -64:45:44
  -64:45:44
   -64:45:44
 -64:45:44.7
 -64:45:44.7
    -64:45:44
  -64:45:44.7
 -64:45:44.66
 -64:45:44.66
     -64:45:44
   -64:45:44.7
  -64:45:44.66
 -64:45:44.658
 -64:45:44.658
      -64:45:44
    -64:45:44.7
   -64:45:44.66
  -64:45:44.658
 -64:45:44.6583
 -64:45:44.6583
       -64:45:44
     -64:45:44.7
    -64:45:44.66
   -64:45:44.658
  -64:45:44.6583
 -64:45:44.65827
 -64:45:44.65827
 -2 16:45
  -2 16:45
   -2 16:45
 -2 16:45:44
  -2 16:45:44
   -2 16:45:44
 -2 16:45:44.7
    -2 16:45:44
  -2 16:45:44.7
 -2 16:45:44.66
     -2 16:45:44
   -2 16:45:44.7
  -2 16:45:44.66
 -2 16:45:44.658
      -2 16:45:44
    -2 16:45:44.7
   -2 16:45:44.66
  -2 16:45:44.658
 -2 16:45:44.6583
       -2 16:45:44
     -2 16:45:44.7
    -2 16:45:44.66
   -2 16:45:44.658
  -2 16:45:44.6583
 -2 16:45:44.65827
        -2 16:45:44
      -2 16:45:44.7
     -2 16:45:44.66
    -2 16:45:44.658
   -2 16:45:44.6583
  -2 16:45:44.65827
 -2 16:45:44.658270
 *****
 -69:30
  -69:30
   -69:30
 -69:30:57
  -69:30:57
  -69:30:57
   -69:30:57
 -69:30:57.6
 -69:30:57.6
    -69:30:57
  -69:30:57.6
 -69:30:57.58
 -69:30:57.58
     -69:30:57
   -69:30:57.6
  -69:30:57.58
 -69:30:57.582
 -69:30:57.582
      -69:30:57
    -69:30:57.6
   -69:30:57.58
  -69:30:57.582
 -69:30:57.5822
 -69:30:57.5822
       -69:30:57
     -69:30:57.6
    -69:30:57.58
   -69:30:57.582
  -69:30:57.5822
 -69:30:57.58219
 -69:30:57.58219
 -2 21:30
  -2 21:30
   -2 21:30
 -2 21:30:57
  -2 21:30:57
   -2 21:30:57
 -2 21:30:57.6
    -2 21:30:57
  -2 21:30:57.6
 -2 21:30:57.58
     -2 21:30:57
   -2 21:30:57.6
  -2 21:30:57.58
 -2 21:30:57.582
      -2 21:30:57
    -2 21:30:57.6
   -2 21:30:57.58
  -2 21:30:57.582
 -2 21:30:57.5822
       -2 21:30:57
     -2 21:30:57.6
    -2 21:30:57.58
   -2 21:30:57.582
  -2 21:30:57.5822
 -2 21:30:57.58219
        -2 21:30:57
      -2 21:30:57.6
     -2 21:30:57.58
    -2 21:30:57.582
   -2 21:30:57.5822
  -2 21:30:57.58219
 -2 21:30:57.582190
 *****
 -70:30
  -70:30
   -70:30
 -70:30:04
  -70:30:04
  -70:30:04
   -70:30:04
 -70:30:04.2
 -70:30:04.2
    -70:30:04
  -70:30:04.2
 -70:30:04.18
 -70:30:04.18
     -70:30:04
   -70:30:04.2
  -70:30:04.18
 -70:30:04.183
 -70:30:04.183
      -70:30:04
    -70:30:04.2
   -70:30:04.18
  -70:30:04.183
 -70:30:04.1835
 -70:30:04.1835
       -70:30:04
     -70:30:04.2
    -70:30:04.18
   -70:30:04.183
  -70:30:04.1835
 -70:30:04.18347
 -70:30:04.18347
 -2 22:30
  -2 22:30
   -2 22:30
 -2 22:30:04
  -2 22:30:04
   -2 22:30:04
 -2 22:30:04.2
    -2 22:30:04
  -2 22:30:04.2
 -2 22:30:04.18
     -2 22:30:04
   -2 22:30:04.2
  -2 22:30:04.18
 -2 22:30:04.183
      -2 22:30:04
    -2 22:30:04.2
   -2 22:30:04.18
  -2 22:30:04.183
 -2 22:30:04.1835
       -2 22:30:04
     -2 22:30:04.2
    -2 22:30:04.18
   -2 22:30:04.183
  -2 22:30:04.1835
 -2 22:30:04.18347
        -2 22:30:04
      -2 22:30:04.2
     -2 22:30:04.18
    -2 22:30:04.183
   -2 22:30:04.1835
  -2 22:30:04.18347
 -2 22:30:04.183470
 *****
 -49:56
  -49:56
   -49:56
 -49:56:51
  -49:56:51
  -49:56:51
   -49:56:51
 -49:56:51.6
 -49:56:51.6
    -49:56:51
  -49:56:51.6
 -49:56:51.59
 -49:56:51.59
     -49:56:51
   -49:56:51.6
  -49:56:51.59
 -49:56:51.593
 -49:56:51.593
      -49:56:51
    -49:56:51.6
   -49:56:51.59
  -49:56:51.593
 -49:56:51.5932
 -49:56:51.5932
       -49:56:51
     -49:56:51.6
    -49:56:51.59
   -49:56:51.593
  -49:56:51.5932
 -49:56:51.59319
 -49:56:51.59319
 -2 01:56
  -2 01:56
   -2 01:56
 -2 01:56:51
  -2 01:56:51
   -2 01:56:51
 -2 01:56:51.6
    -2 01:56:51
  -2 01:56:51.6
 -2 01:56:51.59
     -2 01:56:51
   -2 01:56:51.6
  -2 01:56:51.59
 -2 01:56:51.593
      -2 01:56:51
    -2 01:56:51.6
   -2 01:56:51.59
  -2 01:56:51.593
 -2 01:56:51.5932
       -2 01:56:51
     -2 01:56:51.6
    -2 01:56:51.59
   -2 01:56:51.593
  -2 01:56:51.5932
 -2 01:56:51.59319
        -2 01:56:51
      -2 01:56:51.6
     -2 01:56:51.59
    -2 01:56:51.593
   -2 01:56:51.5932
  -2 01:56:51.59319
 -2 01:56:51.593190
 *****
 ******
 *******
 -1296:00
  -1296:00
   -1296:00
   -1296:00
 -1296:00:00
 -1296:00:00
 -1296:00:00
  -1296:00:00
  -1296:00:00
  -1296:00:00
  -1296:00:00
   -1296:00:00
 -1296:00:00.0
 -1296:00:00.0
 -1296:00:00.0
 -1296:00:00.0
    -1296:00:00
  -1296:00:00.0
 -1296:00:00.00
 -1296:00:00.00
 -1296:00:00.00
 -1296:00:00.00
     -1296:00:00
   -1296:00:00.0
  -1296:00:00.00
 -1296:00:00.000
 -1296:00:00.000
 -1296:00:00.000
 -1296:00:00.000
 ********
 -54 00:00
  -54 00:00
   -54 00:00
 -54 00:00:00
  -54 00:00:00
  -54 00:00:00
   -54 00:00:00
 -54 00:00:00.0
 -54 00:00:00.0
    -54 00:00:00
  -54 00:00:00.0
 -54 00:00:00.00
 -54 00:00:00.00
     -54 00:00:00
   -54 00:00:00.0
  -54 00:00:00.00
 -54 00:00:00.000
 -54 00:00:00.000
      -54 00:00:00
    -54 00:00:00.0
   -54 00:00:00.00
  -54 00:00:00.000
 -54 00:00:00.0000
 -54 00:00:00.0000
       -54 00:00:00
     -54 00:00:00.0
    -54 00:00:00.00
   -54 00:00:00.000
  -54 00:00:00.0000
 -54 00:00:00.00000
 -54 00:00:00.00000
 *****
 ******
 *******
 -1300:50
  -1300:50
   -1300:50
   -1300:50
 -1300:50:38
 -1300:50:38
 -1300:50:38
  -1300:50:38
  -1300:50:38
  -1300:50:38
  -1300:50:38
   -1300:50:38
 -1300:50:38.1
 -1300:50:38.1
 -1300:50:38.1
 -1300:50:38.1
    -1300:50:38
  -1300:50:38.1
 -1300:50:38.12
 -1300:50:38.12
 -1300:50:38.12
 -1300:50:38.12
     -1300:50:38
   -1300:50:38.1
  -1300:50:38.12
 -1300:50:38.123
 -1300:50:38.123
 -1300:50:38.123
 -1300:50:38.123
 ********
 -54 04:50
  -54 04:50
   -54 04:50
 -54 04:50:38
  -54 04:50:38
  -54 04:50:38
   -54 04:50:38
 -54 04:50:38.1
 -54 04:50:38.1
    -54 04:50:38
  -54 04:50:38.1
 -54 04:50:38.12
 -54 04:50:38.12
     -54 04:50:38
   -54 04:50:38.1
  -54 04:50:38.12
 -54 04:50:38.123
 -54 04:50:38.123
      -54 04:50:38
    -54 04:50:38.1
   -54 04:50:38.12
  -54 04:50:38.123
 -54 04:50:38.1230
 -54 04:50:38.1230
       -54 04:50:38
     -54 04:50:38.1
    -54 04:50:38.12
   -54 04:50:38.123
  -54 04:50:38.1230
 -54 04:50:38.12301
 -54 04:50:38.12301
 *****
 ******
 *******
 -1308:31
  -1308:31
   -1308:31
   -1308:31
 -1308:31:35
 -1308:31:35
 -1308:31:35
  -1308:31:35
  -1308:31:35
  -1308:31:35
  -1308:31:35
   -1308:31:35
 -1308:31:35.2
 -1308:31:35.2
 -1308:31:35.2
 -1308:31:35.2
    -1308:31:35
  -1308:31:35.2
 -1308:31:35.23
 -1308:31:35.23
 -1308:31:35.23
 -1308:31:35.23
     -1308:31:35
   -1308:31:35.2
  -1308:31:35.23
 -1308:31:35.235
 -1308:31:35.235
 -1308:31:35.235
 -1308:31:35.235
 ********
 -54 12:31
  -54 12:31
   -54 12:31
 -54 12:31:35
  -54 12:31:35
  -54 12:31:35
   -54 12:31:35
 -54 12:31:35.2
 -54 12:31:35.2
    -54 12:31:35
  -54 12:31:35.2
 -54 12:31:35.23
 -54 12:31:35.23
     -54 12:31:35
   -54 12:31:35.2
  -54 12:31:35.23
 -54 12:31:35.235
 -54 12:31:35.235
      -54 12:31:35
    -54 12:31:35.2
   -54 12:31:35.23
  -54 12:31:35.235
 -54 12:31:35.2345
 -54 12:31:35.2345
       -54 12:31:35
     -54 12:31:35.2
    -54 12:31:35.23
   -54 12:31:35.235
  -54 12:31:35.2345
 -54 12:31:35.23453
 -54 12:31:35.23453
 *****
 ******
 *******
 -1308:47
  -1308:47
   -1308:47
   -1308:47
 -1308:47:53
 -1308:47:53
 -1308:47:53
  -1308:47:53
  -1308:47:53
  -1308:47:53
  -1308:47:53
   -1308:47:53
 -1308:47:53.3
 -1308:47:53.3
 -1308:47:53.3
 -1308:47:53.3
    -1308:47:53
  -1308:47:53.3
 -1308:47:53.35
 -1308:47:53.35
 -1308:47:53.35
 -1308:47:53.35
     -1308:47:53
   -1308:47:53.3
  -1308:47:53.35
 -1308:47:53.345
 -1308:47:53.345
 -1308:47:53.345
 -1308:47:53.345
 ********
 -54 12:47
  -54 12:47
   -54 12:47
 -54 12:47:53
  -54 12:47:53
  -54 12:47:53
   -54 12:47:53
 -54 12:47:53.3
 -54 12:47:53.3
    -54 12:47:53
  -54 12:47:53.3
 -54 12:47:53.35
 -54 12:47:53.35
     -54 12:47:53
   -54 12:47:53.3
  -54 12:47:53.35
 -54 12:47:53.345
 -54 12:47:53.345
      -54 12:47:53
    -54 12:47:53.3
   -54 12:47:53.35
  -54 12:47:53.345
 -54 12:47:53.3450
 -54 12:47:53.3450
       -54 12:47:53
     -54 12:47:53.3
    -54 12:47:53.35
   -54 12:47:53.345
  -54 12:47:53.3450
 -54 12:47:53.34505
 -54 12:47:53.34505
 *****
 ******
 *******
 -1297:26
  -1297:26
   -1297:26
   -1297:26
 -1297:26:00
 -1297:26:00
 -1297:26:00
  -1297:26:00
  -1297:26:00
  -1297:26:00
  -1297:26:00
   -1297:26:00
 -1297:26:00.5
 -1297:26:00.5
 -1297:26:00.5
 -1297:26:00.5
    -1297:26:00
  -1297:26:00.5
 -1297:26:00.46
 -1297:26:00.46
 -1297:26:00.46
 -1297:26:00.46
     -1297:26:00
   -1297:26:00.5
  -1297:26:00.46
 -1297:26:00.456
 -1297:26:00.456
 -1297:26:00.456
 -1297:26:00.456
 ********
 -54 01:26
  -54 01:26
   -54 01:26
 -54 01:26:00
  -54 01:26:00
  -54 01:26:00
   -54 01:26:00
 -54 01:26:00.5
 -54 01:26:00.5
    -54 01:26:00
  -54 01:26:00.5
 -54 01:26:00.46
 -54 01:26:00.46
     -54 01:26:00
   -54 01:26:00.5
  -54 01:26:00.46
 -54 01:26:00.456
 -54 01:26:00.456
      -54 01:26:00
    -54 01:26:00.5
   -54 01:26:00.46
  -54 01:26:00.456
 -54 01:26:00.4561
 -54 01:26:00.4561
       -54 01:26:00
     -54 01:26:00.5
    -54 01:26:00.46
   -54 01:26:00.456
  -54 01:26:00.4561
 -54 01:26:00.45615
 -54 01:26:00.45615
 *****
 ******
 *******
 -1316:58
  -1316:58
   -1316:58
   -1316:58
 -1316:58:11
 -1316:58:11
 -1316:58:11
  -1316:58:11
  -1316:58:11
  -1316:58:11
  -1316:58:11
   -1316:58:11
 -1316:58:11.6
 -1316:58:11.6
 -1316:58:11.6
 -1316:58:11.6
    -1316:58:11
  -1316:58:11.6
 -1316:58:11.57
 -1316:58:11.57
 -1316:58:11.57
 -1316:58:11.57
     -1316:58:11
   -1316:58:11.6
  -1316:58:11.57
 -1316:58:11.567
 -1316:58:11.567
 -1316:58:11.567
 -1316:58:11.567
 ********
 -54 20:58
  -54 20:58
   -54 20:58
 -54 20:58:11
  -54 20:58:11
  -54 20:58:11
   -54 20:58:11
 -54 20:58:11.6
 -54 20:58:11.6
    -54 20:58:11
  -54 20:58:11.6
 -54 20:58:11.57
 -54 20:58:11.57
     -54 20:58:11
   -54 20:58:11.6
  -54 20:58:11.57
 -54 20:58:11.567
 -54 20:58:11.567
      -54 20:58:11
    -54 20:58:11.6
   -54 20:58:11.57
  -54 20:58:11.567
 -54 20:58:11.5668
 -54 20:58:11.5668
       -54 20:58:11
     -54 20:58:11.6
    -54 20:58:11.57
   -54 20:58:11.567
  -54 20:58:11.5668
 -54 20:58:11.56677
 -54 20:58:11.56677
 *****
 ******
 *******
 -1303:36
  -1303:36
   -1303:36
   -1303:36
 -1303:36:05
 -1303:36:05
 -1303:36:05
  -1303:36:05
  -1303:36:05
  -1303:36:05
  -1303:36:05
   -1303:36:05
 -1303:36:05.2
 -1303:36:05.2
 -1303:36:05.2
 -1303:36:05.2
    -1303:36:05
  -1303:36:05.2
 -1303:36:05.19
 -1303:36:05.19
 -1303:36:05.19
 -1303:36:05.19
     -1303:36:05
   -1303:36:05.2
  -1303:36:05.19
 -1303:36:05.190
 -1303:36:05.190
 -1303:36:05.190
 -1303:36:05.190
 ********
 -54 07:36
  -54 07:36
   -54 07:36
 -54 07:36:05
  -54 07:36:05
  -54 07:36:05
   -54 07:36:05
 -54 07:36:05.2
 -54 07:36:05.2
    -54 07:36:05
  -54 07:36:05.2
 -54 07:36:05.19
 -54 07:36:05.19
     -54 07:36:05
   -54 07:36:05.2
  -54 07:36:05.19
 -54 07:36:05.190
 -54 07:36:05.190
      -54 07:36:05
    -54 07:36:05.2
   -54 07:36:05.19
  -54 07:36:05.190
 -54 07:36:05.1896
 -54 07:36:05.1896
       -54 07:36:05
     -54 07:36:05.2
    -54 07:36:05.19
   -54 07:36:05.190
  -54 07:36:05.1896
 -54 07:36:05.18964
 -54 07:36:05.18964
 *****
 ******
 *******
 -1311:43
  -1311:43
   -1311:43
   -1311:43
 -1311:43:49
 -1311:43:49
 -1311:43:49
  -1311:43:49
  -1311:43:49
  -1311:43:49
  -1311:43:49
   -1311:43:49
 -1311:43:49.8
 -1311:43:49.8
 -1311:43:49.8
 -1311:43:49.8
    -1311:43:49
  -1311:43:49.8
 -1311:43:49.83
 -1311:43:49.83
 -1311:43:49.83
 -1311:43:49.83
     -1311:43:49
   -1311:43:49.8
  -1311:43:49.83
 -1311:43:49.831
 -1311:43:49.831
 -1311:43:49.831
 -1311:43:49.831
 ********
 -54 15:43
  -54 15:43
   -54 15:43
 -54 15:43:49
  -54 15:43:49
  -54 15:43:49
   -54 15:43:49
 -54 15:43:49.8
 -54 15:43:49.8
    -54 15:43:49
  -54 15:43:49.8
 -54 15:43:49.83
 -54 15:43:49.83
     -54 15:43:49
   -54 15:43:49.8
  -54 15:43:49.83
 -54 15:43:49.831
 -54 15:43:49.831
      -54 15:43:49
    -54 15:43:49.8
   -54 15:43:49.83
  -54 15:43:49.831
 -54 15:43:49.8313
 -54 15:43:49.8313
       -54 15:43:49
     -54 15:43:49.8
    -54 15:43:49.83
   -54 15:43:49.831
  -54 15:43:49.8313
 -54 15:43:49.83132
 -54 15:43:49.83132
 *****
 ******
 *******
 -1300:25
  -1300:25
   -1300:25
   -1300:25
 -1300:25:09
 -1300:25:09
 -1300:25:09
  -1300:25:09
  -1300:25:09
  -1300:25:09
  -1300:25:09
   -1300:25:09
 -1300:25:09.0
 -1300:25:09.0
 -1300:25:09.0
 -1300:25:09.0
    -1300:25:09
  -1300:25:09.0
 -1300:25:09.01
 -1300:25:09.01
 -1300:25:09.01
 -1300:25:09.01
     -1300:25:09
   -1300:25:09.0
  -1300:25:09.01
 -1300:25:09.013
 -1300:25:09.013
 -1300:25:09.013
 -1300:25:09.013
 ********
 -54 04:25
  -54 04:25
   -54 04:25
 -54 04:25:09
  -54 04:25:09
  -54 04:25:09
   -54 04:25:09
 -54 04:25:09.0
 -54 04:25:09.0
    -54 04:25:09
  -54 04:25:09.0
 -54 04:25:09.01
 -54 04:25:09.01
     -54 04:25:09
   -54 04:25:09.0
  -54 04:25:09.01
 -54 04:25:09.013
 -54 04:25:09.013
      -54 04:25:09
    -54 04:25:09.0
   -54 04:25:09.01
  -54 04:25:09.013
 -54 04:25:09.0129
 -54 04:25:09.0129
       -54 04:25:09
     -54 04:25:09.0
    -54 04:25:09.01
   -54 04:25:09.013
  -54 04:25:09.0129
 -54 04:25:09.01293
 -54 04:25:09.01293
 *****
 ******
 *******
 -1302:49
  -1302:49
   -1302:49
   -1302:49
 -1302:49:27
 -1302:49:27
 -1302:49:27
  -1302:49:27
  -1302:49:27
  -1302:49:27
  -1302:49:27
   -1302:49:27
 -1302:49:27.5
 -1302:49:27.5
 -1302:49:27.5
 -1302:49:27.5
    -1302:49:27
  -1302:49:27.5
 -1302:49:27.52
 -1302:49:27.52
 -1302:49:27.52
 -1302:49:27.52
     -1302:49:27
   -1302:49:27.5
  -1302:49:27.52
 -1302:49:27.524
 -1302:49:27.524
 -1302:49:27.524
 -1302:49:27.524
 ********
 -54 06:49
  -54 06:49
   -54 06:49
 -54 06:49:27
  -54 06:49:27
  -54 06:49:27
   -54 06:49:27
 -54 06:49:27.5
 -54 06:49:27.5
    -54 06:49:27
  -54 06:49:27.5
 -54 06:49:27.52
 -54 06:49:27.52
     -54 06:49:27
   -54 06:49:27.5
  -54 06:49:27.52
 -54 06:49:27.524
 -54 06:49:27.524
      -54 06:49:27
    -54 06:49:27.5
   -54 06:49:27.52
  -54 06:49:27.524
 -54 06:49:27.5237
 -54 06:49:27.5237
       -54 06:49:27
     -54 06:49:27.5
    -54 06:49:27.52
   -54 06:49:27.524
  -54 06:49:27.5237
 -54 06:49:27.52375
 -54 06:49:27.52375
 *****
 ******
 *******
 -1298:57
  -1298:57
   -1298:57
   -1298:57
 -1298:57:52
 -1298:57:52
 -1298:57:52
  -1298:57:52
  -1298:57:52
  -1298:57:52
  -1298:57:52
   -1298:57:52
 -1298:57:52.0
 -1298:57:52.0
 -1298:57:52.0
 -1298:57:52.0
    -1298:57:52
  -1298:57:52.0
 -1298:57:52.02
 -1298:57:52.02
 -1298:57:52.02
 -1298:57:52.02
     -1298:57:52
   -1298:57:52.0
  -1298:57:52.02
 -1298:57:52.016
 -1298:57:52.016
 -1298:57:52.016
 -1298:57:52.016
 ********
 -54 02:57
  -54 02:57
   -54 02:57
 -54 02:57:52
  -54 02:57:52
  -54 02:57:52
   -54 02:57:52
 -54 02:57:52.0
 -54 02:57:52.0
    -54 02:57:52
  -54 02:57:52.0
 -54 02:57:52.02
 -54 02:57:52.02
     -54 02:57:52
   -54 02:57:52.0
  -54 02:57:52.02
 -54 02:57:52.016
 -54 02:57:52.016
      -54 02:57:52
    -54 02:57:52.0
   -54 02:57:52.02
  -54 02:57:52.016
 -54 02:57:52.0157
 -54 02:57:52.0157
       -54 02:57:52
     -54 02:57:52.0
    -54 02:57:52.02
   -54 02:57:52.016
  -54 02:57:52.0157
 -54 02:57:52.01565
 -54 02:57:52.01565
 *****
 ******
 *******
 -1312:45
  -1312:45
   -1312:45
   -1312:45
 -1312:45:44
 -1312:45:44
 -1312:45:44
  -1312:45:44
  -1312:45:44
  -1312:45:44
  -1312:45:44
   -1312:45:44
 -1312:45:44.9
 -1312:45:44.9
 -1312:45:44.9
 -1312:45:44.9
    -1312:45:44
  -1312:45:44.9
 -1312:45:44.87
 -1312:45:44.87
 -1312:45:44.87
 -1312:45:44.87
     -1312:45:44
   -1312:45:44.9
  -1312:45:44.87
 -1312:45:44.865
 -1312:45:44.865
 -1312:45:44.865
 -1312:45:44.865
 ********
 -54 16:45
  -54 16:45
   -54 16:45
 -54 16:45:44
  -54 16:45:44
  -54 16:45:44
   -54 16:45:44
 -54 16:45:44.9
 -54 16:45:44.9
    -54 16:45:44
  -54 16:45:44.9
 -54 16:45:44.87
 -54 16:45:44.87
     -54 16:45:44
   -54 16:45:44.9
  -54 16:45:44.87
 -54 16:45:44.865
 -54 16:45:44.865
      -54 16:45:44
    -54 16:45:44.9
   -54 16:45:44.87
  -54 16:45:44.865
 -54 16:45:44.8653
 -54 16:45:44.8653
       -54 16:45:44
     -54 16:45:44.9
    -54 16:45:44.87
   -54 16:45:44.865
  -54 16:45:44.8653
 -54 16:45:44.86529
 -54 16:45:44.86529
 *****
 ******
 *******
 -1317:30
  -1317:30
   -1317:30
   -1317:30
 -1317:30:57
 -1317:30:57
 -1317:30:57
  -1317:30:57
  -1317:30:57
  -1317:30:57
  -1317:30:57
   -1317:30:57
 -1317:30:57.8
 -1317:30:57.8
 -1317:30:57.8
 -1317:30:57.8
    -1317:30:57
  -1317:30:57.8
 -1317:30:57.82
 -1317:30:57.82
 -1317:30:57.82
 -1317:30:57.82
     -1317:30:57
   -1317:30:57.8
  -1317:30:57.82
 -1317:30:57.820
 -1317:30:57.820
 -1317:30:57.820
 -1317:30:57.820
 ********
 -54 21:30
  -54 21:30
   -54 21:30
 -54 21:30:57
  -54 21:30:57
  -54 21:30:57
   -54 21:30:57
 -54 21:30:57.8
 -54 21:30:57.8
    -54 21:30:57
  -54 21:30:57.8
 -54 21:30:57.82
 -54 21:30:57.82
     -54 21:30:57
   -54 21:30:57.8
  -54 21:30:57.82
 -54 21:30:57.820
 -54 21:30:57.820
      -54 21:30:57
    -54 21:30:57.8
   -54 21:30:57.82
  -54 21:30:57.820
 -54 21:30:57.8205
 -54 21:30:57.8205
       -54 21:30:57
     -54 21:30:57.8
    -54 21:30:57.82
   -54 21:30:57.820
  -54 21:30:57.8205
 -54 21:30:57.82047
 -54 21:30:57.82047
 *****
 ******
 *******
 -1300:25
  -1300:25
   -1300:25
   -1300:25
 -1300:25:09
 -1300:25:09
 -1300:25:09
  -1300:25:09
  -1300:25:09
  -1300:25:09
  -1300:25:09
   -1300:25:09
 -1300:25:09.2
 -1300:25:09.2
 -1300:25:09.2
 -1300:25:09.2
    -1300:25:09
  -1300:25:09.2
 -1300:25:09.15
 -1300:25:09.15
 -1300:25:09.15
 -1300:25:09.15
     -1300:25:09
   -1300:25:09.2
  -1300:25:09.15
 -1300:25:09.154
 -1300:25:09.154
 -1300:25:09.154
 -1300:25:09.154
 ********
 -54 04:25
  -54 04:25
   -54 04:25
 -54 04:25:09
  -54 04:25:09
  -54 04:25:09
   -54 04:25:09
 -54 04:25:09.2
 -54 04:25:09.2
    -54 04:25:09
  -54 04:25:09.2
 -54 04:25:09.15
 -54 04:25:09.15
     -54 04:25:09
   -54 04:25:09.2
  -54 04:25:09.15
 -54 04:25:09.154
 -54 04:25:09.154
      -54 04:25:09
    -54 04:25:09.2
   -54 04:25:09.15
  -54 04:25:09.154
 -54 04:25:09.1540
 -54 04:25:09.1540
       -54 04:25:09
     -54 04:25:09.2
    -54 04:25:09.15
   -54 04:25:09.154
  -54 04:25:09.1540
 -54 04:25:09.15395
 -54 04:25:09.15395
 *****
 ******
 *******
 -1302:49
  -1302:49
   -1302:49
   -1302:49
 -1302:49:27
 -1302:49:27
 -1302:49:27
  -1302:49:27
  -1302:49:27
  -1302:49:27
  -1302:49:27
   -1302:49:27
 -1302:49:27.1
 -1302:49:27.1
 -1302:49:27.1
 -1302:49:27.1
    -1302:49:27
  -1302:49:27.1
 -1302:49:27.11
 -1302:49:27.11
 -1302:49:27.11
 -1302:49:27.11
     -1302:49:27
   -1302:49:27.1
  -1302:49:27.11
 -1302:49:27.105
 -1302:49:27.105
 -1302:49:27.105
 -1302:49:27.105
 ********
 -54 06:49
  -54 06:49
   -54 06:49
 -54 06:49:27
  -54 06:49:27
  -54 06:49:27
   -54 06:49:27
 -54 06:49:27.1
 -54 06:49:27.1
    -54 06:49:27
  -54 06:49:27.1
 -54 06:49:27.11
 -54 06:49:27.11
     -54 06:49:27
   -54 06:49:27.1
  -54 06:49:27.11
 -54 06:49:27.105
 -54 06:49:27.105
      -54 06:49:27
    -54 06:49:27.1
   -54 06:49:27.11
  -54 06:49:27.105
 -54 06:49:27.1053
 -54 06:49:27.1053
       -54 06:49:27
     -54 06:49:27.1
    -54 06:49:27.11
   -54 06:49:27.105
  -54 06:49:27.1053
 -54 06:49:27.10533
 -54 06:49:27.10533
 *****
 ******
 *******
 -1298:57
  -1298:57
   -1298:57
   -1298:57
 -1298:57:52
 -1298:57:52
 -1298:57:52
  -1298:57:52
  -1298:57:52
  -1298:57:52
  -1298:57:52
   -1298:57:52
 -1298:57:52.5
 -1298:57:52.5
 -1298:57:52.5
 -1298:57:52.5
    -1298:57:52
  -1298:57:52.5
 -1298:57:52.48
 -1298:57:52.48
 -1298:57:52.48
 -1298:57:52.48
     -1298:57:52
   -1298:57:52.5
  -1298:57:52.48
 -1298:57:52.482
 -1298:57:52.482
 -1298:57:52.482
 -1298:57:52.482
 ********
 -54 02:57
  -54 02:57
   -54 02:57
 -54 02:57:52
  -54 02:57:52
  -54 02:57:52
   -54 02:57:52
 -54 02:57:52.5
 -54 02:57:52.5
    -54 02:57:52
  -54 02:57:52.5
 -54 02:57:52.48
 -54 02:57:52.48
     -54 02:57:52
   -54 02:57:52.5
  -54 02:57:52.48
 -54 02:57:52.482
 -54 02:57:52.482
      -54 02:57:52
    -54 02:57:52.5
   -54 02:57:52.48
  -54 02:57:52.482
 -54 02:57:52.4823
 -54 02:57:52.4823
       -54 02:57:52
     -54 02:57:52.5
    -54 02:57:52.48
   -54 02:57:52.482
  -54 02:57:52.4823
 -54 02:57:52.48229
 -54 02:57:52.48229
 *****
 ******
 *******
 -1312:45
  -1312:45
   -1312:45
   -1312:45
 -1312:45:44
 -1312:45:44
 -1312:45:44
  -1312:45:44
  -1312:45:44
  -1312:45:44
  -1312:45:44
   -1312:45:44
 -1312:45:44.7
 -1312:45:44.7
 -1312:45:44.7
 -1312:45:44.7
    -1312:45:44
  -1312:45:44.7
 -1312:45:44.66
 -1312:45:44.66
 -1312:45:44.66
 -1312:45:44.66
     -1312:45:44
   -1312:45:44.7
  -1312:45:44.66
 -1312:45:44.658
 -1312:45:44.658
 -1312:45:44.658
 -1312:45:44.658
 ********
 -54 16:45
  -54 16:45
   -54 16:45
 -54 16:45:44
  -54 16:45:44
  -54 16:45:44
   -54 16:45:44
 -54 16:45:44.7
 -54 16:45:44.7
    -54 16:45:44
  -54 16:45:44.7
 -54 16:45:44.66
 -54 16:45:44.66
     -54 16:45:44
   -54 16:45:44.7
  -54 16:45:44.66
 -54 16:45:44.658
 -54 16:45:44.658
      -54 16:45:44
    -54 16:45:44.7
   -54 16:45:44.66
  -54 16:45:44.658
 -54 16:45:44.6583
 -54 16:45:44.6583
       -54 16:45:44
     -54 16:45:44.7
    -54 16:45:44.66
   -54 16:45:44.658
  -54 16:45:44.6583
 -54 16:45:44.65827
 -54 16:45:44.65827
 *****
 ******
 *******
 -1317:30
  -1317:30
   -1317:30
   -1317:30
 -1317:30:57
 -1317:30:57
 -1317:30:57
  -1317:30:57
  -1317:30:57
  -1317:30:57
  -1317:30:57
   -1317:30:57
 -1317:30:57.6
 -1317:30:57.6
 -1317:30:57.6
 -1317:30:57.6
    -1317:30:57
  -1317:30:57.6
 -1317:30:57.58
 -1317:30:57.58
 -1317:30:57.58
 -1317:30:57.58
     -1317:30:57
   -1317:30:57.6
  -1317:30:57.58
 -1317:30:57.582
 -1317:30:57.582
 -1317:30:57.582
 -1317:30:57.582
 ********
 -54 21:30
  -54 21:30
   -54 21:30
 -54 21:30:57
  -54 21:30:57
  -54 21:30:57
   -54 21:30:57
 -54 21:30:57.6
 -54 21:30:57.6
    -54 21:30:57
  -54 21:30:57.6
 -54 21:30:57.58
 -54 21:30:57.58
     -54 21:30:57
   -54 21:30:57.6
  -54 21:30:57.58
 -54 21:30:57.582
 -54 21:30:57.582
      -54 21:30:57
    -54 21:30:57.6
   -54 21:30:57.58
  -54 21:30:57.582
 -54 21:30:57.5822
 -54 21:30:57.5822
       -54 21:30:57
     -54 21:30:57.6
    -54 21:30:57.58
   -54 21:30:57.582
  -54 21:30:57.5822
 -54 21:30:57.58219
 -54 21:30:57.58219
 *****
 ******
 *******
 -1318:30
  -1318:30
   -1318:30
   -1318:30
 -1318:30:04
 -1318:30:04
 -1318:30:04
  -1318:30:04
  -1318:30:04
  -1318:30:04
  -1318:30:04
   -1318:30:04
 -1318:30:04.2
 -1318:30:04.2
 -1318:30:04.2
 -1318:30:04.2
    -1318:30:04
  -1318:30:04.2
 -1318:30:04.18
 -1318:30:04.18
 -1318:30:04.18
 -1318:30:04.18
     -1318:30:04
   -1318:30:04.2
  -1318:30:04.18
 -1318:30:04.183
 -1318:30:04.183
 -1318:30:04.183
 -1318:30:04.183
 ********
 -54 22:30
  -54 22:30
   -54 22:30
 -54 22:30:04
  -54 22:30:04
  -54 22:30:04
   -54 22:30:04
 -54 22:30:04.2
 -54 22:30:04.2
    -54 22:30:04
  -54 22:30:04.2
 -54 22:30:04.18
 -54 22:30:04.18
     -54 22:30:04
   -54 22:30:04.2
  -54 22:30:04.18
 -54 22:30:04.183
 -54 22:30:04.183
      -54 22:30:04
    -54 22:30:04.2
   -54 22:30:04.18
  -54 22:30:04.183
 -54 22:30:04.1835
 -54 22:30:04.1835
       -54 22:30:04
     -54 22:30:04.2
    -54 22:30:04.18
   -54 22:30:04.183
  -54 22:30:04.1835
 -54 22:30:04.18347
 -54 22:30:04.18347
 *****
 ******
 *******
 -1297:56
  -1297:56
   -1297:56
   -1297:56
 -1297:56:51
 -1297:56:51
 -1297:56:51
  -1297:56:51
  -1297:56:51
  -1297:56:51
  -1297:56:51
   -1297:56:51
 -1297:56:51.6
 -1297:56:51.6
 -1297:56:51.6
 -1297:56:51.6
    -1297:56:51
  -1297:56:51.6
 -1297:56:51.59
 -1297:56:51.59
 -1297:56:51.59
 -1297:56:51.59
     -1297:56:51
   -1297:56:51.6
  -1297:56:51.59
 -1297:56:51.593
 -1297:56:51.593
 -1297:56:51.593
 -1297:56:51.593
 ********
 -54 01:56
  -54 01:56
   -54 01:56
 -54 01:56:51
  -54 01:56:51
  -54 01:56:51
   -54 01:56:51
 -54 01:56:51.6
 -54 01:56:51.6
    -54 01:56:51
  -54 01:56:51.6
 -54 01:56:51.59
 -54 01:56:51.59
     -54 01:56:51
   -54 01:56:51.6
  -54 01:56:51.59
 -54 01:56:51.593
 -54 01:56:51.593
      -54 01:56:51
    -54 01:56:51.6
   -54 01:56:51.59
  -54 01:56:51.593
 -54 01:56:51.5932
 -54 01:56:51.5932
       -54 01:56:51
     -54 01:56:51.6
    -54 01:56:51.59
   -54 01:56:51.593
  -54 01:56:51.5932
 -54 01:56:51.59319
 -54 01:56:51.59319
 *****
 ******
 *******
 ********
 -16344:00
  -16344:00
  -16344:00
   -16344:00
   -16344:00
   -16344:00
 -16344:00:00
 -16344:00:00
 -16344:00:00
 -16344:00:00
  -16344:00:00
  -16344:00:00
  -16344:00:00
  -16344:00:00
  -16344:00:00
   -16344:00:00
 -16344:00:00.0
 -16344:00:00.0
 -16344:00:00.0
 -16344:00:00.0
 -16344:00:00.0
    -16344:00:00
  -16344:00:00.0
 -16344:00:00.00
 -16344:00:00.00
 -16344:00:00.00
 -16344:00:00.00
 -16344:00:00.00
 ********
 *********
 -681 00:00
  -681 00:00
   -681 00:00
 -681 00:00:00
 -681 00:00:00
  -681 00:00:00
  -681 00:00:00
  -681 00:00:00
   -681 00:00:00
 -681 00:00:00.0
 -681 00:00:00.0
 -681 00:00:00.0
    -681 00:00:00
  -681 00:00:00.0
 -681 00:00:00.00
 -681 00:00:00.00
 -681 00:00:00.00
     -681 00:00:00
   -681 00:00:00.0
  -681 00:00:00.00
 -681 00:00:00.000
 -681 00:00:00.000
 -681 00:00:00.000
      -681 00:00:00
    -681 00:00:00.0
   -681 00:00:00.00
  -681 00:00:00.000
 -681 00:00:00.0000
 -681 00:00:00.0000
 -681 00:00:00.0000
 *****
 ******
 *******
 ********
 -16348:50
  -16348:50
  -16348:50
   -16348:50
   -16348:50
   -16348:50
 -16348:50:38
 -16348:50:38
 -16348:50:38
 -16348:50:38
  -16348:50:38
  -16348:50:38
  -16348:50:38
  -16348:50:38
  -16348:50:38
   -16348:50:38
 -16348:50:38.1
 -16348:50:38.1
 -16348:50:38.1
 -16348:50:38.1
 -16348:50:38.1
    -16348:50:38
  -16348:50:38.1
 -16348:50:38.12
 -16348:50:38.12
 -16348:50:38.12
 -16348:50:38.12
 -16348:50:38.12
 ********
 *********
 -681 04:50
  -681 04:50
   -681 04:50
 -681 04:50:38
 -681 04:50:38
  -681 04:50:38
  -681 04:50:38
  -681 04:50:38
   -681 04:50:38
 -681 04:50:38.1
 -681 04:50:38.1
 -681 04:50:38.1
    -681 04:50:38
  -681 04:50:38.1
 -681 04:50:38.12
 -681 04:50:38.12
 -681 04:50:38.12
     -681 04:50:38
   -681 04:50:38.1
  -681 04:50:38.12
 -681 04:50:38.123
 -681 04:50:38.123
 -681 04:50:38.123
      -681 04:50:38
    -681 04:50:38.1
   -681 04:50:38.12
  -681 04:50:38.123
 -681 04:50:38.1230
 -681 04:50:38.1230
 -681 04:50:38.1230
 *****
 ******
 *******
 ********
 -16356:31
  -16356:31
  -16356:31
   -16356:31
   -16356:31
   -16356:31
 -16356:31:35
 -16356:31:35
 -16356:31:35
 -16356:31:35
  -16356:31:35
  -16356:31:35
  -16356:31:35
  -16356:31:35
  -16356:31:35
   -16356:31:35
 -16356:31:35.2
 -16356:31:35.2
 -16356:31:35.2
 -16356:31:35.2
 -16356:31:35.2
    -16356:31:35
  -16356:31:35.2
 -16356:31:35.23
 -16356:31:35.23
 -16356:31:35.23
 -16356:31:35.23
 -16356:31:35.23
 ********
 *********
 -681 12:31
  -681 12:31
   -681 12:31
 -681 12:31:35
 -681 12:31:35
  -681 12:31:35
  -681 12:31:35
  -681 12:31:35
   -681 12:31:35
 -681 12:31:35.2
 -681 12:31:35.2
 -681 12:31:35.2
    -681 12:31:35
  -681 12:31:35.2
 -681 12:31:35.23
 -681 12:31:35.23
 -681 12:31:35.23
     -681 12:31:35
   -681 12:31:35.2
  -681 12:31:35.23
 -681 12:31:35.235
 -681 12:31:35.235
 -681 12:31:35.235
      -681 12:31:35
    -681 12:31:35.2
   -681 12:31:35.23
  -681 12:31:35.235
 -681 12:31:35.2345
 -681 12:31:35.2345
 -681 12:31:35.2345
 *****
 ******
 *******
 ********
 -16356:47
  -16356:47
  -16356:47
   -16356:47
   -16356:47
   -16356:47
 -16356:47:53
 -16356:47:53
 -16356:47:53
 -16356:47:53
  -16356:47:53
  -16356:47:53
  -16356:47:53
  -16356:47:53
  -16356:47:53
   -16356:47:53
 -16356:47:53.3
 -16356:47:53.3
 -16356:47:53.3
 -16356:47:53.3
 -16356:47:53.3
    -16356:47:53
  -16356:47:53.3
 -16356:47:53.35
 -16356:47:53.35
 -16356:47:53.35
 -16356:47:53.35
 -16356:47:53.35
 ********
 *********
 -681 12:47
  -681 12:47
   -681 12:47
 -681 12:47:53
 -681 12:47:53
  -681 12:47:53
  -681 12:47:53
  -681 12:47:53
   -681 12:47:53
 -681 12:47:53.3
 -681 12:47:53.3
 -681 12:47:53.3
    -681 12:47:53
  -681 12:47:53.3
 -681 12:47:53.35
 -681 12:47:53.35
 -681 12:47:53.35
     -681 12:47:53
   -681 12:47:53.3
  -681 12:47:53.35
 -681 12:47:53.345
 -681 12:47:53.345
 -681 12:47:53.345
      -681 12:47:53
    -681 12:47:53.3
   -681 12:47:53.35
  -681 12:47:53.345
 -681 12:47:53.3450
 -681 12:47:53.3450
 -681 12:47:53.3450
 *****
 ******
 *******
 ********
 -16345:26
  -16345:26
  -16345:26
   -16345:26
   -16345:26
   -16345:26
 -16345:26:00
 -16345:26:00
 -16345:26:00
 -16345:26:00
  -16345:26:00
  -16345:26:00
  -16345:26:00
  -16345:26:00
  -16345:26:00
   -16345:26:00
 -16345:26:00.5
 -16345:26:00.5
 -16345:26:00.5
 -16345:26:00.5
 -16345:26:00.5
    -16345:26:00
  -16345:26:00.5
 -16345:26:00.46
 -16345:26:00.46
 -16345:26:00.46
 -16345:26:00.46
 -16345:26:00.46
 ********
 *********
 -681 01:26
  -681 01:26
   -681 01:26
 -681 01:26:00
 -681 01:26:00
  -681 01:26:00
  -681 01:26:00
  -681 01:26:00
   -681 01:26:00
 -681 01:26:00.5
 -681 01:26:00.5
 -681 01:26:00.5
    -681 01:26:00
  -681 01:26:00.5
 -681 01:26:00.46
 -681 01:26:00.46
 -681 01:26:00.46
     -681 01:26:00
   -681 01:26:00.5
  -681 01:26:00.46
 -681 01:26:00.456
 -681 01:26:00.456
 -681 01:26:00.456
      -681 01:26:00
    -681 01:26:00.5
   -681 01:26:00.46
  -681 01:26:00.456
 -681 01:26:00.4562
 -681 01:26:00.4562
 -681 01:26:00.4562
 *****
 ******
 *******
 ********
 -16364:58
  -16364:58
  -16364:58
   -16364:58
   -16364:58
   -16364:58
 -16364:58:11
 -16364:58:11
 -16364:58:11
 -16364:58:11
  -16364:58:11
  -16364:58:11
  -16364:58:11
  -16364:58:11
  -16364:58:11
   -16364:58:11
 -16364:58:11.6
 -16364:58:11.6
 -16364:58:11.6
 -16364:58:11.6
 -16364:58:11.6
    -16364:58:11
  -16364:58:11.6
 -16364:58:11.57
 -16364:58:11.57
 -16364:58:11.57
 -16364:58:11.57
 -16364:58:11.57
 ********
 *********
 -681 20:58
  -681 20:58
   -681 20:58
 -681 20:58:11
 -681 20:58:11
  -681 20:58:11
  -681 20:58:11
  -681 20:58:11
   -681 20:58:11
 -681 20:58:11.6
 -681 20:58:11.6
 -681 20:58:11.6
    -681 20:58:11
  -681 20:58:11.6
 -681 20:58:11.57
 -681 20:58:11.57
 -681 20:58:11.57
     -681 20:58:11
   -681 20:58:11.6
  -681 20:58:11.57
 -681 20:58:11.567
 -681 20:58:11.567
 -681 20:58:11.567
      -681 20:58:11
    -681 20:58:11.6
   -681 20:58:11.57
  -681 20:58:11.567
 -681 20:58:11.5668
 -681 20:58:11.5668
 -681 20:58:11.5668
 *****
 ******
 *******
 ********
 -16351:36
  -16351:36
  -16351:36
   -16351:36
   -16351:36
   -16351:36
 -16351:36:05
 -16351:36:05
 -16351:36:05
 -16351:36:05
  -16351:36:05
  -16351:36:05
  -16351:36:05
  -16351:36:05
  -16351:36:05
   -16351:36:05
 -16351:36:05.2
 -16351:36:05.2
 -16351:36:05.2
 -16351:36:05.2
 -16351:36:05.2
    -16351:36:05
  -16351:36:05.2
 -16351:36:05.19
 -16351:36:05.19
 -16351:36:05.19
 -16351:36:05.19
 -16351:36:05.19
 ********
 *********
 -681 07:36
  -681 07:36
   -681 07:36
 -681 07:36:05
 -681 07:36:05
  -681 07:36:05
  -681 07:36:05
  -681 07:36:05
   -681 07:36:05
 -681 07:36:05.2
 -681 07:36:05.2
 -681 07:36:05.2
    -681 07:36:05
  -681 07:36:05.2
 -681 07:36:05.19
 -681 07:36:05.19
 -681 07:36:05.19
     -681 07:36:05
   -681 07:36:05.2
  -681 07:36:05.19
 -681 07:36:05.190
 -681 07:36:05.190
 -681 07:36:05.190
      -681 07:36:05
    -681 07:36:05.2
   -681 07:36:05.19
  -681 07:36:05.190
 -681 07:36:05.1896
 -681 07:36:05.1896
 -681 07:36:05.1896
 *****
 ******
 *******
 ********
 -16359:43
  -16359:43
  -16359:43
   -16359:43
   -16359:43
   -16359:43
 -16359:43:49
 -16359:43:49
 -16359:43:49
 -16359:43:49
  -16359:43:49
  -16359:43:49
  -16359:43:49
  -16359:43:49
  -16359:43:49
   -16359:43:49
 -16359:43:49.8
 -16359:43:49.8
 -16359:43:49.8
 -16359:43:49.8
 -16359:43:49.8
    -16359:43:49
  -16359:43:49.8
 -16359:43:49.83
 -16359:43:49.83
 -16359:43:49.83
 -16359:43:49.83
 -16359:43:49.83
 ********
 *********
 -681 15:43
  -681 15:43
   -681 15:43
 -681 15:43:49
 -681 15:43:49
  -681 15:43:49
  -681 15:43:49
  -681 15:43:49
   -681 15:43:49
 -681 15:43:49.8
 -681 15:43:49.8
 -681 15:43:49.8
    -681 15:43:49
  -681 15:43:49.8
 -681 15:43:49.83
 -681 15:43:49.83
 -681 15:43:49.83
     -681 15:43:49
   -681 15:43:49.8
  -681 15:43:49.83
 -681 15:43:49.831
 -681 15:43:49.831
 -681 15:43:49.831
      -681 15:43:49
    -681 15:43:49.8
   -681 15:43:49.83
  -681 15:43:49.831
 -681 15:43:49.8313
 -681 15:43:49.8313
 -681 15:43:49.8313
 *****
 ******
 *******
 ********
 -16348:25
  -16348:25
  -16348:25
   -16348:25
   -16348:25
   -16348:25
 -16348:25:09
 -16348:25:09
 -16348:25:09
 -16348:25:09
  -16348:25:09
  -16348:25:09
  -16348:25:09
  -16348:25:09
  -16348:25:09
   -16348:25:09
 -16348:25:09.0
 -16348:25:09.0
 -16348:25:09.0
 -16348:25:09.0
 -16348:25:09.0
    -16348:25:09
  -16348:25:09.0
 -16348:25:09.01
 -16348:25:09.01
 -16348:25:09.01
 -16348:25:09.01
 -16348:25:09.01
 ********
 *********
 -681 04:25
  -681 04:25
   -681 04:25
 -681 04:25:09
 -681 04:25:09
  -681 04:25:09
  -681 04:25:09
  -681 04:25:09
   -681 04:25:09
 -681 04:25:09.0
 -681 04:25:09.0
 -681 04:25:09.0
    -681 04:25:09
  -681 04:25:09.0
 -681 04:25:09.01
 -681 04:25:09.01
 -681 04:25:09.01
     -681 04:25:09
   -681 04:25:09.0
  -681 04:25:09.01
 -681 04:25:09.013
 -681 04:25:09.013
 -681 04:25:09.013
      -681 04:25:09
    -681 04:25:09.0
   -681 04:25:09.01
  -681 04:25:09.013
 -681 04:25:09.0129
 -681 04:25:09.0129
 -681 04:25:09.0129
 *****
 ******
 *******
 ********
 -16350:49
  -16350:49
  -16350:49
   -16350:49
   -16350:49
   -16350:49
 -16350:49:27
 -16350:49:27
 -16350:49:27
 -16350:49:27
  -16350:49:27
  -16350:49:27
  -16350:49:27
  -16350:49:27
  -16350:49:27
   -16350:49:27
 -16350:49:27.5
 -16350:49:27.5
 -16350:49:27.5
 -16350:49:27.5
 -16350:49:27.5
    -16350:49:27
  -16350:49:27.5
 -16350:49:27.52
 -16350:49:27.52
 -16350:49:27.52
 -16350:49:27.52
 -16350:49:27.52
 ********
 *********
 -681 06:49
  -681 06:49
   -681 06:49
 -681 06:49:27
 -681 06:49:27
  -681 06:49:27
  -681 06:49:27
  -681 06:49:27
   -681 06:49:27
 -681 06:49:27.5
 -681 06:49:27.5
 -681 06:49:27.5
    -681 06:49:27
  -681 06:49:27.5
 -681 06:49:27.52
 -681 06:49:27.52
 -681 06:49:27.52
     -681 06:49:27
   -681 06:49:27.5
  -681 06:49:27.52
 -681 06:49:27.524
 -681 06:49:27.524
 -681 06:49:27.524
      -681 06:49:27
    -681 06:49:27.5
   -681 06:49:27.52
  -681 06:49:27.524
 -681 06:49:27.5237
 -681 06:49:27.5237
 -681 06:49:27.5237
 *****
 ******
 *******
 ********
 -16346:57
  -16346:57
  -16346:57
   -16346:57
   -16346:57
   -16346:57
 -16346:57:52
 -16346:57:52
 -16346:57:52
 -16346:57:52
  -16346:57:52
  -16346:57:52
  -16346:57:52
  -16346:57:52
  -16346:57:52
   -16346:57:52
 -16346:57:52.0
 -16346:57:52.0
 -16346:57:52.0
 -16346:57:52.0
 -16346:57:52.0
    -16346:57:52
  -16346:57:52.0
 -16346:57:52.02
 -16346:57:52.02
 -16346:57:52.02
 -16346:57:52.02
 -16346:57:52.02
 ********
 *********
 -681 02:57
  -681 02:57
   -681 02:57
 -681 02:57:52
 -681 02:57:52
  -681 02:57:52
  -681 02:57:52
  -681 02:57:52
   -681 02:57:52
 -681 02:57:52.0
 -681 02:57:52.0
 -681 02:57:52.0
    -681 02:57:52
  -681 02:57:52.0
 -681 02:57:52.02
 -681 02:57:52.02
 -681 02:57:52.02
     -681 02:57:52
   -681 02:57:52.0
  -681 02:57:52.02
 -681 02:57:52.016
 -681 02:57:52.016
 -681 02:57:52.016
      -681 02:57:52
    -681 02:57:52.0
   -681 02:57:52.02
  -681 02:57:52.016
 -681 02:57:52.0156
 -681 02:57:52.0156
 -681 02:57:52.0156
 *****
 ******
 *******
 ********
 -16360:45
  -16360:45
  -16360:45
   -16360:45
   -16360:45
   -16360:45
 -16360:45:44
 -16360:45:44
 -16360:45:44
 -16360:45:44
  -16360:45:44
  -16360:45:44
  -16360:45:44
  -16360:45:44
  -16360:45:44
   -16360:45:44
 -16360:45:44.9
 -16360:45:44.9
 -16360:45:44.9
 -16360:45:44.9
 -16360:45:44.9
    -16360:45:44
  -16360:45:44.9
 -16360:45:44.87
 -16360:45:44.87
 -16360:45:44.87
 -16360:45:44.87
 -16360:45:44.87
 ********
 *********
 -681 16:45
  -681 16:45
   -681 16:45
 -681 16:45:44
 -681 16:45:44
  -681 16:45:44
  -681 16:45:44
  -681 16:45:44
   -681 16:45:44
 -681 16:45:44.9
 -681 16:45:44.9
 -681 16:45:44.9
    -681 16:45:44
  -681 16:45:44.9
 -681 16:45:44.87
 -681 16:45:44.87
 -681 16:45:44.87
     -681 16:45:44
   -681 16:45:44.9
  -681 16:45:44.87
 -681 16:45:44.865
 -681 16:45:44.865
 -681 16:45:44.865
      -681 16:45:44
    -681 16:45:44.9
   -681 16:45:44.87
  -681 16:45:44.865
 -681 16:45:44.8653
 -681 16:45:44.8653
 -681 16:45:44.8653
 *****
 ******
 *******
 ********
 -16365:30
  -16365:30
  -16365:30
   -16365:30
   -16365:30
   -16365:30
 -16365:30:57
 -16365:30:57
 -16365:30:57
 -16365:30:57
  -16365:30:57
  -16365:30:57
  -16365:30:57
  -16365:30:57
  -16365:30:57
   -16365:30:57
 -16365:30:57.8
 -16365:30:57.8
 -16365:30:57.8
 -16365:30:57.8
 -16365:30:57.8
    -16365:30:57
  -16365:30:57.8
 -16365:30:57.82
 -16365:30:57.82
 -16365:30:57.82
 -16365:30:57.82
 -16365:30:57.82
 ********
 *********
 -681 21:30
  -681 21:30
   -681 21:30
 -681 21:30:57
 -681 21:30:57
  -681 21:30:57
  -681 21:30:57
  -681 21:30:57
   -681 21:30:57
 -681 21:30:57.8
 -681 21:30:57.8
 -681 21:30:57.8
    -681 21:30:57
  -681 21:30:57.8
 -681 21:30:57.82
 -681 21:30:57.82
 -681 21:30:57.82
     -681 21:30:57
   -681 21:30:57.8
  -681 21:30:57.82
 -681 21:30:57.820
 -681 21:30:57.820
 -681 21:30:57.820
      -681 21:30:57
    -681 21:30:57.8
   -681 21:30:57.82
  -681 21:30:57.820
 -681 21:30:57.8205
 -681 21:30:57.8205
 -681 21:30:57.8205
 *****
 ******
 *******
 ********
 -16348:25
  -16348:25
  -16348:25
   -16348:25
   -16348:25
   -16348:25
 -16348:25:09
 -16348:25:09
 -16348:25:09
 -16348:25:09
  -16348:25:09
  -16348:25:09
  -16348:25:09
  -16348:25:09
  -16348:25:09
   -16348:25:09
 -16348:25:09.2
 -16348:25:09.2
 -16348:25:09.2
 -16348:25:09.2
 -16348:25:09.2
    -16348:25:09
  -16348:25:09.2
 -16348:25:09.15
 -16348:25:09.15
 -16348:25:09.15
 -16348:25:09.15
 -16348:25:09.15
 ********
 *********
 -681 04:25
  -681 04:25
   -681 04:25
 -681 04:25:09
 -681 04:25:09
  -681 04:25:09
  -681 04:25:09
  -681 04:25:09
   -681 04:25:09
 -681 04:25:09.2
 -681 04:25:09.2
 -681 04:25:09.2
    -681 04:25:09
  -681 04:25:09.2
 -681 04:25:09.15
 -681 04:25:09.15
 -681 04:25:09.15
     -681 04:25:09
   -681 04:25:09.2
  -681 04:25:09.15
 -681 04:25:09.154
 -681 04:25:09.154
 -681 04:25:09.154
      -681 04:25:09
    -681 04:25:09.2
   -681 04:25:09.15
  -681 04:25:09.154
 -681 04:25:09.1539
 -681 04:25:09.1539
 -681 04:25:09.1539
 *****
 ******
 *******
 ********
 -16350:49
  -16350:49
  -16350:49
   -16350:49
   -16350:49
   -16350:49
 -16350:49:27
 -16350:49:27
 -16350:49:27
 -16350:49:27
  -16350:49:27
  -16350:49:27
  -16350:49:27
  -16350:49:27
  -16350:49:27
   -16350:49:27
 -16350:49:27.1
 -16350:49:27.1
 -16350:49:27.1
 -16350:49:27.1
 -16350:49:27.1
    -16350:49:27
  -16350:49:27.1
 -16350:49:27.11
 -16350:49:27.11
 -16350:49:27.11
 -16350:49:27.11
 -16350:49:27.11
 ********
 *********
 -681 06:49
  -681 06:49
   -681 06:49
 -681 06:49:27
 -681 06:49:27
  -681 06:49:27
  -681 06:49:27
  -681 06:49:27
   -681 06:49:27
 -681 06:49:27.1
 -681 06:49:27.1
 -681 06:49:27.1
    -681 06:49:27
  -681 06:49:27.1
 -681 06:49:27.11
 -681 06:49:27.11
 -681 06:49:27.11
     -681 06:49:27
   -681 06:49:27.1
  -681 06:49:27.11
 -681 06:49:27.105
 -681 06:49:27.105
 -681 06:49:27.105
      -681 06:49:27
    -681 06:49:27.1
   -681 06:49:27.11
  -681 06:49:27.105
 -681 06:49:27.1053
 -681 06:49:27.1053
 -681 06:49:27.1053
 *****
 ******
 *******
 ********
 -16346:57
  -16346:57
  -16346:57
   -16346:57
   -16346:57
   -16346:57
 -16346:57:52
 -16346:57:52
 -16346:57:52
 -16346:57:52
  -16346:57:52
  -16346:57:52
  -16346:57:52
  -16346:57:52
  -16346:57:52
   -16346:57:52
 -16346:57:52.5
 -16346:57:52.5
 -16346:57:52.5
 -16346:57:52.5
 -16346:57:52.5
    -16346:57:52
  -16346:57:52.5
 -16346:57:52.48
 -16346:57:52.48
 -16346:57:52.48
 -16346:57:52.48
 -16346:57:52.48
 ********
 *********
 -681 02:57
  -681 02:57
   -681 02:57
 -681 02:57:52
 -681 02:57:52
  -681 02:57:52
  -681 02:57:52
  -681 02:57:52
   -681 02:57:52
 -681 02:57:52.5
 -681 02:57:52.5
 -681 02:57:52.5
    -681 02:57:52
  -681 02:57:52.5
 -681 02:57:52.48
 -681 02:57:52.48
 -681 02:57:52.48
     -681 02:57:52
   -681 02:57:52.5
  -681 02:57:52.48
 -681 02:57:52.482
 -681 02:57:52.482
 -681 02:57:52.482
      -681 02:57:52
    -681 02:57:52.5
   -681 02:57:52.48
  -681 02:57:52.482
 -681 02:57:52.4823
 -681 02:57:52.4823
 -681 02:57:52.4823
 *****
 ******
 *******
 ********
 -16360:45
  -16360:45
  -16360:45
   -16360:45
   -16360:45
   -16360:45
 -16360:45:44
 -16360:45:44
 -16360:45:44
 -16360:45:44
  -16360:45:44
  -16360:45:44
  -16360:45:44
  -16360:45:44
  -16360:45:44
   -16360:45:44
 -16360:45:44.7
 -16360:45:44.7
 -16360:45:44.7
 -16360:45:44.7
 -16360:45:44.7
    -16360:45:44
  -16360:45:44.7
 -16360:45:44.66
 -16360:45:44.66
 -16360:45:44.66
 -16360:45:44.66
 -16360:45:44.66
 ********
 *********
 -681 16:45
  -681 16:45
   -681 16:45
 -681 16:45:44
 -681 16:45:44
  -681 16:45:44
  -681 16:45:44
  -681 16:45:44
   -681 16:45:44
 -681 16:45:44.7
 -681 16:45:44.7
 -681 16:45:44.7
    -681 16:45:44
  -681 16:45:44.7
 -681 16:45:44.66
 -681 16:45:44.66
 -681 16:45:44.66
     -681 16:45:44
   -681 16:45:44.7
  -681 16:45:44.66
 -681 16:45:44.658
 -681 16:45:44.658
 -681 16:45:44.658
      -681 16:45:44
    -681 16:45:44.7
   -681 16:45:44.66
  -681 16:45:44.658
 -681 16:45:44.6583
 -681 16:45:44.6583
 -681 16:45:44.6583
 *****
 ******
 *******
 ********
 -16365:30
  -16365:30
  -16365:30
   -16365:30
   -16365:30
   -16365:30
 -16365:30:57
 -16365:30:57
 -16365:30:57
 -16365:30:57
  -16365:30:57
  -16365:30:57
  -16365:30:57
  -16365:30:57
  -16365:30:57
   -16365:30:57
 -16365:30:57.6
 -16365:30:57.6
 -16365:30:57.6
 -16365:30:57.6
 -16365:30:57.6
    -16365:30:57
  -16365:30:57.6
 -16365:30:57.58
 -16365:30:57.58
 -16365:30:57.58
 -16365:30:57.58
 -16365:30:57.58
 ********
 *********
 -681 21:30
  -681 21:30
   -681 21:30
 -681 21:30:57
 -681 21:30:57
  -681 21:30:57
  -681 21:30:57
  -681 21:30:57
   -681 21:30:57
 -681 21:30:57.6
 -681 21:30:57.6
 -681 21:30:57.6
    -681 21:30:57
  -681 21:30:57.6
 -681 21:30:57.58
 -681 21:30:57.58
 -681 21:30:57.58
     -681 21:30:57
   -681 21:30:57.6
  -681 21:30:57.58
 -681 21:30:57.582
 -681 21:30:57.582
 -681 21:30:57.582
      -681 21:30:57
    -681 21:30:57.6
   -681 21:30:57.58
  -681 21:30:57.582
 -681 21:30:57.5822
 -681 21:30:57.5822
 -681 21:30:57.5822
 *****
 ******
 *******
 ********
 -16366:30
  -16366:30
  -16366:30
   -16366:30
   -16366:30
   -16366:30
 -16366:30:04
 -16366:30:04
 -16366:30:04
 -16366:30:04
  -16366:30:04
  -16366:30:04
  -16366:30:04
  -16366:30:04
  -16366:30:04
   -16366:30:04
 -16366:30:04.2
 -16366:30:04.2
 -16366:30:04.2
 -16366:30:04.2
 -16366:30:04.2
    -16366:30:04
  -16366:30:04.2
 -16366:30:04.18
 -16366:30:04.18
 -16366:30:04.18
 -16366:30:04.18
 -16366:30:04.18
 ********
 *********
 -681 22:30
  -681 22:30
   -681 22:30
 -681 22:30:04
 -681 22:30:04
  -681 22:30:04
  -681 22:30:04
  -681 22:30:04
   -681 22:30:04
 -681 22:30:04.2
 -681 22:30:04.2
 -681 22:30:04.2
    -681 22:30:04
  -681 22:30:04.2
 -681 22:30:04.18
 -681 22:30:04.18
 -681 22:30:04.18
     -681 22:30:04
   -681 22:30:04.2
  -681 22:30:04.18
 -681 22:30:04.183
 -681 22:30:04.183
 -681 22:30:04.183
      -681 22:30:04
    -681 22:30:04.2
   -681 22:30:04.18
  -681 22:30:04.183
 -681 22:30:04.1835
 -681 22:30:04.1835
 -681 22:30:04.1835
 *****
 ******
 *******
 ********
 -16345:56
  -16345:56
  -16345:56
   -16345:56
   -16345:56
   -16345:56
 -16345:56:51
 -16345:56:51
 -16345:56:51
 -16345:56:51
  -16345:56:51
  -16345:56:51
  -16345:56:51
  -16345:56:51
  -16345:56:51
   -16345:56:51
 -16345:56:51.6
 -16345:56:51.6
 -16345:56:51.6
 -16345:56:51.6
 -16345:56:51.6
    -16345:56:51
  -16345:56:51.6
 -16345:56:51.59
 -16345:56:51.59
 -16345:56:51.59
 -16345:56:51.59
 -16345:56:51.59
 ********
 *********
 -681 01:56
  -681 01:56
   -681 01:56
 -681 01:56:51
 -681 01:56:51
  -681 01:56:51
  -681 01:56:51
  -681 01:56:51
   -681 01:56:51
 -681 01:56:51.6
 -681 01:56:51.6
 -681 01:56:51.6
    -681 01:56:51
  -681 01:56:51.6
 -681 01:56:51.59
 -681 01:56:51.59
 -681 01:56:51.59
     -681 01:56:51
   -681 01:56:51.6
  -681 01:56:51.59
 -681 01:56:51.593
 -681 01:56:51.593
 -681 01:56:51.593
      -681 01:56:51
    -681 01:56:51.6
   -681 01:56:51.59
  -681 01:56:51.593
 -681 01:56:51.5932
 -681 01:56:51.5932
 -681 01:56:51.5932
EOF
if [ $? -ne 0 ] ; then fail ; fi

pass
