//
// C++ Implementation: %{MODULE}
//
// Description:
//
//
// Author: %{AUTHOR} <%{EMAIL}>, (C) %{YEAR}
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "regexpstate.h"

#include "keys.h"
#include "messages.h"

#include <stdlib.h>

using namespace std;

RegExpFormatter::RegExpFormatter(const string &el, RegExpStatePtr r, bool exit, bool all) :
    elem(el), exit_state(exit), exit_all(all), next_state(r)
{
}

void RegExpFormatter::setNextState(RegExpStatePtr r)
{
  next_state = r;
}

RegExpStatePtr RegExpFormatter::getNextState() const
{
  return next_state;
}

const string &
RegExpState::get_elem(int index)
{
  return formatters[(index<0 ? current_formatter : index)]->elem;
}

void
RegExpState::add_exp(const std::string &s, RegExpFormatterPtr f)
{
  const string &ex = buffer.str();
  if (ex.size())
    buffer << "|";

  buffer << s;

  formatters.push_back(f);
}

void
RegExpState::freeze() throw(boost::bad_expression)
{
  const string &buffered = buffer.str();
  try {
    reg_exp.assign(buffered);
  } catch (boost::bad_expression &e) {
    printError("bad expression: " + buffered);
    throw e;
  }
}

void
RegExpState::add_normal_formatter(RegExpFormatterPtr f)
{
  formatters[0] = f;
}
