/*
   This file is part of TALER
   Copyright (C) 2022 Taler Systems SA

   TALER is free software; you can redistribute it and/or modify it under the
   terms of the GNU General Public License as published by the Free Software
   Foundation; either version 3, or (at your option) any later version.

   TALER is distributed in the hope that it will be useful, but WITHOUT ANY
   WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
   A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

   You should have received a copy of the GNU General Public License along with
   TALER; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */
/**
 * @file exchangedb/pg_trigger_aml_process.h
 * @brief implementation of the trigger_aml_process function for Postgres
 * @author Christian Grothoff
 */
#ifndef PG_TRIGGER_AML_PROCESS_H
#define PG_TRIGGER_AML_PROCESS_H

#include "taler_util.h"
#include "taler_json_lib.h"
#include "taler_exchangedb_plugin.h"


/**
 * Trigger AML process, an account has crossed the threshold. Inserts or
 * updates the AML status.
 *
 * @param cls closure
 * @param h_payto account for which the attribute data is stored
 * @param threshold_crossed existing threshold that was crossed
 * @return database transaction status
 */
enum GNUNET_DB_QueryStatus
TEH_PG_trigger_aml_process (
  void *cls,
  const struct TALER_PaytoHashP *h_payto,
  const struct TALER_Amount *threshold_crossed);


#endif
