/* ,file-id archive://[lord]/381/vu/./bitset.h/1998-05-18
*/
#ifndef BITSETH
#define BITSETH

/*	Copyright (C) 1997 Tom Lord
 * 
 * This program is provided to you under the terms of the Liberty Software
 * License.  You are NOT permitted to redistribute, modify, or use it
 * except in very specific ways described by that license.
 *
 * This software comes with NO WARRANTY.
 * 
 * You should have received a copy of the Liberty Software License
 * along with this software; see the file =LICENSE.  If not, write to
 * the Tom Lord, 1810 Francisco St. #2, Berkeley CA, 94703, USA.  
 */



/* The macros and procedures here manipulate "bitsets", defined
 * to be arrays of "subsets", each subset defined to be "unsigned long".
 *
 * Bitsets are (naturally) ordered.  The 0 element is bit 0 (the lsb) of
 * the first subset in the bitset.
 *
 * Hopefully this code is self-documenting.
 */

typedef unsigned long subset;
typedef subset * bitset;

#define bits_per_subset		(8 * sizeof (subset))
#define subset_mask		(bits_per_subset - 1)
#define bitset_which_subset(N)  ((N) / bits_per_subset)
#define bitset_access(B,N,OP) 	((B)[bitset_which_subset(N)] OP (1 << ((N) & subset_mask)))
#define bitset_member(B,N)   	bitset_access(B, N, &)
#define bitset_adjoin(B,N)   	bitset_access(B, N, |=)
#define bitset_remove(B,N)   	bitset_access(B, N, &= ~)
#define bitset_toggle(B,N)   	bitset_access(B, N, ^= )
#define bitset_numb_subsets(N) 	(((N) + bits_per_subset - 1) / bits_per_subset)
#define sizeof_bitset(N)	(bitset_numb_subsets(N) * sizeof(subset))

extern int byte_ffs[];		/* Return the index of the first bit set in a byte. */


/* automatically generated __STDC__ prototypes */
extern bitset bitset_xalloc (int size);
extern bitset bitset_dup (int size, bitset a);
extern int bitset_is_equal (int size, bitset a, bitset b);
extern int bitset_is_subset (int size, bitset a, bitset b);
extern int bitset_empty (int size, bitset a);
extern void bitset_clear (int size, bitset b);
extern void bitset_fill (int size, bitset b);
extern void bitset_complement (int size, bitset b);
extern void bitset_assign (int size, bitset a, bitset b);
extern void bitset_union (int size, bitset a, bitset b);
extern void bitset_intersection (int size, bitset a, bitset b);
extern void bitset_difference (int size, bitset a, bitset b);
extern void bitset_revdifference (int size, bitset a, bitset b);
extern void bitset_xor (int size, bitset a, bitset b);
extern int bitset_population (int size, bitset a);
extern int subset_ffs (subset a);
extern int bitset_ffs (int size, bitset b);
extern unsigned long bitset_hash (int size, bitset b);
#endif  /* BITSETH */
