/*
CLASS:channel_forward:ssh_channel
*/
#ifndef GABA_DEFINE
struct channel_forward
{
  struct ssh_channel super;
  struct channel_read_state read;
  struct channel_write_state write;
};
extern struct lsh_class channel_forward_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void
do_channel_forward_mark(struct lsh_object *o,
  void (*mark)(struct lsh_object *o))
{
  struct channel_forward *i = (struct channel_forward *) o;
  channel_read_state_mark(&(i->read),
    mark);
  channel_write_state_mark(&(i->write),
    mark);
}
static void
do_channel_forward_free(struct lsh_object *o)
{
  struct channel_forward *i = (struct channel_forward *) o;
  channel_read_state_free(&(i->read));
  channel_write_state_free(&(i->write));
}
struct lsh_class channel_forward_class =
{
  STATIC_HEADER,
  &(ssh_channel_class),
  "channel_forward",
  sizeof(struct channel_forward),
  do_channel_forward_mark,
  do_channel_forward_free,
};
#endif /* !GABA_DECLARE */

