#ifndef GABA_DEFINE
struct kexinit_state
{
  enum kex_state read_state;
  int write_state;
  struct lsh_string *((version)[2]);
  struct kexinit *((kexinit)[2]);
  struct lsh_string *((literal_kexinit)[2]);
  int hostkey_algorithm;
  struct object_list *algorithm_list;
};
extern void kexinit_state_mark(struct kexinit_state *i,
 void (*mark)(struct lsh_object *o));
extern void kexinit_state_free(struct kexinit_state *i);
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
void kexinit_state_mark(struct kexinit_state *i,
 void (*mark)(struct lsh_object *o))
{
  (void) mark; (void) i;
  {
    unsigned k2;
    for(k2=0; k2<2; k2++)
      mark((struct lsh_object *) (i->kexinit)[k2]);
  };
  mark((struct lsh_object *) i->algorithm_list);
}
void kexinit_state_free(struct kexinit_state *i)
{
  (void) i;
  {
    unsigned k4;
    for(k4=0; k4<2; k4++)
      lsh_string_free((i->version)[k4]);
  };
  {
    unsigned k6;
    for(k6=0; k6<2; k6++)
      lsh_string_free((i->literal_kexinit)[k6]);
  };
}
#endif /* !GABA_DECLARE */

/*
CLASS:keyexchange_algorithm:
*/
#ifndef GABA_DEFINE
struct keyexchange_algorithm
{
  struct lsh_object super;
  struct transport_handler *(*(init))(struct keyexchange_algorithm *self,struct transport_connection *connection);
};
extern struct lsh_class keyexchange_algorithm_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
struct lsh_class keyexchange_algorithm_class =
{
  STATIC_HEADER,
  NULL,
  "keyexchange_algorithm",
  sizeof(struct keyexchange_algorithm),
  NULL,
  NULL,
};
#endif /* !GABA_DECLARE */

/*
CLASS:kexinit:
*/
#ifndef GABA_DEFINE
struct kexinit
{
  struct lsh_object super;
  uint8_t ((cookie)[16]);
  struct int_list *kex_algorithms;
  struct int_list *server_hostkey_algorithms;
  struct int_list *((parameters)[KEX_PARAMETERS]);
  struct int_list *languages_client_to_server;
  struct int_list *languages_server_to_client;
  int first_kex_packet_follows;
  struct lsh_string *first_kex_packet;
};
extern struct lsh_class kexinit_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void
do_kexinit_mark(struct lsh_object *o,
  void (*mark)(struct lsh_object *o))
{
  struct kexinit *i = (struct kexinit *) o;
  mark((struct lsh_object *) i->kex_algorithms);
  mark((struct lsh_object *) i->server_hostkey_algorithms);
  {
    unsigned k8;
    for(k8=0; k8<KEX_PARAMETERS; k8++)
      mark((struct lsh_object *) (i->parameters)[k8]);
  };
  mark((struct lsh_object *) i->languages_client_to_server);
  mark((struct lsh_object *) i->languages_server_to_client);
}
static void
do_kexinit_free(struct lsh_object *o)
{
  struct kexinit *i = (struct kexinit *) o;
  lsh_string_free(i->first_kex_packet);
}
struct lsh_class kexinit_class =
{
  STATIC_HEADER,
  NULL,
  "kexinit",
  sizeof(struct kexinit),
  do_kexinit_mark,
  do_kexinit_free,
};
#endif /* !GABA_DECLARE */

/*
CLASS:make_kexinit:
*/
#ifndef GABA_DEFINE
struct make_kexinit
{
  struct lsh_object super;
  struct kexinit *(*(make))(struct make_kexinit *self,struct randomness *random);
};
extern struct lsh_class make_kexinit_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
struct lsh_class make_kexinit_class =
{
  STATIC_HEADER,
  NULL,
  "make_kexinit",
  sizeof(struct make_kexinit),
  NULL,
  NULL,
};
#endif /* !GABA_DECLARE */

/*
CLASS:lookup_verifier:
*/
#ifndef GABA_DEFINE
struct lookup_verifier
{
  struct lsh_object super;
  struct verifier *(*(lookup))(struct lookup_verifier *self,int method,uint32_t length,const uint8_t *key);
};
extern struct lsh_class lookup_verifier_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
struct lsh_class lookup_verifier_class =
{
  STATIC_HEADER,
  NULL,
  "lookup_verifier",
  sizeof(struct lookup_verifier),
  NULL,
  NULL,
};
#endif /* !GABA_DECLARE */

