/*
CLASS:server_forward:forwarded_port
*/
#ifndef GABA_DEFINE
struct server_forward
{
  struct forwarded_port super;
  struct resource *port;
};
extern struct lsh_class server_forward_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void
do_server_forward_mark(struct lsh_object *o,
  void (*mark)(struct lsh_object *o))
{
  struct server_forward *i = (struct server_forward *) o;
  mark((struct lsh_object *) i->port);
}
struct lsh_class server_forward_class =
{
  STATIC_HEADER,
  &(forwarded_port_class),
  "server_forward",
  sizeof(struct server_forward),
  do_server_forward_mark,
  NULL,
};
#endif /* !GABA_DECLARE */

static struct command *
tcpforward_forwarded_tcpip(struct address_info *port)
  /* (S (B listen_tcp (open_forwarded_tcpip port)) (prog1 port)) */
#define A GABA_APPLY
#define I GABA_VALUE_I
#define K GABA_VALUE_K
#define K1 GABA_APPLY_K_1
#define S GABA_VALUE_S
#define S1 GABA_APPLY_S_1
#define S2 GABA_APPLY_S_2
#define B GABA_VALUE_B
#define B1 GABA_APPLY_B_1
#define B2 GABA_APPLY_B_2
#define C GABA_VALUE_C
#define C1 GABA_APPLY_C_1
#define C2 GABA_APPLY_C_2
#define Sp GABA_VALUE_Sp
#define Sp1 GABA_APPLY_Sp_1
#define Sp2 GABA_APPLY_Sp_2
#define Sp3 GABA_APPLY_Sp_3
#define Bp GABA_VALUE_Bp
#define Bp1 GABA_APPLY_Bp_1
#define Bp2 GABA_APPLY_Bp_2
#define Bp3 GABA_APPLY_Bp_3
#define Cp GABA_VALUE_Cp
#define Cp1 GABA_APPLY_Cp_1
#define Cp2 GABA_APPLY_Cp_2
#define Cp3 GABA_APPLY_Cp_3
{
  CAST_SUBTYPE(command, res,
MAKE_TRACE("tcpforward_forwarded_tcpip",
    S2(B2(LISTEN_TCP,
        A(OPEN_FORWARDED_TCPIP,
          ((struct lsh_object *) port))),
      A(PROG1,
        ((struct lsh_object *) port)))));
return res;
;
}
#undef A
#undef I
#undef K
#undef K1
#undef S
#undef S1
#undef S2
#undef B
#undef B1
#undef B2
#undef C
#undef C1
#undef C2
#undef Sp
#undef Sp1
#undef Sp2
#undef Sp3
#undef Bp
#undef Bp1
#undef Bp2
#undef Bp3
#undef Cp
#undef Cp1
#undef Cp2
#undef Cp3
/*
CLASS:tcpip_forward_request_continuation:command_continuation
*/
#ifndef GABA_DEFINE
struct tcpip_forward_request_continuation
{
  struct command_continuation super;
  struct server_forward *forward;
  struct ssh_connection *connection;
  struct command_continuation *c;
};
extern struct lsh_class tcpip_forward_request_continuation_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void
do_tcpip_forward_request_continuation_mark(struct lsh_object *o,
  void (*mark)(struct lsh_object *o))
{
  struct tcpip_forward_request_continuation *i = (struct tcpip_forward_request_continuation *) o;
  mark((struct lsh_object *) i->forward);
  mark((struct lsh_object *) i->connection);
  mark((struct lsh_object *) i->c);
}
struct lsh_class tcpip_forward_request_continuation_class =
{
  STATIC_HEADER,
  &(command_continuation_class),
  "tcpip_forward_request_continuation",
  sizeof(struct tcpip_forward_request_continuation),
  do_tcpip_forward_request_continuation_mark,
  NULL,
};
#endif /* !GABA_DECLARE */

/*
CLASS:tcpip_forward_request_exception_handler:exception_handler
*/
#ifndef GABA_DEFINE
struct tcpip_forward_request_exception_handler
{
  struct exception_handler super;
  struct ssh_connection *connection;
  struct server_forward *forward;
  struct exception_handler *parent;
};
extern struct lsh_class tcpip_forward_request_exception_handler_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void
do_tcpip_forward_request_exception_handler_mark(struct lsh_object *o,
  void (*mark)(struct lsh_object *o))
{
  struct tcpip_forward_request_exception_handler *i = (struct tcpip_forward_request_exception_handler *) o;
  mark((struct lsh_object *) i->connection);
  mark((struct lsh_object *) i->forward);
  mark((struct lsh_object *) i->parent);
}
struct lsh_class tcpip_forward_request_exception_handler_class =
{
  STATIC_HEADER,
  &(exception_handler_class),
  "tcpip_forward_request_exception_handler",
  sizeof(struct tcpip_forward_request_exception_handler),
  do_tcpip_forward_request_exception_handler_mark,
  NULL,
};
#endif /* !GABA_DECLARE */

