/* wptErrors.h - Errors headerfile
 *	Copyright (C) 2000-2005 Timo Schulz
 *
 * This file is part of WinPT.
 *
 * WinPT is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License 
 * as published by the Free Software Foundation; either version 2 
 * of the License, or (at your option) any later version.
 *  
 * WinPT is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License 
 * along with WinPT; if not, write to the Free Software Foundation, 
 * Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 */

#ifndef WPT_ERRORS_H
#define WPT_ERRORS_H

#define DEBUG(MSG)   debug   (MSG, __FILE__, __LINE__)
#define DEBUG_F(MSG) debug_f (MSG, __FILE__, __LINE__)
	

enum {
    WPTERR_GENERAL        = 1,
    WPTERR_FILE_OPEN      = 2,
    WPTERR_FILE_CREAT     = 3,
    WPTERR_FILE_READ      = 4,
    WPTERR_FILE_WRITE     = 5,
    WPTERR_FILE_CLOSE     = 6,
    WPTERR_FILE_EXIST     = 7,
    WPTERR_FILE_REMOVE    = 8,
    WPTERR_CLIP_OPEN      = 10,
    WPTERR_CLIP_CLOSE     = 11,
    WPTERR_CLIP_EMPTY     = 12,
    WPTERR_CLIP_SET	  = 13,
    WPTERR_CLIP_GET       = 14,
    WPTERR_CLIP_ISEMPTY   = 15,
    WPTERR_CLIP           = 16,	
    WPTERR_CLIP_SECURED   = 17,
    WPTERR_WINSOCK_INIT   = 18,
    WPTERR_WINSOCK_RESOLVE= 19,
    WPTERR_WINSOCK_SOCKET = 20,
    WPTERR_WINSOCK_CONNECT= 21,
    WPTERR_WINSOCK_SENDKEY= 22,
    WPTERR_WINSOCK_RECVKEY= 23,
    WPTERR_WINSOCK_TIMEOUT= 50,
    WPTERR_KEYSERVER_NOTFOUND= 24,
    WPTERR_REGISTRY       = 26,	
    WPTERR_HOTKEY	  = 28,
    WPTERR_DIR_OPEN	  = 33,
    WPTERR_DIR_CREAT      = 34,
    WPTERR_CURR_WND	  = 35,
    WPTERR_CONFIG_FILE    = 36,
    WPTERR_GPG_EXEFILE    = 51,	
    WPTERR_GPG_KEYRINGS   = 52,
    WPTERR_GPG_OPT_KEYRINGS= 53,
    WPTERR_NOCARD	  = 100,
    WPTERR_NOREADER	  = 101,
    WPTERR_NOPGPCARD	  = 102,
    WPTERR_CDISK_LOCK	  = 201,
    WPTERR_CDISK_MOUNT    = 202,
    WPTERR_CDISK_UMOUNT   = 203,
    WPTERR_CDISK_OPEN	  = 204,
    WPTERR_CDISK_BUSY	  = 205,
    WPTERR_CDISK_QUERY	  = 206,
};

const char * winpt_strerror (int errid);
void winpt_errmsg (const char * name, int is_file);
void winpt_debug_msg (void);
void debug_box (const char * msg, const char * file, int line);
void debug_f (const char * msg, const char * file, int line);
void log_f (const char * format, ...);
int log_box (const char * title, int style, const char * format, ...);

/*-- wptW32API.cpp --*/
int msg_box (HWND hwnd, const char * text, const char * title, int mode);
int show_msg (HWND hWnd, int millis, LPCTSTR string);
#define status_box(hwnd, text, title) msg_box (hwnd, text, title, MB_OK)

#endif /* WPT_ERRORS_H */